/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.secsignersigg;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import seccommerce.bo.BO;
import seccommerce.ca.certmanage.bo.RegAuthCrtProf;
import seccommerce.ca.certmanage.bo.RegistAuth;
import seccommerce.ca.certmanage.bo.SoftSignUnitHist;
import seccommerce.mobile.bo.SamlServiceProv;
import seccommerce.mobile.bo.SecSignID;
import seccommerce.secpki.bo.ActiveSoftSign;
import seccommerce.secpki.bo.RemoteSigProv;
import seccommerce.secpki.bo.SoftSignUnit;
import seccommerce.secsignersigg.ahp;
import seccommerce.secsignersigg.ai;
import seccommerce.secsignersigg.alk;
import seccommerce.secsignersigg.amt;
import seccommerce.secsignersigg.amw;
import seccommerce.secsignersigg.an;
import seccommerce.secsignersigg.aoa;
import seccommerce.secsignersigg.ar9;
import seccommerce.secsignersigg.as7;
import seccommerce.secsignersigg.ase;
import seccommerce.secsignersigg.aum;
import seccommerce.secsignersigg.aut;
import seccommerce.secsignersigg.av;
import seccommerce.secsignersigg.azm;
import seccommerce.secsignersigg.b2x;
import seccommerce.secsignersigg.b7;
import seccommerce.secsignersigg.bb;
import seccommerce.secsignersigg.bg7;
import seccommerce.secsignersigg.bhc;
import seccommerce.secsignersigg.ccy;
import seccommerce.secsignersigg.cdm;
import seccommerce.secsignersigg.cdu;
import seccommerce.secsignersigg.cfh;
import seccommerce.secsignersigg.cn;
import seccommerce.secsignersigg.dw;
import seccommerce.secsignersigg.eb;
import seccommerce.secsignersigg.em;
import seccommerce.secsignersigg.ey;
import seccommerce.secsignersigg.k;
import seccommerce.secsignersigg.n;
import seccommerce.secsignersigg.ns;
import seccommerce.secsignersigg.q8;
import seccommerce.secsignersigg.q9;
import seccommerce.user.bo.IdProfile;
import seccommerce.user.bo.UserId;
import seccommerce.user.bo.UserRole;
import seccommerce.workflow.bo.SoftSignUserGrp;

public class a0o
extends aoa<SoftSignUnit> {
    private final String[] e = new String[]{"ActivationDate"};

    public a0o(amw amw2, amt amt2) {
        super(amw2, amt2);
    }

    @Override
    protected SoftSignUnit a() {
        return new SoftSignUnit();
    }

    public List<SoftSignUnit> a(boolean bl10, Long l10, Long l11, Long l12, boolean bl11, boolean bl12, Boolean bl13, Connection connection) throws SQLException, alk {
        Object object;
        Object object2;
        if (!(bl10 || l10 != null || l11 != null || bl13 != null && bl13.booleanValue())) {
            ns.c("No soft sign unit will be returned from the database since no UserIdId was specified. useSeal=" + bl13);
            return null;
        }
        if (l10 != null && l11 != null) {
            throw new alk("UserIdId and userGroupId cannot be specified both at the same time to find SoftSignUnits.");
        }
        SoftSignUnit softSignUnit = new SoftSignUnit();
        if (null != l11) {
            object2 = new UserRole();
            object2.setUserGroupId(l11);
            object = new UserRole();
            object.setUserIdId(Long.valueOf(1L));
            object2.setTableNameForNestedSelect("UserRole");
            object2.setSelectListPattern((BO)object);
            try {
                softSignUnit.a("useridid", 12, object2);
            }
            catch (n n10) {
                throw new alk("Cannot set pattern IN condition for userIdId to find SoftSignUnits for userGroupId '" + l11 + "': " + n10.getMessage(), n10);
            }
        } else if (null != l10) {
            softSignUnit.c(l10);
        }
        if (l12 == null) {
            throw new alk("Cannot get softsignunit. OrgID is null.");
        }
        softSignUnit.a(l12);
        softSignUnit.a((Boolean)bl11);
        softSignUnit.b(bl13);
        object2 = new ArrayList<SoftSignUnit>(this.i(softSignUnit, connection));
        if (bl12 && !object2.isEmpty()) {
            object = new Date();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                SoftSignUnit softSignUnit2 = (SoftSignUnit)iterator.next();
                byte[] byArray = softSignUnit2.bo();
                if (null == byArray) {
                    ns.b("SoftSignUnit " + softSignUnit2.u() + " does not contain a certificate blob. Cannot check if the certificate is expired.");
                    continue;
                }
                try {
                    ahp ahp2 = new ahp(byArray);
                    if (ahp2.p().after((Date)object) && ahp2.q().before((Date)object)) {
                        ns.f("The certificate of SoftSignUnit " + softSignUnit2.u() + " is suitable for the userID " + l10 + " since it will expiry only on " + ahp2.p());
                        return object2;
                    }
                    iterator.remove();
                }
                catch (Exception exception) {
                    ns.a(exception, "The certificate of SoftSignUnit " + softSignUnit2.u() + " cannot be parsed. Cannot check if the certificate is suitable");
                }
            }
        }
        return object2;
    }

    public List<SoftSignUnit> a(Long l10, boolean bl10, Connection connection) {
        SoftSignUnit softSignUnit = new SoftSignUnit();
        softSignUnit.a(l10);
        softSignUnit.b(Boolean.TRUE);
        if (bl10) {
            softSignUnit.a(Boolean.TRUE);
        }
        try {
            return this.i(softSignUnit, connection);
        }
        catch (SQLException sQLException) {
            ns.a("Error while retrieving seals from DB: " + sQLException.getMessage());
            return Collections.emptyList();
        }
    }

    public SoftSignUnit a(Long l10, Connection connection) throws SQLException, alk {
        return (SoftSignUnit)this.i(l10, connection);
    }

    public List<SoftSignUnit> a(Long l10, String string, boolean bl10, Connection connection) throws alk, SQLException {
        if (l10 == null) {
            throw new alk("Cannot get list of signunits for holder. Org ID is null.");
        }
        SoftSignUnit softSignUnit = new SoftSignUnit();
        softSignUnit.c(string);
        softSignUnit.a(l10);
        List<SoftSignUnit> list = this.i(softSignUnit, connection);
        if (!list.isEmpty() && bl10) {
            cdu cdu2 = new cdu(this.c, this.d);
            for (SoftSignUnit softSignUnit2 : list) {
                if (softSignUnit2.bp() != null) {
                    ns.f("The userIdId " + softSignUnit2.bp() + " belonging to the SoftSignUnit " + softSignUnit2.u() + " was assigned in the database already.");
                    continue;
                }
                try {
                    Long l11 = this.b(softSignUnit2, connection);
                    softSignUnit2.c(l11);
                    ns.f("The userIdId " + l11 + " belongs to the SoftSignUnit " + softSignUnit2.u() + " according to the matching signature certificate.");
                    if (null == l11) continue;
                    ns.f("Assigning the SoftSignUnit to UserId '" + l11 + "' in the database.");
                    UserId userId = (UserId)cdu2.i(l11, connection);
                    if (null == userId) {
                        throw new alk("Could not assign the SoftSignUnit to the UserId '" + l11 + "' since the UserID cannot be found in the database.");
                    }
                    if (!l10.equals(userId.getOrgId())) {
                        throw new alk("Could not assign the SoftSignUnit to the UserId '" + l11 + "' User org ID is different from given org ID (" + userId.getOrgId() + " != " + l10 + ").");
                    }
                    SoftSignUnit softSignUnit3 = new SoftSignUnit();
                    softSignUnit3.e(softSignUnit2.u());
                    SoftSignUnit softSignUnit4 = new SoftSignUnit();
                    softSignUnit4.c(l11);
                    long l12 = this.a(softSignUnit4, softSignUnit3, connection);
                    if (1L == l12) continue;
                    throw new alk("Could not assign the SoftSignUnit to the UserId '" + l11 + "' since the update in the database has changed " + l12 + " rows instead of 1.");
                }
                catch (alk alk2) {
                    if (alk2.b() == 1013) {
                        ns.c("There is no UserID matching the signature certificates of signature unit " + softSignUnit2 + " in the database.");
                        continue;
                    }
                    throw alk2;
                }
                catch (Exception exception) {
                    throw new alk("The look-up of the userID of signature unit " + softSignUnit2 + " failed: " + exception.getMessage(), exception);
                }
            }
        }
        return list;
    }

    public long a(@NotNull SoftSignUnit softSignUnit, Connection connection) throws SQLException, alk {
        Objects.requireNonNull(softSignUnit, "Cannot delete SoftSignUnit. Given BO is null.");
        List<SoftSignUnit> list = this.i(softSignUnit, connection);
        cfh cfh2 = new cfh(this.c, this.d);
        for (SoftSignUnit softSignUnit2 : list) {
            SoftSignUserGrp softSignUserGrp = new SoftSignUserGrp();
            softSignUserGrp.a(softSignUnit2.u());
            cfh2.a(softSignUserGrp, connection);
        }
        return this.e(softSignUnit, connection);
    }

    public Long b(@NotNull SoftSignUnit softSignUnit, Connection connection) throws alk, ParseException, IOException {
        int n10;
        Objects.requireNonNull(softSignUnit, "There is no soft sign unit given to find userIdId.");
        byte[] byArray = softSignUnit.bo();
        Objects.requireNonNull(byArray, "There is no certificate for soft sign unit " + softSignUnit + " in the database.");
        cdm cdm2 = new cdm(this.c, this.d);
        ahp ahp2 = new ahp(byArray);
        Long[] longArray = cdm2.a(ahp2, softSignUnit.toString(), this.d.l(), connection);
        int n11 = n10 = longArray == null ? 0 : longArray.length;
        if (n10 == 1) {
            return longArray[0];
        }
        if (n10 > 1) {
            throw new alk("Found " + n10 + " user IDs for org " + this.d.l() + " for the signature certificate of soft sign unit " + softSignUnit + " instead of the expected exactly one.");
        }
        return null;
    }

    @Override
    public List<SoftSignUnit> a(Long l10, Long l11, Connection connection) throws SQLException, alk {
        boolean bl10 = true;
        boolean bl11 = true;
        Boolean bl12 = null;
        boolean bl13 = false;
        Long l12 = null;
        return this.a(bl13, l10, l12, l11, bl10, bl11, bl12, connection);
    }

    public void c(SoftSignUnit softSignUnit, Connection connection) throws bg7, alk, n, SQLException {
        if (softSignUnit.b() == null) {
            softSignUnit.a(this.f());
        }
        this.a((k)softSignUnit, connection);
    }

    @Override
    public void d(SoftSignUnit softSignUnit, Connection connection) throws bg7, alk, n, SQLException {
        ahp ahp2;
        aum aum2 = amw.f().ar();
        if (null == aum2) {
            throw new bg7(false, "Cannot update the soft sign unit since the SecSignApi is null.");
        }
        Long l10 = softSignUnit.u();
        if (null == l10) {
            throw new bg7(false, "Cannot update the soft sign unit since its ID is null.");
        }
        try {
            ahp2 = new ahp(softSignUnit.bo());
        }
        catch (Exception exception) {
            throw new bg7(false, "Cannot update the soft sign unit since the new certificate cannot be parsed: " + exception.getMessage());
        }
        SoftSignUnit softSignUnit2 = (SoftSignUnit)this.i(l10, connection);
        SoftSignUnit softSignUnit3 = new SoftSignUnit();
        softSignUnit3.e(l10);
        SoftSignUnit softSignUnit4 = new SoftSignUnit();
        softSignUnit4.c(softSignUnit.h());
        softSignUnit4.b(softSignUnit.bo());
        softSignUnit4.b(ahp2.w());
        softSignUnit4.a(softSignUnit.i());
        softSignUnit4.a(softSignUnit.d());
        softSignUnit4.b(softSignUnit.g());
        softSignUnit4.c(softSignUnit.bt());
        Boolean bl10 = softSignUnit.br();
        softSignUnit4.a(bl10);
        boolean bl11 = Boolean.TRUE.equals(bl10);
        boolean bl12 = null != softSignUnit2 && softSignUnit2.br() != false;
        this.a(softSignUnit4, bl11, bl12);
        this.a(softSignUnit4, softSignUnit3, connection);
    }

    @Override
    public void a(SoftSignUnit softSignUnit, boolean bl10, boolean bl11) {
        if (softSignUnit == null) {
            return;
        }
        if (bl10 && !bl11) {
            softSignUnit.c(new Date());
        } else if (!bl10 && bl11) {
            softSignUnit.c((Date)null);
            softSignUnit.e(this.e);
        }
    }

    @Override
    public void a(long l10, Connection connection) throws bg7, alk, n, SQLException {
        List<RemoteSigProv> list;
        try {
            list = bb.a().a(b2x.class).a(l10);
        }
        catch (SQLException | as7 exception) {
            throw new alk("Cannot get the remote signature provider for the signunit id '" + l10 + "': " + exception.getMessage(), exception);
        }
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (RemoteSigProv remoteSigProv : list) {
                stringBuilder.append("'" + remoteSigProv.getName() + "' (ID=" + remoteSigProv.u() + "), ");
            }
            throw new alk("Cannot delete the SoftSignUnit with ID " + l10 + " since it is referenced by the remote signature provider(s): " + stringBuilder);
        }
        azm azm2 = new azm(this.c, this.d);
        ActiveSoftSign activeSoftSign = new ActiveSoftSign();
        activeSoftSign.c(l10);
        ActiveSoftSign activeSoftSign2 = new ActiveSoftSign();
        activeSoftSign2.e("rootSignUnit");
        long l11 = azm2.a(activeSoftSign2, activeSoftSign, connection);
        if (1L < l11) {
            throw new alk("The update in table ActiveSoftSign to set the rootSignUnit reference to null has changed " + l11 + " rows.");
        }
        ActiveSoftSign activeSoftSign3 = new ActiveSoftSign();
        activeSoftSign3.d(l10);
        ActiveSoftSign activeSoftSign4 = new ActiveSoftSign();
        activeSoftSign4.e("crlSignUnit");
        long l12 = azm2.a(activeSoftSign4, activeSoftSign3, connection);
        if (1L < l12) {
            throw new alk("The update in table ActiveSoftSign to set the crlSignUnit reference to null has changed " + l12 + " rows.");
        }
        ActiveSoftSign activeSoftSign5 = new ActiveSoftSign();
        activeSoftSign5.b((Long)l10);
        ActiveSoftSign activeSoftSign6 = new ActiveSoftSign();
        activeSoftSign6.e("trustListSignUnit");
        long l13 = azm2.a(activeSoftSign6, activeSoftSign5, connection);
        if (1L < l13) {
            throw new alk("The update in table ActiveSoftSign to set the trustListSignUnit reference to null has changed " + l13 + " rows.");
        }
        ActiveSoftSign activeSoftSign7 = new ActiveSoftSign();
        activeSoftSign7.j(l10);
        ActiveSoftSign activeSoftSign8 = new ActiveSoftSign();
        activeSoftSign8.e("ocspSignUnit");
        long l14 = azm2.a(activeSoftSign8, activeSoftSign7, connection);
        if (1L < l14) {
            throw new alk("The update in table ActiveSoftSign to set the ocspSignUnit reference to null has changed " + l14 + " rows.");
        }
        ActiveSoftSign activeSoftSign9 = new ActiveSoftSign();
        activeSoftSign9.k(l10);
        ActiveSoftSign activeSoftSign10 = new ActiveSoftSign();
        activeSoftSign10.e("timestampSignUnit");
        long l15 = azm2.a(activeSoftSign10, activeSoftSign9, connection);
        if (1L < l15) {
            throw new alk("The update in table ActiveSoftSign to set the timestampSignUnit reference to null has changed " + l15 + " rows.");
        }
        ActiveSoftSign activeSoftSign11 = new ActiveSoftSign();
        activeSoftSign11.l(l10);
        ActiveSoftSign activeSoftSign12 = new ActiveSoftSign();
        activeSoftSign12.e("certExportSignUnit");
        long l16 = azm2.a(activeSoftSign12, activeSoftSign11, connection);
        if (1L < l16) {
            throw new alk("The update in table ActiveSoftSign to set the certExportSignUnit reference to null has changed " + l16 + " rows.");
        }
        SoftSignUnit softSignUnit = new SoftSignUnit();
        softSignUnit.e(l10);
        List<SoftSignUnit> list2 = this.i(softSignUnit, connection);
        int n10 = list2.size();
        if (1 < n10) {
            throw new alk("There are " + n10 + " database rows in the SoftSignUnit table having the ID " + l10 + ".");
        }
        q8 q82 = new q8(this.c, this.d);
        SamlServiceProv samlServiceProv = new SamlServiceProv();
        samlServiceProv.c(l10);
        SamlServiceProv samlServiceProv2 = new SamlServiceProv();
        samlServiceProv2.e("SignUnitId");
        long l17 = q82.a(samlServiceProv2, samlServiceProv, connection);
        ns.c("Set softkeyID for all SAML service provider that used the softkey from '" + l10 + "' to null. " + l17 + " service provider were affected.");
        av av10 = new av(this.c, this.d);
        SoftSignUnitHist softSignUnitHist = new SoftSignUnitHist();
        softSignUnitHist.a((Long)l10);
        av10.e(softSignUnitHist, connection);
        SoftSignUnit softSignUnit2 = new SoftSignUnit();
        softSignUnit2.e(l10);
        this.e(softSignUnit2, connection);
    }

    public static String a(String string) {
        ey ey2 = amw.ak();
        byte[] byArray = new byte[16];
        ey2.nextBytes(byArray);
        byte[] byArray2 = eb.a(new dw(new em()), string.getBytes(StandardCharsets.UTF_8), byArray, 2048, 32);
        byte[] byArray3 = new byte[48];
        System.arraycopy(byArray, 0, byArray3, 0, 16);
        System.arraycopy(byArray2, 0, byArray3, 16, 32);
        return new String(cn.a(byArray3, false), StandardCharsets.UTF_8);
    }

    public void a(String string, UserId userId, String string2, String string3, String string4, Long l10, Long l11, Connection connection) throws alk, ase {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SUBJECT_SURNAME", string3);
        hashMap.put("LASTNAME", string2);
        hashMap.put("INITIAL_PASSWORD", string4);
        ai ai10 = new ai(this.c, this.d);
        Long l12 = ai10.a(l10, connection);
        ns.e("Will use the e-mail template group with ID " + l12 + " as selected in a registration authority that can use the certificate profile " + l10 + " to send the initial password of the generated private key to the request submitter.");
        boolean bl10 = ar9.a(14, l11).a(l12).a(hashMap).a(userId, string).a(connection);
        if (!bl10) {
            throw new alk("The SecSign ID Server could not send an e-mail with the initial password of the new remote signature key in the HSM to " + string + ".");
        }
    }

    public void a(Long l10, String string, String string2, String string3, String string4, String string5, String string6, Long l11, Connection connection) throws alk, ase {
        List<RegistAuth> list;
        RegAuthCrtProf regAuthCrtProf = new RegAuthCrtProf();
        regAuthCrtProf.a((Long)0L);
        RegAuthCrtProf regAuthCrtProf2 = new RegAuthCrtProf();
        regAuthCrtProf2.b(l10);
        regAuthCrtProf2.h(regAuthCrtProf);
        regAuthCrtProf2.o("RegAuthCrtProf");
        RegistAuth registAuth = new RegistAuth();
        try {
            registAuth.a("registAuthId", 12, regAuthCrtProf2);
        }
        catch (n n10) {
            throw new alk("Cannot set pattern IN condition for registAuthId to find registration authorities that can access the certificate profile " + l10 + ": " + n10.getMessage(), n10);
        }
        an an10 = new an(this.c, this.d);
        try {
            list = an10.i(registAuth, connection);
        }
        catch (Exception exception) {
            throw new alk("Cannot query the registration authorities that can access the certificate profile " + l10 + " to send them a notification about a pending CSR: " + exception.getMessage(), exception);
        }
        if (list.isEmpty()) {
            ns.b("Cannot inform any registration authority about the pending CSR since no RA can access the certificate profile " + l10 + ".");
        } else {
            for (RegistAuth registAuth2 : list) {
                String string7 = registAuth2.b();
                if (null == string7) {
                    ns.b("Cannot inform the registration authority with ID " + registAuth2.u() + " about the pending CSR since this RA has no e-mail address assigned.");
                    continue;
                }
                ns.c("Will send an e-mail to the registration authority '" + registAuth2.getName() + "' at '" + string7 + "' to inform them about the pending CSR.");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("USER_NAME", string);
                hashMap.put("EMAIL_ADDRESS", string2);
                hashMap.put("CERT_PROFILE", string3);
                hashMap.put("CERT_REQUEST_CONTENT", string4);
                hashMap.put("CERT_REQUEST_PROBLEMS", string5);
                hashMap.put("CERT_REQUEST_VIOLATION_REASON", string6);
                boolean bl10 = ar9.a(65, l11).a(string7).a(hashMap).a(connection);
                if (bl10) continue;
                throw new alk("The SecSign ID Server could not send an e-mail with a notification about a pending certificate signing request to " + string7 + ".");
            }
        }
    }

    public static void a(String string, Date date, Long l10, String string2, boolean bl10, boolean bl11) throws bg7 {
        if (null == string) {
            throw new bg7(2002, false, "The specified signature password cannot be checked since no authentication password has been stored in the database.");
        }
        byte[] byArray = cn.b(string);
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, 16);
        if (bl11 && !bl10) {
            throw new bg7(611, false, "The signature password still has its initial value. The user needs to replace it with an own password before first.");
        }
        byte[] byArray3 = new byte[32];
        System.arraycopy(byArray, 16, byArray3, 0, 32);
        byte[] byArray4 = eb.a(new dw(new em()), string2.getBytes(StandardCharsets.UTF_8), byArray2, 2048, 32);
        if (!Arrays.equals(byArray4, byArray3)) {
            throw new bg7(2002, false, "The specified signature password is not correct.");
        }
        if (null != l10 && null != date) {
            long l11 = (System.currentTimeMillis() - date.getTime()) / 60000L;
            ns.f("The signature PIN is " + l11 + " minutes old. The PIN policy allows a maximum age of " + l10 + " minutes.");
            if (l11 > l10) {
                throw new bg7(618, false, "The specified signature password is has expired and must be changed.");
            }
        }
    }

    public void a(Long l10, amw amw2, Long l11, Connection connection) throws as7 {
        long l12;
        List<IdProfile> list;
        SecSignID secSignID;
        List<SoftSignUnit> list2;
        ns.c("Sending a download link e-mail to the owner of the SoftSignUnit with ID " + l10 + ".");
        SoftSignUnit softSignUnit = new SoftSignUnit();
        softSignUnit.e(l10);
        try {
            list2 = this.i(softSignUnit, connection);
        }
        catch (Exception exception) {
            throw new as7("Cannot look up the SoftSignUnit with ID '" + l10 + "' from the database to send a download link: " + exception.getMessage(), 500, exception);
        }
        int n10 = list2.size();
        if (n10 != 1) {
            throw new as7("Found " + n10 + " instances of the SoftSignUnit with ID '" + l10 + "' in the database to send a download link.", 404);
        }
        SoftSignUnit softSignUnit2 = list2.get(0);
        q9 q92 = new q9(amw2, null);
        try {
            secSignID = q92.a(softSignUnit2.bp(), connection);
        }
        catch (Exception exception) {
            throw new as7("Could not look up the SecSign ID of the SoftSignUnit with ID '" + l10 + "' from the database to send a download link: " + exception.getMessage(), 500, exception);
        }
        ccy ccy2 = new ccy(amw2, null);
        try {
            IdProfile idProfile = new IdProfile();
            idProfile.setUserIdId(softSignUnit2.bp());
            list = ccy2.i(idProfile, connection);
        }
        catch (Exception exception) {
            throw new as7("Could not look up the ID profile of the smartcard owner's userIdId " + softSignUnit2.bp() + " from the database to send a renewal invitation.", 500, exception);
        }
        int n11 = list.size();
        if (n11 != 1) {
            throw new as7("There are " + n11 + " ID profiles instead of 1 for the userIdId " + softSignUnit2.bp() + " in the database. Hence, cannot look-up the user's e-mail address for the softkey download invitation.", 500);
        }
        IdProfile idProfile = list.get(0);
        String string = idProfile.getLanguage();
        String string2 = idProfile.getEmailAddress();
        if (!idProfile.getEmailAddressVerifd().booleanValue()) {
            throw new as7("The e-mail address of the userIdId " + softSignUnit2.bp() + " in the database has not been verified yet. Hence, cannot send the softkey download invitation.", 500);
        }
        String string3 = null != string ? string : amw.f().d().getLanguage();
        String string4 = aut.b();
        String string5 = b7.j(string4);
        SoftSignUnit softSignUnit3 = new SoftSignUnit();
        softSignUnit3.g(new Date());
        softSignUnit3.q(string4);
        SoftSignUnit softSignUnit4 = new SoftSignUnit();
        softSignUnit4.e(l10);
        try {
            l12 = this.a(softSignUnit3, softSignUnit4, connection);
        }
        catch (Exception exception) {
            throw new as7("Could not save the download ticket of the SoftSignUnit with ID '" + l10 + "' in the database to send a download invitation: " + exception.getMessage(), 500, exception);
        }
        if (l12 != 1L) {
            throw new as7("Changed " + l12 + " instances of the SoftSignUnit with ID '" + l10 + "' in the database instead of 1. Cannot send a download invitation.", 500);
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("USER_NAME", secSignID.b());
            hashMap.put("SOFTKEY_DOWNLOAD_AUTH_CODE", string5);
            ar9.a(66, l11).a(hashMap).a(secSignID).c(string3).a(connection);
        }
        catch (Exception exception) {
            throw new as7("Could not send an e-mail invitation to download softkey and PIN letter: " + exception.getMessage(), 500, exception);
        }
    }

    public bhc a(@NotNull RemoteSigProv remoteSigProv, Connection connection) throws alk, SQLException, bg7 {
        Objects.requireNonNull(remoteSigProv, "Cannot create authentication sign unit. Remoite signature provider is null.");
        if (remoteSigProv.b4() == null) {
            throw new alk("Cannot connect to SwissCom AIS or authenticate seal-me requests since no authentication certificate is configured for the selected remote signature provider with ID " + remoteSigProv.u() + ".");
        }
        return this.b(remoteSigProv.b4(), connection);
    }

    public bhc b(@NotNull Long l10, Connection connection) throws alk, SQLException, bg7 {
        Objects.requireNonNull(l10, "Cannot create authentication sign unit. TLS auth sign unit id is null.");
        SoftSignUnit softSignUnit = new SoftSignUnit();
        softSignUnit.e(l10);
        List<SoftSignUnit> list = this.i(softSignUnit, connection);
        if (list.size() != 1) {
            throw new alk("Cannot connect to SwissCom AIS or to seal-me since " + list.size() + " TLS client authentication certificates with the configured ID " + l10 + " were found.");
        }
        return this.c.ar().a(list.get(0), false, connection);
    }
}

