/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleSet;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.error.BMUParseException;
import de.consist.bmu.rule.impl.BMUDokumentImpl;
import de.consist.bmu.rule.util.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DocumentController {
    private static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final Log LOGGER = LogFactory.getLog(DocumentController.class);

    private DocumentController() {
    }

    public static Document parse(byte[] data) throws BMUException {
        return DocumentController.parse(new ByteArrayInputStream(data));
    }

    public static BMUDokument parseBMU(byte[] data, RuleSet ruleSet) throws BMUParseException {
        return BMUDokumentImpl.parse(new ByteArrayInputStream(data), data.length, ruleSet);
    }

    public static BMUDokument parseBMU(InputStream is, int size, RuleSet ruleSet) throws BMUParseException {
        return BMUDokumentImpl.parse(is, size, ruleSet);
    }

    public static BMUDokument parseBMU(InputStream is, RuleSet ruleSet) throws BMUParseException {
        return BMUDokumentImpl.parse(is, ruleSet);
    }

    public static BMUDokument parseBMU(File file, RuleSet ruleSet) throws BMUParseException {
        return BMUDokumentImpl.parse(file, ruleSet);
    }

    public static BMUDokument parseBMU(String resource, RuleSet ruleSet) throws BMUParseException {
        return BMUDokumentImpl.parse(DocumentController.class.getResourceAsStream(resource), -1, ruleSet);
    }

    public static Document parse(String resource) throws BMUException {
        return DocumentController.parse(DocumentController.class.getResourceAsStream(resource));
    }

    public static Document parse(File file) throws BMUException {
        try {
            return DocumentController.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new BMUException("error parsing file: " + file.getAbsolutePath(), e);
        }
    }

    public static Document parse(InputStream is) throws BMUException {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        LOGGER.debug((Object)("DocumentBuilderFactory: " + dbf.getClass().getName()));
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        ParserErrorHandler eh = new ParserErrorHandler();
        try {
            dbf.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(eh);
            doc = db.parse(is);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Document-Impl: " + doc.getClass().getName()));
                LOGGER.debug((Object)("XML Dokument geladen: " + doc.getFirstChild().getNodeName()));
            }
            if (eh._errors > 0 || eh._fatals > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("<parse> Schema validation failed, errors: " + eh._errors + ", fatals: " + eh._fatals));
                }
                throw new BMUException("Die Daten enthalten kein g\u00fcltiges XML-Dokument.");
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn((Object)("<parse> Fehler beim Parsen: " + e.getMessage()), (Throwable)e);
            throw new BMUException("<parse> Fehler beim Parsen des Documents", e);
        }
        catch (SAXException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<parse> Fehler beim Parsen: " + DocumentController.exceptionToString(e)), (Throwable)e);
            }
            throw new BMUException("Die Daten enthalten kein g\u00fcltiges XML-Dokument (" + DocumentController.exceptionToString(e) + ")", e);
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<parse> Fehler beim Parsen: " + e.getMessage()), (Throwable)e);
            }
            throw new BMUException("<parse> Fehler beim Parsen des Documents", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Closing InputStream failed", (Throwable)e);
            }
        }
        return doc;
    }

    private static String exceptionToString(SAXException e) {
        Object retVal = "";
        if (e instanceof SAXParseException) {
            SAXParseException e2 = (SAXParseException)e;
            retVal = e2.getMessage() + " (line " + Integer.toString(e2.getLineNumber()) + ", column " + Integer.toString(e2.getColumnNumber()) + ")";
        } else {
            retVal = e.getMessage();
        }
        return retVal;
    }

    public static byte[] serialize(Document doc) throws BMUException {
        return XmlUtils.serialize(doc);
    }

    @Deprecated
    public static Date getReferenzDatum(BMUDokument doc) {
        return doc.getMessageType().getFirstSignTime();
    }

    private static class ParserErrorHandler
    implements ErrorHandler {
        private static final int MAX_ERROR_LOG = 10;
        private int _errors = 0;
        private int _fatals = 0;

        private ParserErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<warning>: " + DocumentController.exceptionToString(exception)), (Throwable)exception);
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ++this._errors;
            if (this._errors <= 10 && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<error>: " + DocumentController.exceptionToString(exception)));
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ++this._fatals;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info((Object)("<fatalError>: " + DocumentController.exceptionToString(exception)), (Throwable)exception);
            } else {
                LOGGER.info((Object)("<fatalError>: " + DocumentController.exceptionToString(exception)));
            }
        }
    }
}

