/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.def;

import de.consist.bmu.rule.MeldungTyp;
import de.consist.bmu.rule.schema.Namespace;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="meldungtyp", propOrder={"_klasse", "_stufe", "_beschreibung", "_code", "_abhilfe"})
@XmlRootElement(name="Meldung")
public class MeldungTypImpl
implements MeldungTyp {
    private static final int INT_6 = 6;
    private static final int INT_10 = 10;
    private static final int INT_100 = 100;
    private static final int INT_1000 = 1000;
    private static final int INT_252 = 252;
    private static final int INT_255 = 255;
    private static final Log LOGGER = LogFactory.getLog(MeldungTypImpl.class);
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Klasse")
    private MeldungTyp.FehlerKlasse _klasse;
    @XmlElement(name="Stufe")
    private MeldungTyp.FehlerStufe _stufe;
    @XmlElement(name="Beschreibung")
    private String _beschreibung;
    @XmlElement(name="Code")
    private String _code;
    @XmlElement(name="Abhilfe")
    private String _abhilfe;

    public MeldungTypImpl() {
    }

    public MeldungTypImpl(MeldungTyp.FehlerKlasse klasse, MeldungTyp.FehlerStufe stufe, String beschreibung, String code, String abhilfe) {
        this._klasse = klasse;
        this._stufe = stufe;
        this._beschreibung = beschreibung;
        this._code = code;
        this._abhilfe = abhilfe;
    }

    public MeldungTypImpl(MeldungTyp source) {
        this._klasse = source.getKlasse();
        this._stufe = source.getStufe();
        this._beschreibung = source.getBeschreibung();
        this._code = source.getCode();
        this._abhilfe = source.getAbhilfe();
    }

    @Override
    public final MeldungTyp.FehlerKlasse getKlasse() {
        return this._klasse;
    }

    @Override
    public final void setKlasse(MeldungTyp.FehlerKlasse klasse) {
        this._klasse = klasse;
    }

    @Override
    public final MeldungTyp.FehlerStufe getStufe() {
        return this._stufe;
    }

    @Override
    public final void setStufe(MeldungTyp.FehlerStufe stufe) {
        this._stufe = stufe;
    }

    @Override
    public final String getBeschreibung() {
        return this._beschreibung;
    }

    @Override
    public final void setBeschreibung(String beschreibung) {
        this._beschreibung = beschreibung;
    }

    @Override
    public final String getCode() {
        return this._code;
    }

    @Override
    public final void setCode(String code) {
        this._code = code;
    }

    @Override
    public final String getAbhilfe() {
        return this._abhilfe;
    }

    @Override
    public final void setAbhilfe(String abhilfe) {
        this._abhilfe = abhilfe;
    }

    public final Element toXml(Document doc, String message, int index) {
        Element meldung = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Meldung");
        Element klasse = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Klasse");
        klasse.setTextContent(this.getKlasse().toString());
        meldung.appendChild(klasse);
        Element stufe = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Stufe");
        stufe.setTextContent(this.getStufe().toString());
        meldung.appendChild(stufe);
        Element beschreibung = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Beschreibung");
        Object tempBeschreibung = this.getBeschreibung();
        if (message != null) {
            tempBeschreibung = (String)tempBeschreibung + message;
        }
        if (((String)tempBeschreibung).length() > 255) {
            tempBeschreibung = ((String)tempBeschreibung).substring(0, 252);
            tempBeschreibung = (String)tempBeschreibung + "...";
            LOGGER.warn((Object)("Beschreibung ist l\u00e4nger als 255 Zeichen, Inhalt wird abgeschnitten: " + (String)tempBeschreibung));
        }
        beschreibung.setTextContent((String)tempBeschreibung);
        meldung.appendChild(beschreibung);
        Object tempCode = this.getCode();
        if (tempCode != null && index >= 0 && index < 1000) {
            Element code = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Code");
            Object indexString = null;
            indexString = index < 10 ? "00" + index : (index < 100 ? "0" + index : Integer.toString(index));
            if (((String)tempCode).length() > 6) {
                tempCode = ((String)tempCode).substring(0, 6);
                LOGGER.warn((Object)("Code wurde abgeschnitten: " + (String)tempCode));
            }
            tempCode = (String)tempCode + "_" + (String)indexString;
            code.setTextContent((String)tempCode);
            meldung.appendChild(code);
        }
        if (this.getAbhilfe() != null) {
            Element abhilfe = doc.createElementNS(Namespace.Nachricht.getUri(), Namespace.Nachricht.getPrefix() + ":Abhilfe");
            abhilfe.setTextContent(this.getAbhilfe());
            meldung.appendChild(abhilfe);
        }
        return meldung;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Klasse=" + String.valueOf((Object)this._klasse));
        builder.append(", Stufe=" + String.valueOf((Object)this._stufe));
        builder.append(", Beschreibung=" + this._beschreibung);
        builder.append(", Code=" + this._code);
        builder.append(", Abhilfe=" + this._abhilfe);
        return builder.toString();
    }

    public static class Adapter
    extends XmlAdapter<MeldungTypImpl, MeldungTyp> {
        public final MeldungTyp unmarshal(MeldungTypImpl meldungTypImpl) {
            return meldungTypImpl;
        }

        public final MeldungTypImpl marshal(MeldungTyp meldungTyp) {
            return (MeldungTypImpl)meldungTyp;
        }
    }
}

