/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.BMUMessageTypeEnum;
import de.consist.bmu.rule.MeldungTyp;
import de.consist.bmu.rule.Rule;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.RuleSet;
import de.consist.bmu.rule.RuleSetResult;
import de.consist.bmu.rule.Version;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleImplSchemaNachricht;
import de.consist.bmu.rule.impl.RuleImplSignatureVerification;
import de.consist.bmu.rule.impl.RuleImplSignatureVerificationRA;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.impl.RuleSetResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuleSetImpl
implements RuleSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleSetImpl.class);
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private List<Rule> _ruleList;
    private RuleDef _ruleDefBezugNoError;
    private RuleDef _ruleDefBezugError;
    private Map<String, Rule> _ruleMap = new HashMap<String, Rule>();
    private Map<String, Rule> _ruleIdMap = new HashMap<String, Rule>();

    public RuleSetImpl(List<Rule> ruleList, RuleDef ruleDefBezugNoError, RuleDef ruleDefBezugError) {
        this._ruleList = ruleList;
        for (Rule rule : ruleList) {
            if (!(rule instanceof RuleImpl)) continue;
            this._ruleMap.put(((RuleImpl)rule).getRuleDef().getName(), rule);
            this._ruleIdMap.put(((RuleImpl)rule).getRuleDef().getId(), rule);
        }
        this._ruleDefBezugNoError = ruleDefBezugNoError;
        this._ruleDefBezugError = ruleDefBezugError;
    }

    @Override
    public final RuleSetResult execute(BMUDokument bmuDok) throws BMUException {
        return this.execute(bmuDok, true);
    }

    @Override
    public final RuleSetResult execute(BMUDokument bmuDok, boolean pruefeNachricht) throws BMUException {
        ArrayList<RuleResult> resultList = new ArrayList<RuleResult>();
        RuleSetResult.Status status = RuleSetResult.Status.OK;
        MeldungTyp.FehlerStufe fehlerStufe = MeldungTyp.FehlerStufe.INFO;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("F\u00fchre " + this._ruleList.size() + " Pr\u00fcfungen aus."));
        }
        boolean signaturesVerified = false;
        for (Rule rule : this._ruleList) {
            if (rule instanceof RuleImpl) {
                RuleDef ruleDef;
                if (rule instanceof RuleImplSchemaNachricht && !pruefeNachricht) {
                    LOGGER.debug((Object)"Pr\u00fcfung auf 'msg:Nachricht' wird nicht ausgef\u00fchrt!");
                    continue;
                }
                RuleImpl ruleImpl = (RuleImpl)rule;
                List<RuleResult> ruleResultList = ruleImpl.executeInternal(bmuDok);
                BMUMessageType msgType = bmuDok.getMessageType();
                if ((rule instanceof RuleImplSignatureVerification && !BMUMessageTypeEnum.RegisterAuszug.equals((Object)msgType.getEnumType()) || rule instanceof RuleImplSignatureVerificationRA && BMUMessageTypeEnum.RegisterAuszug.equals((Object)msgType.getEnumType())) && ruleImpl.isEnabled(bmuDok)) {
                    signaturesVerified = true;
                    if (!ruleResultList.isEmpty()) {
                        status = RuleSetResult.Status.SIGNATURE_ERROR;
                    }
                }
                if (ruleResultList.isEmpty()) continue;
                MeldungTyp.FehlerStufe ruleResultFehlerStufe = ruleResultList.get(0).getRuleDef().getMeldung().getStufe();
                if (ruleResultFehlerStufe.ordinal() < fehlerStufe.ordinal()) {
                    fehlerStufe = ruleResultFehlerStufe;
                }
                if (ruleResultFehlerStufe.equals((Object)MeldungTyp.FehlerStufe.DEBUG)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Regel mit Fehlerstufe 'DEBUG' :\n" + String.valueOf(ruleResultList)));
                    }
                } else {
                    resultList.addAll(ruleResultList);
                }
                if (!(ruleDef = ((RuleImpl)rule).getRuleDef()).isAbbruch()) continue;
                LOGGER.info((Object)("Pr\u00fcfung abgebrochen nach Regel: " + ruleDef.getName()));
                break;
            }
            LOGGER.error((Object)("Regel erbt nicht von 'RuleImpl': " + rule.getClass().getName()));
            throw new BMUException("Regel erbt nicht von 'RuleImpl': " + rule.getClass().getName());
        }
        if (!signaturesVerified) {
            status = RuleSetResult.Status.SIGNATURES_NOT_VERIFIED;
        }
        String docNr = "k.A.";
        if (bmuDok.getMessageType().getDocNr() != null && bmuDok.getMessageType().getDocNr().length() > 0) {
            docNr = bmuDok.getMessageType().getDocNr();
        }
        String bezugMessage = "Fachliche Nummer: " + docNr + ", Pr\u00fcfzeitpunkt: " + this.DATE_FORMAT.format(new Date()) + ", Version der Pr\u00fcfbibliothek: " + Version.getVersion();
        RuleResultImpl bezugResult = null;
        bezugResult = resultList.isEmpty() ? new RuleResultImpl(this._ruleDefBezugNoError, 1, bezugMessage) : new RuleResultImpl(this._ruleDefBezugError, 1, bezugMessage);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)(resultList.size() + " Meldungen erzeugt, h\u00f6chste Stufe: " + String.valueOf((Object)fehlerStufe) + "."));
        }
        RuleSetResultImpl rsr = new RuleSetResultImpl(bmuDok, this, resultList, bezugResult, fehlerStufe, status);
        try {
            XPathFassade xpf = XPathFassade.getInstance();
            NodeList nl = xpf.evaluateNodeList(bmuDok.getDocument(), "descendant::svc:Meldung");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!(node instanceof Element)) continue;
                String klasse = xpf.evaluate((Element)node, "descendant::svc:Klasse");
                String stufe = xpf.evaluate((Element)node, "descendant::svc:Stufe");
                String beschreibung = xpf.evaluate((Element)node, "descendant::svc:Beschreibung");
                String code = xpf.evaluate((Element)node, "descendant::svc:Code");
                String abhilfe = xpf.evaluate((Element)node, "descendant::svc:Abhilfe");
                rsr.addZKSMeldung(klasse, stufe, beschreibung, code, abhilfe);
                LOGGER.debug((Object)("ZKS-Meldung verarbeitet: Klasse=" + klasse + ", Stufe=" + stufe + ", Beschreibung=" + beschreibung + ", Code=" + code + ", Abhilfe=" + abhilfe));
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.error((Object)"Error evaluating 'svc:Meldung'", (Throwable)e);
        }
        return rsr;
    }

    @Override
    public final List<Rule> getRuleList() {
        return this._ruleList;
    }

    @Override
    @Deprecated
    public final Rule getRuleByName(String name) {
        return this._ruleMap.get(name);
    }

    @Override
    public final Rule getRuleById(String id) {
        return this._ruleIdMap.get(id);
    }

    @Override
    public final RuleDef getRuleDefBezugNoError() {
        return this._ruleDefBezugNoError;
    }

    @Override
    public final RuleDef getRuleDefBezugError() {
        return this._ruleDefBezugError;
    }
}

