/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.util;

import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.util.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ByteUtils {
    private static final int BUFFERSIZE_DEFAULT = 1024;
    private static final Log LOGGER = LogFactory.getLog(ByteUtils.class);

    private ByteUtils() {
    }

    public static byte[] readFromStream(InputStream is) throws BMUException {
        return ByteUtils.readFromStream(is, 1024);
    }

    public static byte[] readFromStream(InputStream is, int buffersize) throws BMUException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(buffersize);
        byte[] data = new byte[buffersize];
        int len = 0;
        try {
            while ((len = is.read(data)) != -1) {
                bos.write(data, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"error reading from stream", (Throwable)e);
            throw new BMUException("error reading from stream", e);
        }
        return bos.toByteArray();
    }

    public static byte[] readFromResource(String name, int buffersize) throws BMUException {
        InputStream is = XmlUtils.class.getResourceAsStream(name);
        if (is == null) {
            LOGGER.error((Object)("error loading resource: " + name));
            throw new BMUException("error loading resource: " + name);
        }
        return ByteUtils.readFromStream(is, buffersize);
    }

    public static byte[] readFromResource(String name) throws BMUException {
        InputStream is = XmlUtils.class.getResourceAsStream(name);
        if (is == null) {
            LOGGER.error((Object)("error loading resource: " + name));
            throw new BMUException("error loading resource: " + name);
        }
        return ByteUtils.readFromStream(is);
    }

    public static byte[] readFromFile(String filename) throws BMUException {
        byte[] data = null;
        File f = new File(filename);
        if (f.exists()) {
            try {
                data = ByteUtils.readFromStream(new FileInputStream(f));
            }
            catch (Exception ex) {
                LOGGER.error((Object)("error reading Document from file: " + f.getAbsolutePath()));
                throw new BMUException("error reading Document from file: " + f.getAbsolutePath(), ex);
            }
        } else {
            LOGGER.error((Object)("File not found: " + f.getAbsolutePath()));
            throw new BMUException("File not found: " + f.getAbsolutePath());
        }
        return data;
    }

    public static void writeToFile(String filename, byte[] data) throws BMUException {
        File f = new File(filename);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ReadableByteChannel inChannel = Channels.newChannel(bais);
            FileOutputStream fos = new FileOutputStream(f);
            FileChannel outChannel = fos.getChannel();
            outChannel.transferFrom(inChannel, 0L, data.length);
            outChannel.close();
            fos.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error writing to file: " + f.getAbsolutePath()), (Throwable)e);
            throw new BMUException("error writing to file: " + f.getAbsolutePath(), e);
        }
    }

    public static boolean match(byte[] data, byte[] pattern) {
        int iPattern = 0;
        for (int i = 0; i < data.length; ++i) {
            iPattern = data[i] == pattern[iPattern] ? ++iPattern : (data[i] == pattern[0] ? 1 : 0);
            if (iPattern != pattern.length) continue;
            return true;
        }
        return false;
    }
}

