/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.xmlsec;

import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.util.CertUtils;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xmlsec.XmlSecException;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlSecFassade {
    private static final Log LOGGER = LogFactory.getLog(XmlSecFassade.class);
    private static final String RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private static final String RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    private static final String RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    private static final String RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    private static final String XADES_NS = "http://uri.etsi.org/01903/v1.3.2#";
    private static boolean _useJSR105 = false;
    private static XmlSecFassade _theInstance = null;
    private static boolean _bcFirst = false;
    private XMLSignatureFactory _signatureFactory = null;
    public static final String XPATH_INTERSECT = "here()/ancestor::*[6]";
    public static final String XPATH_SUBTRACT_INCLUDE_PREVIOUS_SIG = "here()/ancestor::*[5]/following-sibling::*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']";
    public static final String XPATH_SUBTRACT_EXCLUDE_PREVIOUS_SIG = "here()/ancestor::*[6]/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']";

    private XmlSecFassade() {
    }

    public static synchronized XmlSecFassade getInstance() {
        if (_theInstance == null && !(_theInstance = new XmlSecFassade()).init()) {
            LOGGER.error((Object)"Fehler beim Initialisieren von XmlSec");
            _theInstance = null;
        }
        return _theInstance;
    }

    public static boolean isUseJSR105() {
        return _useJSR105;
    }

    public static boolean isBcFirst() {
        return _bcFirst;
    }

    public static void setUseJSR105(boolean useJSR105) {
        _useJSR105 = useJSR105;
    }

    public synchronized boolean init() {
        if (this._signatureFactory != null) {
            return true;
        }
        boolean binitialized = true;
        String javaVersion = System.getProperty("java.version");
        boolean bcFirst = javaVersion.startsWith("1.");
        if (XmlSecFassade.loadBouncyCastle()) {
            LOGGER.debug((Object)"BouncyCastle ist initialisiert");
        } else {
            LOGGER.error((Object)"BouncyCastle konnte nicht geladen werden.");
        }
        Provider[] providers = Security.getProviders();
        if (providers != null && providers.length > 0) {
            if ("BC".equals(providers[0].getName())) {
                if (bcFirst) {
                    LOGGER.debug((Object)("BouncyCastle " + providers[0].getName() + ", Version " + providers[0].getVersionStr()));
                } else {
                    LOGGER.debug((Object)"BouncyCastle ist der erste Provider in der Liste mit Java > 1.8");
                }
            } else if (bcFirst) {
                LOGGER.debug((Object)"BouncyCastle ist nicht der erste Provider in der Liste.");
            } else {
                LOGGER.debug((Object)("Provider " + providers[0].getName() + ", Version " + providers[0].getVersionStr()));
            }
        } else {
            LOGGER.error((Object)"Liste der Provider kann nicht abgefragt werden.");
        }
        if (!Init.isInitialized()) {
            LOGGER.debug((Object)"Initialisiere XMLSEC");
            System.setProperty("org.apache.xml.security.resource.config", "security-config-xalan.xml");
            Init.init();
            LOGGER.debug((Object)"XMLSEC ist initialisiert");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Java version: " + javaVersion));
        }
        this._signatureFactory = XMLSignatureFactory.getInstance("DOM");
        Package pkg = ClassLoader.getPlatformClassLoader().getDefinedPackage("xmlsec");
        if (pkg != null) {
            LOGGER.debug((Object)(pkg.getImplementationTitle() + ", version: " + pkg.getImplementationVersion()));
        } else {
            LOGGER.debug((Object)"<init> Keine Versionsinformation f\u00fcr XmlSec gefunden!");
        }
        return binitialized;
    }

    private static boolean checkBrainpoolP256r1() {
        String[] curves;
        for (String curve : curves = Security.getProvider("SunEC").getProperty("AlgorithmParameters.EC SupportedCurves").split("\\|")) {
            if (!curve.contains("1.3.36.3.3.2.8.1.1.7")) continue;
            LOGGER.debug((Object)"brainpoolP256r1 supported by SunEC");
            return true;
        }
        LOGGER.info((Object)"Die elliptische Kurve 'brainpoolP256r1' wird vom SunEC Provider nicht unterst\u00fctzt.");
        return false;
    }

    public static boolean loadBouncyCastle() {
        if (Security.getProvider("BC") == null) {
            try {
                System.setProperty("org.bouncycastle.pkcs12.ignore_useless_passwd", "true");
                Class<?> bcProvClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                Provider bcProv = (Provider)bcProvClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String javaVersion = System.getProperty("java.version");
                String javaVendor = System.getProperty("java.vendor");
                LOGGER.info((Object)("Java version: " + javaVersion + ", vendor: " + javaVendor));
                boolean brainPoolSupported = XmlSecFassade.checkBrainpoolP256r1();
                if (javaVersion.startsWith("1.") || !brainPoolSupported) {
                    if (Security.insertProviderAt(bcProv, 1) > -1) {
                        LOGGER.info((Object)"BouncyCastle Provider wurde an Position 1 eingef\u00fcgt.");
                        _bcFirst = true;
                        return true;
                    }
                } else if (Security.addProvider(bcProv) > -1) {
                    LOGGER.info((Object)"BouncyCastle Provider wurde hinzugef\u00fcgt.");
                    _bcFirst = false;
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"BouncyCastle nicht gefunden!", (Throwable)e);
            }
        } else {
            LOGGER.info((Object)"BouncyCastle Provider ist bereits vorhanden.");
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean pruefeSignaturen(Document doc, boolean signatureMustExist, String sigID) throws XmlSecException {
        if (doc == null) {
            throw new IllegalArgumentException("Document must not be null");
        }
        try {
            return this.pruefeSignaturen0(doc, signatureMustExist, sigID);
        }
        catch (MarshalException e) {
            LOGGER.error((Object)"<pruefeSignaturen>", (Throwable)e);
            throw new XmlSecException(e);
        }
        catch (XMLSignatureException e) {
            LOGGER.error((Object)"<pruefeSignaturen>", (Throwable)e);
            throw new XmlSecException(e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"<pruefeSignaturen>", (Throwable)e);
            throw new XmlSecException(e);
        }
    }

    public List<String> verifySignatures(Document doc) throws XmlSecException {
        if (doc == null) {
            throw new IllegalArgumentException("Document must not be null");
        }
        ArrayList<String> sigIdInvalidList = new ArrayList<String>();
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        LOGGER.debug((Object)("Pr\u00fcfe " + nl.getLength() + " Signatur(en)"));
        for (int i = 0; i < nl.getLength(); ++i) {
            Node sigNode = nl.item(i);
            Node idNode = sigNode.getAttributes().getNamedItem("Id");
            String sigId = null;
            if (idNode == null) continue;
            sigId = idNode.getTextContent();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Pr\u00fcfe Signatur " + i + "/" + nl.getLength() + " mit Id='" + sigId + "'"));
            }
            if (this.verifySignature(doc, sigId)) continue;
            sigIdInvalidList.add(sigId);
        }
        return sigIdInvalidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifySignature(Document doc, String sigId) throws XmlSecException {
        boolean valid = true;
        if (doc == null) {
            throw new IllegalArgumentException("No document given.");
        }
        Node sigNode = null;
        String sigXPath = "descendant::ds:Signature[@Id='" + sigId + "']";
        try {
            sigNode = XPathFassade.getInstance().evaluateNode(doc, sigXPath);
        }
        catch (XPathExpressionException e) {
            LOGGER.error((Object)("error evaluating XPath: " + sigXPath));
            throw new XmlSecException("error evaluating XPath: " + sigXPath, e);
        }
        if (_useJSR105) {
            XMLSignature signature;
            DOMValidateContext valContext;
            block18: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"using JSR 105 API..");
                }
                valContext = new DOMValidateContext(new KeyValueKeySelector(), sigNode);
                valContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
                signature = null;
                try {
                    XMLSignatureFactory xMLSignatureFactory = this._signatureFactory;
                    synchronized (xMLSignatureFactory) {
                        signature = this._signatureFactory.unmarshalXMLSignature(valContext);
                    }
                }
                catch (MarshalException e) {
                    LOGGER.debug((Object)("unmarshal signature failed: " + e.getMessage()));
                    LOGGER.debug((Object)"trying apache xmlsec implementation..");
                    if (this.verifySignatureApache((Element)sigNode)) break block18;
                    valid = false;
                }
            }
            if (signature != null) {
                try {
                    this.prepareXadesReferenceId((Element)sigNode);
                    boolean coreValidity = signature.validate(valContext);
                    if (!coreValidity) {
                        LOGGER.error((Object)("Signatur mit ID '" + signature.getId() + "' ist NICHT g\u00fcltig!"));
                        valid = false;
                        boolean sv = signature.getSignatureValue().validate(valContext);
                        LOGGER.debug((Object)("signature value validation status: " + sv));
                        javax.xml.crypto.dsig.SignedInfo si = signature.getSignedInfo();
                        Iterator<javax.xml.crypto.dsig.Reference> iter = si.getReferences().iterator();
                        int j = 0;
                        while (iter.hasNext()) {
                            javax.xml.crypto.dsig.Reference ref = iter.next();
                            boolean refValid = ref.validate(valContext);
                            LOGGER.debug((Object)("ref[" + j + "], id '" + ref.getId() + "' validity status: " + refValid));
                            if (!refValid) {
                                this.dumpReference(ref);
                            }
                            ++j;
                        }
                    }
                    LOGGER.debug((Object)("Signatur mit ID '" + signature.getId() + "' ist g\u00fcltig"));
                }
                catch (XMLSignatureException e) {
                    LOGGER.error((Object)"<pruefeSignaturen>", (Throwable)e);
                    throw new XmlSecException(e);
                }
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"using Apache Santuario API..");
            }
            valid = this.verifySignatureApache((Element)sigNode);
        }
        return valid;
    }

    public boolean verifySignatureApache(Element signElement) throws XmlSecException {
        boolean result = false;
        long start = System.currentTimeMillis();
        org.apache.xml.security.signature.XMLSignature signature = null;
        PublicKey pk = null;
        try {
            this.prepareXadesReferenceId(signElement);
            signature = new org.apache.xml.security.signature.XMLSignature(signElement, "");
            KeyInfo ki = signature.getKeyInfo();
            pk = ki.getPublicKey();
            result = signature.checkSignatureValue((Key)pk);
            if (result) {
                LOGGER.debug((Object)"Signature passed core validation!");
            } else {
                SignedInfo si = signature.getSignedInfo();
                LOGGER.warn((Object)"Signature failed core validation!");
                boolean refStatus = si.verifyReferences();
                LOGGER.debug((Object)("Reference validation status: " + refStatus));
                if (!refStatus) {
                    for (int i = 0; i < si.getLength(); ++i) {
                        Reference ref = si.item(i);
                        boolean refValid = ref.verify();
                        LOGGER.debug((Object)("ref[" + i + "], id '" + ref.getId() + "' validity status: " + refValid));
                    }
                }
            }
        }
        catch (XMLSecurityException e) {
            LOGGER.error((Object)"error verifying signature", (Throwable)e);
            throw new XmlSecException("error verifying signature", e);
        }
        if (LOGGER.isTraceEnabled()) {
            long dauer = System.currentTimeMillis() - start;
            LOGGER.trace((Object)("Dauer der Pr\u00fcfung: " + (dauer > 5000L ? dauer / 1000L + "s." : dauer + "ms.")));
        }
        return result;
    }

    public PublicKey unmarshalECDSAKeyValue(Element kvtElem) throws MarshalException {
        String uri;
        Element curElem = XmlUtils.getFirstChildElement(kvtElem);
        if (curElem == null) {
            throw new MarshalException("KeyValue must contain at least one type");
        }
        String oid = null;
        String ecdsaNS = Namespace.xmldsig_more.getUri();
        if (curElem.getLocalName().equals("ECParameters") && ecdsaNS.equals(curElem.getNamespaceURI())) {
            throw new UnsupportedOperationException("ECParameters not supported");
        }
        if (curElem.getLocalName().equals("NamedCurve") && ecdsaNS.equals(curElem.getNamespaceURI())) {
            uri = XmlUtils.getAttributeValue(curElem, "URN");
            if (!uri.startsWith("urn:oid:")) {
                throw new MarshalException("Invalid NamedCurve URI");
            }
        } else {
            throw new MarshalException("Invalid ECKeyValue");
        }
        oid = uri.substring(8);
        curElem = XmlUtils.getNextSiblingElement(kvtElem);
        PublicKey pk = null;
        PublicKey pk1 = null;
        try {
            Element publicKeyXElem = XmlUtils.getChildElement(curElem, ecdsaNS, "X");
            String publicKeyXStr = publicKeyXElem.getAttributeNS(null, "Value");
            Element publicKeyYElem = XmlUtils.getChildElement(curElem, ecdsaNS, "Y");
            String publicKeyYStr = publicKeyYElem.getAttributeNS(null, "Value");
            pk = this.getECPublicKey(publicKeyXStr, publicKeyYStr, oid);
            pk1 = this.generatePublicKey(new BigInteger(publicKeyXStr, 10), new BigInteger(publicKeyYStr, 10), oid);
            if (!pk.equals(pk1)) {
                LOGGER.error((Object)"keys differ!");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting public key", (Throwable)e);
        }
        return pk;
    }

    private PublicKey generatePublicKey(BigInteger x, BigInteger y, String sCurve) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)sCurve);
        ECPoint pPublicPoint = spec.getCurve().createPoint(x, y);
        ECPublicKeySpec publicSpec = new ECPublicKeySpec(pPublicPoint, (ECParameterSpec)spec);
        KeyFactory keyfac = KeyFactory.getInstance("ECDSA", "BC");
        return keyfac.generatePublic((KeySpec)publicSpec);
    }

    private PublicKey getECPublicKey(String x, String y, String curve) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)curve);
        ECCurve ecCurve = spec.getCurve();
        ECPoint ecPoint = ecCurve.createPoint(new BigInteger(x), new BigInteger(y));
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)spec);
        KeyFactory kf = KeyFactory.getInstance("EC", "BC");
        ECPublicKey pk = (ECPublicKey)kf.generatePublic((KeySpec)pubKeySpec);
        return pk;
    }

    public boolean validateX509Certificate(Element sigElem) {
        boolean valid = false;
        org.apache.xml.security.signature.XMLSignature signature = null;
        try {
            signature = new org.apache.xml.security.signature.XMLSignature(sigElem, "");
            KeyInfo ki = signature.getKeyInfo();
            if (ki != null) {
                LOGGER.trace((Object)("containsKeyValue: " + ki.containsKeyValue()));
                org.apache.xml.security.keys.content.KeyValue kv = ki.itemKeyValue(0);
                if (kv != null) {
                    Element kvElem = XmlUtils.getFirstChildElement(kv.getElement());
                    PublicKey pk = null;
                    pk = "ECDSAKeyValue".equals(kvElem.getLocalName()) && Namespace.xmldsig_more.getUri().equals(kvElem.getNamespaceURI()) ? this.unmarshalECDSAKeyValue(XmlUtils.getFirstChildElement(kvElem)) : ki.getPublicKey();
                    if (pk != null && ki.getX509Certificate() != null && ki.getX509Certificate().getPublicKey() != null) {
                        PublicKey pkCert = ki.getX509Certificate().getPublicKey();
                        byte[] key = pk.getEncoded();
                        byte[] certKey = pkCert.getEncoded();
                        LOGGER.trace((Object)("key from 'ds:KeyValue:        " + Hex.encodeHexString((byte[])key)));
                        LOGGER.trace((Object)("key from 'ds:X509Certificate: " + Hex.encodeHexString((byte[])certKey)));
                        valid = Arrays.equals(key, certKey);
                    } else if (!valid) {
                        LOGGER.error((Object)"PublicKey and/or X509Certificate is not accessible");
                    }
                } else {
                    LOGGER.error((Object)"KeyValue not accessible");
                }
            } else {
                LOGGER.error((Object)"KeyInfo not accessible");
            }
        }
        catch (XMLSecurityException e) {
            LOGGER.error((Object)"error validating public key", (Throwable)e);
        }
        catch (MarshalException e) {
            LOGGER.error((Object)"error validating public key", (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"error validating public key", e);
        }
        return valid;
    }

    @Deprecated
    protected boolean pruefeSignaturen0(Document doc, boolean signatureMustExist, String sigID) throws MarshalException, XMLSignatureException, XmlSecException {
        boolean valid = true;
        if (doc == null) {
            throw new IllegalArgumentException("No document given.");
        }
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0 && signatureMustExist) {
            valid = false;
            LOGGER.warn((Object)"Cannot find Signature element");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node sigNode = nl.item(i);
            DOMValidateContext valContext = new DOMValidateContext(new KeyValueKeySelector(), nl.item(i));
            valContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
            XMLSignature signature = null;
            try {
                signature = this._signatureFactory.unmarshalXMLSignature(valContext);
            }
            catch (MarshalException e) {
                LOGGER.debug((Object)("unmarshal signature failed: " + e.getMessage()));
                LOGGER.debug((Object)"trying apache xmlsec implementation..");
                if (this.verifySignatureApache((Element)sigNode)) continue;
                valid = false;
                continue;
            }
            if (sigID != null && !sigID.equals(signature.getId())) continue;
            LOGGER.debug((Object)("Pr\u00fcfe Signatur mit ID=" + signature.getId()));
            boolean coreValidity = signature.validate(valContext);
            javax.xml.crypto.dsig.SignedInfo si = signature.getSignedInfo();
            Iterator<javax.xml.crypto.dsig.Reference> iter = null;
            if (LOGGER.isDebugEnabled()) {
                iter = si.getReferences().iterator();
                int j = 0;
                while (iter.hasNext()) {
                    javax.xml.crypto.dsig.Reference ref = iter.next();
                    boolean refValid = ref.validate(valContext);
                    LOGGER.debug((Object)("ref[" + j + "], id '" + ref.getId() + "' validity status: " + refValid));
                    this.dumpReference(ref);
                    ++j;
                }
            }
            if (!coreValidity) {
                LOGGER.error((Object)("Signatur mit ID '" + signature.getId() + "' ist NICHT g\u00fcltig!"));
                valid = false;
                boolean sv = signature.getSignatureValue().validate(valContext);
                LOGGER.debug((Object)("signature value validation status: " + sv));
                iter = si.getReferences().iterator();
                int j = 0;
                while (iter.hasNext()) {
                    javax.xml.crypto.dsig.Reference ref = iter.next();
                    boolean refValid = ref.validate(valContext);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("ref[" + j + "], id '" + ref.getId() + "' validity status: " + refValid));
                        if (!refValid) {
                            this.dumpReference(ref);
                        }
                    }
                    ++j;
                }
                continue;
            }
            LOGGER.debug((Object)("Signatur mit ID '" + signature.getId() + "' ist g\u00fcltig"));
        }
        return valid;
    }

    private void dumpReference(javax.xml.crypto.dsig.Reference ref) {
        LOGGER.debug((Object)("dumping reference: " + ref.getId() + ", URI: " + ref.getURI()));
        byte[] dv = ref.getDigestValue();
        if (dv != null) {
            LOGGER.debug((Object)("digestvalue: " + Hex.encodeHexString((byte[])dv)));
        } else {
            LOGGER.debug((Object)"no digest value");
        }
        InputStream is = ref.getDigestInputStream();
        if (is != null) {
            try {
                byte[] data = new byte[is.available()];
                is.read(data);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("digest input data:\n" + new String(data)));
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"<dumpReference>", (Throwable)e);
            }
        } else {
            LOGGER.debug((Object)"digest input stream of refernce is null");
        }
    }

    private void prepareXadesReferenceId(Element signElement) {
        NodeList nlXadesSignedProperties = signElement.getElementsByTagNameNS(XADES_NS, "SignedProperties");
        if (nlXadesSignedProperties.getLength() > 0) {
            Element xadesSignedProperties = (Element)nlXadesSignedProperties.item(0);
            if (xadesSignedProperties.hasAttribute("Id")) {
                xadesSignedProperties.setIdAttribute("Id", true);
            } else {
                LOGGER.debug((Object)"Attribute 'Id' not found on Element 'XadesSignedProperties'");
            }
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(javax.xml.crypto.dsig.keyinfo.KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            if (method == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (xmlStructure instanceof KeyValue) {
                    LOGGER.debug((Object)"XMLStructure of type 'KeyValue' found.");
                    PublicKey pk = null;
                    try {
                        pk = ((KeyValue)xmlStructure).getPublicKey();
                    }
                    catch (KeyException ke) {
                        LOGGER.error((Object)("KeyException: " + ke.getMessage()));
                        throw new KeySelectorException(ke);
                    }
                    if (KeyValueKeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) {
                        return new SimpleKeySelectorResult(pk);
                    }
                    LOGGER.error((Object)("Algorithm of KeyValue not compatible: " + pk.getAlgorithm() + ", expected: " + sm.getAlgorithm()));
                    continue;
                }
                if (xmlStructure instanceof RetrievalMethod) {
                    RetrievalMethod rm = (RetrievalMethod)xmlStructure;
                    LOGGER.debug((Object)("RetrievalMethod found, URI: " + rm.getURI()));
                    try {
                        Data derefData = rm.dereference(context);
                        if (derefData instanceof NodeSetData) {
                            NodeSetData nds = (NodeSetData)derefData;
                            for (Object o : nds) {
                                if (o instanceof Element) {
                                    String certb64 = XPathFassade.getInstance().evaluate((Element)o, "//ds:X509Certificate");
                                    X509Certificate cert = CertUtils.getX509CertificateFromBase64(certb64);
                                    PublicKey pk = cert.getPublicKey();
                                    if (KeyValueKeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) {
                                        return new SimpleKeySelectorResult(pk);
                                    }
                                    LOGGER.error((Object)("Algorithm of KeyValue not compatible: " + pk.getAlgorithm() + ", expected: " + sm.getAlgorithm()));
                                    continue;
                                }
                                LOGGER.error((Object)("Unexpected NodeSetData entry: " + (o != null ? o.getClass().getName() : "null")));
                            }
                            continue;
                        }
                        LOGGER.error((Object)("KeyInfo type not supported: " + (derefData != null ? derefData.getClass().getName() : "null")));
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Error selecting KeyValue: " + e.getMessage()));
                        throw new KeySelectorException(e);
                    }
                }
                LOGGER.debug((Object)("KeyValue select-method not supported: " + (xmlStructure != null ? xmlStructure.getClass().getName() : "null")));
            }
            LOGGER.error((Object)"No KeyValue found!");
            throw new KeySelectorException("No KeyValue element found!");
        }

        static boolean algEquals(String algURI, String algName) {
            if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                return true;
            }
            return algName.equalsIgnoreCase("RSA") && (algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || algURI.equalsIgnoreCase(XmlSecFassade.RSA_SHA256) || algURI.equalsIgnoreCase(XmlSecFassade.RSA_SHA384) || algURI.equalsIgnoreCase(XmlSecFassade.RSA_SHA512) || algURI.equalsIgnoreCase(XmlSecFassade.RSA_RIPEMD160));
        }
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey _pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this._pk = pk;
        }

        @Override
        public Key getKey() {
            return this._pk;
        }
    }
}

