/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.DecoMon;
import com.jamonapi.MonInternals;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;

class TimeMonNano
extends DecoMon {
    static final long NANOSECS_PER_MILLISEC = 1000000L;
    private static final long serialVersionUID = 279L;
    protected long startTime;

    public TimeMonNano(MonKey key, MonInternals monData) {
        super(key, monData);
    }

    @Override
    public Monitor start() {
        super.start();
        this.startTime = System.nanoTime();
        return this;
    }

    @Override
    public Monitor stop() {
        long endTime = System.nanoTime();
        this.setAccessStats(endTime / 1000000L);
        this.add(endTime - this.startTime);
        super.stop();
        return this;
    }

    @Override
    public Object getValue(String key) {
        if ("starttime".equalsIgnoreCase(key)) {
            return new Long(this.startTime);
        }
        return super.getValue(key);
    }

    @Override
    public void reset() {
        super.reset();
        this.startTime = 0L;
    }
}

