/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import java.util.Arrays;

class ArraySorter {
    private Object[][] array;
    private int sortCol;
    private String sortOrder;

    public ArraySorter(Object[][] array, int sortCol, String sortOrder) {
        this.array = array;
        this.sortCol = sortCol;
        this.sortOrder = sortOrder;
    }

    private int getRows() {
        return this.array.length;
    }

    private int getCols() {
        return this.array[0].length;
    }

    private Object[] getArrayToSort() {
        Object[] arrayToSort = new Object[this.getRows()];
        int i = 0;
        while (i < this.getRows()) {
            arrayToSort[i] = this.array[i];
            ++i;
        }
        return arrayToSort;
    }

    private ArraySorterEntry[] getArraySorterEntries() {
        Object[] arrayToSort = this.getArrayToSort();
        ArraySorterEntry[] arraySorterEntries = new ArraySorterEntry[this.getRows()];
        int i = 0;
        while (i < this.getRows()) {
            arraySorterEntries[i] = new ArraySorterEntry(arrayToSort[i], (Comparable)this.array[i][this.sortCol]);
            ++i;
        }
        return arraySorterEntries;
    }

    public Object[][] sort() {
        Object[] arraySorterEntries = this.getArraySorterEntries();
        Arrays.sort(arraySorterEntries);
        Object[][] returnArray = new Object[this.getRows()][this.getCols()];
        int i = 0;
        while (i < this.getRows()) {
            returnArray[i] = (Object[])((ArraySorterEntry)arraySorterEntries[i]).getSortedObject();
            ++i;
        }
        return returnArray;
    }

    private class ArraySorterEntry
    implements Comparable {
        private Object arrayValueToSort;
        private Comparable valueToSortBy;

        public ArraySorterEntry(Object arrayValueToSort, Comparable valueToSortBy) {
            this.arrayValueToSort = arrayValueToSort;
            this.valueToSortBy = valueToSortBy;
        }

        public int compareTo(Object o) {
            ArraySorterEntry sorter = (ArraySorterEntry)o;
            int compare = this.valueToSortBy.compareTo(sorter.valueToSortBy);
            if (compare == 0 || "asc".equalsIgnoreCase(ArraySorter.this.sortOrder)) {
                return compare;
            }
            if ("desc".equalsIgnoreCase(ArraySorter.this.sortOrder)) {
                return -compare;
            }
            throw new RuntimeException("Programming error: The only valid sort orders are 'asc' and 'desc', but '" + ArraySorter.this.sortOrder + "' was passed");
        }

        public Object getSortedObject() {
            return this.arrayValueToSort;
        }
    }
}

