/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.itu.bmu.BMUBehoerdlicheNummer;
import de.itu.bmu.BMUNameUndAdresse;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BMUAdressAntwortEntry {
    private static final Logger _logger = LogManager.getLogger(BMUAdressAntwortEntry.class);
    private BMUBehoerdlicheNummer _providerNummer;
    private BMUBehoerdlicheNummer _behoerdlicheNummer;
    private boolean _indicatorIstDefaultadresse;
    private BMUNameUndAdresse _firmaNameUndAdresse;
    private BMUNameUndAdresse _betriebNameUndAdresse;

    public BMUAdressAntwortEntry(Element elem) {
        this.init(elem);
    }

    private void init(Element elem) {
        if (elem != null) {
            XPathFacade xpf = XPathFacade.getInstance();
            try {
                Node betriebAdresse;
                this._providerNummer = new BMUBehoerdlicheNummer((Element)xpf.evaluateNode(elem, "zks:ProviderNummer"));
                this._behoerdlicheNummer = new BMUBehoerdlicheNummer((Element)xpf.evaluateNode(elem, "zks:BehoerdlicheNummer"));
                String indicatorString = xpf.evaluate(elem, "zks:IndicatorIstDefaultadresse");
                this._indicatorIstDefaultadresse = "1".equals(indicatorString) || "true".equals(indicatorString);
                Node firmaAdresse = xpf.evaluateNode(elem, "zks:FirmaNameUndAdresse");
                if (firmaAdresse != null) {
                    this._firmaNameUndAdresse = new BMUNameUndAdresse((Element)firmaAdresse);
                }
                if ((betriebAdresse = xpf.evaluateNode(elem, "zks:BetriebNameUndAdresse")) != null) {
                    this._betriebNameUndAdresse = new BMUNameUndAdresse((Element)betriebAdresse);
                }
            }
            catch (XmlException e) {
                _logger.error("Fehler bei der XPath-Auswertung", (Throwable)e);
            }
        }
    }

    public BMUBehoerdlicheNummer getProviderNummer() {
        return this._providerNummer;
    }

    public BMUBehoerdlicheNummer getBehoerdlicheNummer() {
        return this._behoerdlicheNummer;
    }

    public boolean getIndicatorIstDefaultadresse() {
        return this._indicatorIstDefaultadresse;
    }

    public BMUNameUndAdresse getFirmaNameUndAdresse() {
        return this._firmaNameUndAdresse;
    }

    public BMUNameUndAdresse getBetriebNameUndAdresse() {
        return this._betriebNameUndAdresse;
    }
}

