/*
 * Decompiled with CFR 0.152.
 */
package de.itu.pdf;

import de.itu.util.MD5Helper;
import de.itu.xmlsec.FileSignInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Hex;

public class PdfSignatureUtils {
    private static final Logger LOGGER = LogManager.getLogger(PdfSignatureUtils.class);

    private static byte[] getByteRangeData(ByteArrayInputStream bis, int[] byteRange) {
        int length1 = byteRange[1] + byteRange[3];
        byte[] contentSigned = new byte[length1];
        bis.skip(byteRange[0]);
        bis.read(contentSigned, 0, byteRange[1]);
        bis.skip(byteRange[2] - byteRange[1] - byteRange[0]);
        bis.read(contentSigned, byteRange[1], byteRange[3]);
        bis.reset();
        return contentSigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<String, FileSignInfo> verifySignatures(File pdfFile) throws IOException, NoSuchAlgorithmException {
        TreeMap<String, FileSignInfo> sigInfoMap = new TreeMap<String, FileSignInfo>();
        try (PDDocument pdfDoc = null;){
            ByteArrayInputStream pdfBytes = new ByteArrayInputStream(Files.readAllBytes(Paths.get(pdfFile.getAbsolutePath(), new String[0])));
            pdfDoc = Loader.loadPDF((File)pdfFile);
            String checksum = MD5Helper.getMD5FromFile(pdfFile.getAbsolutePath());
            for (PDSignature sig : pdfDoc.getSignatureDictionaries()) {
                try {
                    FileSignInfo fsi = new FileSignInfo(FileSignInfo.FileType.PDF, pdfFile.getName(), pdfFile.getAbsolutePath(), pdfFile.length(), checksum);
                    fsi.setSigSubjectName(sig.getName());
                    fsi.setSignDate(sig.getSignDate().getTime());
                    fsi.setSigValid(PdfSignatureUtils.processSignature(sig, pdfBytes, fsi));
                    fsi.setSigNodeName(fsi.getFileName());
                    sigInfoMap.put("Pdf-Signatur " + fsi.getSigID(), fsi);
                }
                catch (Exception e) {
                    LOGGER.error("Error processing Signature", (Throwable)e);
                }
            }
            pdfBytes.close();
        }
        return sigInfoMap;
    }

    private static boolean processSignature(PDSignature signature, ByteArrayInputStream pdfBytes, FileSignInfo fsi) throws CMSException, TSPException, IOException, NoSuchAlgorithmException, OperatorCreationException, CertificateException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        byte[] signedContent = PdfSignatureUtils.getByteRangeData(pdfBytes, signature.getByteRange());
        String filter = signature.getFilter();
        String subFilter = signature.getSubFilter();
        String contactInfo = Optional.ofNullable(signature.getContactInfo()).orElse("N/A");
        String reason = Optional.ofNullable(signature.getReason()).orElse("N/A");
        if (!filter.trim().equalsIgnoreCase("Adobe.PPKLite")) {
            LOGGER.error("Cannot process PDF Signature {} with filter {}", (Object)signature.getName(), (Object)filter);
            return false;
        }
        if (!(subFilter.trim().contains("ETSI.CAdES.detached") || subFilter.trim().contains("adbe.pkcs7.detached") || subFilter.trim().contains("ETSI.RFC3161") || subFilter.trim().contains("adbe.x509.rsa_sha1"))) {
            LOGGER.error("Cannot process PDF Signature {} with subFilter {}", (Object)signature.getName(), (Object)subFilter);
            return false;
        }
        LOGGER.debug("Signature {} Filter:{}", (Object)signature.getName(), (Object)filter);
        LOGGER.debug("Signature {} SubFilter:{}", (Object)signature.getName(), (Object)subFilter);
        LOGGER.debug("Signature {} ContactInfo:{}", (Object)signature.getName(), (Object)contactInfo);
        LOGGER.debug("Signature {} Reason:{}", (Object)signature.getName(), (Object)reason);
        if (subFilter.trim().contains("adbe.x509.rsa_sha1")) {
            COSDictionary sigDict = signature.getCOSObject();
            COSString contents = (COSString)sigDict.getDictionaryObject(COSName.CONTENTS);
            COSString certString = (COSString)sigDict.getDictionaryObject(COSName.CERT);
            byte[] certData = certString.getBytes();
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream certStream = new ByteArrayInputStream(certData);
            Collection<? extends Certificate> certs = factory.generateCertificates(certStream);
            ASN1InputStream asn1IS = new ASN1InputStream((InputStream)new ByteArrayInputStream(contents.getBytes()));
            ASN1Primitive asn1prim = asn1IS.readObject();
            if (!(asn1prim instanceof ASN1OctetString)) {
                asn1IS.close();
                throw new IOException("ASN1 octet string expected, but got " + asn1prim.getClass().getSimpleName());
            }
            ASN1OctetString oct = (ASN1OctetString)asn1prim;
            X509Certificate cert = (X509Certificate)certs.iterator().next();
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(cert.getPublicKey());
            sig.update(signedContent);
            boolean valid = sig.verify(oct.getOctets());
            LOGGER.info("Verification result: " + valid);
            asn1IS.close();
            return valid;
        }
        CMSSignedData signedData = new CMSSignedData(signature.getContents());
        SignerInformation signerInfo = (SignerInformation)signedData.getSignerInfos().iterator().next();
        Attribute attribute1 = signerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        Attribute attrTS = null;
        if (signerInfo.getUnsignedAttributes() != null) {
            attrTS = signerInfo.getUnsignedAttributes().get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        }
        String messageDigest = "";
        if (subFilter.contains("ETSI.RFC3161")) {
            TimeStampToken timeToken = new TimeStampToken(signedData);
            messageDigest = Base64.getEncoder().encodeToString(timeToken.getTimeStampInfo().getMessageImprintDigest());
        } else {
            messageDigest = Base64.getEncoder().encodeToString(Hex.decode((String)attribute1.getAttributeValues()[0].toString().substring(1)));
        }
        MessageDigest digest = MessageDigest.getInstance(signerInfo.getDigestAlgOID());
        LOGGER.debug("Digest Algorithm used: {} ({})", (Object)new DefaultAlgorithmNameFinder().getAlgorithmName(signerInfo.getDigestAlgorithmID()), (Object)digest.getAlgorithm());
        String signatureSID = signerInfo.getSID().getSerialNumber().toString(16);
        fsi.setSigID(signatureSID);
        if (attrTS != null && attrTS.getAttributeValues().length > 0) {
            LOGGER.debug("Signature ID {} contains timestamp", (Object)signatureSID);
            fsi.setIsTimeStamped(true);
            ASN1Encodable dob = attrTS.getAttrValues().getObjectAt(0);
            byte[] encodedTsp = dob.toASN1Primitive().getEncoded();
            TimeStampToken result = null;
            if (encodedTsp != null) {
                CMSSignedData cms = new CMSSignedData(encodedTsp);
                result = new TimeStampToken(cms);
                LOGGER.debug("Timestamp generation time: " + String.valueOf(result.getTimeStampInfo().getGenTime()));
                fsi.setSignDate(result.getTimeStampInfo().getGenTime());
                LOGGER.debug("Timestamp serial number " + String.valueOf(result.getTimeStampInfo().getSerialNumber()));
                LOGGER.debug("Timestamp tsa: " + String.valueOf(result.getTimeStampInfo().getTsa()));
                LOGGER.debug("Timestamp policy: " + String.valueOf(result.getTimeStampInfo().getPolicy()));
                LOGGER.debug("Timestamp issuer: " + String.valueOf(result.getSID().getIssuer()));
                Store storeTt = result.getCertificates();
                Collection collTt = storeTt.getMatches((Selector)result.getSID());
                Iterator certIt2 = collTt.iterator();
                X509CertificateHolder cert2 = (X509CertificateHolder)certIt2.next();
                try {
                    result.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert2));
                    fsi.setIsTimeStampValid(true);
                    LOGGER.debug("timestamp validation successful");
                }
                catch (TSPValidationException e) {
                    LOGGER.error("timestamp validation failed", (Throwable)e);
                }
            }
        } else {
            LOGGER.debug("Signature ID {} contains no timestamp", (Object)signatureSID);
        }
        Collection matches = signedData.getCertificates().getMatches((Selector)signerInfo.getSID());
        X509CertificateHolder certHolder = (X509CertificateHolder)matches.iterator().next();
        if (fsi.getSigSubjectName() == null) {
            fsi.setSigSubjectName(certHolder.getSubject().getRDNs(BCStyle.CN)[0].getFirst().getValue().toString());
        }
        byte[] pubByte = certHolder.getSubjectPublicKeyInfo().getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubByte);
        KeyFactory kf = null;
        kf = signerInfo.getEncryptionAlgOID().startsWith("1.2.840.10045.4.3") ? KeyFactory.getInstance("ECDSA") : KeyFactory.getInstance("RSA");
        PublicKey pubKey = kf.generatePublic(keySpec);
        String encAlgo = null;
        if (signerInfo.getEncryptionAlgOID().trim().equals("1.2.840.113549.1.1.1")) {
            if (signerInfo.getDigestAlgOID().equals("1.3.14.3.2.26")) {
                encAlgo = "SHA1withRSA";
            } else if (signerInfo.getDigestAlgOID().equals("2.16.840.1.101.3.4.2.1")) {
                encAlgo = "SHA256withRSA";
            } else if (signerInfo.getDigestAlgOID().equals("2.16.840.1.101.3.4.2.2")) {
                encAlgo = "SHA384withRSA";
            } else if (signerInfo.getDigestAlgOID().equals("2.16.840.1.101.3.4.2.3")) {
                encAlgo = "SHA512withRSA";
            }
        } else {
            encAlgo = signerInfo.getEncryptionAlgOID();
        }
        Signature rsaSign = Signature.getInstance(encAlgo);
        LOGGER.debug("Signature Algorithm used: {}", (Object)rsaSign.getAlgorithm());
        rsaSign.initVerify(pubKey);
        rsaSign.update(signerInfo.getEncodedSignedAttributes());
        boolean cmsSignatureValid = rsaSign.verify(signerInfo.getSignature());
        if (!cmsSignatureValid) {
            LOGGER.error("Signature ID {} have INVALID CMS Signature", (Object)signatureSID);
            return false;
        }
        LOGGER.info("Signature ID {} have VALID CMS Signature", (Object)signatureSID);
        String mdPdf = Base64.getEncoder().encodeToString(digest.digest(signedContent));
        LOGGER.debug("Message Digest Signature ID {} in CMS:{}", (Object)signatureSID, (Object)messageDigest);
        LOGGER.debug("Message Digest Signature ID {} in PDF:{}", (Object)signatureSID, (Object)mdPdf);
        if (!mdPdf.equals(messageDigest)) {
            LOGGER.info("Message Digest Signature ID {} is invalid, data integrity is NOT OK", (Object)signatureSID);
            return false;
        }
        LOGGER.info("Message Digest Signature ID {} is valid, data integrity is OK", (Object)signatureSID);
        return true;
    }
}

