/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import de.itu.error.ITUException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtil {
    private static final Logger _logger = LogManager.getLogger(FileUtil.class);

    public static byte[] readByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] data = new byte[32];
        int len = 0;
        while ((len = is.read(data)) != -1) {
            bos.write(data, 0, len);
        }
        is.close();
        return bos.toByteArray();
    }

    public static byte[] readByteArray(File file) throws IOException {
        return FileUtil.readByteArray(new FileInputStream(file));
    }

    public static byte[] readByteArray(String path) throws IOException {
        return FileUtil.readByteArray(FileUtil.class.getResourceAsStream(path));
    }

    public static boolean copyfile(File source, File dest, boolean deleteSource) throws ITUException {
        return FileUtil.copyfile(source, dest, deleteSource, false);
    }

    public static boolean copyfile(File source, File dest, boolean deleteSource, boolean overwrite) throws ITUException {
        boolean retVal = false;
        try {
            if (!source.exists()) {
                _logger.error("Datei nicht gefunden: " + source.getAbsolutePath());
            } else if (!source.canRead()) {
                _logger.error("Datei kann nicht gelesen werden: " + source.getAbsolutePath());
            } else if (dest.exists() && !overwrite) {
                _logger.debug("Datei gibt es schon: " + dest.getAbsolutePath());
            } else if (!dest.exists() && !dest.createNewFile()) {
                _logger.error("Datei kann nicht erzeugt werden: " + dest.getAbsolutePath());
            } else {
                FileInputStream in = new FileInputStream(source);
                FileOutputStream out = new FileOutputStream(dest);
                FileChannel inChannel = in.getChannel();
                FileChannel outChannel = out.getChannel();
                inChannel.transferTo(0L, inChannel.size(), outChannel);
                inChannel.close();
                outChannel.close();
                in.close();
                out.close();
                _logger.debug("Successfully copied " + source.length() + " bytes.");
                if (deleteSource && !FileUtil.deleteFile(source)) {
                    _logger.error("Datei kann nicht gel\u00f6scht werden: " + source.getAbsolutePath());
                } else {
                    retVal = true;
                }
            }
        }
        catch (Throwable ex) {
            _logger.error("Fehler beim kopieren von " + source.getAbsolutePath() + " nach " + dest.getAbsolutePath(), ex);
            throw new ITUException(ex, "copyfile");
        }
        return retVal;
    }

    public static boolean deleteFile(File f) {
        boolean deleted = false;
        _logger.debug("<deleteFile> deleting file: " + (f != null ? f.getAbsolutePath() : "null"));
        if (f != null && f.exists()) {
            deleted = f.delete();
            int retryCount = 0;
            if (!deleted) {
                try {
                    FileInputStream is = new FileInputStream(f);
                    is.close();
                    is = null;
                    System.gc();
                    while (!deleted && retryCount < 10) {
                        _logger.debug("<deleteFile> failed to delete, retry " + retryCount++);
                        Thread.sleep(10L);
                        deleted = f.delete();
                    }
                }
                catch (Exception e) {
                    _logger.error("Fehler beim Zugriff auf Datei: " + f.getAbsolutePath(), (Throwable)e);
                }
            }
            if (deleted) {
                _logger.debug("<deleteFile> file was deleted.");
            } else {
                _logger.warn("Datei kann nicht gel\u00f6scht werden: " + f.getAbsolutePath());
            }
        }
        return deleted;
    }

    public static String changeFileExtension(String filename, String newExtension) {
        int index = filename.lastIndexOf(46);
        String newFilename = index != -1 ? filename.substring(0, index) + "." + newExtension : filename + "." + newExtension;
        return newFilename;
    }

    public static boolean checkFile(File file, boolean create, boolean throwError, boolean isDir) throws ITUException {
        boolean retVal;
        block9: {
            retVal = false;
            try {
                if (!file.exists()) {
                    if (isDir && create) {
                        try {
                            if (!file.mkdirs()) {
                                throw new ITUException("failed to create directory: " + file.getAbsolutePath());
                            }
                            retVal = true;
                            break block9;
                        }
                        catch (Throwable ex) {
                            throw new ITUException(ex, "failed to create directory: " + file.getAbsolutePath());
                        }
                    }
                    if (throwError) {
                        throw new ITUException("file not found: " + file.getAbsolutePath());
                    }
                    break block9;
                }
                if (isDir && !file.isDirectory()) {
                    throw new ITUException("not a directory: " + file.getAbsolutePath());
                }
                retVal = true;
            }
            catch (SecurityException e) {
                _logger.error("Fehler beim Zugriff auf " + file.getAbsolutePath(), (Throwable)e);
                if (!throwError) break block9;
                throw new ITUException(e, "Fehler beim Zugriff auf " + file.getAbsolutePath());
            }
        }
        return retVal;
    }

    public static File getDateDir(File rootDir, Date date) throws ITUException {
        String yearPath = new SimpleDateFormat("yyyy").format(date);
        File yearDir = new File(rootDir, yearPath);
        FileUtil.checkFile(yearDir, true, true, true);
        String monthPath = new SimpleDateFormat("MM").format(date);
        File monthDir = new File(yearDir, monthPath);
        FileUtil.checkFile(monthDir, true, true, true);
        String dayPath = new SimpleDateFormat("dd").format(date);
        File dayDir = new File(monthDir, dayPath);
        FileUtil.checkFile(dayDir, true, true, true);
        return dayDir;
    }

    public static File getTimeFile(File dir, String prefix, String ext, Date date) throws ITUException {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append("-");
        String timeString = new SimpleDateFormat("hh").format(date);
        buf.append(timeString);
        buf.append("_");
        timeString = new SimpleDateFormat("mm").format(date);
        buf.append(timeString);
        buf.append("_");
        timeString = new SimpleDateFormat("ss").format(date);
        buf.append(timeString);
        buf.append(ext);
        File retVal = new File(dir, buf.toString());
        _logger.debug("getTimeFileName: " + retVal.getAbsolutePath());
        return retVal;
    }
}

