/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.TimeZone;

public class DateToXsdDatetimeFormatter {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public DateToXsdDatetimeFormatter() {
    }

    public DateToXsdDatetimeFormatter(TimeZone timeZone) {
        this.simpleDateFormat.setTimeZone(timeZone);
    }

    public synchronized Date parse(String xmlDateTime) throws ParseException {
        if (xmlDateTime.length() != 25) {
            throw new ParseException("Date not in expected xml datetime format", 0);
        }
        StringBuilder sb = new StringBuilder(xmlDateTime);
        sb.deleteCharAt(22);
        return this.simpleDateFormat.parse(sb.toString());
    }

    public synchronized String format(Date xmlDateTime) throws IllegalFormatException {
        String s = this.simpleDateFormat.format(xmlDateTime);
        StringBuilder sb = new StringBuilder(s);
        sb.insert(22, ':');
        return sb.toString();
    }

    public synchronized void setTimeZone(String timezone) {
        this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timezone));
    }
}

