/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xml;

import de.itu.xml.XmlException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathFacade {
    public static final String TEXT_SELECTOR = "text()";
    private static XPathFacade theInstance = null;
    private static Logger _logger = LogManager.getLogger(XPathFacade.class);
    private XPathFactory _xf = XPathFactory.newInstance();
    private NamespaceContext _ctx = null;

    private XPathFacade() {
    }

    public void setNamespaceContext(NamespaceContext ctx) {
        this._ctx = ctx;
    }

    public static synchronized XPathFacade getInstance() {
        if (theInstance == null) {
            theInstance = new XPathFacade();
        }
        return theInstance;
    }

    public NodeList evaluateNodeList(Document doc, String expression) throws XmlException {
        return this.evaluateNodeList(doc.getDocumentElement(), expression);
    }

    public NodeList evaluateNodeList(Element root, String expression) throws XmlException {
        NodeList retVal = null;
        try {
            XPath xp = this._xf.newXPath();
            xp.setNamespaceContext(this._ctx);
            retVal = (NodeList)xp.evaluate(expression, root, XPathConstants.NODESET);
        }
        catch (Exception ex) {
            _logger.error("error evaluating expr=" + expression, (Throwable)ex);
        }
        return retVal;
    }

    public Node evaluateNode(Document doc, String expression) throws XmlException {
        return this.evaluateNode(doc.getDocumentElement(), expression);
    }

    public Node evaluateNode(Element root, String expression) throws XmlException {
        Node retVal = null;
        try {
            XPath xp = this._xf.newXPath();
            xp.setNamespaceContext(this._ctx);
            retVal = (Node)xp.evaluate(expression, root, XPathConstants.NODE);
        }
        catch (Exception ex) {
            _logger.error("error evaluating expr=" + expression, (Throwable)ex);
        }
        return retVal;
    }

    public String evaluate(Document doc, String expression) throws XmlException {
        return this.evaluate(doc.getDocumentElement(), expression);
    }

    public String evaluate(Element root, String expression) throws XmlException {
        String retVal = null;
        try {
            XPath xp = this._xf.newXPath();
            xp.setNamespaceContext(this._ctx);
            retVal = (String)xp.evaluate(expression, root, XPathConstants.STRING);
        }
        catch (Exception ex) {
            _logger.error("error evaluating expr=" + expression, (Throwable)ex);
        }
        return retVal;
    }

    public boolean evalBool(Element elem, String expression) throws XmlException {
        boolean retVal = false;
        try {
            XPath xp = this._xf.newXPath();
            xp.setNamespaceContext(this._ctx);
            retVal = (Boolean)xp.evaluate(expression, elem, XPathConstants.BOOLEAN);
        }
        catch (Exception ex) {
            _logger.error("error evaluating expr=" + expression, (Throwable)ex);
        }
        return retVal;
    }

    public double evalNumber(Element elem, String expression) throws XmlException {
        double retVal = 0.0;
        try {
            XPath xp = this._xf.newXPath();
            xp.setNamespaceContext(this._ctx);
            retVal = (Double)xp.evaluate(expression, elem, XPathConstants.NUMBER);
        }
        catch (Exception ex) {
            _logger.error("error evaluating expr=" + expression, (Throwable)ex);
        }
        return retVal;
    }
}

