/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xmlsec;

import de.itu.xmlsec.XmlSecException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyStoreAdapter {
    private static Logger _logger = LogManager.getLogger(KeyStoreAdapter.class);
    public static final String SYSCONF_KSFILENAME = "KeyStoreAdapter.fileName";
    public static final String SYSCONF_KSPW = "KeyStoreAdapter.pw";
    public static final String DEFAULT_TYPE = "JKS";
    public static final String DEFAULT_PROVIDER = "SUN";
    private static Map<String, KeyStoreAdapter> _theInstanceMap = new HashMap<String, KeyStoreAdapter>();
    private InputStream _ksStream = null;
    private char[] _ksPW = null;
    private KeyStore _ks = null;
    private String _type = null;
    private String _provider = null;

    private KeyStoreAdapter(String type, String provider) {
        this._type = type;
        this._provider = provider;
    }

    private boolean init(String name, InputStream is, char[] pw) {
        this._ksPW = pw;
        this._ksStream = is;
        try {
            this.loadKeyStore(this._ksStream, this._ksPW);
            _logger.info("KeyStoreAdapter '" + name + "' initialized.");
            return true;
        }
        catch (Exception ex) {
            _logger.error("failed to load keystore " + name, (Throwable)ex);
            return false;
        }
    }

    public static synchronized KeyStoreAdapter getInstance(String name, char[] pw) {
        _logger.debug("keystore name=" + name);
        InputStream is = KeyStoreAdapter.class.getResourceAsStream(name);
        return KeyStoreAdapter.getInstance(name, is, pw, DEFAULT_TYPE, DEFAULT_PROVIDER);
    }

    public static synchronized KeyStoreAdapter getInstance(String name, InputStream is, char[] pw, String type, String provider) {
        KeyStoreAdapter ksa = _theInstanceMap.get(name);
        if (ksa == null) {
            ksa = new KeyStoreAdapter(type, provider);
            ksa.init(name, is, pw);
            _theInstanceMap.put(name, ksa);
        }
        return ksa;
    }

    public static synchronized KeyStoreAdapter getInstance(File file, char[] pw) {
        String name = file.getAbsolutePath();
        KeyStoreAdapter ksa = _theInstanceMap.get(name);
        if (ksa == null) {
            ksa = new KeyStoreAdapter(DEFAULT_TYPE, DEFAULT_PROVIDER);
            try {
                FileInputStream is = new FileInputStream(file);
                ksa.init(name, is, pw);
                _theInstanceMap.put(name, ksa);
            }
            catch (FileNotFoundException fnfe) {
                _logger.error("Fehler beim Laden des Keystore: " + name);
            }
        }
        return ksa;
    }

    public boolean isLoaded() {
        return this._ks != null;
    }

    private void loadKeyStore(InputStream is, char[] password) throws XmlSecException {
        if (this._ks != null) {
            return;
        }
        try {
            this._ks = KeyStore.getInstance(this._type, this._provider);
        }
        catch (Exception ex) {
            throw new XmlSecException("error loading keystore, type=" + this._type + ", provider=" + this._provider, ex);
        }
        try {
            this._ks.load(is, password);
        }
        catch (CertificateException ce) {
            throw new XmlSecException("CertificateException", ce);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XmlSecException("NoSuchAlgorithmException", nsae);
        }
        catch (IOException ioe) {
            throw new XmlSecException("IOException", ioe);
        }
        finally {
            if (password != null) {
                // empty if block
            }
            password = null;
        }
    }

    public X509Certificate getCertificate(String alias) throws XmlSecException {
        this.checkState0("getCertificate");
        X509Certificate retVal = null;
        try {
            retVal = (X509Certificate)this._ks.getCertificate(alias);
        }
        catch (KeyStoreException kse) {
            throw new XmlSecException("KeyStoreException", kse);
        }
        if (_logger.isDebugEnabled()) {
            // empty if block
        }
        return retVal;
    }

    public PrivateKey getPrivateKey(String alias, char[] password) throws XmlSecException {
        this.checkState0("getPrivateKey");
        PrivateKey retVal = null;
        try {
            retVal = (PrivateKey)this._ks.getKey(alias, password);
        }
        catch (UnrecoverableKeyException uke) {
            throw new XmlSecException("UnrecoverableKeyException", uke);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XmlSecException("NoSuchAlgorithmException", nsae);
        }
        catch (KeyStoreException kse) {
            throw new XmlSecException("KeyStoreException", kse);
        }
        finally {
            password = null;
        }
        return retVal;
    }

    public KeyStore.PrivateKeyEntry getPrivateKeyEntry(String alias, char[] password) throws XmlSecException {
        this.checkState0("getPrivateKeyEntry");
        KeyStore.PrivateKeyEntry retVal = null;
        try {
            KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(password);
            retVal = (KeyStore.PrivateKeyEntry)this._ks.getEntry(alias, pp);
        }
        catch (UnrecoverableEntryException uke) {
            throw new XmlSecException("UnrecoverableKeyException", uke);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XmlSecException("NoSuchAlgorithmException", nsae);
        }
        catch (KeyStoreException kse) {
            throw new XmlSecException("KeyStoreException", kse);
        }
        finally {
            password = null;
        }
        return retVal;
    }

    public KeyStore.Entry getEntry(String alias, char[] pw) throws XmlSecException {
        KeyStore.Entry entry = null;
        if (this._ks == null) {
            throw new XmlSecException("keystore not loaded");
        }
        try {
            entry = this._ks.getEntry(alias, new KeyStore.PasswordProtection(pw));
        }
        catch (Exception ex) {
            _logger.error("getEntry", (Throwable)ex);
            throw new XmlSecException("getEntry", ex);
        }
        return entry;
    }

    public String getKeyAlias() throws XmlSecException {
        String keyAlias = null;
        if (this._ks == null) {
            throw new XmlSecException("keystore not loaded");
        }
        try {
            Enumeration<String> e = this._ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                if (!this._ks.isKeyEntry(alias)) continue;
                keyAlias = alias;
                _logger.debug("<getKeyAlias> keyAlias=" + alias);
            }
        }
        catch (Exception ex) {
            _logger.error("getKeyAlias", (Throwable)ex);
            throw new XmlSecException("getKeyAlias", ex);
        }
        return keyAlias;
    }

    public Certificate[] getCertificateChain(String alias) throws XmlSecException {
        Certificate[] retVal = null;
        if (this._ks == null) {
            throw new XmlSecException("keystore not loaded");
        }
        try {
            retVal = this._ks.getCertificateChain(alias);
        }
        catch (Exception ex) {
            _logger.error("getCertificateChain", (Throwable)ex);
            throw new XmlSecException("getCertificateChain", ex);
        }
        return retVal;
    }

    private void checkState0(String context) {
        if (this._ks == null) {
            throw new IllegalStateException("Keystore not initialized (action " + context + ")");
        }
    }

    public static KeyStore getKeyStore(String filename, char[] pw) throws XmlSecException {
        KeyStore ks = null;
        String userHome = System.getProperty("user.home");
        File keystorefile = new File(userHome, filename);
        if (!keystorefile.exists()) {
            _logger.error("keystore file not found: " + keystorefile.getAbsolutePath());
        } else {
            try {
                ks = KeyStore.getInstance(DEFAULT_TYPE, DEFAULT_PROVIDER);
                ks.load(new FileInputStream(keystorefile), pw);
                _logger.debug("<getJKSKeyStore> keystore loaded..");
            }
            catch (Exception ex) {
                _logger.error("getJKSKeyStore", (Throwable)ex);
                throw new XmlSecException("Fehler beim laden des Zertifikatspeichers", ex);
            }
        }
        return ks;
    }

    public static void storeKeyStore(KeyStore store, String filename, char[] pw) throws XmlSecException {
        String backupFileName;
        File backupFile;
        File keystorefile = new File(filename);
        if (keystorefile.exists() && !keystorefile.renameTo(backupFile = new File(backupFileName = filename + new SimpleDateFormat(".yyyy-MM-dd-hh-mm-ss").format(new Date())))) {
            _logger.error("<storeKeyStore> failed to rename KeyStore-File: " + backupFile.getAbsolutePath());
        }
        keystorefile = new File(filename);
        try {
            keystorefile.createNewFile();
            FileOutputStream fout = new FileOutputStream(keystorefile);
            store.store(fout, pw);
        }
        catch (Exception ex) {
            _logger.error("storeKeyStore", (Throwable)ex);
            throw new XmlSecException("Fehler beim speichern des Zertifikatspeichers", ex);
        }
    }

    public static byte[] getCertificateFromStream(InputStream is) throws XmlSecException {
        try {
            return CertificateFactory.getInstance("X.509").generateCertificate(is).getEncoded();
        }
        catch (CertificateException e) {
            throw new XmlSecException("Fehler beim Laden des X509Certificate", e);
        }
    }

    public static byte[] getCertificateFromResource(String name) throws XmlSecException {
        return KeyStoreAdapter.getCertificateFromStream(KeyStoreAdapter.class.getResourceAsStream(name));
    }

    public static boolean loadBouncyCastle() {
        if (Security.getProvider("BC") == null) {
            try {
                Class<?> bcProvClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                Provider bcProv = (Provider)bcProvClass.newInstance();
                if (Security.insertProviderAt(bcProv, 0) > -1) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                _logger.error("BouncyCastle nicht gefunden!", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                _logger.error("Kann BouncyCastle nicht instantiieren!", (Throwable)e);
            }
            catch (InstantiationException e) {
                _logger.error("Kann BouncyCastle nicht instantiieren!", (Throwable)e);
            }
        } else {
            return true;
        }
        return false;
    }

    public static X509Certificate extractCertFromP12(InputStream is, char[] password) throws XmlSecException {
        X509Certificate retVal = null;
        String alias = "";
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
            ks.load(is, password);
            if (ks.size() == 1) {
                alias = ks.aliases().nextElement().toString();
            } else {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    String temp = e.nextElement();
                    if (ks.isKeyEntry(temp)) {
                        _logger.debug("<extractCertFromP12> keyAlias=" + temp);
                        alias = temp;
                        continue;
                    }
                    if (ks.isCertificateEntry(temp)) {
                        _logger.debug("<extractCertFromP12> certAlias=" + temp);
                        continue;
                    }
                    _logger.debug("<extractCertFromP12> ???Alias=" + temp);
                }
            }
            retVal = (X509Certificate)ks.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new XmlSecException("<extractCertFromP12> KeyStoreException " + e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new XmlSecException("<extractCertFromP12> CertificateException " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new XmlSecException("<extractCertFromP12> NoSuchProviderException " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XmlSecException("<extractCertFromP12> NoSuchAlgorithmException " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlSecException("<extractCertFromP12> IOException: " + e.getMessage(), e);
        }
        return retVal;
    }

    public static PrivateKey extractPrivateKeyFromP12(InputStream is, char[] password) throws XmlSecException {
        PrivateKey retVal = null;
        String alias = "";
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
            ks.load(is, password);
            if (ks.size() == 1) {
                alias = ks.aliases().nextElement().toString();
            } else {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    String temp = e.nextElement();
                    if (ks.isKeyEntry(temp)) {
                        _logger.debug("<extractPrivateKeyFromP12> keyAlias=" + temp);
                        alias = temp;
                        continue;
                    }
                    if (ks.isCertificateEntry(temp)) {
                        _logger.debug("<extractPrivateKeyFromP12> certAlias=" + temp);
                        continue;
                    }
                    _logger.debug("<extractPrivateKeyFromP12> ???Alias=" + temp);
                }
            }
            retVal = (PrivateKey)ks.getKey(alias, password);
        }
        catch (KeyStoreException kse) {
            throw new XmlSecException("<extractPrivateKeyFromP12> KeyStoreException", kse);
        }
        catch (UnrecoverableKeyException kse) {
            throw new XmlSecException("<extractPrivateKeyFromP12> UnrecoverableKeyException", kse);
        }
        catch (CertificateException e) {
            throw new XmlSecException("<extractPrivateKeyFromP12> CertificateException", e);
        }
        catch (NoSuchProviderException e) {
            throw new XmlSecException("<extractPrivateKeyFromP12> NoSuchProviderException", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XmlSecException("<extractPrivateKeyFromP12> NoSuchAlgorithmException", e);
        }
        catch (IOException e) {
            throw new XmlSecException("<extractPrivateKeyFromP12> IOException", e);
        }
        return retVal;
    }

    public static KeyStore.PrivateKeyEntry extractPrivateKeyEntryFromP12(InputStream is, char[] password) throws XmlSecException {
        KeyStore.PrivateKeyEntry retVal = null;
        String alias = "";
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
            ks.load(is, password);
            if (ks.size() == 1) {
                alias = ks.aliases().nextElement().toString();
            } else {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    String temp = e.nextElement();
                    if (ks.isKeyEntry(temp)) {
                        _logger.debug("<extractPrivateKeyFromP12> keyAlias=" + temp);
                        alias = temp;
                        continue;
                    }
                    if (ks.isCertificateEntry(temp)) {
                        _logger.debug("<extractPrivateKeyFromP12> certAlias=" + temp);
                        continue;
                    }
                    _logger.debug("<extractPrivateKeyFromP12> ???Alias=" + temp);
                }
            }
            KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(password);
            retVal = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, pp);
        }
        catch (KeyStoreException kse) {
            throw new XmlSecException("<extractPrivateKeyFromP12> KeyStoreException", kse);
        }
        catch (UnrecoverableEntryException kse) {
            throw new XmlSecException("<extractPrivateKeyFromP12> UnrecoverableKeyException", kse);
        }
        catch (CertificateException e) {
            throw new XmlSecException("<extractPrivateKeyFromP12> CertificateException", e);
        }
        catch (NoSuchProviderException e) {
            throw new XmlSecException("<extractPrivateKeyFromP12> NoSuchProviderException", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XmlSecException("<extractPrivateKeyFromP12> NoSuchAlgorithmException", e);
        }
        catch (IOException e) {
            throw new XmlSecException("<extractPrivateKeyFromP12> IOException", e);
        }
        return retVal;
    }
}

