<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper"
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib msg ds b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer"/>
	<xsl:param name="register" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="zks:Adressauskunft">
		<html>
			<head>
				<title>Adressauskunft</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf">
         			</xsl:call-template>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile0"/>
							<xsl:call-template name="Zeile1"/>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
				Adressauskunft
				</font>
				</td>
			</tr>
			<tr height="3%">
				<td/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table width="100%" border="0">
			<tr height="10">
				<td>
			
			</td>
			</tr>
			<tr width="100%">
				<td id="Titel"> Anforderung UUID </td>
			</tr>
			<tr width="100%">
				<td>
					<font id="Aktuell">
						<xsl:value-of select="zks:AnforderungUUID"/>
					</font>
				</td>
			</tr>
			<tr width="100%">
				<td id="Titel"> Behördliche Nummer </td>
			</tr>
			<tr width="100%">
				<td id="Aktuell">
					<xsl:value-of select="concat(zks:BehoerdlicheNummer/lib:BehoerdlicheNr, zks:BehoerdlicheNummer/lib:Pruefziffer, ' (', zks:BehoerdlicheNummer/@lib:ATBRolle, ')')"/>
				</td>
			</tr>
			<tr width="100%">
				<td id="Titel"> Provider Nummer </td>
			</tr>
			<tr width="100%">
				<td id="Aktuell">
					<xsl:value-of select="concat(zks:ProviderNummer/lib:BehoerdlicheNr, zks:ProviderNummer/lib:Pruefziffer, ' (', zks:ProviderNummer/@lib:ATBRolle, ')')"/>
				</td>
			</tr>
			<table width="100%">
				<tr width="100%">
					<td width="50%" id="Titel">Unterschrift (Signatur)</td>
					<td width="50%" id="Titel">2. Unterschrift (2. Signatur)</td>
				</tr>
				<tr width="100%">
					<td width="50%">
						<xsl:call-template name="Sig1NameNoLayer"/>
					</td>
					<td width="50%">
						<xsl:call-template name="Sig2NameNoLayer"/>
					</td>
				</tr>
			</table>
		</table>
	</xsl:template>
</xsl:stylesheet>
