<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:html="http://www.w3c.org/TR/xhtml1/" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" xmlns:msg="uri:BMU_Waste_Interface/Message" xmlns:ntz="uri:BMU_Waste_Interface/Ntz" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:b64="xalan://de.itu.util.Base64" xmlns:crc32="xalan://de.itu.util.CRC32Helper" xmlns:x509="xalan://de.itu.util.X509CertHelper" xmlns:tfs="http://xsd.infotech.de/schema/tfs" xmlns:userrsm="usr:EUDINWasteMovementDocument:2:1" xmlns:usercwr="usr:EUDINCertificateOfWasteReceiptDocument:2:1" xmlns:usercwrd="usr:EUDINCertificateOfWasteRecoveryDisposalDocument:2:1" xmlns:userram="usr:ReusableAggregateBusinessInformationEntitySchemaModule:2:1" extension-element-prefixes="b64 crc32 x509 tfs userrsm userram" exclude-result-prefixes="xsl lib msg ds b64 crc32 x509 tfs userrsm userram usercwr usercwrd">
	<xsl:import href="ZKS-Library_11.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="register" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:variable name="gTrenn1" select="' '"> </xsl:variable>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ntz:Abfallverbringungsdokument">
		<html>
			<head>
				<title>Begleitformular</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:for-each select="//ntz:VersandBegleitformular">
					<xsl:if test="position()=$positionsnummer">
						<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
							<tr>
								<th>
									<xsl:call-template name="Zeile1_2"/>
									<xsl:call-template name="Zeile3_4"/>
									<xsl:call-template name="Zeile5_6"/>
									<xsl:call-template name="Zeile7"/>
									<xsl:call-template name="Zeile8"/>
									<xsl:call-template name="Zeile9_15"/>
									<!--xsl:call-template name="Zeile10"/>
									<p style="page-break-after:always">
										<br style="height:0; line-height:0"/>
									</p>
									<xsl:call-template name="Zeile11"/>
									<xsl:call-template name="Zeile12"/>
									<xsl:call-template name="Zeile13"/>
									<xsl:call-template name="Zeile14"/-->
									<xsl:call-template name="Zeile15"/>
									<xsl:call-template name="Zeile16"/>
									<xsl:call-template name="Zeile17"/>
									<xsl:call-template name="Zeile17a"/>
									<xsl:call-template name="Zeile18_19"/>
									<!--xsl:call-template name="Zeile19"/-->
									<p style="page-break-after:always">
										<br style="height:0; line-height:0"/>
									</p>
									<xsl:call-template name="Zeile19a"/>
									<xsl:call-template name="Zeile20_21"/>
									<xsl:call-template name="Zeile22"/>
									<xsl:call-template name="Zeile22a"/>
									<xsl:variable name="DOCTYP">
										<xsl:choose>
											<xsl:when test="count(userrsm:EUDINWasteMovementDocument) > 0">
												<xsl:value-of select="'Transportanmeldung'"/>
											</xsl:when>
											<xsl:when test="count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
												<xsl:value-of select="'Empfangsbestätigung'"/>
											</xsl:when>
											<xsl:when test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0">
												<xsl:value-of select="'Entsorgungsbestätigung'"/>
											</xsl:when>
										</xsl:choose>
									</xsl:variable>
									<xsl:for-each select="..">
										<xsl:call-template name="showSigBegleitformular">
											<xsl:with-param name="DOK_TYP" select="$DOCTYP"/>
										</xsl:call-template>
									</xsl:for-each>
								</th>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="Zeile1_2">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td>
					<font id="Ueberschrift2">Begleitformular für grenzüberschreitende Verbringung von Abfällen</font>
				</td>
			</tr>
			<xsl:if test="../ntz:FreieXMLStruktur//tfs:Cancelled='true'">
				<tr>
					<td>
						<font id="Ueberschrift">
							<xsl:value-of select="'Der Transport wurde storniert'"/>
						</font>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="50%"/>
							<col width="50%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel">1. Entspricht der Notifizierung Nr. </font>
							</td>
							<td>
								<font id="Aktuell_gross">
									<xsl:value-of select="descendant::userram:CorrespondingNotificationIdentificationID"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<table width="100%" id="Tabelle_links">
						<colgroup>
							<col width="80%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel">2. Fortlaufende Nummer / Gesamtzahl der Verbringungen:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="descendant::userram:ConsecutiveTransportNumberNumeric"/>
								</font>
								&#173;
								<font id="Titel">/</font>
								&#173;
								<font id="Aktuell_nu">
									<xsl:value-of select="descendant::userram:TotalNumberOfShipmentsNumeric"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile3_4">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td width="50%">
					<xsl:call-template name="Zeile3"/>
				</td>
				<td width="50%">
					<xsl:call-template name="Zeile4"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile3">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(descendant::userram:SenderParty)>0">
							<xsl:for-each select="descendant::userram:SenderParty">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'3. Exporteur - Notifizierender'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'3. Exporteur - Notifizierender'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile4">
		<table width="100%" id="Tabelle_links">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(descendant::userram:ReceiverParty)>0">
							<xsl:for-each select="descendant::userram:ReceiverParty">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'4. Importeur - Empfänger'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'4. Importeur - Empfänger'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile5_6">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="40%"/>
							<col width="15%"/>
							<col width="15%"/>
							<col width="15%"/>
							<col width="15%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel">5. Tatsächliche Menge:</font>
							</td>
							<td>
								<font id="Titel_klein">Tonnen (Mg):</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="descendant::userram:ActualWeightMeasurementSpecification/userram:Measure"/>
								</font>
							</td>
							<td>
								<font id="Titel_klein">m³</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="descendant::userram:ActualVolumeMeasurementSpecification/userram:Measure"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<table width="100%" id="Tabelle_links">
						<colgroup>
							<col width="70%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel">6. Tatsächliches Datum der Verbringung:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="descendant::userram:ActualShipmentDateTime"/>
									</xsl:call-template>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile7">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="10%"/>
							<col width="45%"/>
							<col width="20%"/>
							<col width="5%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel">7. Verpackung</font>
							</td>
							<td>
								<font id="Titel_klein">Art(en):</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Package">
										<xsl:variable name="lTypeCode">
											<xsl:value-of select="userram:TypeCode"/>
										</xsl:variable>
										<xsl:variable name="TypeCode">
											<xsl:choose>
												<xsl:when test="$lTypeCode = '2C'">3. Kanister</xsl:when>
												<!-- 2C = Barrel, wooden -> 2 = Holzfässer -->
												<xsl:when test="$lTypeCode = 'BG'">5. Sack/Beutel</xsl:when>
												<!-- BG = Bag -> 5 = Säcke -->
												<xsl:when test="$lTypeCode = 'BX'">4. Kiste/Kasten</xsl:when>
												<!-- BX = Box -> 4 = Kisten -->
												<xsl:when test="$lTypeCode = 'DR'">1. Trommel/Fass</xsl:when>
												<!-- DR = Drum -> 1 = Fässer -->
												<xsl:when test="$lTypeCode = 'W1'">2. Holzfass</xsl:when>
												<!-- W1 = Jerrican -> 3 = Kanister -->
												<xsl:when test="$lTypeCode = 'W2'">6. Verbundverpackung</xsl:when>
												<!-- W2 = Composite Package -> 6 = Zusammengesetzte Verp.-->
												<xsl:when test="$lTypeCode = 'W3'">7. Druckbehälter</xsl:when>
												<!-- W3 = Pressure Receptacle -> 7 = Druckbehälter -->
												<xsl:when test="$lTypeCode = 'W4'">8. Schüttgut</xsl:when>
												<!-- W4 = Other -> 9 = Sonstige Verpackungen -->
												<xsl:when test="$lTypeCode = 'W5'">
													<xsl:value-of select="'9. Andere: '"/>
													<xsl:value-of select="Type"/>
												</xsl:when>
												<!-- W5 = Bulk -> 8 = Unverpackt, Schüttgut -->
												<xsl:otherwise>9. Andere</xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="$TypeCode"/>
									</xsl:for-each>
								</font>
							</td>
							<td>
								<font id="Titel_klein">Anzahl der Frachstücke:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="sum(descendant::userram:Package/userram:IndividualPackagesQuantity)"/>
								</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="40%"/>
							<col width="5%"/>
							<col width="10%"/>
							<col width="5%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel"> Besondere Handhabungsvorschriften</font>
							</td>
							<td>
								<font id="Titel_klein">Ja:</font>
							</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="descendant::userram:SpecialHandlingInstructions/userram:SpecialHandlingRequiredIndicator='true'">
												<font id="Aktuell_nu">
													<xsl:value-of select="'X'"/>
												</font>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<font id="Titel_klein">Nein:</font>
							</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="descendant::userram:SpecialHandlingInstructions/userram:SpecialHandlingRequiredIndicator='false'">
												<font id="Aktuell_nu">
													<xsl:value-of select="'X'"/>
												</font>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td/>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile8">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="33%"/>
			</colgroup>
			<tr>
			<xsl:variable name="CNT_CARRIER" select="count(descendant::userram:CarrierParty)"/>
				<xsl:for-each select="descendant::userram:CarrierParty">
					<xsl:sort select="../userram:TransportStage/userram:ConsecutiveNumberNumeric" order="ascending"/>
					<xsl:choose>
						<xsl:when test="position() = 1">
							<td width="33%">
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td>
											<xsl:call-template name="NAME_ADRESSE">
												<xsl:with-param name="ROLLE_VBF" select="concat('8.  ', position(), '. Transportunternehmen')"/>
												<xsl:with-param name="TRANS" select="true()"/>
											</xsl:call-template>
										</td>
									</tr>
									<xsl:call-template name="CARRIER_MORE">
										<xsl:with-param name="POS" select="position()"/>
									</xsl:call-template>
								</table>
							</td>
						</xsl:when>
						<xsl:when test="position() = 2">
							<td width="33%">
								<table width="100%" id="Tabelle_links">
									<tr>
										<td>
											<xsl:call-template name="NAME_ADRESSE">
												<xsl:with-param name="ROLLE_VBF" select="concat('8.  ', position(), '. Transportunternehmen')"/>
												<xsl:with-param name="TRANS" select="true()"/>
											</xsl:call-template>
										</td>
									</tr>
									<xsl:call-template name="CARRIER_MORE">
										<xsl:with-param name="POS" select="position()"/>
									</xsl:call-template>
								</table>
							</td>
						</xsl:when>
						<xsl:when test="position() = 3 and position() = $CNT_CARRIER">
							<td width="33%">
								<table width="100%" id="Tabelle_links">
									<tr>
										<td>
											<xsl:call-template name="NAME_ADRESSE">
												<xsl:with-param name="ROLLE_VBF" select="'8. Letztes Transportunternehmen'"/>
												<xsl:with-param name="TRANS" select="true()"/>
											</xsl:call-template>
										</td>
									</tr>
									<xsl:call-template name="CARRIER_MORE">
										<xsl:with-param name="POS" select="position()"/>
									</xsl:call-template>
								</table>
							</td>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:if test="$CNT_CARRIER=2">
					<table width="100%" id="Tabelle_links">
						<tr>
							<td width="33%">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'8.  Letztes Transportunternehmen'"/>
									<xsl:with-param name="TRANS" select="true()"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</xsl:if>
				<xsl:if test="$CNT_CARRIER=1">
					<td width="33%">
						<table width="100%" id="Tabelle_links">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  2. Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
					<td width="33%">
						<table width="100%" id="Tabelle_links">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  Letztes Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
				</xsl:if>
				<xsl:if test="$CNT_CARRIER=0">
					<td width="33%">
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  1. Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
					<td width="33%">
						<table width="100%" id="Tabelle_links">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  2. Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
					<td width="33%">
						<table width="100%" id="Tabelle_links">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8.  Letztes Transportunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:call-template name="CARRIER_MORE"/>
						</table>
					</td>
				</xsl:if>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="CARRIER_MORE">
		<xsl:param name="POS" select="0"/>
			<xsl:choose>
				<xsl:when test="$POS = 0">
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="20%"/>
											<col width="80%"/>
										</colgroup>
										<tr>
											<td>
												<font id="Titel_klein">Transportart:</font>
											</td>
											<xsl:call-template name="DUMMY_ZEICHEN"/>
										</tr>
										<tr>
											<td>
												<font id="Titel_klein">Übergabedatum:</font>
											</td>
											<xsl:call-template name="DUMMY_ZEICHEN"/>
										</tr>
										<tr>
											<td>
												<font id="Titel_klein">Unterschrift:</font>
											</td>
											<xsl:call-template name="DUMMY_ZEICHEN"/>
										</tr>
									</table>
								</td>
							</tr>
						</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="20%"/>
									<col width="80%"/>
								</colgroup>
								<tr>
									<td>
										<font id="Titel_klein">Transportart:</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:variable name="BefCode">
												<xsl:choose>
													<xsl:when test="../userram:ModeCode = 1">S</xsl:when>
													<!-- See -->
													<xsl:when test="../userram:ModeCode = 2">T</xsl:when>
													<!-- Schiene -->
													<xsl:when test="../userram:ModeCode = 3">R</xsl:when>
													<!--Straße -->
													<xsl:when test="../userram:ModeCode = 4">A</xsl:when>
													<!-- Luft -->
													<xsl:when test="../userram:ModeCode = 8">W</xsl:when>
													<!-- Binnenwasserweg -->
												</xsl:choose>
											</xsl:variable>
											<xsl:value-of select="$BefCode"/>
										</font>
									</td>
								</tr>
								<tr>
									<td>
										<font id="Titel_klein">Übergabedatum:</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:call-template name="formatDate">
												<xsl:with-param name="date" select="../userram:ActualDepartureDateTime"/>
											</xsl:call-template>
										</font>
									</td>
								</tr>
								<tr>
									<td>
										<font id="Titel_klein">Unterschrift:</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:value-of select="../userram:Confirmation/userram:PersonName"/>
										</font>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Zeile9_15">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td width="50%">
					<xsl:call-template name="Zeile9"/>
					<xsl:call-template name="Zeile10"/>
					<xsl:call-template name="Zeile11"/>
				</td>
				<td width="50%">
					<xsl:call-template name="Zeile12"/>
					<xsl:call-template name="Zeile13"/>
					<xsl:call-template name="Zeile14"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile9">
		<table width="100%" id="Tabelle_unten_rechts">
			<xsl:choose>
				<xsl:when test="count(descendant::userram:WasteOrigin/userram:Party)>0">
					<xsl:for-each select="descendant::userram:WasteOrigin/userram:Party">
						<xsl:if test="position()=1">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'9. Abfallerzeuger'"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="40%"/>
											<col width="60%"/>
										</colgroup>
										<tr>
											<td>
												<font id="Titel_klein">Ort der Abfallerzeugung:</font>
											</td>
											<td>
												<font id="Aktuell_nu">
													<xsl:value-of select="substring(../userram:Description,1,35)"/>
												</font>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'9. Abfallerzeuger'"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="20%"/>
									<col width="80%"/>
								</colgroup>
								<tr>
									<td>
										<font id="Titel_klein">Ort der Abfallerzeugung:</font>
									</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile10">
		<table width="100%" id="Tabelle_unten_rechts">
			<xsl:choose>
				<xsl:when test="count(descendant::userram:RecoveryDisposalOperatingSite/userram:OperatingParty)>0">
					<xsl:for-each select="descendant::userram:RecoveryDisposalOperatingSite/userram:OperatingParty">
						<tr>
							<td>
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'10. Beseitigungsanlage'"/>
									<xsl:with-param name="BES_VERW" select="true()"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<tr>
										<td>
											<font id="Titel_klein">Ort der tatsächlichen Beseitigung/Verwertung:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="userram:Comment"/>
											</font>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'10. Beseitigungsanlage'"/>
								<xsl:with-param name="BES_VERW" select="true()"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<tr>
									<td>
										<font id="Titel_klein">Ort der tatsächlichen Beseitigung/Verwertung:</font>
									</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile11">
		<table width="100%" id="Tabelle_rechts">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<font id="Titel">11. Beseitigungs-/Verwertungsverfahren</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">D-Code / R-Code:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:RecoveryDisposalOperationClassification[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="userram:Code"/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile12">
		<table width="100%" id="Tabelle_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<font id="Titel">12. Bezeichnung und Zusammensetzung des Abfalls:</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:Description"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile13">
		<table width="100%" id="Tabelle_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="50%"/>
							<col width="50%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel">13. Physikalische Eigenschaften:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:PhysicalCharacteristicCode">
										<xsl:variable name="lPhys">
											<xsl:value-of select="."/>
										</xsl:variable>
										<xsl:variable name="PhysEig">
											<xsl:choose>
												<xsl:when test="$lPhys = 'GAS'">6. Gasförmig</xsl:when>
												<!-- GAS = Gaseous -> 6 = gasförmig -->
												<xsl:when test="$lPhys = 'LIQ'">5. Flüssig</xsl:when>
												<!-- LIQ = Liquid -> 5 = flüssig -->
												<xsl:when test="$lPhys = 'LIQVISC'">5. Flüssig</xsl:when>
												<!-- LIQVISC = Liquid - Viscous -> 5 = flüssig -->
												<xsl:when test="$lPhys = 'OTHER'">7. Andere</xsl:when>
												<!-- OTHER = Other value - specify in corresponding field -> 7 = andere Erscheinungsform -->
												<xsl:when test="$lPhys = 'POW'">1. Staub- oder pulverförmig</xsl:when>
												<!-- POW = Powdery -> 1 = pulverförmig oder staubförmig -->
												<xsl:when test="$lPhys = 'SLU'">4. Schlammig</xsl:when>
												<!-- SLU = Sludgy -> 4 = schlammig -->
												<xsl:when test="$lPhys = 'SLUSOL'">4. Schlammig</xsl:when>
												<!-- SLUSOL = Sludgy - almost solid -> 4 = schlammig -->
												<xsl:when test="$lPhys = 'SLUVISC'">3. Pastös/breiig</xsl:when>
												<!-- SLUVISC =  Viscous or paste -> 3 = pastös oder breiig -->
												<xsl:when test="$lPhys = 'SOLCHU'">2. Fest</xsl:when>
												<!-- SOLCHU = Solid - in chunks -> 2 = fest -->
												<xsl:when test="$lPhys = 'SOLDUS'">1. Staub- oder pulverförmig</xsl:when>
												<!-- SOLDUS = Solid - Dusty -> 1 = pulverförmig oder staubförmig -->
												<xsl:when test="$lPhys = 'SOLGRAN'">2. Fest</xsl:when>
												<!-- SOLGRAN = Solid and granular -> 2 = fest -->
												<xsl:when test="$lPhys = 'SOLMOI'">2. Fest</xsl:when>
												<!-- SOLMOI = Solid - Moist -> 2 = fest -->
												<xsl:when test="$lPhys = 'SOLMON'">2. Fest</xsl:when>
												<!-- SOLCHU = Solid and monolithic -> 2 = fest -->
												<xsl:when test="$lPhys = 'SOLPOW'">1. Staub- oder pulverförmig</xsl:when>
												<!-- SOLPOW = Solid - Powdery -> 1 = pulverförmig oder staubförmig -->
												<xsl:when test="$lPhys = 'VISC'">3. Pastös/breiig</xsl:when>
												<!-- VISC = Viscous or paste -> 3 = pastös oder breiig -->
												<xsl:otherwise>0. unbekannt</xsl:otherwise>
												<!-- ??? -> 0 = unbekannt -->
											</xsl:choose>
										</xsl:variable>
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="$PhysEig"/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile14">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<font id="Titel">14. Abfallidentifizierung</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="3%" align="right"/>
							<col width="47%"/>
							<col width="50%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">i)</font>
							</td>
							<td>
								<font id="Titel_klein">Basel Anlage VIII (oder IX falls anwendbar):</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='BASEL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">ii) </font>
							</td>
							<td>
								<font id="Titel_klein">OECD-Code (falls abweichend von i):</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='OECD']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">iii) </font>
							</td>
							<td>
								<font id="Titel_klein">EU-Abfallverzeichnis:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='EWC']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">iv) </font>
							</td>
							<td>
								<font id="Titel_klein">Nationaler Code im Ausfuhrland:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='NATEXP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">v) </font>
							</td>
							<td>
								<font id="Titel_klein">Nationaler Code im Einfuhrland:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='NATIMP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">vi) </font>
							</td>
							<td>
								<font id="Titel_klein">Sonstige:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='OTHER']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">vii) </font>
							</td>
							<td>
								<font id="Titel_klein">Y-Code:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='YCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">viii) </font>
							</td>
							<td>
								<font id="Titel_klein">H-Code:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='HCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">iX) </font>
							</td>
							<td>
								<font id="Titel_klein">UN-Klasse:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='UNCLASS']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">X) </font>
							</td>
							<td>
								<font id="Titel_klein">UN-Kennnummer:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='UNNUM']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">Xi) </font>
							</td>
							<td>
								<font id="Titel_klein">UN-Versandname:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='UNSHIP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">Xii)</font>
							</td>
							<td>
								<font id="Titel_klein">Zollnummer(n) (HS):</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="descendant::userram:Waste[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement]/userram:WasteClassification/userram:Code[@CodeListIdentifier='CUST']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile15">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<font id="Titel">15. Erklärung des Exporteurs – Notifizierenden/Erzeugers</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">Ich erkläre hiermit, dass die obigen Informationen nach meinem besten Wissen vollständig sind und der Wahrheit entsprechen. Ich erkläre ferner, dass rechtlich durchsetzbare vertragliche Verpflichtungen schriftlich eingegangen wurden, alle für die grenzüberschreitende Verbringung erforderlichen Versicherungen oder sonstigen Sicherheitsleistungen abgeschlossen bzw. hinterlegt wurden und alle erforderlichen Zustimmungen der zuständigen Behörden der betreffenden Staaten vorliegen.</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="10%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">Name:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:Declaration/tfs:Exporter/tfs:NameExporter"/>
								</font>
							</td>
							<td>
								<font id="Titel_klein">Datum:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<font id="Aktuell_nu">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:Declaration/tfs:Exporter/tfs:DeclarationDateTimeExporter"/>
										</xsl:call-template>
									</font>
								</font>
							</td>
							<td>
								<font id="Titel_klein">Unterschrift:</font>
							</td>
							<td>
								<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0 or count(userrsm:EUDINWasteMovementDocument) > 0">
									<xsl:choose>
										<xsl:when test="count(userrsm:EUDINWasteMovementDocument) > 0">
											<xsl:for-each select="..">
												<font id="Aktuell_nu">
													<xsl:call-template name="getSigBegleitformular">
														<xsl:with-param name="ROLLE1" select="'EXP'"/>
														<xsl:with-param name="ROLLE2" select="'ERZ'"/>
													</xsl:call-template>
												</font>
											</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="//ntz:PreDokument">
												<xsl:if test="count(ntz:VersandBegleitformular/userrsm:EUDINWasteMovementDocument) > 0">
													<font id="Aktuell_nu">
														<xsl:call-template name="getSigBegleitformular">
															<xsl:with-param name="ROLLE1" select="'EXP'"/>
															<xsl:with-param name="ROLLE2" select="'ERZ'"/>
														</xsl:call-template>
													</font>
												</xsl:if>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile16">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<font id="Titel">16. Von sonstigen an der grenzüberschreitenden Verbringung beteiligte Personen auszufüllen, falls zusätzliche Informationen verlangt werden:</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="//ntz:Abfallverbringungsdokument/ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:Declaration/tfs:AdditionalInformation"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile17">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<font id="Titel">17. Eingang beim Importeur – Empfänger (falls keine Anlage)</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="10%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">Name:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteReceiptDocument/tfs:ImporterConsigneeReceptionConfirmation/tfs:PersonName"/>
								</font>
							</td>
							<td>
								<font id="Titel_klein">Datum:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="../ntz:FreieXMLStruktur/tfs:EUDINCertificateOfWasteReceiptDocument/tfs:ImporterConsigneeReceptionConfirmation/tfs:Date"/>
									</xsl:call-template>
								</font>
							</td>
							<td>
								<font id="Titel_klein">Unterschrift:</font>
							</td>
							<td>
								<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
									<xsl:choose>
										<xsl:when test="count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
											<xsl:for-each select="..">
												<font id="Aktuell_nu">
													<xsl:call-template name="getSigBegleitformular">
														<xsl:with-param name="ROLLE1" select="'IMP'"/>
													</xsl:call-template>
												</font>
											</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="//ntz:PreDokument">
												<xsl:if test="count(ntz:VersandBegleitformular/usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
													<font id="Aktuell_nu">
														<xsl:call-template name="getSigBegleitformular">
															<xsl:with-param name="ROLLE1" select="'IMP'"/>
														</xsl:call-template>
													</font>
												</xsl:if>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile17a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr align="center">
							<td>
								<font id="Titel">VON DER BESEITIGUNGS/VERWERTUNGSANLAGE AUSZUFÜLLEN</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile18_19">
		<table width="100%" id="Tabelle">
			<colgroup>
				<col width="75%"/>
				<col width="25%"/>
			</colgroup>
			<tr>
				<td width="75%">
					<xsl:call-template name="Zeile18"/>
				</td>
				<td width="25%">
					<xsl:call-template name="Zeile19"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile18">
		<table width="100%" id="Tabelle_rechts">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="24%"/>
							<col width="10%"/>
							<col width="17%"/>
							<col width="13%"/>
							<col width="20%"/>
							<col width="10%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel">
									<xsl:value-of select="'18. Eingang bei der Beseitigungsanlage'"/>
								</font>
							</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
												<xsl:if test="descendant::userram:DisposalFacilityIndicator[parent::userram:CorrespondingCertificateOfWasteReceipt or parent::usercwr:BusinessDocumentCertificateOfWasteReceipt] = 'true'">
													<font id="Aktuell_nu">
														<xsl:value-of select="'X'"/>
													</font>
												</xsl:if>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td/>
							<td/>
							<td>
								<font id="Titel">
									<xsl:value-of select="'oder Verwertungsanlage'"/>
								</font>
							</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
												<xsl:if test="descendant::userram:DisposalFacilityIndicator[parent::userram:CorrespondingCertificateOfWasteReceipt or parent::usercwr:BusinessDocumentCertificateOfWasteReceipt] = 'false'">
													<font id="Aktuell_nu">
														<xsl:value-of select="'X'"/>
													</font>
												</xsl:if>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">
									<xsl:value-of select="'Eingangsdatum:'"/>
								</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="descendant::userram:ReceptionDateTime"/>
										</xsl:call-template>
									</xsl:if>
								</font>
							</td>
							<td>
								<font id="Titel_klein">
									<xsl:value-of select="'in Empfang genommen:'"/>
								</font>
							</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
												<xsl:if test="descendant::userram:WasteRejectionCode = 'NR'">
													<font id="Aktuell_nu">
														<xsl:value-of select="'X'"/>
													</font>
												</xsl:if>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<font id="Titel_klein">
									<xsl:value-of select="'Empfang verweigert:'"/>
								</font>
							</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
												<xsl:if test="count(descendant::userram:WasteRejectionCode)>0">
													<xsl:if test="descendant::userram:WasteRejectionCode = 'FR'">
														<font id="Aktuell_nu">
															<xsl:value-of select="'X'"/>
														</font>
													</xsl:if>
												</xsl:if>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">
									<xsl:value-of select="'In Empfang genommene Menge:'"/>
								</font>
							</td>
							<td/>
							<td>
								<font id="Titel_klein">
									<xsl:value-of select="'Tonnen (Mg):'"/>
								</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
										<xsl:value-of select="descendant::userram:ReceivedWeightMeasurementSpecification/userram:Measure"/>
									</xsl:if>
								</font>
							</td>
							<td>
								<font id="Titel_klein">
									<xsl:value-of select="'m³:'"/>
								</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
										<xsl:value-of select="descendant::userram:ReceivedVolumeMeasurementSpecification/userram:Measure"/>
									</xsl:if>
								</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="37%"/>
							<col width="63%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">Ungefähres Datum der Beseitigung/Verwertung:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="descendant::userram:ApproximateRecoveryDisposalDateTime"/>
										</xsl:call-template>
									</xsl:if>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">Beseitigungs- Verwertungsverfahren:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
										<xsl:value-of select="descendant::userram:RecoveryDisposalOperationClassification[parent::userram:CorrespondingCertificateOfWasteReceipt or parent::usercwr:BusinessDocumentCertificateOfWasteReceipt]/userram:Code"/>
									</xsl:if>
								</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="10%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">Name:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
										<font id="Aktuell_nu">
											<xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteReceiptDocument/tfs:PersonName"/>
										</font>
										<!--										<xsl:choose>
											<xsl:when test="count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
											</xsl:when>
											<xsl:otherwise>
												<font id="Text_nu">
													<xsl:value-of select="//ntz:Abfallverbringungsdokument/ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteReceiptDocument/tfs:PersonName"/>
												</font>
											</xsl:otherwise>																						
										</xsl:choose>
-->
									</xsl:if>
								</font>
							</td>
							<td>
								<font id="Titel_klein">Datum:</font>
							</td>
							<td>
								<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
									<font id="Aktuell_nu">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="../ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteReceiptDocument/tfs:SigningTime"/>
										</xsl:call-template>
									</font>
									<!--									<xsl:if test="count(//ntz:Abfallverbringungsdokument/ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteReceiptDocument/tfs:SigningTime) > 0">
										<xsl:choose>
											<xsl:when test="count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
											</xsl:when>
											<xsl:otherwise>
												<font id="Text_nu">
													<xsl:call-template name="formatDate">
														<xsl:with-param name="date" select="//ntz:Abfallverbringungsdokument/ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteReceiptDocument/tfs:SigningTime"/>
													</xsl:call-template>
												</font>
											</xsl:otherwise>																						
										</xsl:choose>
									</xsl:if>
-->
								</xsl:if>
							</td>
							<td>
								<font id="Titel_klein">Unterschrift:</font>
							</td>
							<td>
								<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0 or count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
									<xsl:choose>
										<xsl:when test="count(usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
											<xsl:for-each select="..">
												<font id="Aktuell_nu">
													<xsl:call-template name="getSigBegleitformular">
														<xsl:with-param name="ROLLE1" select="'ENT'"/>
													</xsl:call-template>
												</font>
											</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="//ntz:PreDokument">
												<xsl:if test="count(ntz:VersandBegleitformular/usercwr:EUDINCertificateOfWasteReceiptDocument) > 0">
													<font id="Aktuell_nu">
														<xsl:call-template name="getSigBegleitformular">
															<xsl:with-param name="ROLLE1" select="'ENT'"/>
														</xsl:call-template>
													</font>
												</xsl:if>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile19">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<xsl:choose>
									<xsl:when test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0">
										<xsl:choose>
											<xsl:when test="usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument/usercwrd:BusinessDocumentCertificateOfWasteRecoveryDisposal/userram:DisposalFacilityIndicator='true'">
												<font id="Titel">19. Ich bescheinige hiermit, dass die oben beschriebenen Abfälle </font>
												&#173;
												<font id="Aktuell_nu">beseitigt/</font>
												<font id="Aktuell_nu_gestrichen">verwertet</font>
												&#173;
												<font id="Titel"> worden sind.</font>
											</xsl:when>
											<xsl:when test="usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument/usercwrd:BusinessDocumentCertificateOfWasteRecoveryDisposal/userram:DisposalFacilityIndicator='false'">
												<font id="Titel">19. Ich bescheinige hiermit, dass die oben beschriebenen Abfälle </font>
												&#173;
												<font id="Aktuell_nu_gestrichen">beseitigt</font>
												<font id="Aktuell_nu">/verwertet</font>
												&#173;
												<font id="Titel"> worden sind.</font>
											</xsl:when>
											<xsl:otherwise>
												<font id="Titel">19. Ich bescheinige hiermit, dass die oben beschriebenen Abfälle beseitigt/verwertet worden sind.</font>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<font id="Titel">19. Ich bescheinige hiermit, dass die oben beschriebenen Abfälle beseitigt/verwertet worden sind.</font>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">Name:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0">
										<xsl:value-of select="//ntz:Abfallverbringungsdokument/ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteRecoveryDisposalDocument/tfs:PersonName"/>
									</xsl:if>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">Datum:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0">
										<xsl:if test="count(//ntz:Abfallverbringungsdokument/ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteRecoveryDisposalDocument/tfs:SigningTime) > 0">
											<xsl:variable name="DATE_US">
												<xsl:value-of select="//ntz:Abfallverbringungsdokument/ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteRecoveryDisposalDocument/tfs:SigningTime"/>
											</xsl:variable>
											<xsl:call-template name="formatDate">
												<xsl:with-param name="date" select="$DATE_US"/>
											</xsl:call-template>
										</xsl:if>
									</xsl:if>
								</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel_klein">Unterschrift:</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Aktuell_nu">
									<xsl:if test="count(usercwrd:EUDINCertificateOfWasteRecoveryDisposalDocument) > 0">
										<xsl:for-each select="..">
											<xsl:call-template name="getSigBegleitformular">
												<xsl:with-param name="ROLLE1" select="'ENT'"/>
											</xsl:call-template>
										</xsl:for-each>
									</xsl:if>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile19a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr align="center">
							<td>
								<font id="Titel">VON DER ZOLLSTELLE AUSZUFÜLLEN</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile20_21">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td>
											<font id="Titel">20. Ausfuhrstaat/Versandstaat oder Ausgangszollstelle</font>
										</td>
									</tr>
								</table>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<tr>
										<td>
											<font id="Titel_klein">Die in diesem Begleitformular beschriebenen Abfälle wurden aus dem Land ausgeführt am:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Export/tfs:ExitDateTime"/>
													<!--<xsl:with-param name="date" select="descendant::userram:CustomsClearance[userram:EnteredCountryRoleIdentificationID = 'E']/userram:ClearanceDateTime"/>-->
												</xsl:call-template>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Zollstelle:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Export/tfs:OrganisationName"/>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Unterschrift:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Export/tfs:PersonName"/>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Unterschrieben:</font>
										</td>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Export/tfs:IndicatorSignature = 'true'">
															<font id="Aktuell_nu">
																<xsl:value-of select="'X'"/>
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Stempel:</font>
										</td>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Export/tfs:IndicatorStamp = 'true'">
															<font id="Aktuell_nu">
																<xsl:value-of select="'X'"/>
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<table width="100%" id="Tabelle_links">
						<tr>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td>
											<font id="Titel">21. Einfuhrstaat/Empfängerstaat oder Eingangszollstelle</font>
										</td>
									</tr>
								</table>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<tr>
										<td>
											<font id="Titel_klein">Die in diesem Begleitformular beschriebenen Abfälle wurden in das Land eingeführt am:</font>
										</td>
									</tr>
									<td>
										<font id="Aktuell_nu">
											<xsl:call-template name="formatDate">
												<xsl:with-param name="date" select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Import/tfs:EntryDateTime"/>
												<!--<xsl:with-param name="date" select="descendant::userram:CustomsClearance[userram:EnteredCountryRoleIdentificationID = 'E']/userram:ClearanceDateTime"/>-->
											</xsl:call-template>
										</font>
									</td>
									<tr>
										<td>
											<font id="Titel_klein">Zollstelle:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Import/tfs:OrganisationName"/>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Unterschrift:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Import/tfs:PersonName"/>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Unterschrieben:</font>
										</td>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Import/tfs:IndicatorSignature = 'true'">
															<font id="Aktuell_nu">
																<xsl:value-of select="'X'"/>
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Stempel:</font>
										</td>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Import/tfs:IndicatorStamp = 'true'">
															<font id="Aktuell_nu">
																<xsl:value-of select="'X'"/>
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile22">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<font id="Titel">22. Stempel der Zollstellen der Durchfuhrstaaten</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile22a">
		<xsl:choose>
			<xsl:when test="count(../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Transit) > 0">
				<xsl:for-each select="../ntz:FreieXMLStruktur//tfs:EUDINWasteMovementDocument/tfs:CustomsClearance/tfs:Transit">
					<xsl:sort select="@ConsecutiveNumberNumeric" order="ascending"/>
					<table width="100%" id="Tabelle">
						<tr>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="25%"/>
										<col width="25%"/>
										<col width="25%"/>
										<col width="25%"/>
									</colgroup>
									<tr>
										<td>
											<font id="Titel_klein">Lfd. Nr.</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="@ConsecutiveNumberNumeric"/>
											</font>
										</td>
										<td>
											<font id="Titel_klein"></font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="''"/>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Name des Staates:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="tfs:CountryID"/>
											</font>
										</td>
										<td>
											<font id="Titel_klein"></font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="''"/>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Einfuhr-Zollstelle:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="tfs:EntryOrganisationName"/>
											</font>
										</td>
										<td>
											<font id="Titel_klein">Ausfuhr-Zollstelle:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="tfs:ExitOrganisationName"/>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Eingang:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="tfs:EntryDateTime"/>
												</xsl:call-template>
											</font>
										</td>
										<td>
											<font id="Titel_klein">Ausgang</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="tfs:ExitDateTime"/>
												</xsl:call-template>
											</font>
										</td>
									</tr>
									<tr>
										<td>
											<font id="Titel_klein">Eingangsstempel</font>
										</td>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="tfs:IndicatorStampEntryOrganisation = 'true'">
															<font id="Aktuell_nu">
																<xsl:value-of select="'X'"/>
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
										<td>
											<font id="Titel_klein">Ausgangstempel</font>
										</td>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:if test="tfs:IndicatorStampExitOrganisation = 'true'">
															<font id="Aktuell_nu">
																<xsl:value-of select="'X'"/>
															</font>
														</xsl:if>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle">
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="25%"/>
									<col width="25%"/>
									<col width="25%"/>
									<col width="25%"/>
								</colgroup>
								<tr>
										<td>
											<font id="Titel_klein">Lfd. Nr.</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="''"/>
											</font>
										</td>
									<td>
										<font id="Titel_klein"></font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:value-of select="''"/>
										</font>
									</td>
								</tr>
								<tr>
										<td>
											<font id="Titel_klein">Name des Staates:</font>
										</td>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="''"/>
											</font>
										</td>
									<td>
										<font id="Titel_klein"></font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:value-of select="''"/>
										</font>
									</td>
								</tr>
								<tr>
									<td>
										<font id="Titel_klein">Einfuhr-Zollstelle:</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:value-of select="''"/>
										</font>
									</td>
									<td>
										<font id="Titel_klein">Ausfuhr-Zollstelle:</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:value-of select="''"/>
										</font>
									</td>
								</tr>
								<tr>
									<td>
										<font id="Titel_klein">Eingang:</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:value-of select="''"/>
										</font>
									</td>
									<td>
										<font id="Titel_klein">Ausgang</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:value-of select="''"/>
										</font>
									</td>
								</tr>
								<tr>
									<td>
										<font id="Titel_klein">Eingangsstempel</font>
									</td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
<!--													<xsl:if test="//userram:CorrespondingWasteMovement[not(ancestor::ntz:PreDokument)]/userram:DisposalFacilityIndicator = 'true'">
														<font id="Aktuell_nu">
															<xsl:value-of select="'X'"/>
														</font>
													</xsl:if>
-->												</td>
											</tr>
										</table>
									</td>
									<td>
										<font id="Titel_klein">Ausgangstempel</font>
									</td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
<!--													<xsl:if test="//userram:CorrespondingWasteMovement[not(ancestor::ntz:PreDokument)]/userram:DisposalFacilityIndicator = 'true'">
														<font id="Aktuell_nu">
															<xsl:value-of select="'X'"/>
														</font>
													</xsl:if>
-->												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="NAME_ADRESSE">
		<xsl:param name="ROLLE_VBF"/>
		<xsl:param name="BES_VERW" select="false()"/>
		<xsl:param name="TRANS" select="false()"/>
		<xsl:choose>
			<xsl:when test="$BES_VERW">
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="40%"/>
						<col width="10%"/>
					</colgroup>
					<tr>
						<td>
							<font id="Titel">
								<xsl:value-of select="$ROLLE_VBF"/>
							</font>
						</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:if test="../../userram:DisposalFacilityIndicator[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement] = 'true'">
											<font id="Aktuell_nu">
												<xsl:value-of select="'X'"/>
											</font>
										</xsl:if>
									</td>
								</tr>
							</table>
						</td>
						<td>
							<font id="Titel">
								<xsl:value-of select="'oder Verwertungsanlage'"/>
							</font>
						</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<xsl:if test="../../userram:DisposalFacilityIndicator[parent::userram:CorrespondingWasteMovement or parent::userrsm:BusinessDocumentWasteMovement] = 'false'">
											<font id="Aktuell_nu">
												<xsl:value-of select="'X'"/>
											</font>
										</xsl:if>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="50%"/>
						<col width="15%"/>
						<col width="35%"/>
					</colgroup>
					<tr>
						<td>
							<font id="Titel">
								<xsl:value-of select="$ROLLE_VBF"/>
							</font>
						</td>
						<xsl:if test="$TRANS=false()">
							<td>
								<font id="Titel_klein">Registriernummer:</font>
							</td>
							<xsl:if test="count(userram:Organization)>0">
								<xsl:for-each select="userram:Organization">
									<td>
										<font id="Aktuell_nu">
											<xsl:choose>
												<xsl:when test="string-length(userram:IdentificationID[@schemeURI='urn:id:de:bmu:eanv'])>0">
													<xsl:value-of select="concat(userram:IdentificationID[@schemeURI='urn:id:national:registrationnumber'],' (', userram:IdentificationID[@schemeURI='urn:id:de:bmu:eanv'], ')')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="userram:IdentificationID[@schemeURI='urn:id:national:registrationnumber']"/>
												</xsl:otherwise>
											</xsl:choose>
										</font>
									</td>
								</xsl:for-each>
							</xsl:if>
						</xsl:if>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(userram:Organization)>0">
				<xsl:for-each select="userram:Organization">
					<xsl:if test="$TRANS">
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td>
									<font id="Titel_klein">Registriernummer:</font>
								</td>
								<td>
									<font id="Aktuell_nu">
										<xsl:choose>
											<xsl:when test="string-length(userram:IdentificationID[@schemeURI='urn:id:de:bmu:eanv'])>0">
												<xsl:value-of select="concat(userram:IdentificationID[@schemeURI='urn:id:national:registrationnumber'],' (', userram:IdentificationID[@schemeURI='urn:id:de:bmu:eanv'], ')')"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="userram:IdentificationID[@schemeURI='urn:id:national:registrationnumber']"/>
											</xsl:otherwise>
										</xsl:choose>
									</font>
								</td>
							</tr>
						</table>
					</xsl:if>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<xsl:for-each select="userram:RegisteredOfficeContact">
							<tr>
								<td>
									<font id="Titel_klein">Name:</font>
								</td>
								<td>
									<xsl:variable name="NAME_1">
										<xsl:value-of select="substring(userram:Address/userram:LineOne,1,35)"/>
									</xsl:variable>
									<xsl:variable name="NAME_2">
										<xsl:value-of select="substring(userram:Address/userram:LineTwo,1,35)"/>
									</xsl:variable>
									<xsl:variable name="NAME_3">
										<xsl:value-of select="substring(userram:Address/userram:LineThree,1,35)"/>
									</xsl:variable>
									<xsl:variable name="NAME_4">
										<xsl:value-of select="substring(userram:Address/userram:LineFour,1,35)"/>
									</xsl:variable>
									<font id="Aktuell_nu">
										<xsl:choose>
											<xsl:when test="string-length(concat($NAME_1, ' ', $NAME_2, ' ', $NAME_3, ' ', $NAME_4))>50">
												<xsl:value-of select="concat(substring(concat($NAME_1, ' ', $NAME_2, ' ', $NAME_3, ' ', $NAME_4),1,50),'...')"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="concat($NAME_1, ' ', $NAME_2, ' ', $NAME_3, ' ', $NAME_4)"/>
											</xsl:otherwise>
										</xsl:choose>
									</font>
								</td>
							</tr>
							<tr>
								<td>
									<font id="Titel_klein">Anschrift:</font>
								</td>
								<td>
									<font id="Aktuell_nu">
										<xsl:variable name="STRASSE">
											<xsl:choose>
												<xsl:when test="string-length(userram:Address/userram:StreetName) > 0">
													<xsl:value-of select="userram:Address/userram:StreetName"/>
												</xsl:when>
												<xsl:when test="string-length(userram:Address/userram:PostOfficeBox)">
													<xsl:value-of select="userram:Address/userram:PostOfficeBox"/>
												</xsl:when>
											</xsl:choose>
										</xsl:variable>
										<xsl:variable name="HAUSNR">
											<xsl:value-of select="substring(userram:Address/userram:BuildingNumber,1,9)"/>
										</xsl:variable>
										<xsl:variable name="HAUSNR_ZUSATZ">
											<xsl:value-of select="substring(normalize-space(concat(userram:Address/userram:Block, ' ', userram:Address/userram:BuildingName, ' ',userram:Address/userram:Door, ' ', userram:Address/userram:Floor, ' ', userram:Address/userram:Wing, ' ', userram:Address/userram:Staircase)),1,35)"/>
										</xsl:variable>
										<xsl:value-of select="normalize-space(concat($STRASSE, ' ', $HAUSNR, ' ', $HAUSNR_ZUSATZ))"/>
									</font>
								</td>
							</tr>
							<tr>
								<td/>
								<td>
									<font id="Aktuell_nu">
										<xsl:variable name="ORT">
											<xsl:value-of select="normalize-space(concat(substring(userram:Address/userram:CityName,1,35),' ',userram:Address/userram:CitySub-Division))"/>
										</xsl:variable>
										<xsl:value-of select="normalize-space(concat(userram:Address/userram:CountryID,' ',userram:Address/userram:PostcodeCode,' ',$ORT))"/>
									</font>
								</td>
							</tr>
							<!--tr>
								<td>
									<font id="Titel_klein">Region:</font>
								</td>
								<td>
									<font id="Aktuell_nu">
										<xsl:value-of select="userram:Address/userram:Region"/>
									</font>
								</td>
							</tr-->
							<xsl:if test="$TRANS=false()">
								<tr>
									<td>
										<font id="Titel_klein">Kontaktperson:</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:variable name="KONTAKT">
												<xsl:value-of select="normalize-space(concat(userram:Person/userram:Salutation, ' ',userram:Person/userram:Title, ' ',  userram:Person/userram:GivenName, ' ', userram:Person/userram:FamilyNamePrefix, ' ', userram:Person/userram:FamilyName, ' ', userram:Person/userram:FamilyNameSuffix))"/>
											</xsl:variable>
											<xsl:value-of select="substring($KONTAKT,1,35)"/>
										</font>
									</td>
								</tr>
							</xsl:if>
						</xsl:for-each>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="40%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">Tel.:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="userram:RegisteredOfficeContact/userram:OfficeCommunication">
										<xsl:choose>
											<xsl:when test="string-length(userram:CommunicationNumber) > 0">
												<xsl:value-of select="userram:CommunicationNumber"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="substring(concat(userram:CountryDialling, ' ', userram:AreaDialling, ' ', userram:DialNumber, ' ', userram:Extension),1,35)"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</font>
							</td>
							<td>
								<font id="Titel_klein">Fax:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="userram:RegisteredOfficeContact/userram:FaxCommunication">
										<xsl:choose>
											<xsl:when test="string-length(userram:CommunicationNumber) > 0">
												<xsl:value-of select="userram:CommunicationNumber"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="substring(concat(userram:CountryDialling, ' ', userram:AreaDialling, ' ', userram:DialNumber, ' ', userram:Extension),1,35)"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">E-Mail:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="userram:RegisteredOfficeContact/userram:EmailIdentificationID"/>
								</font>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="count(userram:Person)>0">
				<xsl:for-each select="userram:Person">
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">Registriernummer:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:choose>
										<xsl:when test="string-length(userram:IdentificationID[@schemeURI='urn:id:de:bmu:eanv'])>0">
											<xsl:value-of select="concat(userram:IdentificationID[@schemeURI='urn:id:national:registrationnumber'],' (', userram:IdentificationID[@schemeURI='urn:id:de:bmu:eanv'], ')')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="userram:IdentificationID[@schemeURI='urn:id:national:registrationnumber']"/>
										</xsl:otherwise>
									</xsl:choose>
								</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<xsl:variable name="NAME_FULL">
							<xsl:value-of select="normalize-space(concat(./userram:Title, ' ', ./userram:GivenName, ' ', ./userram:FamilyNamePrefix, ' ', ./userram:FamilyName, ' ', ./userram:NameSuffix))"/>
						</xsl:variable>
						<tr>
							<td>
								<font id="Titel_klein">Name:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="substring($NAME_FULL,1,70)"/>
								</font>
							</td>
						</tr>
						<tr>
							<td/>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="substring($NAME_FULL,71)"/>
								</font>
							</td>
						</tr>
						<xsl:for-each select="userram:PrimaryContact">
							<tr>
								<td>
									<font id="Titel_klein">Anschrift:</font>
								</td>
								<td>
									<font id="Aktuell_nu">
										<xsl:variable name="STRASSE">
											<xsl:choose>
												<xsl:when test="string-length(userram:Address/userram:StreetName) > 0">
													<xsl:value-of select="userram:Address/userram:StreetName"/>
												</xsl:when>
												<xsl:when test="string-length(userram:Address/userram:PostOfficeBox)">
													<xsl:value-of select="userram:Address/userram:PostOfficeBox"/>
												</xsl:when>
											</xsl:choose>
										</xsl:variable>
										<xsl:variable name="HAUSNR">
											<xsl:value-of select="substring(userram:Address/userram:BuildingNumber,1,9)"/>
										</xsl:variable>
										<xsl:variable name="HAUSNR_ZUSATZ">
											<xsl:value-of select="substring(normalize-space(concat(userram:Address/userram:Block, ' ', userram:Address/userram:BuildingName, ' ',userram:Address/userram:Door, ' ', userram:Address/userram:Floor, ' ', userram:Address/userram:Wing, ' ', userram:Address/userram:Staircase)),1,35)"/>
										</xsl:variable>
										<xsl:value-of select="normalize-space(concat($STRASSE, ' ', $HAUSNR, ' ', $HAUSNR_ZUSATZ))"/>
									</font>
								</td>
							</tr>
							<tr>
								<td/>
								<td>
									<font id="Aktuell_nu">
										<xsl:variable name="ORT">
											<xsl:value-of select="normalize-space(concat(substring(userram:Address/userram:CityName,1,35),' ',userram:Address/userram:CitySub-Division))"/>
										</xsl:variable>
										<xsl:value-of select="normalize-space(concat(userram:Address/userram:CountryID,' ',userram:Address/userram:PostcodeCode,' ',$ORT))"/>
									</font>
								</td>
							</tr>
							<!--tr>
								<td>
									<font id="Titel_klein">Region:</font>
								</td>
								<td>
									<font id="Aktuell_nu">
										<xsl:value-of select="userram:Address/userram:Region"/>
									</font>
								</td>
							</tr-->
							<xsl:if test="$TRANS=false()">
								<tr>
									<td>
										<font id="Titel_klein">Kontaktperson:</font>
									</td>
									<td>
										<font id="Aktuell_nu">
											<xsl:value-of select="substring(normalize-space(concat(userram:Person/userram:Salutation, ' ',userram:Person/userram:Title, ' ',  userram:Person/userram:GivenName, ' ', userram:Person/userram:FamilyNamePrefix, ' ', userram:Person/userram:FamilyName, ' ', userram:Person/userram:FamilyNameSuffix)),1,35)"/>
										</font>
									</td>
								</tr>
							</xsl:if>
						</xsl:for-each>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="40%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">Tel.:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="userram:PrimaryContact/userram:OfficeCommunication">
										<xsl:choose>
											<xsl:when test="string-length(userram:CommunicationNumber) > 0">
												<xsl:value-of select="userram:CommunicationNumber"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="substring(concat(userram:CountryDialling, ' ', userram:AreaDialling, ' ', userram:DialNumber, ' ', userram:Extension),1,35)"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</font>
							</td>
							<td>
								<font id="Titel_klein">Fax:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:for-each select="userram:PrimaryContact/userram:FaxCommunication">
										<xsl:choose>
											<xsl:when test="string-length(userram:CommunicationNumber) > 0">
												<xsl:value-of select="userram:CommunicationNumber"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="substring(concat(userram:CountryDialling, ' ', userram:AreaDialling, ' ', userram:DialNumber, ' ', userram:Extension),1,35)"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td>
								<font id="Titel_klein">E-Mail:</font>
							</td>
							<td>
								<font id="Aktuell_nu">
									<xsl:value-of select="userram:PrimaryContact/userram:EmailIdentificationID"/>
								</font>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="20%"/>
						<col width="30%"/>
					</colgroup>
					<tr>
						<td>
							<font id="Titel_klein">Registriernummer:</font>
						</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td>
							<font id="Titel_klein">Name:</font>
						</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td>
							<font id="Titel_klein">Anschrift:</font>
						</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<xsl:if test="$TRANS=false()">
						<tr>
							<td>
								<font id="Titel_klein">Kontaktperson:</font>
							</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</xsl:if>
				</table>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="10%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td>
							<font id="Titel_klein">Tel.:</font>
						</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
						<td>
							<font id="Titel_klein">Fax:</font>
						</td>
						<td/>
					</tr>
					<tr>
						<td>
							<font id="Titel_klein">E-Mail:</font>
						</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="DUMMY_ZEICHEN">
		<td>
			<font id="Aktuell_nu">&#173;</font>
		</td>
	</xsl:template>
</xsl:stylesheet>
