<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="Deckblatt"/>
				<xsl:call-template name="showSigLayer"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Deckblatt">
		<!--xsl:for-each select="//*[@lib:LayerID=$layerID]"-->
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<td/>
					</tr>
					<tr>
						<td>
							<div id="Nummer" align="right">Deckblatt</div>
							<table id="tabelle_nicht_unten" width="100%">
								<xsl:call-template name="ESNKopfNummern"/>
								<tr>
									<td>
										<xsl:choose>
											<xsl:when test="local-name() = 'ENSNVorlageLayerRE'">
												<font id="Nummer">
													Spezielles freies Layer für Register
												</font>
											</xsl:when>
											<xsl:otherwise>
												<font id="Nummer">
													Entsorgungsnachweis/Sammelentsorgungsnachweis/EN/SN
												</font>
											</xsl:otherwise>
										</xsl:choose>
										<font id="Ueberschrift2">
											<!--xsl:value-of select="$layerName"/-->							
											(<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)								
										</font>
									</td>
								</tr>
							</table>
							<table id="tabelle_nicht_unten" width="100%">
								<tr>
									<td>
										<table width="100%">
											<colgroup>
												<col width="4%"/>
												<col width="2%"/>
												<col width="94%"/>
											</colgroup>
											<tr>
												<td id="titel_gross">EN</td>
												<td>
													<table id="Tabelle_indikator">
														<tr>
															<td>
																<xsl:call-template name="getBooleanValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorEN'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
												<td id="Ueberschrift2">Entsorgungsnachweis f&#252;r nachweispflichtige Abf&#228;lle </td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td>
										<table width="100%">
											<colgroup>
												<col width="4%"/>
												<col width="2%"/>
												<col width="92%"/>
											</colgroup>
											<tr>
												<td id="titel_gross">SN</td>
												<td>
													<table id="Tabelle_indikator">
														<tr>
															<td>
																<xsl:call-template name="getBooleanValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorEN'"/>
																	<xsl:with-param name="invers" select="true()"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
												<td id="Ueberschrift2">	Sammelentsorgungsnachweis f&#252;r nachweispflichtige Abf&#228;lle </td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table id="tabelle_nicht_unten" width="100%">
								<colgroup>
									<col width="3%"/>
									<col width="2%"/>
									<col width="19%"/>
									<col width="3%"/>
									<col width="2%"/>
									<col width="32%"/>
									<col width="3%"/>
									<col width="2%"/>
									<col width="10%"/>
									<col width="3%"/>
									<col width="2%"/>
									<col width="10%"/>
									<col width="2%"/>
								</colgroup>
								<tr>
									<td> </td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorMitBB'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
									<td id="Titel"> mit Beh&#246;rdenbest&#228;tigung</td>
									<td> </td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorMitBB'"/>
														<xsl:with-param name="invers" select="true()"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
									<td id="Titel"> ohne Beh&#246;rdenbest&#228;tigung (§ 7 NachwV)</td>
									<td> </td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorBeseitigung'"/>
														<xsl:with-param name="invers" select="true()"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
									<td id="Titel"> zur Verwertung </td>
									<td> </td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorBeseitigung'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
									<td id="Titel"> zur Beseitigung</td>
									<td>
						        		 </td>
								</tr>
							</table>
							<table id="tabelle_nicht_oben_unten" width="100%">
								<colgroup>
									<col width="3%"/>
									<col width="2%"/>
									<col width="19%"/>
									<col width="3%"/>
									<col width="2%"/>
									<col width="32%"/>
									<col width="3%"/>
									<col width="2%"/>
									<col width="10%"/>
									<col width="3%"/>
									<col width="2%"/>
									<col width="10%"/>
									<col width="2%"/>
								</colgroup>
								<tr>
									<td> </td>
									<td>
										<table id="Tabelle_indikator">
											<tr>
												<td>
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorFreiwilligeRuecknahme'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
									<td id="Titel"> Freiwillige Rücknahme</td>
									<td> </td>
									<td> </td>
									<td> </td>
									<td> </td>
									<td> </td>
									<td> </td>
									<td> </td>
									<td> </td>
									<td> </td>
									<td> </td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="92%"/>
									<col width="8%"/>
								</colgroup>
								<tr>
									<td>
										<table id="tabelle_unten" width="100%">
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="Ueberschrift2">Nur bei Verwendung als Registerblatt </td>
														</tr>
														<tr>
															<td id="titel">Nach Abfallverzeichnis-Verordnung (AVV)   </td>
														</tr>
														<tr>
															<td id="titel">Abfallschl&#252;ssel </td>
														</tr>
														<tr>
															<td height="8">
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfall/en:Abfallschluessel'"/>
																</xsl:call-template>
															</td>
														</tr>
														<tr>
															<td id="titel">Abfallbezeichnung </td>
														</tr>
														<tr>
															<td height="8">
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfall/en:Abfallbezeichnung'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
										<table id="tabelle_unten" width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">1</td>
												<td id="Ueberschrift2" width="98%">Angaben zum Abfallerzeuger</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Firma / K&#246;rperschaft</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.1</td>
												<td width="98%">
													<!-- Erzeuger - Name 1 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Name/lib:Name1'"/>
													</xsl:call-template>
													&#173;
												      <!-- Erzeuger - Name 2 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Name/lib:Name2'"/>
													</xsl:call-template>
													&#173;
													<!-- Erzeuger - Name 3 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Name/lib:Name3'"/>
													</xsl:call-template>
													&#173;
													<!-- Erzeuger - Name 4 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Name/lib:Name4'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="90%">Straße</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.2</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="90%">
																<!-- Erzeuger - Strasse 1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
									                                         &#173;
								 								<!-- Erzeuger - Strasse 2-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
																</xsl:call-template>
															</td>
															<td width="10%">
																<!-- Erzeuger - Hausnummer -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.3</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Erzeuger Postleitzahl -->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Erzeuger Ort1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>					 
																&#173;
																<!-- Erzeuger Ort2-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallerzeuger/en:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Ansprechpartner</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.4</td>
												<td width="98%">
													<!-- Erzeuger Ansprechpartner - Name-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Ansprechpartner/lib:Name'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Telefon</td>
															<td id="titel" width="70%">Telefax</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.5</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Erzeuger Ansprechpartner - Telefon-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Ansprechpartner/lib:Telefon'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Erzeuger Ansprechpartner - Telefax-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Ansprechpartner/lib:Telefax'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">E-Mail-Adresse</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.6</td>
												<td width="98%">
													<!-- Erzeuger Ansprechpartner - E-Mail-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Ansprechpartner/lib:EMail'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">2</td>
												<td id="Ueberschrift2" width="98%">Angaben zum Bevollm&#228;chtigten</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Firma / K&#246;rperschaft</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.1</td>
												<td width="98%">
													<!-- Bevollmaechtigter - Name 1 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Name/lib:Name1'"/>
													</xsl:call-template>
													&#173;
												      <!-- Bevollmaechtigter - Name 2 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Name/lib:Name2'"/>
													</xsl:call-template>
													&#173;
													<!-- Bevollmaechtigter - Name 3 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Name/lib:Name3'"/>
													</xsl:call-template>
													&#173;
													<!-- Bevollmaechtigter - Name 4 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Name/lib:Name4'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="90%">Straße</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.2</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="90%">
																<!-- Bevollmaechtigter - Strasse 1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
							                                         &#173;
						 								<!-- Bevollmaechtigter - Strasse 2-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
																</xsl:call-template>
															</td>
															<td width="10%">
																<!-- Bevollmaechtigter - Hausnummer -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.3</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Bevollmaechtigter Postleitzahl -->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Bevollmaechtigter Ort1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>					 
														&#173;
														<!-- Bevollmaechtigter Ort2-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Ansprechpartner</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.4</td>
												<td width="98%">
													<!-- Bevollmaechtigter Ansprechpartner - Name-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:Ansprechpartner/lib:Name'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Telefon</td>
															<td id="titel" width="70%">Telefax</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.5</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Bevollmaechtigter Ansprechpartner - Telefon-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:Ansprechpartner/lib:Telefon'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Bevollmaechtigter Ansprechpartner - Telefax-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:Ansprechpartner/lib:Telefax'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">E-Mail-Adresse</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.6</td>
												<td width="98%">
													<!-- Bevollmaechtigter Ansprechpartner - EMail-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeuger/en:Bevollmaechtigter/en:Ansprechpartner/lib:EMail'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> F&#252;r interne Vermerke der Beh&#246;rde   </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table id="tabelle" width="100%">
								<tr>
									<td width="5"/>
									<td width="98%">
										<table width="100%">
											<tr>
												<td id="Ueberschrift2">F&#252;r Vermerke des Abfallerzeugers (f&#252;r Entsorgungs / Sammelentsorgungsnachweis ausf&#252;llen)</td>
											</tr>
											<tr>
												<td>
													<table width="100%">
														<tr>
															<td id="titel" width="33%">Ablauf der Frist nach § 5 Abs. 5 oder § 7 Abs. 4 NachwV
																<!-- Ablauf der Frist nach § 5 Abs. 5 oder § 7 Abs. 4 NachwV -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeugervermerke/en:DatumAblaufFrist'"/>
																</xsl:call-template>
															</td>
															<td width="33%"/>
															<td width="33%"/>
														</tr>
														<tr>
															<td id="titel" width="33%">Durch die Beh&#246;rde best&#228;tigtes Eingangsdatum
																<!-- Durch die Behörde bestätigtes Eingangsdatum -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeugervermerke/en:DatumEB'"/>
																</xsl:call-template>
															</td>
															<td width="33%"/>
															<td width="33%">
															</td>
														</tr>
														<tr>
															<td width="33%">
															</td>
															<td width="33%">
																<table>
																	<tr>
																		<td>
																			<table id="Tabelle_indikator">
																				<tr>
																					<td>
																						<xsl:call-template name="getBooleanValue">
																							<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeugervermerke/en:IndicatorUnterlagenVollstaendig'"/>
																						</xsl:call-template>
																					</td>
																				</tr>
																			</table>
																		</td>
																		<td id="titel">
                                                                                                 Unterlagen vollst&#228;ndig
																</td>
																	</tr>
																</table>
															</td>
															<td width="33%"/>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<table width="100%">
													<tr>
														<td id="titel" width="40%">
                        		            	                       Verantwortliche Erkl&#228;rung und Anahmeerkl&#228;rung und Best&#228;tigung der Beh&#246;rde (soweit aufgrund NachwV erforderlich) gingen in Kopie an die zust&#228;ndige Beh&#246;rde am
												</td>
														<td width="20%">
                                                                         ►  
							                		       	<!--Verantwortliche Erklärung und Anahmeerklärung und Bestätigung der
													Behörde (soweit aufgrund NachwV erforderlich) gingen
													in Kopie an die zuständige Behörde am -->
															<xsl:call-template name="getDateValue">
																<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallerzeugervermerke/en:DatumAusgangErzeugerbehoerde'"/>
															</xsl:call-template>
														</td>
													</tr>
												</table>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
