<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:dyn="http://exslt.org/dynamic"
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	xmlns:xalan="http://xml.apache.org/xalan"
	extension-element-prefixes="dyn b64 crc32 x509 xalan" 
	exclude-result-prefixes="xsl dyn lib en ds b64 crc32 x509 xalan xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Freistellung</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="Freistellung"/>
				<xsl:call-template name="showSigLayer">
					<xsl:with-param name="Praefix" select="'FR'"/>
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Freistellung">
		<xsl:for-each select="//*[(starts-with(local-name(), 'FR')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<td/>
					</tr>
					<tr>
						<td>
							<div align="right"><font id="Nummer">Antrag auf Freistellung nach § 7 NachwV</font><font id="Ueberschrift2"> (<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)</font></div>
							<table id="tabelle_nicht_unten" width="100%">
								<tr>
									<td>
										<table width="100%">
											<colgroup>
												<col width="39%"/>
												<col width="22%"/>
												<col width="39%"/>
											</colgroup>
											<tr>
												<td>
													<font id="Nummer2">Vor-Nr. </font>
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VorlaeufigeFRNr'"/>
                                                        <xsl:with-param name="first" select="true()"/>
													</xsl:call-template>
												</td>
												<td/>
												<td>
													<font id="Nummer2">Nr. </font>
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Freistellungsnummer/lib:FreistellungsNr'"/>
                                                        <xsl:with-param name="first" select="true()"/>
													</xsl:call-template>
													&#173;
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Freistellungsnummer/lib:Pruefziffer'"/>
                                                        <xsl:with-param name="first" select="true()"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">1</td>
												<td id="Ueberschrift2" width="98%">
			                                                     Angaben zum Abfallentsorger                                                    
                                                         </td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Firma / K&#228;rperschaft</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.1</td>
												<td width="98%">
													<!-- Firma 1-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Name/lib:Name1'"/>
													</xsl:call-template>
													&#173;
												      <!-- Firma 2 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Name/lib:Name2'"/>
													</xsl:call-template>
													&#173;
													<!-- Firma 3 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Name/lib:Name3'"/>
													</xsl:call-template>
													&#173;
													<!-- Firma 4 -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Name/lib:Name4'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="90%">Straße oder Koordinaten</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.2</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="90%">
																<!--  Strasse 1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
									                                         &#173;
								 								<!-- Strasse 2-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
																</xsl:call-template>
																&#160;
																<xsl:if test="count(en:Deckblatt/en:Entsorgungsanlage/en:Koordinaten) > 0 or count(descendant::en:Deckblatt/en:Entsorgungsanlage/en:Koordinaten) > 0">
																	<font id="titel">Koordinaten: </font>
																</xsl:if>
																&#160;
																<!-- Koordinaten Hochwert-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Koordinaten/lib:Hochwert'"/>
																</xsl:call-template>
																&#160;
																<!-- Koordinaten Rechtswert-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Koordinaten/lib:Rechtswert'"/>
																</xsl:call-template>
																&#160;
																<!-- Koordinaten NummerTopoKarte-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Koordinaten/lib:NummerTopoKarte'"/>
																</xsl:call-template>
															</td>
															<td valign="top" width="10%">
																<!-- Hausnummer -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.3</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Postleitzahl -->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Ort1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>					 
																&#173;
																<!-- Ort2-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Abfallentsorger/en:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2">   </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">2</td>
												<td id="Ueberschrift2" width="98%">
                                                      			Entsorgungsanlage                                              
                                                         </td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.1</td>
												<td width="98%">
													<table>
														<tr>
															<td width="2"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorCPB'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="Ueberschrift2">Chemisch-/ physikalische Behandlung</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorTherm'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="Ueberschrift2">Thermische Behandlung</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorODep'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="Ueberschrift2">oberirdische Deponie</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorUDep'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="Ueberschrift2">Untertagedeponie</td>
															<td width="25"/>
															<td>
																<table id="Tabelle_indikator">
																	<tr>
																		<td>
																			<xsl:call-template name="getBooleanValue">
																				<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Anlagentyp/en:IndicatorSonst'"/>
																			</xsl:call-template>
																		</td>
																	</tr>
																</table>
															</td>
															<td id="Ueberschrift2">sonstige Entsorgungsverfahren</td>
															<td width="25"/>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.2</td>
												<td width="98%">
													<table>
														<tr>
															<td>
																<font id="titel">Entsorgungsverfahren (Verfahrensangabe nach Anlage 1 oder Anlage 2 des KrWG)</font>
															</td>
															<td width="3"/>
															<td>
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:RDVerfahren'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
													<tr>
														<td width="5"/>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td id="titel" width="87%">Bezeichnung der Entsorgungsanlage bzw. Betriebsstätte</td>
																	<td id="titel" width="13%">Entsorgernummer</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td valign="top" id="Ueberschrift2" width="5">2.3</td>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td width="87%">
																		<!-- Bezeichnung 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Bezeichnung/en:Bezeichnung1'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Bezeichnung 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Bezeichnung/en:Bezeichnung2'"/>
																		</xsl:call-template>
																		<br></br>
																		<!-- Name 1-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name1'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name2'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 3-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name3'"/>
																		</xsl:call-template>
																		&#173;
																		<!-- Name 4-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Name/lib:Name4'"/>
																		</xsl:call-template>
																	</td>
																	<td width="13%" valign="top">
																		<!-- Entsorgernummer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Entsorgernummer/lib:BehoerdlicheNr'"/>
																		</xsl:call-template>
																		&#160;
																		<!-- Prüfziffer-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Entsorgernummer/lib:Pruefziffer '"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td id="titel" width="87%">Straße</td>
																	<td id="titel" width="13%">Hausnummer</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.4</td>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td width="87%">
																		<!-- Entsorger - Strasse 1-->
																		<xsl:call-template name="getTextValuePostfach">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Strasse_1'"/>
																			<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Postfach/lib:Postfach'"/>
																		</xsl:call-template>
											                                         &#173;
										 								<!-- Entsorger - Strasse 2-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Strasse_2'"/>
																		</xsl:call-template>
																	</td>
																	<td width="13%">
																		<!-- Entsorger - Hausnummer -->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Hausnummer'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td id="titel" width="30%">Postleitzahl</td>
																	<td id="titel" width="70%">Ort</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.5</td>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td width="30%">
																		<!-- Entsorger Postleitzahl -->
																		<xsl:call-template name="getTextValuePostfach">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Postleitzahl'"/>
																			<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Postfach/lib:Postleitzahl'"/>
																		</xsl:call-template>
																	</td>
																	<td width="70%">
																		<!-- Entsorger Ort1-->
																		<xsl:call-template name="getTextValuePostfach">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Ort_1'"/>
																			<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Postfach/lib:Ort_1'"/>
																		</xsl:call-template>					 
																		&#173;
																		<!-- Entsorger Ort2-->
																		<xsl:call-template name="getTextValuePostfach">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Adresse/lib:Ort_2'"/>
																			<xsl:with-param name="TagNamePostfach" select="'en:Deckblatt/en:Entsorgungsanlage/en:Betriebsstaette/lib:Postfach/lib:Ort_2'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td id="titel" width="98%">Ansprechpartner</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.6</td>
														<td width="98%">
															<!-- Entsorger Ansprechpartner - Name-->
															<xsl:call-template name="getTextValue">
																<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Ansprechpartner/lib:Name'"/>
															</xsl:call-template>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td id="titel" width="30%">Telefon</td>
																	<td id="titel" width="70%">Telefax</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.7</td>
														<td width="98%">
															<table width="100%">
																<tr>
																	<td width="30%">
																		<!-- Entsorger Ansprechpartner - Telefon-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Ansprechpartner/lib:Telefon'"/>
																		</xsl:call-template>
																	</td>
																	<td width="70%">
																		<!-- Entsorger Ansprechpartner - Telefax-->
																		<xsl:call-template name="getTextValue">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Ansprechpartner/lib:Telefax'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td width="5"/>
														<td id="titel" width="98%">E-Mail-Adresse</td>
													</tr>
													<tr>
														<td id="Ueberschrift2" width="5">2.8</td>
														<td width="98%">
															<!-- Entsorger Ansprechpartner - E-Mail-->
															<xsl:call-template name="getTextValue">
																<xsl:with-param name="TagName" select="'en:Deckblatt/en:Entsorgungsanlage/en:Ansprechpartner/lib:EMail'"/>
															</xsl:call-template>
														</td>
													</tr>
													<tr>
														<td id="Ueberschrift2"  valign="top" width="5">2.9</td>
														<td width="98%">
															<table>
																<tr>
																	<td id="titel">Auflistung und Beschreibung der Abf&#228;lle nach Art, Beschaffenheit und Menge bei Antr&#228;gen nach § 7 NachwV auf gesonderten Blatt nach Maßgabe der zust&#228;ndigen Behörde.</td>
																</tr>
																<tr>
																	<td>
																		<table id="Tabelle_unten" width="100%">
																			<tr>
																				<td id="Ueberschrift2" width="20%"> Abfallschlüssel</td>
																				<td id="Ueberschrift2" width="1%"/>
																				<td id="Ueberschrift2" width="57%"> Beschaffenheit</td>
																				<td id="Ueberschrift2" width="1%"/>
																				<td id="Ueberschrift2" width="20%"> Menge</td>
																				<td id="Ueberschrift2" width="1%"/>
																			</tr>
																		</table>
																		 <!--  Abfalliste-->
																		<xsl:call-template name="getAbfallList">
																			<xsl:with-param name="TagName" select="'en:Deckblatt/en:Abfall'"/>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2">    </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">3</td>
												<td id="Ueberschrift2" width="98%">Antrag</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5" valign="top">3.1</td>
												<td width="98%">
													<!-- Text -->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:Deckblatt/en:Antrag/en:Text'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr height="2%"/>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="25%">Ort</td>
															<td id="titel" width="15%">Datum</td>
															<td id="titel" width="25%">Name</td>
															<td id="titel" width="35%">Rechtsverbindliche Unterschrift (Signatur)</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">3.2</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="25%">
																<!--  Ort -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Antrag/lib:Ort'"/>
																</xsl:call-template>
															</td>
															<td width="15%">
																<!--  Datum  -->
																<xsl:call-template name="getDateValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Antrag/lib:Datum'"/>
																</xsl:call-template>
															</td>
															<td width="25%">
																<!--  Name -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:Deckblatt/en:Antrag/lib:Name'"/>
																</xsl:call-template>
															</td>
															<td width="35%">
																<xsl:variable name="FR_LAYER_ID">
																	<xsl:choose>
																		<xsl:when test="local-name()='FRENTLayer'">
																			<xsl:value-of select="@lib:LayerID"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="descendant::en:FRENTLayer/@lib:LayerID"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:variable>
																<!--xsl:message>VE_LAYER_ID: <xsl:value-of select="$VE_LAYER_ID"/></xsl:message-->
																<xsl:variable name="SIG_AKTUELL">
																	<xsl:choose>
																		<xsl:when test="local-name()='FRENTLayer'">
																			<xsl:value-of select="true()"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="false()"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:variable>
																<!--xsl:message>SIG_AKTUELL: <xsl:value-of select="$SIG_AKTUELL"/></xsl:message-->
																<xsl:choose>
																	<xsl:when test="$SIG_AKTUELL='true'">
																		<xsl:choose>
																			<xsl:when test="count(ds:Signature) > 0">
																				<font id="Aktuell">
																					<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																					<xsl:variable name="SIG_DATE">
																						<xsl:call-template name="formatDate">
																							<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																						</xsl:call-template>
																					</xsl:variable>
														 							<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
																					<!--xsl:message>Font: <xsl:value-of select="'Aktuell'"/></xsl:message-->
																				</font>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:if test="count(descendant::*[@lib:LayerID=$FR_LAYER_ID]/ds:Signature) > 0">
																			<font id="Text">
																				<xsl:value-of select="x509:extractCommonName(b64:decode(descendant::*[@lib:LayerID=$FR_LAYER_ID]/ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																				<xsl:variable name="SIG_DATE2">
																					<xsl:call-template name="formatDate">
																						<xsl:with-param name="date" select="descendant::*[@lib:LayerID=$FR_LAYER_ID]/ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																					</xsl:call-template>
																				</xsl:variable>
													 							<xsl:value-of select="concat(' (', $SIG_DATE2, ')')"/>
																				<!--xsl:message>Font: <xsl:value-of select="'Text'"/></xsl:message-->
																			</font>
																		</xsl:if>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="AbfallBez">
		<xsl:param name="index"/>
		<xsl:choose>
			<xsl:when test="boolean(en:Deckblatt/en:Abfall[@lib:Index=$index])">
				<xsl:for-each select="en:Deckblatt/en:Abfall[@lib:Index=$index]">
					<table id="Tabelle_unten" width="100%">
						<tr>
							<td id="Aktuell" valign="top" width="20%">
								<xsl:value-of select="en:Abfallschluessel"/>
							</td>
							<td width="1%"/>
							<td id="Aktuell" valign="top" width="57%">
								<xsl:value-of select="en:Beschaffenheit"/>
							</td>
							<td width="1%"/>
							<td id="Aktuell" valign="top" width="23%">
								<xsl:call-template name="formatDouble">
									<xsl:with-param name="wert" select="en:Menge"/>
									<xsl:with-param name="unit" select="en:Menge/@lib:Einheit"/>
								</xsl:call-template>
								<!--xsl:value-of select="en:Menge"/>
  		                                         &#173;
		                                     <xsl:value-of select="en:Menge/@lib:Einheit"/-->
							</td>
							<td width="1%"/>
						</tr>
						<tr height="15">
							<th/>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(descendant::en:Deckblatt/en:Abfall[@lib:Index=$index])">
				<xsl:for-each select="descendant::en:Abfall[parent::en:Deckblatt][@lib:Index=$index][last()]">
					<table id="Tabelle_unten" width="100%">
						<tr>
							<td id="Text" valign="top" width="20%">
								<xsl:value-of select="en:Abfallschluessel"/>
							</td>
							<td width="1%"/>
							<td id="Text" valign="top" width="57%">
								<xsl:value-of select="en:Beschaffenheit"/>
							</td>
							<td width="1%"/>
							<td id="Text" valign="top" width="23%">
								<xsl:value-of select="en:Menge"/>
  		                                         &#173;
		                                     <xsl:value-of select="en:Menge/@lib:Einheit"/>
							</td>
							<td width="1%"/>
						</tr>
						<tr height="15">
							<th/>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getAbfallList">
		<xsl:param name="TagName"/>
		<xsl:if test="boolean(en:Deckblatt/en:Abfall) or boolean(descendant::en:Deckblatt/en:Abfall)">
			<xsl:variable name="sortedAbfall">
				<xsl:for-each select="descendant::en:Abfall[parent::en:Deckblatt]">
					<xsl:sort select="@lib:Index" data-type="number" order="ascending"/>
					<xsl:copy-of select="."/>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="source" select="."/>
			<xsl:for-each select="xalan:nodeset($sortedAbfall)/*">
				<!--xsl:message>Index:<xsl:value-of select="@lib:Index"/>, preceding Index:<xsl:value-of select="preceding-sibling::bgs:UNSNummer[1]/@lib:Index"/></xsl:message-->
					<xsl:if test="position()=1 or not(@lib:Index=preceding-sibling::en:Abfall[1]/@lib:Index)">
					<xsl:variable name="index" select="@lib:Index"/>
					<xsl:for-each select="$source">
						<xsl:call-template name="AbfallBez">
							<xsl:with-param name="index" select="$index"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>


	<xsl:template name="getAbfallList_Old">
		<xsl:param name="TagName"/>
		<!--xsl:message>
			Max Index <xsl:value-of select="math:max(//en:BImSchG/@lib:Index)">
			</xsl:value-of>
		</xsl:message-->
		<xsl:choose>
			<xsl:when test="boolean(dyn:evaluate($TagName))">
				<xsl:for-each select="dyn:evaluate($TagName)">
					<table id="Tabelle_unten" width="100%">
						<tr>
							<td id="Aktuell" valign="top" width="20%">
								<xsl:value-of select="en:Abfallschluessel"/>
							</td>
							<td width="1%"/>
							<td id="Aktuell" valign="top" width="57%">
								<xsl:value-of select="en:Beschaffenheit"/>
							</td>
							<td width="1%"/>
							<td id="Aktuell" valign="top" width="57%">
								<xsl:value-of select="en:Menge"/>
  		                                         &#173;
		                                     <xsl:value-of select="en:Menge/@lib:Einheit"/>
							</td>
							<td width="1%"/>
						</tr>
						<tr height="15">
							<th/>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(dyn:evaluate(concat('descendant::', $TagName)))">
				<xsl:for-each select="dyn:evaluate(concat('descendant::', $TagName))">
					<table id="Tabelle_unten" width="100%">
						<tr>
							<td id="Text" valign="top" width="20%">
								<xsl:value-of select="en:Abfallschluessel"/>
							</td>
							<td width="1%"/>
							<td id="Text" valign="top" width="57%">
								<xsl:value-of select="en:Beschaffenheit"/>
							</td>
							<td width="1%"/>
							<td id="Text" valign="top" width="57%">
								<xsl:value-of select="en:Menge"/>
  		                                         &#173;
		                                     <xsl:value-of select="en:Menge/@lib:Einheit"/>
							</td>
							<td width="1%"/>
						</tr>
						<tr height="15">
							<th/>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
