<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:erzst="uri:ErzeugerStammdaten/ErzStamm"
	xmlns:ezlib="uri:ErzeugerStammdaten/ErzStammTypBibliothek"
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="CURRENT_DATE" select="'2023-04-13'"/>	
	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<xsl:template match="/">
		<xsl:for-each select="//erzst:Erzeuger">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>Erzeuger</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="ZeileMain"/>
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="ZeileMain">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Betrieb"/>
					<xsl:call-template name="FkbZuBetrieb"/>
					<xsl:call-template name="EndeBetrieb"/>
					<xsl:call-template name="Abfall"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<!--table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<xsl:call-template name="FkbZuBetrieb"/>
				</td>
			</tr>
		</table-->
	</xsl:template>
	
	<xsl:template name="Betrieb">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Erzeugerbetriebsstätte</font>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<!--colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup-->
			<tr>
				<td id="Titel_klein">Erzeugernummer</td>
				<!--td id="Titel_klein">Registriernummer im Heimatland</td-->
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:BehoerdlicheNummer/ezlib:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:BehoerdlicheNummer/ezlib:Pruefziffer"/>
				</td>
				<!--td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:RegistriernummerHeimatland"/>
				</td-->
			</tr>
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="'erzst:ErzeugerBetrieb/erzst:'"/>
			<xsl:with-param name="prefixLib" select="'ezlib:'"/>
			<xsl:with-param name="withPostfach" select="false()"/>
		</xsl:call-template>
		
		<!--table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">East-Wert</td>
				<td id="Titel_klein">North-Wert</td>
				<td id="Titel_klein">Rechtswert</td>
				<td id="Titel_klein">Hochwert</td>
				<td id="Titel_klein">TK 25</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:East"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:North"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:Rechts"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:Hoch"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:Koordinaten/erzst:TK25"/>
				</td>
			</tr>
		</table-->

		<xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="'erzst:ErzeugerBetrieb/erzst:Kontaktdaten/ezlib:'"/>
		</xsl:call-template>

		<!--table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Homepage</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="erzst:ErzeugerBetrieb/erzst:InternetAdresse"/>
					&#173;
				</td>
			</tr>
		</table-->
	</xsl:template>

	<xsl:template name="Abfall">
		<xsl:variable name="CNT_ABF" select="count(erzst:ErzeugerBetrieb/erzst:Abfaelle)"/>
		<xsl:if test="$CNT_ABF>0">
			<table width="100%" id="tabelle_nicht_unten">
				<tr>
					<td>
						<font id="Titel">Aktuell anfallende Abfälle</font>
					</td>
				</tr>
			</table>
			<table width="100%" id="tabelle_nicht_oben_unten">
				<colgroup>
					<col width="10%"/>
					<col width="70%"/>
					<col width="10%"/>
					<col width="10%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Schlüssel</td>
					<td id="Titel_klein">Betriebsinterne Bezeichnung</td>
					<td id="Titel_klein">angefallen von</td>
					<td id="Titel_klein">bis</td>
				</tr>
			</table>
			
			<!-- ############################################## -->
			<xsl:variable name="TODAY" select="number(concat(substring($CURRENT_DATE, 1, 4), substring($CURRENT_DATE, 6, 2), substring($CURRENT_DATE, 9, 2)))"/>
			<!-- ############################################## -->
			
			<xsl:for-each select="erzst:ErzeugerBetrieb/erzst:Abfaelle">
				<xsl:sort select="erzst:Abfallschluessel" data-type="number" order="ascending"/>
				
				<!-- Gibt es zum Abfall ein Element erzst:AbfallanfallVon? -->
				<xsl:variable name="CNT_ABF_ANFVON" select="count(erzst:AbfallanfallVon)"/>
				<!-- Hat der Abfall ein Startdatum des Anfalls, das nicht in der Zukunft liegt? -->
				<xsl:variable name="ABF_ANFVON_OK" select="($TODAY - (number(concat(substring(erzst:AbfallanfallVon, 1,4), substring(erzst:AbfallanfallVon, 6,2), substring(erzst:AbfallanfallVon, 9,2)))))"/>
				
				<xsl:if test="($CNT_ABF_ANFVON = 0) or ($ABF_ANFVON_OK &gt; 0)">
				
					<!-- Gibt es zum Abfall ein Element erzst:AbfallanfallBis? -->
					<xsl:variable name="CNT_ABF_ANFBIS" select="count(erzst:AbfallanfallBis)"/>
					<!-- Hat der Abfall ein Enddatum des Anfalls, das nicht in der Vergangenheit liegt? -->
					<xsl:variable name="ABF_ANFBIS_OK" select="((number(concat(substring(erzst:AbfallanfallBis, 1,4), substring(erzst:AbfallanfallBis, 6,2), substring(erzst:AbfallanfallBis, 9,2)))) - $TODAY)"/>
					
					<xsl:if test="($CNT_ABF_ANFBIS = 0) or ($ABF_ANFBIS_OK &gt; 0)">
					
						<table width="100%" id="tabelle_nicht_oben_unten">
							<colgroup>
								<col width="10%"/>
								<col width="70%"/>
								<col width="10%"/>
								<col width="10%"/>
							</colgroup>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="erzst:Abfallschluessel"/>
									&#173;
								</td>
								<td id="Aktuell">
									<xsl:value-of select="erzst:BezeichnungIntern"/>
								</td>
								<td id="Aktuell">
									<xsl:call-template name="getDateValue">
										<xsl:with-param name="TagName" select="'erzst:AbfallanfallVon'"/>
									</xsl:call-template>
									&#173;
								</td>
								<td id="Aktuell">
									<xsl:call-template name="getDateValue">
										<xsl:with-param name="TagName" select="'erzst:AbfallanfallBis'"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
						<!--table width="100%" id="tabelle_nicht_oben_unten">
							<colgroup>
								<col width="20%"/>
								<col width="30%"/>
								<col width="50%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Sekundärabfall</td>
								<td id="Titel_klein">Abfall ist besonders zu überwachen</td>
								<td id="Titel_klein">Menge pro Jahr</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'erzst:Sekundaerabfall'"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
								<td id="Aktuell">
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'erzst:BesondereUeberwachung'"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
								<td>
									<font id="Aktuell">
										<xsl:call-template name="formatDouble">
											<xsl:with-param name="wert" select="erzst:Menge"></xsl:with-param>
										</xsl:call-template>
										<!-xsl:value-of select="erzst:Menge"/->
									</font>
									&#173;
									<font id="Titel_klein">t/a</font>
								</td>
							</tr>
						</table-->
						<!--table width="100%" id="tabelle_nicht_oben_unten">
							<tr>
								<td id="Titel_klein">Bemerkungen</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="erzst:Bemerkung"/>
									&#173;
								</td>
							</tr>
						</table-->
						<!--xsl:if test="count(erzst:Detailangaben)>0">
							<table id="Tabelle_nicht_unten" width="100%">
								<tr>
									<td>
										<font id="Titel">Detailangaben zu Abfall:</font>
										&#173;
										<font id="Aktuell">
											<xsl:value-of select="erzst:Abfallschluessel"/>
										</font>
									</td>
								</tr>
							</table>
							<xsl:for-each select="erzst:Detailangaben">
								<xsl:call-template name="Detailangabe">
									<xsl:with-param name="prefix" select="'erzst:'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:if-->
						<!--xsl:if test="count(erzst:AnfallstelleZuAbfall)>0">
							<table id="Tabelle_nicht_unten" width="100%">
								<tr>
									<td>
										<font id="Titel">Anfallstellen des Abfalls:</font>
										&#173;
										<font id="Aktuell">
											<xsl:value-of select="erzst:Abfallschluessel"/>
										</font>
									</td>
								</tr>
								<tr>
									<td>
										<font id="Titel_klein">Anfallstelle(n):</font>
										&#173;
										<font  id="Aktuell">
											<xsl:for-each select="erzst:AnfallstelleZuAbfall/erzst:LKEY">
												<xsl:variable name="LKEY">
													<xsl:value-of select="."/>
												</xsl:variable>
												<xsl:if test="position()>1">, </xsl:if>
												<xsl:variable name="ANFALL_KEY">
													<xsl:value-of select="normalize-space(concat(//erzst:Anfallstellen[erzst:LKEY=$LKEY]/erzst:LfdNr, ' - ',//erzst:Anfallstellen[erzst:LKEY=$LKEY]/erzst:Bezeichnung1,' ', //erzst:Anfallstellen[erzst:LKEY=$LKEY]/erzst:Bezeichnung2))"/>
												</xsl:variable>
												<xsl:value-of select="$ANFALL_KEY"/>
											</xsl:for-each>
										</font>
									</td>
								</tr>
							</table>
						</xsl:if-->
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			<table id="Tabelle_oben" width="100%">
				<tr>
					<td>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="EndeBetrieb">
		<!-- Tabelle mit unterer Linie versehen -->
		<table id="Tabelle_oben" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="FkbZuBetrieb">
		<xsl:for-each select="erzst:FKB">
			<xsl:call-template name="Fkb_short">
				<xsl:with-param name="prefix" select="'erzst:'"/>
				<xsl:with-param name="prefixLib" select="'ezlib:'"/>
			</xsl:call-template>
			<!--xsl:if test="count(erzst:Branchen)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Branchen</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="erzst:Branchen">
					<xsl:call-template name="BrancheBtr">
						<xsl:with-param name="prefix" select="'erzst:'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if-->
			<!--xsl:if test="count(erzst:Ansprechpartner)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Personen zu Firma, Körperschaft, Betreiber</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="erzst:Ansprechpartner">
					<xsl:call-template name="PersonBtr">
						<xsl:with-param name="prefix" select="'erzst:'"/>
						<xsl:with-param name="prefixLib" select="'ezlib:'"/>
						<xsl:with-param name="betriebsinhaber" select="true()"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if-->
			<!--xsl:if test="count(erzst:WeitereAdresseFirma)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Weitere Adressen zu Firma, Körperschaft, Betreiber</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="erzst:WeitereAdresseFirma">
					<xsl:call-template name="WeitereAdresse">
						<xsl:with-param name="prefix" select="'erzst:'"/>
						<xsl:with-param name="prefixLib" select="'ezlib:'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if-->
			<table id="Tabelle_oben" width="100%">
				<tr>
					<td>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
