<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:html="http://www.w3c.org/TR/xhtml1/" 
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" 
xmlns:msg="uri:BMU_Waste_Interface/Message" 
xmlns:ntz="uri:BMU_Waste_Interface/Ntz" 
xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
xmlns:b64="xalan://de.itu.util.Base64" 
xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
xmlns:x509="xalan://de.itu.util.X509CertHelper" 
xmlns:util="xalan://de.condat.mbs.tools.TransformUtils"
xmlns:itu="xalan://de.itu.util.ISO_3166" 
xmlns:tfs="http://xsd.infotech.de/schema/tfs" 
xmlns:wmsg="Waste-WG-2018-Message" 
extension-element-prefixes="b64 crc32 x509 tfs util" 
exclude-result-prefixes="xsl lib msg ds b64 crc32 x509 tfs ntz wmsg util">
	<xsl:import href="ZKS-Library_11.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="register" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:variable name="gTrenn1" select="' '"> </xsl:variable>
	<xsl:variable name="MAX_ZEICHEN_1024" select="200"/>
	<xsl:variable name="MAX_ZEICHEN_256" select="50"/>
	<xsl:variable name="EXP_COUNTRY_ID">
		<xsl:value-of select="//wmsg:Submission/wmsg:Notifier/wmsg:Address/wmsg:CountryID"/>
	</xsl:variable>
	<xsl:variable name="IMP_COUNTRY_ID">
		<xsl:value-of select="//wmsg:Submission/wmsg:Consignee/wmsg:Address/wmsg:CountryID"/>
	</xsl:variable>
	<xsl:variable name="BEH_COUNTRY_ID" select="'276'"/>
	<xsl:variable name="DVERF">
		<xsl:choose>
			<xsl:when test="count(//wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility)>0">
				<xsl:for-each select="//wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
					<xsl:if test="starts-with(.,'D')">
						<xsl:value-of select="'X'"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="count(//wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility)>0">
				<xsl:for-each select="//wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
					<xsl:if test="position()=1">
						<xsl:if test="starts-with(.,'D')">
							<xsl:value-of select="'X'"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="RVERF">
		<xsl:choose>
			<xsl:when test="count(//wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility)>0">
				<xsl:for-each select="//wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
					<xsl:if test="starts-with(.,'R')">
						<xsl:value-of select="'X'"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="count(//wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility)>0">
				<xsl:for-each select="//wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
					<xsl:if test="position()=1">
						<xsl:if test="starts-with(.,'R')">
							<xsl:value-of select="'X'"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="DX">
		<xsl:if test="string-length($DVERF)>0">
			<xsl:value-of select="'X'"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name="RX">
		<xsl:if test="string-length($RVERF)>0">
			<xsl:value-of select="'X'"/>
		</xsl:if>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:for-each select="//wmsg:NotificationDocument">
			<xsl:if test="position()=$positionsnummer">
				<xsl:call-template name="Notification"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Notification">
		<html>
			<head>
				<title>Notifizierungsformular</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile1_14"/>
							<xsl:call-template name="Zeile15"/>
							<xsl:call-template name="Zeile16"/>
							<xsl:call-template name="Zeile17_18"/>
							<xsl:call-template name="Zeile18a"/>
							<xsl:call-template name="Zeile19_20"/>
							<xsl:call-template name="Zeile21"/>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="Zeile1_14">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td id="Ueberschrift2">Notifizierungsformular für grenzüberschreitende Verbringungen von Abfällen</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%" valign="top"/>
				<col width="50%" valign="top"/>
			</colgroup>
			<tr>
				<td width="50%">
					<xsl:call-template name="Zeile1"/>
					<xsl:call-template name="Zeile2"/>
					<xsl:call-template name="Zeile8"/>
					<xsl:call-template name="Zeile9"/>
					<xsl:call-template name="Zeile10"/>
				</td>
				<td width="50%">
					<xsl:call-template name="Zeile3"/>
					<xsl:call-template name="Zeile4"/>
					<xsl:call-template name="Zeile5"/>
					<xsl:call-template name="Zeile6"/>
					<xsl:call-template name="Zeile7"/>
					<xsl:call-template name="Zeile11"/>
					<xsl:call-template name="Zeile12"/>
					<xsl:call-template name="Zeile13"/>
					<xsl:call-template name="Zeile14"/>
				</td>
			</tr>
		</table>
	
	</xsl:template>
	
	<xsl:template name="Zeile1">
		<table width="100%" id="Tabelle_unten_rechts">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(wmsg:Submission/wmsg:Notifier)>0">
							<xsl:for-each select="wmsg:Submission/wmsg:Notifier">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'1. Exporteur - Notifizierender'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'1. Exporteur - Notifizierender'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile2">
		<table width="100%" id="Tabelle_unten_rechts">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(wmsg:Submission/wmsg:Consignee)>0">
							<xsl:for-each select="wmsg:Submission/wmsg:Consignee">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'2. Importeur - Empfänger'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'2. Importeur - Empfänger'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile3">
		<table width="100%" id="Tabelle_ohne">
			<colgroup>
				<col width="40%"/>
				<col width="60%"/>
			</colgroup>
			<tr>
				<td id="Titel">3. Notifizierung Nr.:</td>
				<td id="Aktuell_gross">
					<xsl:value-of select="wmsg:NotificationID"/>
				</td>
			</tr>
			<tr>
				<td id="Titel">Notifizierung betreffend:</td>
				<td/>
			</tr>
		</table>
		<table width="100%" id="Tabelle_ohne">
			<colgroup>
				<col width="5%"/>
				<col width="35%"/>
				<col width="20%"/>
				<col width="30%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">A.</td>
				<td id="Titel_klein">Einmalige Verbringung:</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="wmsg:Submission/wmsg:ShipmentQuantity=1">
									<font id="Aktuell_nu_indikator">
										<xsl:value-of select="'X'"/>
									</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Mehrmalige Verbringungen:</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="wmsg:Submission/wmsg:ShipmentQuantity>1">
									<font id="Aktuell_nu_indikator">
										<xsl:value-of select="'X'"/>
									</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">B.</td>
				<td id="Titel_klein">Beseitigung:</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<font id="Aktuell_nu_indikator">
									<xsl:value-of select="$DX"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Verwertung:</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<font id="Aktuell_nu_indikator">
									<xsl:value-of select="$RX"/>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_unten">
			<colgroup>
				<col width="5%"/>
				<col width="65%"/>
				<col width="5%"/>
				<col width="10%"/>
				<col width="5%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">C.</td>
				<td id="Titel_klein">Verwertungsanlage für Vorabzustimmung</td>
				<td id="Titel_klein">Ja</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="wmsg:Submission/wmsg:PreConsentIndicator='true'">
									<font id="Aktuell_nu_indikator">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Nein</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="wmsg:Submission/wmsg:PreConsentIndicator='false'">
									<font id="Aktuell_nu_indikator">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile4">
		<table width="100%" id="Tabelle_unten">
			<colgroup>
				<col width="70%"/>
				<col width="30%"/>
			</colgroup>
			<tr>
				<td id="Titel">4. Vorgesehene Gesamtzahl der Verbringungen:</td>
				<td id="Aktuell_nu">
					<xsl:value-of select="wmsg:Submission/wmsg:ShipmentQuantity"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile5">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td id="Titel">5. Vorgesehene Gesamtmenge:</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:Submission">
			<table width="100%" id="Tabelle_unten">
				<colgroup>
					<col width="20%"/>
					<col width="80%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Tonnen (Mg):</td>
					<td id="Aktuell_nu">
						<xsl:call-template name="formatDouble">
							<xsl:with-param name="wert" select="wmsg:TotalWasteMeasurement/wmsg:MassMeasure"></xsl:with-param>
							<xsl:with-param name="unit" select="wmsg:TotalWasteMeasurement/wmsg:MassMeasure/@unitCode"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td id="Titel_klein">m³:</td>
					<td id="Aktuell_nu">
						<xsl:call-template name="formatDouble">
							<xsl:with-param name="wert" select="wmsg:TotalWasteMeasurement/wmsg:VolumeMeasure"></xsl:with-param>
							<xsl:with-param name="unit" select="wmsg:TotalWasteMeasurement/wmsg:VolumeMeasure/@unitCode"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile6">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td id="Titel">6. Vorgesehener Zeitraum für die Verbringungen:</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:Submission">
			<table width="100%" id="Tabelle_unten">
				<colgroup>
					<col width="20%"/>
					<col width="30%"/>
					<col width="20%"/>
					<col width="30%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Erster Beginn:</td>
					<td id="Aktuell_nu">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="wmsg:ShipmentPeriod/wmsg:FirstStartDate"/>
						</xsl:call-template>
					</td>
					<td id="Titel_klein">Letzter Beginn:</td>
					<td id="Aktuell_nu">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="wmsg:ShipmentPeriod/wmsg:LastStartDate"/>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile7">
		<table width="100%" id="Tabelle_ohne">
			<colgroup>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel">7. Verpackungsart(en):</td>
				<td id="Aktuell_nu">
					<xsl:for-each select="wmsg:Submission/wmsg:Packaging">
						<xsl:variable name="lTypeCode">
							<xsl:value-of select="wmsg:PackageTypeCode"/>
						</xsl:variable>
						<xsl:variable name="TypeCode">
							<xsl:choose>
								<xsl:when test="$lTypeCode = '1'">1. Trommel/Fass</xsl:when>
								<!-- DR = Drum -> 1 = Fässer -->
								<xsl:when test="$lTypeCode = '2'">2. Holzfass</xsl:when>
								<!-- W1 = Jerrican -> 3 = Kanister -->
								<xsl:when test="$lTypeCode = '3'">3. Kanister</xsl:when>
								<!-- 2C = Barrel, wooden -> 2 = Holzfässer -->
								<xsl:when test="$lTypeCode = '4'">4. Kiste/Kasten</xsl:when>
								<!-- BX = Box -> 4 = Kisten -->
								<xsl:when test="$lTypeCode = '5'">5. Sack/Beutel</xsl:when>
								<!-- BG = Bag -> 5 = Säcke -->
								<xsl:when test="$lTypeCode = '6'">6. Verbundverpackung</xsl:when>
								<!-- W2 = Composite Package -> 6 = Zusammengesetzte Verp.-->
								<xsl:when test="$lTypeCode = '7'">7. Druckbehälter</xsl:when>
								<!-- W3 = Pressure Receptacle -> 7 = Druckbehälter -->
								<xsl:when test="$lTypeCode = '8'">8. Schüttgut</xsl:when>
								<!-- W4 = Other -> 9 = Sonstige Verpackungen -->
								<!--xsl:when test="$lTypeCode = 'W5'">
									<xsl:value-of select="'9. Andere: '"/>
									<xsl:value-of select="Type"/>
								</xsl:when-->
								<!-- W5 = Bulk -> 8 = Unverpackt, Schüttgut -->
								<xsl:otherwise>9. Andere</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="position()>1">
							<xsl:value-of select="', '"/>
						</xsl:if>
						<xsl:value-of select="$TypeCode"/>
					</xsl:for-each>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_unten">
			<colgroup>
				<col width="70%"/>
				<col width="5%"/>
				<col width="10%"/>
				<col width="5%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">Besondere Handhabungsvorschriften:</td>
				<td id="Titel_klein">Ja</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="wmsg:Submission/wmsg:Packaging/wmsg:SpecialHandlingRequirementIndicator='true'">
									<font id="Aktuell_nu_indikator">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Nein</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="wmsg:Submission/wmsg:Packaging/wmsg:SpecialHandlingRequirementIndicator='false'">
									<font id="Aktuell_nu_indikator">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile8">
		<table width="100%" id="Tabelle_unten_rechts">
			<xsl:choose>
				<xsl:when test="count(wmsg:Submission/wmsg:Carrier)=1">
					<xsl:for-each select="wmsg:Submission/wmsg:Carrier">
						<xsl:if test="position()=1">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'8. Vorgesehene(s) Transporttunternehmen'"/>
										<xsl:with-param name="TRANS" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="40%"/>
											<col width="60%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Transportart:</td>
											<td id="Aktuell_nu">
												<xsl:value-of select="wmsg:MeansOfTransportCode"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'8. Vorgesehene(s) Transporttunternehmen'"/>
								<xsl:with-param name="TRANS" select="true()"/>
								<xsl:with-param name="MEHRERE" select="count(wmsg:Submission/wmsg:Carrier)>1"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="20%"/>
									<col width="80%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Transportart:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>

	<xsl:template name="Zeile9">
		<table width="100%" id="Tabelle_unten_rechts">
			<xsl:choose>
				<xsl:when test="count(wmsg:Submission/wmsg:WasteProducer)=1">
					<xsl:for-each select="wmsg:Submission/wmsg:WasteProducer">
						<xsl:if test="position()=1">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'9. Abfallerzeuger'"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="25%"/>
											<col width="75%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Ort der Abfallerzeugung:</td>
											<td id="Aktuell_nu">
												<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
													<xsl:if test="position()=1">
														<xsl:call-template name="SUBSTRING_VAL">
															<xsl:with-param name="VAL" select="."/>
															<xsl:with-param name="MAX_ZEICHEN" select="60"/>
														</xsl:call-template>
													</xsl:if>
												</xsl:for-each>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'9. Abfallerzeuger'"/>
								<xsl:with-param name="MEHRERE" select="count(wmsg:Submission/wmsg:WasteProducer)>1"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="30%"/>
									<col width="70%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Ort der Abfallerzeugung:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile10">
		<table width="100%" id="Tabelle_rechts">
			<xsl:choose>
				<xsl:when test="count(wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility)>0">
					<xsl:for-each select="wmsg:Submission/wmsg:InitialInterimRecoveryDisposalFacility">
						<tr>
							<td>
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'10. Beseitigungsanlage'"/>
									<xsl:with-param name="BES_VERW" select="true()"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="45%"/>
										<col width="55%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">Ort der tatsächlichen Beseitigung/Verwertung:</td>
										<td id="Aktuell_nu">
											<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
												<xsl:if test="position()=1">
													<xsl:call-template name="SUBSTRING_VAL">
														<xsl:with-param name="VAL" select="."/>
														<xsl:with-param name="MAX_ZEICHEN" select="45"/>
													</xsl:call-template>
												</xsl:if>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="count(wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility)>0">
					<xsl:for-each select="wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility">
						<xsl:if test="position()=1">
							<tr>
								<td>
									<xsl:call-template name="NAME_ADRESSE">
										<xsl:with-param name="ROLLE_VBF" select="'10. Beseitigungsanlage'"/>
										<xsl:with-param name="BES_VERW" select="true()"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="45%"/>
											<col width="55%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Ort der tatsächlichen Beseitigung/Verwertung:</td>
											<td id="Aktuell_nu">
												<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
													<xsl:if test="position()=1">
														<xsl:call-template name="SUBSTRING_VAL">
															<xsl:with-param name="VAL" select="."/>
															<xsl:with-param name="MAX_ZEICHEN" select="45"/>
														</xsl:call-template>
													</xsl:if>
												</xsl:for-each>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'10. Beseitigungsanlage'"/>
								<xsl:with-param name="BES_VERW" select="true()"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="45%"/>
									<col width="55%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Ort der tatsächlichen Beseitigung/Verwertung:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile11">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td id="Titel">11. Beseitigungs-/Verwertungsverfahren</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_unten">
			<colgroup>
				<col width="30%" valign="top"/>
				<col width="70%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">D-Code / R-Code:</td>
				<td id="Aktuell_nu">
					<xsl:for-each select="wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility/wmsg:RecoveryDisposalTypeCode">
						<xsl:if test="position()>1">
							<xsl:value-of select="', '"/>
						</xsl:if>
						<xsl:value-of select="."/>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">Angewandte Technologie:</td>
				<td id="Aktuell_nu">
					<xsl:for-each select="wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility/wmsg:TechnologyDescription">
						<xsl:if test="position()=1">
							<xsl:call-template name="SUBSTRING_VAL">
								<xsl:with-param name="VAL" select="."/>
								<xsl:with-param name="MAX_ZEICHEN" select="$MAX_ZEICHEN_1024"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">Grund für die Ausfuhr:</td>
				<td id="Aktuell_nu">
					<xsl:for-each select="wmsg:Submission/wmsg:NonInterimRecoveryDisposalFacility/wmsg:ReasonForExportDescription">
						<xsl:if test="position()=1">
							<xsl:call-template name="SUBSTRING_VAL">
								<xsl:with-param name="VAL" select="."/>
								<xsl:with-param name="MAX_ZEICHEN" select="$MAX_ZEICHEN_1024"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile12">
		<table width="100%" id="Tabelle_unten">
			<tr>
				<td id="Titel">12. Bezeichnung und Zusammensetzung des Abfalls:</td>
			</tr>
			<tr>
				<td id="Aktuell_nu">
					<xsl:for-each select="wmsg:Submission/wmsg:WasteDesignationDescription/wmsg:Description">
						<xsl:if test="position()=1">
							<xsl:call-template name="SUBSTRING_VAL">
								<xsl:with-param name="VAL" select="."/>
								<xsl:with-param name="MAX_ZEICHEN" select="$MAX_ZEICHEN_1024"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<xsl:call-template name="DUMMY_ZEICHEN"/>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile13">
		<table width="100%" id="Tabelle_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="50%"/>
							<col width="50%"/>
						</colgroup>
						<tr>
							<td id="Titel">13. Physikalische Eigenschaften:</td>
							<td id="Aktuell_nu">
								<xsl:for-each select="wmsg:Submission/wmsg:PhysicalCharacteristicTypeCode">
									<xsl:variable name="lPhys">
										<xsl:value-of select="."/>
									</xsl:variable>
									<xsl:variable name="PhysEig">
										<xsl:choose>
											<xsl:when test="$lPhys = 1">1. Staub- oder pulverförmig</xsl:when>
											<!-- SOLDUS = Solid - Dusty -> 1 = pulverförmig oder staubförmig -->
											<xsl:when test="$lPhys = 2">2. Fest</xsl:when>
											<!-- SOLCHU = Solid - in chunks -> 2 = fest -->
											<xsl:when test="$lPhys = 3">3. Pastös/breiig</xsl:when>
											<!-- SLUVISC =  Viscous or paste -> 3 = pastös oder breiig -->
											<xsl:when test="$lPhys = 4">4. Schlammig</xsl:when>
											<!-- SLU = Sludgy -> 4 = schlammig -->
											<xsl:when test="$lPhys = 5">5. Flüssig</xsl:when>
											<!-- LIQ = Liquid -> 5 = flüssig -->
											<xsl:when test="$lPhys = 6">6. Gasförmig</xsl:when>
											<!-- GAS = Gaseous -> 6 = gasförmig -->
											<xsl:otherwise>0. unbekannt</xsl:otherwise>
											<!-- ??? -> 0 = unbekannt -->
										</xsl:choose>
									</xsl:variable>
									<xsl:if test="position()>1">
										<xsl:value-of select="', '"/>
									</xsl:if>
									<xsl:value-of select="$PhysEig"/>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile14">
		<xsl:for-each select="wmsg:Submission">
			<table width="100%" id="Tabelle_ohne">
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td id="Titel">14. Abfallidentifizierung</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="3%" align="right"/>
								<col width="47%"/>
								<col width="50%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">i)</td>
								<td id="Titel_klein">Basel Anlage VIII (oder IX falls anwendbar):</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='BASEL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">ii)</td>
								<td id="Titel_klein">OECD-Code (falls abweichend von i):</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='OECD']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iii)</td>
								<td id="Titel_klein">EU-Abfallverzeichnis:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='EWL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iv)</td>
								<td id="Titel_klein">Nationaler Code im Ausfuhrland:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='NATEXP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">v)</td>
								<td id="Titel_klein">Nationaler Code im Einfuhrland:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='NATIMP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">vi)</td>
								<td id="Titel_klein">Sonstige:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='OTHER']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">vii)</td>
								<td id="Titel_klein">Y-Code:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='YCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">viii)</td>
								<td id="Titel_klein">H-Code:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='HCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iX) </td>
								<td id="Titel_klein">UN-Klasse:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNCLASS']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">X)</td>
								<td id="Titel_klein">UN-Kennnummer:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNNUM']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Xi)</td>
								<td id="Titel_klein">UN-Versandname:</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNSHIP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Xii)</td>
								<td id="Titel_klein">Zollnummer(n) (HS):</td>
								<td id="Aktuell_nu">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='CUST']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Zeile15">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_unten">
						<tr>
							<td>
								<font id="Titel">15. a) Betroffene Staaten</font>
								&#173;
								<font id="Titel_klein">b) Codenummer der zuständigen Behörde, sofern zutreffend, c) Ein- und Ausfuhrorte (Grenzübergang oder Hafen)</font>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_unten">
						<colgroup>
							<col width="25%"/>
							<col width="50%"/>
							<col width="25%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%" id="Tabelle_rechts">
									<tr>
										<td align="center">
											<font id="Titel_klein">Ausfuhrstaat/Versandstaat</font>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table width="100%" id="Tabelle_rechts">
									<tr>
										<td align="center">
											<font id="Titel_klein">Durchfuhrstaat(en) (Ein- und Ausgang)</font>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td align="center">
											<font id="Titel_klein">Einfuhrstaat/Empfängerstaat</font>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_unten">
						<colgroup>
							<col width="25%"/>
							<col width="50%"/>
							<col width="25%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="10%"/>
										<col width="90%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">a)</td>
										<td id="Aktuell_nu">
											<xsl:value-of select="itu:getLandKuerzel(wmsg:Submission/wmsg:ExportState/wmsg:CountryID)"/>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="33%"/>
										<col width="33%"/>
										<col width="33%"/>
									</colgroup>
									<tr>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=1">
																		<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=2">
																		<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_ohne">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=3">
																		<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td>
											<font id="Aktuell_nu">
												<xsl:value-of select="itu:getLandKuerzel(wmsg:Submission/wmsg:ImportState/wmsg:CountryID)"/>
											</font>
										</td>
									</tr>
								</table>
							</td>
						</tr>	
					</table>
					<table width="100%" id="Tabelle_unten">
						<colgroup>
							<col width="25%"/>
							<col width="50%"/>
							<col width="25%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="10%"/>
										<col width="90%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">b)</td>
										<td id="Aktuell_nu">
											<xsl:value-of select="wmsg:Submission/wmsg:ExportState/wmsg:CompetentAuthority/wmsg:CompetentAuthorityID"/>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="33%"/>
										<col width="33%"/>
										<col width="33%"/>
									</colgroup>
									<tr>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=1">
																		<xsl:value-of select="wmsg:CompetentAuthority/wmsg:CompetentAuthorityID"/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=2">
																		<xsl:value-of select="wmsg:CompetentAuthority/wmsg:CompetentAuthorityID"/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_ohne">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=3">
																		<xsl:value-of select="wmsg:CompetentAuthority/wmsg:CompetentAuthorityID"/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td id="Aktuell_nu">
											<xsl:value-of select="wmsg:Submission/wmsg:ImportState/wmsg:CompetentAuthority/wmsg:CompetentAuthorityID"/>
										</td>
									</tr>
								</table>
							</td>
						</tr>						
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="25%"/>
							<col width="50%"/>
							<col width="25%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="10%"/>
										<col width="90%"/>
									</colgroup>
									<tr>
										<td id="Titel_klein">c)</td>
										<td id="Aktuell_nu">
											<xsl:call-template name="SUBSTRING_VAL">
												<xsl:with-param name="VAL" select="wmsg:Submission/wmsg:ExportState/wmsg:ExitPointName"/>
												<xsl:with-param name="MAX_ZEICHEN" select="30"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="16%"/>
										<col width="16%"/>
										<col width="16%"/>
										<col width="16%"/>
										<col width="16%"/>
										<col width="16%"/>
									</colgroup>
									<tr>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=1">
																	<xsl:call-template name="SUBSTRING_VAL">
																		<xsl:with-param name="VAL" select="wmsg:EntryPointName"/>
																		<xsl:with-param name="MAX_ZEICHEN" select="15"/>
																	</xsl:call-template>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=1">
																	<xsl:call-template name="SUBSTRING_VAL">
																		<xsl:with-param name="VAL" select="wmsg:ExitPointName"/>
																		<xsl:with-param name="MAX_ZEICHEN" select="15"/>
																	</xsl:call-template>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=2">
																	<xsl:call-template name="SUBSTRING_VAL">
																		<xsl:with-param name="VAL" select="wmsg:EntryPointName"/>
																		<xsl:with-param name="MAX_ZEICHEN" select="15"/>
																	</xsl:call-template>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=2">
																	<xsl:call-template name="SUBSTRING_VAL">
																		<xsl:with-param name="VAL" select="wmsg:ExitPointName"/>
																		<xsl:with-param name="MAX_ZEICHEN" select="15"/>
																	</xsl:call-template>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_rechts">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=3">
																	<xsl:call-template name="SUBSTRING_VAL">
																		<xsl:with-param name="VAL" select="wmsg:EntryPointName"/>
																		<xsl:with-param name="MAX_ZEICHEN" select="15"/>
																	</xsl:call-template>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
										<td>
											<table width="100%" id="Tabelle_ohne">
												<tr>
													<td>
														<xsl:variable name="CT1">
															<xsl:for-each select="wmsg:Submission/wmsg:TransitState">
																<xsl:if test="position()=3">
																	<xsl:call-template name="SUBSTRING_VAL">
																		<xsl:with-param name="VAL" select="wmsg:ExitPointName"/>
																		<xsl:with-param name="MAX_ZEICHEN" select="15"/>
																	</xsl:call-template>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<font id="Aktuell_nu">
															<xsl:choose>
																<xsl:when test="string-length($CT1)">
																	<xsl:value-of select="$CT1"/>
																</xsl:when>
																<xsl:otherwise>&#173;</xsl:otherwise>
															</xsl:choose>
														</font>
													</td>
												</tr>						
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table width="100%" id="Tabelle_ohne">
									<tr>
										<td id="Aktuell_nu">
											<xsl:call-template name="SUBSTRING_VAL">
												<xsl:with-param name="VAL" select="wmsg:Submission/wmsg:ImportState/wmsg:EntryPointName"/>
												<xsl:with-param name="MAX_ZEICHEN" select="30"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>						
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile16">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">16. Eingangs- und/oder Ausfuhrzollstellen (Europäische Gemeinschaft)</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="10%"/>
							<col width="23%"/>
							<col width="10%"/>
							<col width="23%"/>
							<col width="10%"/>
							<col width="24%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Eingang:</td>
							<td id="Aktuell_nu">
								<xsl:call-template name="SUBSTRING_VAL">
									<xsl:with-param name="VAL" select="wmsg:Submission/wmsg:CustomsOfficeEntryName"/>
									<xsl:with-param name="MAX_ZEICHEN" select="25"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Ausgang:</td>
							<td id="Aktuell_nu">
								<xsl:call-template name="SUBSTRING_VAL">
									<xsl:with-param name="VAL" select="wmsg:Submission/wmsg:CustomsOfficeExitName"/>
									<xsl:with-param name="MAX_ZEICHEN" select="25"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Ausfuhr:</td>
							<td id="Aktuell_nu">
								<xsl:call-template name="SUBSTRING_VAL">
									<xsl:with-param name="VAL" select="wmsg:Submission/wmsg:CustomsOfficeExportName"/>
									<xsl:with-param name="MAX_ZEICHEN" select="25"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
		
	<xsl:template name="Zeile17_18">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="85%" valign="top"/>
				<col width="15%" valign="top"/>
			</colgroup>
				<tr>
					<td>
						<table width="100%" id="Tabelle_rechts">
							<tr>
								<td>
									<table width="100%" id="Tabelle_ohne">
										<tr>
											<td id="Titel">17. Erklärung des Exporteurs – Notifizierenden/Erzeugers</td>
										</tr>
										<tr>
											<td id="Titel_klein">Ich erkläre hiermit, dass die obigen Informationen nach meinem besten Wissen vollständig sind und der Wahrheit entsprechen.<br/>Ich erkläre ferner, dass rechtlich durchsetzbare vertragliche Verpflichtungen schriftlich eingegangen wurden und alle für die grenzüberschreitende<br/>Verbringung erforderlichen Versicherungen oder sonstigen Sicherheitsleistungen abgeschlossen bzw. hinterlegt wurden oder werden.</td>
										</tr>
									</table>
									<table width="100%" id="Tabelle_ohne">
										<colgroup>
											<col width="22%"/>
											<col width="25%"/>
											<col width="8%"/>
											<col width="10%"/>
											<col width="10%"/>
											<col width="25%"/>
										</colgroup>
										<tr>
											<td id="Titel_klein">Name des Exporteurs/Notifizierenden:</td>
											<td id="Aktuell_nu">
												<xsl:value-of select="wmsg:DeclarationExporter/wmsg:Name"/>
											</td>
											<td id="Titel_klein">Datum:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="wmsg:DeclarationExporter/wmsg:Date"/>
												</xsl:call-template>
											</td>
											<td id="Titel_klein">Unterschrift:</td>
											<td id="Aktuell_nu">
												<xsl:value-of select="wmsg:DeclarationExporter/wmsg:Signature"/>
											</td>
										</tr>
										<tr>
											<td id="Titel_klein">Name des Erzeugers:</td>
											<td id="Aktuell_nu">
												<xsl:value-of select="wmsg:DeclarationProducer/wmsg:Name"/>
											</td>
											<td id="Titel_klein">Datum:</td>
											<td id="Aktuell_nu">
												<xsl:call-template name="formatDate">
													<xsl:with-param name="date" select="wmsg:DeclarationProducer/wmsg:Date"/>
												</xsl:call-template>
											</td>
											<td id="Titel_klein">Unterschrift:</td>
											<td id="Aktuell_nu">
												<xsl:value-of select="wmsg:DeclarationProducer/wmsg:Signature"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td id="Titel">18. Anzahl der<br/>beigefügten Anhänge</td>
							</tr>
							<tr>
								<td id="Aktuell_nu">
									<xsl:value-of select="wmsg:Submission/wmsg:AnnexQuantity"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile18a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr align="center">
							<td>
								<font id="Titel">VON DEN ZUSTÄNDIGEN BEHÖRDEN AUSZUFÜLLEN</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile19_20">
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%" valign="top"/>
				<col width="50%" valign="top"/>
			</colgroup>
			<tr>
				<td>
					<xsl:call-template name="Zeile19"/>
				</td>
				<td>
					<xsl:call-template name="Zeile20"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile19">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td id="Titel">19. Bestätigung der zuständigen Behörde des Einfuhrstaates -<br/>Empfängerstaats/Durchfuhrstaats/Ausfuhrstaats - Versandstaats:</td>
			</tr>
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="35%"/>
							<col width="65%"/>
						</colgroup>
								<tr>
									<td id="Titel_klein">Land</td>
									<xsl:choose>
										<xsl:when test="wmsg:Acknowledgement">
											<td id="Aktuell_nu">s. vollständige Ansicht</td>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="DUMMY_ZEICHEN"/>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
								<tr>
									<td id="Titel_klein">Eingang der Notifizierung am:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Eingang bestätigt am:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Name der zuständigen Behörde:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
								<tr>
									<td id="Titel_klein">Stempel und/oder Unterschrift:</td>
									<xsl:call-template name="DUMMY_ZEICHEN"/>
								</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile20">
		<table width="100%" id="Tabelle_links">
			<tr>
				<td>
					<font id="Titel">20. Schriftliche Zustimmung der Verbringung durch die<br/>zuständige Behörde von</font>
					&#173;
					<font id="Titel_klein">(Land):</font>
					&#173;
					<font id="Aktuell_nu">
						<xsl:if test="wmsg:Decision">s. vollständige Ansicht</xsl:if>
					</font>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="30%"/>
							<col width="20%"/>
							<col width="10%"/>
							<col width="40%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Zustimmung erteilt am</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
							<td/>
							<td/>
						</tr>
						<tr>
							<td id="Titel_klein">Zustimmung gültig vom</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
							<td id="Titel_klein">bis</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="30%"/>
							<col width="20%"/>
							<col width="10%"/>
							<col width="30%"/>
							<col width="10%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Besondere Auflagen:</td>
							<td id="Titel_klein">Nein:</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Falls Ja, siehe Nr. 21:</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="35%"/>
							<col width="65%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Name der zuständigen Behörde:</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
						<tr>
							<td id="Titel_klein">Stempel und/oder Unterschrift:</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile21">
		<table width="100%" id="Tabelle">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td>
								<font id="Titel">
									21. Besondere Auflagen für die Zustimmung zu der Verbringung oder Gründe für die Erhebung von Einwänden:
								</font>
								&#173;
								<font id="Aktuell_nu">
									<xsl:if test="wmsg:Decision/wmsg:SpecificConditionDescription or wmsg:Decision/wmsg:ObjectionDescription">s. vollständige Ansicht</xsl:if>
								</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="NAME_ADRESSE">
		<xsl:param name="ROLLE_VBF"/>
		<xsl:param name="BES_VERW" select="false()"/>
		<xsl:param name="TRANS" select="false()"/>
		<xsl:param name="MEHRERE" select="false()"/>
		
		<xsl:variable name="MAXZEICHEN">
				<xsl:choose>
					<xsl:when test="not($TRANS)">
						<xsl:value-of select="70"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="70"/>
					</xsl:otherwise>
				</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$BES_VERW">
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="40%"/>
						<col width="10%"/>
						<col width="40%"/>
						<col width="10%"/>
					</colgroup>
					<tr>
						<td id="Titel">
							<xsl:value-of select="$ROLLE_VBF"/>
						</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<font id="Aktuell_nu_indikator">
											<xsl:value-of select="$DX"/>
										</font>
									</td>
								</tr>
							</table>
						</td>
						<td id="Titel">oder Verwertungsanlage</td>
						<td>
							<table id="Tabelle_indikator">
								<tr>
									<td>
										<font id="Aktuell_nu_indikator">
											<xsl:value-of select="$RX"/>
										</font>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="60%"/>
						<col width="15%"/>
						<col width="25%"/>
					</colgroup>
					<tr>
						<td id="Titel">
							<xsl:value-of select="$ROLLE_VBF"/>
						</td>
						<xsl:if test="$BES_VERW=false()">
							<td id="Titel_klein">Registriernummer:</td>
							<td id="Aktuell_nu">
								<xsl:for-each select="wmsg:PartyID[@identificationSchemeID='276']">
										<xsl:value-of select="."/>
								</xsl:for-each>
							</td>
						</xsl:if>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="string-length(wmsg:OrganizationName)>0 or string-length(wmsg:Person)>0">
					<xsl:if test="$TRANS or $BES_VERW">
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Registriernummer:</td>
								<xsl:for-each select="wmsg:PartyID[@identificationSchemeID='276']">
									<td id="Aktuell_nu">
										<xsl:value-of select="."/>
									</td>
								</xsl:for-each>
							</tr>
						</table>
					</xsl:if>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
							<tr>
								<td id="Titel_klein">Name:</td>
								<td id="Aktuell_nu">
									<xsl:variable name="NAME_1">
										<xsl:choose>
											<xsl:when test="string-length(wmsg:OrganizationName)>0">
												<xsl:value-of select="wmsg:OrganizationName"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="wmsg:Person/wmsg:GivenName"/>
												&#173;
												<xsl:value-of select="wmsg:Person/wmsg:FamilyName"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:call-template name="SUBSTRING_VAL">
										<xsl:with-param name="VAL" select="$NAME_1"/>
										<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Anschrift:</td>
								<td id="Aktuell_nu">
									<xsl:variable name="STRASSE">
										<xsl:choose>
											<xsl:when test="string-length(wmsg:Address/wmsg:StreetName) > 0">
												<xsl:value-of select="wmsg:Address/wmsg:StreetName"/>
											</xsl:when>
											<xsl:when test="string-length(wmsg:Address/wmsg:PostOfficeBox)">
												<xsl:value-of select="wmsg:Address/wmsg:PostOfficeBox"/>
											</xsl:when>
										</xsl:choose>
									</xsl:variable>
									<xsl:variable name="HAUSNR">
										<xsl:value-of select="wmsg:Address/wmsg:BuildingNumber"/>
									</xsl:variable>
									<xsl:variable name="STRASSE_GES">
										<xsl:value-of select="normalize-space(concat($STRASSE, ' ', $HAUSNR))"/>
									</xsl:variable>
									<xsl:call-template name="SUBSTRING_VAL">
										<xsl:with-param name="VAL" select="$STRASSE_GES"/>
										<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td/>
								<td id="Aktuell_nu">
									<xsl:variable name="ORT">
										<!-- ohne Country ID wmsg:Address/wmsg:CountryID,' ', -->
										<xsl:value-of select="normalize-space(concat(wmsg:Address/wmsg:Postcode,' ',wmsg:Address/wmsg:CityName))"/>
									</xsl:variable>
									<xsl:call-template name="SUBSTRING_VAL">
										<xsl:with-param name="VAL" select="$ORT"/>
										<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:if test="$TRANS=false()">
								<tr>
									<td id="Titel_klein">Kontaktperson:</td>
									<td id="Aktuell_nu">
										<xsl:variable name="GENDER">
											<xsl:choose>
												<xsl:when test="wmsg:Contact/wmsg:GenderCode=1">Herr</xsl:when>
												<xsl:when test="wmsg:Contact/wmsg:GenderCode=2">Frau</xsl:when>
											</xsl:choose>
										</xsl:variable>
										<xsl:variable name="KONTAKT">
											<xsl:value-of select="normalize-space(concat($GENDER,' ', wmsg:Contact/wmsg:GivenName, ' ',wmsg:Contact/wmsg:FamilyName))"/>
										</xsl:variable>
										<xsl:call-template name="SUBSTRING_VAL">
											<xsl:with-param name="VAL" select="$KONTAKT"/>
											<xsl:with-param name="MAX_ZEICHEN" select="$MAXZEICHEN"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:if>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="40%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Tel.:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:Contact/wmsg:TelephoneCompleteNumber"/>
							</td>
							<td id="Titel_klein">Fax:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:Contact/wmsg:FaxCompleteNumber"/>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">E-Mail:</td>
							<td id="Aktuell_nu">
								<xsl:value-of select="wmsg:Contact/wmsg:EmailURI"/>
							</td>
						</tr>
					</table>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$BES_VERW">
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="30%"/>
							<col width="20%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Registriernummer:</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</table>
				</xsl:if>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Name:</td>
						<xsl:choose>
							<xsl:when test="$MEHRERE">
								<xsl:choose>
									<xsl:when test="$TRANS">
										<td id="Aktuell_nu">mehrere Transportunternehmen, s. vollständige Ansicht</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="Aktuell_nu">mehrere Abfallerzeuger, s. vollständige Ansicht</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="DUMMY_ZEICHEN"/>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
					<tr>
						<td id="Titel_klein">Anschrift:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<xsl:if test="$TRANS=false()">
						<tr>
							<td id="Titel_klein">Kontaktperson:</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</xsl:if>
				</table>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="10%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Tel.:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
						<td id="Titel_klein">Fax:</td>
						<td/>
					</tr>
					<tr>
						<td id="Titel_klein">E-Mail:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
