<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" 
	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib msg b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer"/>
	<xsl:param name="register" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:param name="SUPPRESS_HEADER" select="false()"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="msg:Quittung">
		<html>
			<head>
				<title>Quittung</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf">
         			</xsl:call-template>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
						    <xsl:if test="not($SUPPRESS_HEADER)">
								<xsl:call-template name="Zeile0"/>
								<xsl:call-template name="Zeile1"/>
		            		</xsl:if>
							<xsl:for-each select="//msg:Meldung">
								<xsl:call-template name="Meldung"/>
							</xsl:for-each>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td>
					<font id="Nummer">
						BMU Quittung
					</font>
					
				</td>
				<td>
					<font id="Nummer2">
						(höchste Fehlerstufe der Meldungen in dieser BMU-Quittung: <xsl:call-template name="MAXERROR"/>)
					</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Titel">
						Bezug MSG UUID
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="//@msg:BezugMsgUUID"/>
					</font>
				</td>
			</tr>
			<tr height="3%">
				<td>
			</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table id="Tabelle_unten" width="100%" border="0">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td>
					<font id="Nummer">
						Einzelmeldungen
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Meldung">
		<table width="100%" border="0">
			<tr height="10">
				<td></td>
				<td></td>
				<td></td>
			</tr>
			<tr width="100%">
				<td width="10%" id="Titel"></td>
				<td width="20%" id="Titel">Klasse</td>
				<td width="70%" id="Titel">Stufe</td>
			</tr>
			<tr width="100%">
				<td width="10%">
					<font id="Nummer">
						<xsl:value-of select="position()"/>
					</font>
				</td>
				<td width="20%">
					<font id="Aktuell">
						<xsl:value-of select="msg:Klasse"/>
					</font>
				</td>
				<td width="70%">
					<font id="Aktuell">
						<xsl:value-of select="msg:Stufe"/>
					</font>
				</td>
			</tr>
			<tr height="10">
				<td>
			</td>
			</tr>
		</table>
			<!--tr width="100%">
				<td width="20%" id="Titel">Stufe</td>
			</tr>
			<tr width="100%">
				<td width="100%">
					<font id="Aktuell">
						<xsl:value-of select="msg:Stufe"/>
					</font>
				</td>
			</tr-->
		<table id="Tabelle_unten" width="100%" border="0">
			<tr width="100%">
				<td width="100%" id="Titel">Beschreibung</td>
			</tr>
			<tr width="100%">
				<td width="100%">
					<font id="Aktuell">
						<xsl:value-of select="msg:Beschreibung"/>
					</font>
				</td>
			</tr>
			<tr width="100%">
				<td width="100%" id="Titel">Abhilfe</td>
			</tr>
			<tr width="100%">
				<td width="100%">
					<font id="Aktuell">
						<xsl:value-of select="msg:Abhilfe"/>
					</font>
				</td>
			</tr>
			<tr height="10">
				<td>
			
			</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="MAXERROR">
		<xsl:choose>
			<xsl:when test="//msg:Meldung/msg:Stufe='FATAL'">
				<xsl:value-of select="'FATAL'"/>
			</xsl:when>
			<xsl:when test="//msg:Meldung/msg:Stufe='FEHLER'">
				<xsl:value-of select="'FEHLER'"/>
			</xsl:when>
			<xsl:when test="//msg:Meldung/msg:Stufe='WARNUNG'">
				<xsl:value-of select="'WARNUNG'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'INFO'"/>
			</xsl:otherwise>
		</xsl:choose> 
	</xsl:template>

</xsl:stylesheet>
