<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:reg="uri:BMU_Waste_Interface/Reg" 
	xmlns:bgs="uri:BMU_Waste_Interface/BGS" 
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib ds reg b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:import href="bgs_exzerpt_ra_all.xsl"/>
	<xsl:import href="bgs_ra_all.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
    <xsl:param name="positionsnummerCharge" select="1"/>
    <xsl:param name="positionsnummerUNS" select="0"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="reg:RegisterAuszug">
	   <xsl:for-each select="descendant::reg:Charge[$positionsnummerCharge]">
			<xsl:choose>
				<xsl:when test="reg:BGSmitUNS">
					<xsl:for-each select="reg:BGSmitUNS/reg:BGS">
						<xsl:choose>
							<xsl:when test="contains(local-name(*), 'Exzerpt')">
								<xsl:call-template name="BGSExzerpt"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="BGSOrgDokAll"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="contains(local-name(*/*), 'Exzerpt')">
							<xsl:call-template name="BGSExzerpt"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="BGSOrgDokAll"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
	   </xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
