<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:enx="urn:de:bmu:eanv:ENFXS:ENMore:1:01" 
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="Deckblatt"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Deckblatt">
		<xsl:variable name="ISEN">
			<xsl:call-template name="getBooleanValue">
				<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorEN'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="ISBB">
			<xsl:call-template name="getBooleanValue">
				<xsl:with-param name="TagName" select="'en:Deckblatt/en:IndicatorMitBB'"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="string-length(//enx:NWxtra)>0">
				<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
					<xsl:if test="position()=$positionsnummer">
						<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
							<tr>
								<td/>
							</tr>
							<tr>
								<td>
									<table id="tabelle_nicht_unten" width="100%">
										<tr>
											<td>
												<xsl:choose>
													<xsl:when test="local-name() = 'ENSNVorlageLayerRE'">
														<font id="Nummer">
															Spezielles freies Layer für Register
														</font>
													</xsl:when>
													<xsl:otherwise>
														<font id="Nummer">
															<xsl:choose>
																<xsl:when test="$ISEN='X'">
																	<xsl:choose>
																		<xsl:when test="$ISBB='X'">
																			Entsorgungsnachweis im Grundverfahren
																		</xsl:when>
																		<xsl:otherwise>
																			Entsorgungsnachweis im privilegierten Verfahren
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:when>
																<xsl:otherwise>
																	<xsl:choose>
																		<xsl:when test="$ISBB='X'">
																			Sammelentsorgungsnachweis im Grundverfahren
																		</xsl:when>
																		<xsl:otherwise>
																			Sammelentsorgungsnachweis im privilegierten Verfahren
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:otherwise>
															</xsl:choose>
														</font>
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</tr>
										<tr>
											<td>
												<table width="100%">
													<colgroup>
														<col width="25%" valign="top"/>
														<col width="75%" valign="top"/>
													</colgroup>
													<tr>
														<td>
															<xsl:call-template name="ESNKopfNummerUebersicht"/>
														</td>
														<td>
															<table width="100%">
																<colgroup>
																	<col width="25%"/>
																	<col width="75%"/>
																</colgroup>
																<tr>
																	<td>
																		<font id="titel">Laufzeit: </font>
																	</td>
																	<td>
																		<xsl:if test="string-length(//enx:NachweisGueltigVon)>0 or string-length(//enx:NachweisGueltigBis)>0">
																			<font id="Aktuell_notu">
																				<xsl:call-template name="formatDate">
																					<xsl:with-param name="date">
																						<xsl:value-of select="//enx:NachweisGueltigVon"/>
																					</xsl:with-param>
																				</xsl:call-template>
																				&#173;-&#173;
																				<xsl:call-template name="formatDate">
																					<xsl:with-param name="date">
																						<xsl:value-of select="//enx:NachweisGueltigBis"/>
																					</xsl:with-param>
																				</xsl:call-template>
																			</font>
																		</xsl:if>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Nachweis nutzbar: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:choose>
																				<xsl:when test="//enx:NachweisNutzbar='true'">Ja</xsl:when>
																				<xsl:when test="//enx:NachweisNutzbar='false'">Nein</xsl:when>
																				<xsl:otherwise>nicht angegeben</xsl:otherwise>
																			</xsl:choose>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Gestrichen: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:choose>
																				<xsl:when test="//enx:NachweisGestrichen='true'">Ja</xsl:when>
																				<xsl:when test="//enx:NachweisGestrichen='false'">Nein</xsl:when>
																				<xsl:otherwise>nicht angegeben</xsl:otherwise>
																			</xsl:choose>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Streichgrund: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="//enx:Streichgrund"/>
																		</font>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
									<table id="tabelle_nicht_unten" width="100%">
										<colgroup>
											<col width="25%" valign="top"/>
											<col width="75%" valign="top"/>
										</colgroup>
										<tr>
											<td>
												<font id="Nummer2">Weiteres Entsorgerbehörde</font>
											</td>
											<td>
												<table width="100%">
													<colgroup>
														<col width="25%" valign="top"/>
														<col width="75%" valign="top"/>
													</colgroup>
													<tr>
														<td>
															<font id="titel">In Bearbeitung: </font>
														</td>
														<td>
															<font id="Aktuell_notu">
																<xsl:choose>
																	<xsl:when test="//enx:ESinBearbeitung='true'">Ja</xsl:when>
																	<xsl:when test="//enx:ESinBearbeitung='false'">Nein</xsl:when>
																	<xsl:otherwise>nicht angegeben</xsl:otherwise>
																</xsl:choose>
															</font>
														</td>
													</tr>
													<tr>
														<td>
															<font id="titel">Aktenzeichen: </font>
														</td>
														<td>
															<font id="Aktuell_notu">
																<xsl:value-of select="//enx:ESAktenzeichen"/>
															</font>
														</td>
													</tr>
													<tr>
														<td>
															<font id="titel">Bemerkungen: </font>
														</td>
														<td>
															<font id="Aktuell_notu">
																<xsl:value-of select="//enx:ESBemerkung"/>
															</font>
														</td>
													</tr>
													<tr>
														<td>
															<font id="titel">Notizen: </font>
														</td>
														<td>
															<font id="Aktuell_notu">
																<xsl:value-of select="//enx:ESNotiz"/>
															</font>
														</td>
													</tr>
													<tr>
														<td>
															<font id="titel">Maximale Transportdauer: </font>
														</td>
														<td>
															<xsl:if test="//enx:TransMaxTage">
																<font id="Aktuell_notu">
																	<xsl:value-of select="//enx:TransMaxTage"/>
																</font>
																&#173;
																<font id="Text_kleiner">Tage</font>
															</xsl:if>
														</td>
													</tr>
													<tr>
														<td>
															<font id="titel">Maximale Menge pro Transport: </font>
														</td>
														<td>
															<xsl:if test="//enx:TransMaxTonnen">
																<font id="Aktuell_notu">
																	<xsl:call-template name="formatDouble">
																		<xsl:with-param name="wert">
																			<xsl:value-of select="//enx:TransMaxTonnen"/>
																		</xsl:with-param>
																	</xsl:call-template>
																</font>
																&#173;
																<font id="Text_kleiner">t</font>
															</xsl:if>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
									<xsl:choose>
										<xsl:when test="$ISEN='X'">
											<xsl:if test="//enx:EZBehoerde">
												<table id="tabelle_nicht_unten" width="100%">
													<colgroup>
														<col width="25%" valign="top"/>
														<col width="75%" valign="top"/>
													</colgroup>
													<tr>
														<td>
															<font id="Nummer2">Erzeugerbehörde</font>
														</td>
														<td>
															<table width="100%">
																<colgroup>
																	<col width="25%" valign="top"/>
																	<col width="75%" valign="top"/>
																</colgroup>
																<tr>
																	<td>
																		<font id="titel">In Bearbeitung: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:choose>
																				<xsl:when test="//enx:EZinBearbeitung='true'">Ja</xsl:when>
																				<xsl:when test="//enx:EZinBearbeitung='false'">Nein</xsl:when>
																				<xsl:otherwise>nicht angegeben</xsl:otherwise>
																			</xsl:choose>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Aktenzeichen: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="//enx:EZAktenzeichen"/>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Bemerkungen: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="//enx:EZBemerkung"/>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Notizen: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="//enx:EZNotiz"/>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Nutzung untersagt: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:choose>
																				<xsl:when test="//enx:EZNutzungUntersagt='true'">Ja</xsl:when>
																				<xsl:when test="//enx:EZNutzungUntersagt='false'">Nein</xsl:when>
																				<xsl:otherwise>nicht angegeben</xsl:otherwise>
																			</xsl:choose>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Nutzungsuntersagung (Zeitraum): </font>
																	</td>
																	<td>
																		<xsl:if test="string-length(//enx:EZUntersagtVon)>0 or string-length(//enx:EZUntersagtBis)>0">
																			<font id="Aktuell_notu">
																				<xsl:call-template name="formatDate">
																					<xsl:with-param name="date">
																						<xsl:value-of select="//enx:EZUntersagtVon"/>
																					</xsl:with-param>
																				</xsl:call-template>
																				&#173;-&#173;
																				<xsl:call-template name="formatDate">
																					<xsl:with-param name="date">
																						<xsl:value-of select="//enx:EZUntersagtBis"/>
																					</xsl:with-param>
																				</xsl:call-template>
																			</font>
																		</xsl:if>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Zulässige Höchstmenge: </font>
																	</td>
																	<td>
																		<xsl:if test="//enx:EZHoechstmenge">
																			<font id="Aktuell_notu">
																				<xsl:call-template name="formatDouble">
																					<xsl:with-param name="wert">
																						<xsl:value-of select="//enx:EZHoechstmenge"/>
																					</xsl:with-param>
																				</xsl:call-template>
																			</font>
																			&#173;
																			<font id="Text_kleiner">t</font>
																		</xsl:if>
																	</td>
																</tr>
															</table>
															<xsl:if test="//enx:EZBehoerde">
																<xsl:for-each select="//enx:EZBehoerde">
																	<table width="100%">
																		<colgroup>
																			<col width="25%" valign="top"/>
																			<col width="75%" valign="top"/>
																		</colgroup>
																		<tr height="10">
																			<td/>
																			<td/>
																		</tr>
																		<tr>
																			<td>
																				<font id="titel">Behördennummer:</font>
																			</td>
																			<td>
																				<!-- Behördennummer-->
																				<font id="Aktuell_notu">
																					<xsl:value-of select="enx:BehoerdlicheNummer/enx:BehoerdlicheNr"/>
																					&#173;
																					<xsl:value-of select="enx:BehoerdlicheNummer/enx:Pruefziffer"/>
																				</font>
																			</td>
																		</tr>
																		<tr>
																			<td>
																				<font id="titel">Name und Adresse:</font>
																			</td>
																			<td>
																				<!-- Name 1-->
																				<font id="Aktuell_notu">
																					<xsl:value-of select="enx:NameUndAdresse/enx:Name/enx:Name1"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Name/enx:Name2"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Name/enx:Name3"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Name/enx:Name4"/>
																					<br/>
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Strasse_1"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Strasse_2"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Hausnummer"/>
																					<br/>
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Staat"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Postleitzahl"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Ort_1"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Ort_2"/>
																				</font>
																			</td>
																		</tr>
																	</table>
																	<xsl:for-each select="enx:Ansprechpartner">
																		<table width="100%">
																			<colgroup>
																				<col width="25%" valign="top"/>
																				<col width="75%" valign="top"/>
																			</colgroup>
																			<tr>
																				<td>
																					<font id="titel">Bearbeiter:</font>
																				</td>
																				<td>
																					<!-- Name-->
																					<font id="Aktuell_notu">
																						<xsl:value-of select="enx:Name"/>
																					</font>
																				</td>
																			</tr>
																			<tr>
																				<td>
																					<font id="titel">Telefon:</font>
																				</td>
																				<td>
																					<!-- Telefon-->
																					<font id="Aktuell_notu">
																						<xsl:value-of select="enx:Telefon"/>
																					</font>
																				</td>
																			</tr>
																			<tr>
																				<td>
																					<font id="titel">Fax:</font>
																				</td>
																				<td>
																					<!-- Fax-->
																					<font id="Aktuell_notu">
																						<xsl:value-of select="enx:Fax"/>
																					</font>
																				</td>
																			</tr>
																			<tr>
																				<td>
																					<font id="titel">E-Mail:</font>
																				</td>
																				<td>
																					<!-- eMail-->
																					<font id="Aktuell_notu">
																						<xsl:value-of select="enx:EMail"/>
																					</font>
																				</td>
																			</tr>
																		</table>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:if>
														</td>
													</tr>
												</table>
											</xsl:if>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="//enx:Sammelgebietsbehoerde">
												<table id="tabelle_nicht_unten" width="100%">
													<colgroup>
														<col width="25%" valign="top"/>
														<col width="75%" valign="top"/>
													</colgroup>
													<tr>
														<td>
															<font id="Nummer2">Sammelgebietsbehörde</font>
															&#173;
															<font id="Aktuell_notu">
																<xsl:value-of select="position()"/>
															</font>
														</td>
														<td>
															<table width="100%">
																<colgroup>
																	<col width="25%" valign="top"/>
																	<col width="75%" valign="top"/>
																</colgroup>
																<tr>
																	<td>
																		<font id="titel">Für Bundesland: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="enx:Bundesland"/>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Für Gebietskennung: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="enx:Gemeindeschluessel"/>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">In Bearbeitung: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:choose>
																				<xsl:when test="enx:SMinBearbeitung='true'">Ja</xsl:when>
																				<xsl:when test="enx:SMinBearbeitung='false'">Nein</xsl:when>
																				<xsl:otherwise>nicht angegeben</xsl:otherwise>
																			</xsl:choose>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Aktenzeichen: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="enx:SMAktenzeichen"/>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Bemerkungen: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="enx:SMBemerkung"/>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Notizen: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:value-of select="enx:SMNotiz"/>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Nutzung untersagt: </font>
																	</td>
																	<td>
																		<font id="Aktuell_notu">
																			<xsl:choose>
																				<xsl:when test="enx:SMNutzungUntersagt='true'">Ja</xsl:when>
																				<xsl:when test="enx:SMNutzungUntersagt='false'">Nein</xsl:when>
																				<xsl:otherwise>nicht angegeben</xsl:otherwise>
																			</xsl:choose>
																		</font>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Nutzungsuntersagung (Zeitraum): </font>
																	</td>
																	<td>
																		<xsl:if test="string-length(enx:SMUntersagtVon)>0 or string-length(enx:SMUntersagtBis)>0">
																			<font id="Aktuell_notu">
																				<xsl:call-template name="formatDate">
																					<xsl:with-param name="date">
																						<xsl:value-of select="enx:SMUntersagtVon"/>
																					</xsl:with-param>
																				</xsl:call-template>
																				&#173;-&#173;
																				<xsl:call-template name="formatDate">
																					<xsl:with-param name="date">
																						<xsl:value-of select="enx:SMUntersagtBis"/>
																					</xsl:with-param>
																				</xsl:call-template>
																			</font>
																		</xsl:if>
																	</td>
																</tr>
																<tr>
																	<td>
																		<font id="titel">Zulässige Höchstmenge: </font>
																	</td>
																	<td>
																		<xsl:if test="enx:SMHoechstmenge">
																			<font id="Aktuell_notu">
																				<xsl:call-template name="formatDouble">
																					<xsl:with-param name="wert">
																						<xsl:value-of select="enx:SMHoechstmenge"/>
																					</xsl:with-param>
																				</xsl:call-template>
																			</font>
																			&#173;
																			<font id="Text_kleiner">t</font>
																		</xsl:if>
																	</td>
																</tr>
															</table>
															<xsl:if test="enx:SMBehoerde">
																<xsl:for-each select="enx:SMBehoerde">
																	<table width="100%">
																		<colgroup>
																			<col width="25%" valign="top"/>
																			<col width="75%" valign="top"/>
																		</colgroup>
																		<tr height="10">
																			<td/>
																			<td/>
																		</tr>
																		<tr>
																			<td>
																				<font id="titel">Behördennummer:</font>
																			</td>
																			<td>
																				<!-- Behördennummer-->
																				<font id="Aktuell_notu">
																					<xsl:value-of select="enx:BehoerdlicheNummer/enx:BehoerdlicheNr"/>
																					&#173;
																					<xsl:value-of select="enx:BehoerdlicheNummer/enx:Pruefziffer"/>
																				</font>
																			</td>
																		</tr>
																		<tr>
																			<td>
																				<font id="titel">Name und Adresse:</font>
																			</td>
																			<td>
																				<!-- Name 1-->
																				<font id="Aktuell_notu">
																					<xsl:value-of select="enx:NameUndAdresse/enx:Name/enx:Name1"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Name/enx:Name2"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Name/enx:Name3"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Name/enx:Name4"/>
																					<br/>
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Strasse_1"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Strasse_2"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Hausnummer"/>
																					<br/>
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Staat"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Postleitzahl"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Ort_1"/>
																					&#173;
																					<xsl:value-of select="enx:NameUndAdresse/enx:Adresse/enx:Ort_2"/>
																				</font>
																			</td>
																		</tr>
																	</table>
																	<xsl:for-each select="enx:Ansprechpartner">
																		<table width="100%">
																			<colgroup>
																				<col width="25%" valign="top"/>
																				<col width="75%" valign="top"/>
																			</colgroup>
																			<tr>
																				<td>
																					<font id="titel">Bearbeiter:</font>
																				</td>
																				<td>
																					<!-- Name-->
																					<font id="Aktuell_notu">
																						<xsl:value-of select="enx:Name"/>
																					</font>
																				</td>
																			</tr>
																			<tr>
																				<td>
																					<font id="titel">Telefon:</font>
																				</td>
																				<td>
																					<!-- Telefon-->
																					<font id="Aktuell_notu">
																						<xsl:value-of select="enx:Telefon"/>
																					</font>
																				</td>
																			</tr>
																			<tr>
																				<td>
																					<font id="titel">Fax:</font>
																				</td>
																				<td>
																					<!-- Fax-->
																					<font id="Aktuell_notu">
																						<xsl:value-of select="enx:Fax"/>
																					</font>
																				</td>
																			</tr>
																			<tr>
																				<td>
																					<font id="titel">E-Mail:</font>
																				</td>
																				<td>
																					<!-- eMail-->
																					<font id="Aktuell_notu">
																						<xsl:value-of select="enx:EMail"/>
																					</font>
																				</td>
																			</tr>
																		</table>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:if>
														</td>
													</tr>
												</table>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
									<!-- Transportarten -->
									<xsl:choose>
										<xsl:when test="count(//enx:Transport)>0">
											<table width="100%" id="tabelle">
												<tr>
													<td>
														<table width="100%">
															<tr>
																<td id="Nummer2">Ausschließliche Transportarten</td>
															</tr>
															<tr height="5">
															</tr>
															<tr>
																<td>
																	<table width="100%">
																		<tr>
																			<td id="titel" width="20%">Beförderernummer</td>
																			<td id="titel" width="10%">Code</td>
																			<td id="titel" width="70%">Transportart</td>
																		</tr>
																	</table>
																	<xsl:for-each select="//enx:Transport">
																		<table id="Tabelle_oben" width="100%">
																			<tr>
																				<td id="Aktuell_notu" valign="top" width="20%">
																					<xsl:value-of select="enx:Befoerderernummer"/>
																				</td>
																				<td id="Aktuell_notu" valign="top" width="10%">
																					<xsl:value-of select="enx:Code"/>
																				</td>
																				<td id="Aktuell_notu" valign="top" width="70%">
																					<xsl:value-of select="enx:Art"/>
																				</td>
																			</tr>
																		</table>
																	</xsl:for-each>
																</td>
															</tr>
														</table>
													</td>
												</tr>
											</table>
										</xsl:when>
										<xsl:otherwise>
											<table width="100%" id="tabelle_nicht_oben">
												<tr>
													<th></th>
												</tr>
											</table>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%">
					<tr>
						<td>
							<font id="titel">Das Dokument enthält keine freie XML-Struktur mit weiteren Angaben.</font>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
