<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
	xmlns:svc_zba="urn:de:bmu:eanv:ServiceModul:0:4"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib ds zks b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="zks:ZKSAuftrag">
		<html>
			<head>
				<title>ZKS Auftrag</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf">
         			</xsl:call-template>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:for-each select="//zks:ZKSAuftrag">
								<xsl:call-template name="Zeile0"/>
								<xsl:call-template name="Zeile1"/>
							</xsl:for-each>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
						ZKS Auftrag 
					</font>
				</td>
			</tr>
			<tr height="3%">
				<td>
			</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table id="tabelle" width="100%" border="0">
			<tr>
				<td id="Titel"> Auftrag UUID </td>
				<td id="Titel"> Auftraggeber </td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="zks:AuftragUUID"/>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="concat(zks:Auftraggeber/lib:BehoerdlicheNr,' ',zks:Auftraggeber/lib:Pruefziffer)"/>
					</font>
				</td>
			</tr>
			<tr>
				<td id="Titel"> Auftragsart </td>
			</tr>

			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="zks:Auftragsart"/>
					</font>
				</td>
			</tr>
			<tr>
				<td id="Titel"> Prüfgegenstand </td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:choose>
							<xsl:when test="string-length(zks:Pruefgegenstand/svc_zba:CheckedDocument) > 0">
								<xsl:value-of select="'Binär kodierte BMU-Nachricht zur Prüfung.'"/>
							</xsl:when>
							<xsl:when test="string-length(zks:Pruefgegenstand/svc_zba:ArchivedDocument) > 0">
								<xsl:value-of select="'Binär kodierte BMU-Nachricht zur Archivierung.'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'Die Aufbewahrungsfrist eines im BSA eingestellten Dokumentes wird geändert.'"/>
							</xsl:otherwise>
						</xsl:choose>
					</font>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when test="string-length(zks:Pruefgegenstand/svc_zba:Frist) > 0">
					<tr>
						<td id="Titel"> BSA ID </td>
						<td id="Titel"> Neue Frist in Jahren </td>
					</tr>
					<tr>
						<td>
							<font id="Aktuell">
								<xsl:value-of select="zks:Pruefgegenstand/svc_zba:Frist/svc_zba:BsaId"/>
							</font>
						</td>
						<td>
							<font id="Aktuell">
								<xsl:value-of select="zks:Pruefgegenstand/svc_zba:Frist/svc_zba:Aufbewahrungsfrist"/>
							</font>
						</td>
					</tr>
				</xsl:when>
			</xsl:choose>
		</table>
	</xsl:template>
</xsl:stylesheet>
