/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule;

import de.consist.bmu.rule.MeldungTyp;
import de.consist.bmu.rule.Rule;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleSet;
import de.consist.bmu.rule.RuleSetDef;
import de.consist.bmu.rule.RuleSetResult;
import de.consist.bmu.rule.config.schema.fxs.FXSConfig;
import de.consist.bmu.rule.config.schema.fxs.FXSSchemaValidator;
import de.consist.bmu.rule.def.MeldungTypImpl;
import de.consist.bmu.rule.def.RuleDefImpl;
import de.consist.bmu.rule.def.RuleSetDefImpl;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.impl.RuleSetImpl;
import de.consist.bmu.rule.impl.RuleSetResultImpl;
import de.consist.bmu.rule.util.ByteUtils;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public final class RuleFactory {
    private static final Log LOGGER = LogFactory.getLog(RuleFactory.class);
    private static final String DEF_RESOURCE_PATH = "/de/consist/bmu/config/";
    private static final String DEFAULT_RULESET_DEF_NAME = "/de/consist/bmu/config/BMU_Rule_Config_Default.xml";
    private static final String MERGE_XSLT_NAME = "/de/consist/bmu/xslt/merge_ruleconfig.xslt";
    private static File _fxsSchemaBaseDir = new File(System.getProperty("user.dir"));
    private static RuleFactory _theInstance = null;
    private JAXBContext _jaxbContext = null;
    private Schema _ruleConfigSchema = null;
    private Schema _ruleConfigSchemaFXS = null;
    private RuleConfig _ruleConfig = null;
    private FXSConfig _fxsConfig = null;
    private FXSSchemaValidator _fxsValidator;

    private RuleFactory() {
    }

    private void init() throws BMUException {
        try {
            XmlSecFassade.getInstance();
            String jaxbContextFactory = System.getProperty("jakarta.xml.bind.JAXBContextFactory");
            LOGGER.debug((Object)("jakarta.xml.bind.JAXBContextFactory : " + jaxbContextFactory));
            jaxbContextFactory = System.getProperty("jakarta.xml.bind.JAXBContextFactory");
            LOGGER.debug((Object)("jakarta.xml.bind.JAXBContextFactory : " + jaxbContextFactory));
            this._jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RuleSetDefImpl.class, RuleDefImpl.class, MeldungTypImpl.class, RuleSetResultImpl.class, RuleResultImpl.class, FXSConfig.class});
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaSource = new StreamSource(RuleFactory.class.getResourceAsStream("/de/consist/bmu/rule/config/schema/BMU_Rule_Config.xsd"));
            this._ruleConfigSchema = sf.newSchema(schemaSource);
            schemaSource = new StreamSource(RuleFactory.class.getResourceAsStream("/de/consist/bmu/rule/config/schema/fxs/BMU_Rule_Config_FXS.xsd"));
            this._ruleConfigSchemaFXS = sf.newSchema(schemaSource);
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"error creating JAXBContext", (Throwable)e);
            throw new BMUException("error creating JAXBContext", e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)"error loading Schema", (Throwable)e);
            throw new BMUException("error loading Schema", e);
        }
    }

    public void loadFXSConfig(File fxsConfigFile, File schemaBaseDir) throws BMUException {
        LOGGER.info((Object)("Lade FXS-Konfigurationsdatei: " + fxsConfigFile.getAbsolutePath() + ", Basisverzeichnis f\u00fcr Schemas: " + (schemaBaseDir != null ? schemaBaseDir.getAbsolutePath() : "null")));
        try {
            this._fxsConfig = this.loadFXSConfig(new FileInputStream(fxsConfigFile));
            if (schemaBaseDir != null && schemaBaseDir.exists()) {
                _fxsSchemaBaseDir = schemaBaseDir;
            } else {
                LOGGER.warn((Object)("Basisverzeichnis f\u00fcr Schemas existiert nicht: " + schemaBaseDir.getAbsolutePath()));
            }
            this._fxsValidator = new FXSSchemaValidator(this._fxsConfig.getFXSSchema());
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("Datei nicht gefunden: " + fxsConfigFile.getAbsolutePath()));
            throw new BMUException("FXS-Konfigurationsdatei nicht gefunden: " + fxsConfigFile.getAbsolutePath(), e);
        }
    }

    private FXSConfig loadFXSConfig(InputStream is) throws BMUException {
        FXSConfig fxsConfig = null;
        try {
            Unmarshaller um = this._jaxbContext.createUnmarshaller();
            um.setSchema(this._ruleConfigSchemaFXS);
            fxsConfig = (FXSConfig)um.unmarshal(is);
            LOGGER.debug((Object)("FXS-Definition geladen: " + String.valueOf(fxsConfig)));
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"Fehler", (Throwable)e);
            throw new BMUException("Error loading FXSConfig from InputStream", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"closing InputStream failed", (Throwable)e);
            }
        }
        return fxsConfig;
    }

    public FXSConfig getFXSConfig() {
        return this._fxsConfig;
    }

    public FXSSchemaValidator getFXSSchemaValidator() {
        return this._fxsValidator;
    }

    public File getFxsSchemaBaseDir() {
        return _fxsSchemaBaseDir;
    }

    public static synchronized RuleFactory getInstance() throws BMUException {
        if (_theInstance == null) {
            _theInstance = new RuleFactory();
            _theInstance.init();
        }
        return _theInstance;
    }

    public RuleSetDef loadRuleSetDef(File ruleSetDefFile) throws BMUException {
        StreamSource xmlSource = new StreamSource(RuleFactory.class.getResourceAsStream(DEFAULT_RULESET_DEF_NAME));
        StreamSource xsltSource = new StreamSource(RuleFactory.class.getResourceAsStream(MERGE_XSLT_NAME));
        RuleSetDef ruleSetDef = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer tf = TransformerFactory.newInstance().newTransformer(xsltSource);
            tf.setParameter("SRC_PATH", ruleSetDefFile.getAbsolutePath());
            tf.transform(xmlSource, new StreamResult(out));
            ruleSetDef = this.loadRuleSetDef(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"error loading RuleSetDef", (Throwable)e);
            throw new BMUException("error loading RuleSetDef", e);
        }
        return ruleSetDef;
    }

    public RuleSetDef loadRuleSetDef(RuleConfig ruleConfig) throws BMUException {
        this._ruleConfig = ruleConfig;
        File ruleSetDefFile = new File(System.getProperty("java.io.tmpdir"), ruleConfig.getFileName());
        byte[] data = ByteUtils.readFromResource(DEF_RESOURCE_PATH + ruleConfig.getFileName());
        ByteUtils.writeToFile(ruleSetDefFile.getAbsolutePath(), data);
        RuleSetDef ruleSetDef = this.loadRuleSetDef(ruleSetDefFile);
        ruleSetDefFile.deleteOnExit();
        return ruleSetDef;
    }

    public RuleConfig getRuleConfig() {
        return this._ruleConfig;
    }

    public RuleSetDef getDefaultRuleSetDef() throws BMUException {
        return this.loadRuleSetDef(RuleFactory.class.getResourceAsStream(DEFAULT_RULESET_DEF_NAME));
    }

    public RuleSetDef loadRuleSetDef(InputStream is) throws BMUException {
        RuleSetDef ruleSetDef = null;
        try {
            Unmarshaller um = this._jaxbContext.createUnmarshaller();
            um.setSchema(this._ruleConfigSchema);
            ruleSetDef = (RuleSetDef)um.unmarshal(is);
            LOGGER.debug((Object)("Ruleset-Definition geladen: " + String.valueOf(ruleSetDef)));
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"Fehler", (Throwable)e);
            throw new BMUException("Error loading RuleSetDef from InputStream", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"closing InputStream failed", (Throwable)e);
            }
        }
        return ruleSetDef;
    }

    public void saveRuleSetDef(File ruleSetFile, RuleSetDef ruleSetDef) throws BMUException {
        try {
            this.saveRuleSetDef(new FileOutputStream(ruleSetFile), ruleSetDef);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Fehler", (Throwable)e);
            throw new BMUException("Error opening file for saving RuleSetDef: " + ruleSetFile.getAbsolutePath(), e);
        }
    }

    public void saveRuleSetDef(OutputStream os, RuleSetDef ruleSetDef) throws BMUException {
        try {
            Marshaller m = this._jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setSchema(this._ruleConfigSchema);
            m.marshal((Object)ruleSetDef, os);
            LOGGER.debug((Object)("Ruleset-Definition gesichert: " + String.valueOf(ruleSetDef)));
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"Fehler", (Throwable)e);
            throw new BMUException("Error saving RuleSetDef: " + String.valueOf(ruleSetDef), e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"closing OutputStream failed", (Throwable)e);
            }
        }
    }

    public void saveRuleSetResult(OutputStream os, RuleSetResult ruleSetResult) throws BMUException {
        try {
            Marshaller m = this._jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)ruleSetResult, os);
            LOGGER.debug((Object)("Ruleset-Result gesichert: " + String.valueOf(ruleSetResult)));
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"Fehler", (Throwable)e);
            throw new BMUException("Error saving RuleSetResult: " + String.valueOf(ruleSetResult), e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"closing OutputStream failed", (Throwable)e);
            }
        }
    }

    public RuleSetResult loadRuleSetResult(InputStream is) throws BMUException {
        RuleSetResult ruleSetResult = null;
        try {
            Unmarshaller um = this._jaxbContext.createUnmarshaller();
            ruleSetResult = (RuleSetResult)um.unmarshal(is);
            LOGGER.debug((Object)("Ruleset-Result geladen: " + String.valueOf(ruleSetResult)));
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"Fehler", (Throwable)e);
            throw new BMUException("Error loading RuleSetResult from InputStream", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"closing InputStream failed", (Throwable)e);
            }
        }
        return ruleSetResult;
    }

    public RuleSet createRuleSet(RuleSetDef ruleSetDef) throws BMUException {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (RuleDef ruleDef : ruleSetDef.getRuleList()) {
            RuleImpl ruleImpl = RuleImpl.newRuleImpl(ruleDef);
            if (ruleImpl != null) {
                ruleList.add(ruleImpl);
                continue;
            }
            LOGGER.error((Object)("Error creating Rule from RuleDef: " + String.valueOf(ruleDef)));
            throw new BMUException("Error creating Rule from RuleDef: " + String.valueOf(ruleDef));
        }
        Collections.sort(ruleList, new Comparator<Rule>(){

            @Override
            public int compare(Rule rule1, Rule rule2) {
                if (rule1 instanceof RuleImpl && rule2 instanceof RuleImpl) {
                    MeldungTyp.FehlerStufe fs1 = ((RuleImpl)rule1).getRuleDef().getMeldung().getStufe();
                    MeldungTyp.FehlerStufe fs2 = ((RuleImpl)rule2).getRuleDef().getMeldung().getStufe();
                    if (fs1.ordinal() > fs2.ordinal()) {
                        return 1;
                    }
                    if (fs1.equals((Object)fs2)) {
                        return 0;
                    }
                    return -1;
                }
                return 0;
            }
        });
        RuleSetImpl ruleSet = new RuleSetImpl(ruleList, ruleSetDef.getRuleDefRefOK(), ruleSetDef.getRuleDefRefError());
        return ruleSet;
    }

    public static String getTechDoc(String name) throws BMUException {
        String techDoc = null;
        try {
            Class<?> ruleClass = Class.forName("de.consist.bmu.rule.impl.RuleImpl" + name);
            Method m = ruleClass.getDeclaredMethod("getTechDoc", null);
            techDoc = (String)m.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting techDoc from: " + name), (Throwable)e);
            throw new BMUException("error getting techDoc from: " + name, e);
        }
        return techDoc;
    }

    public static enum RuleConfig {
        SERVICEMODUL,
        LEANV,
        ASYS,
        BMUVIEWER,
        TEST;


        public String getFileName() {
            return "BMU_Rule_Config_" + this.toString() + ".xml";
        }
    }
}

