/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureX509Data
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String XPATH_X509_DATA = "count(descendant::ds:X509Data) > 1";

    public RuleImplSignatureX509Data(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        NodeList nodeList;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            nodeList = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), "/descendant::ds:Signature[@Id]");
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int index = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node sigNode = nodeList.item(i);
            String sigId = sigNode.getAttributes().getNamedItem("Id").getTextContent();
            SignatureVerificationResult svr = bmuDok.getMessageType().getSignatureVerificationResult(sigId);
            if (svr == null || !svr.isEnabled(this.getRuleDef())) continue;
            try {
                if (!XPathFassade.getInstance().evalBool((Element)sigNode, XPATH_X509_DATA)) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigId));
                continue;
            }
            catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Pr\u00fcfen", e);
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return "XPath f\u00fcr die Pr\u00fcfung: count(descendant::ds:X509Data) > 1";
    }
}

