/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import de.consist.bmu.rule.def.RuleDefImpl;

/**
 * Interface f&uuml;r eine Regeldefinition.
 * 
 * Der Stichtag, ab dem eine Pr&uuml;fung auszuwerten ist, ist ein Pflichtfeld.
 * Die Pr&uuml;fung kann aber grunds&auml;tzlich aktiviert bzw. deaktiviert
 * werden. Die Beschreibung (aka Info in der Konfiguration) ist dazu gedacht,
 * dem Anwender angezeigt zu werden.
 */
@XmlJavaTypeAdapter(RuleDefImpl.Adapter.class)
public interface RuleDef extends Serializable {

    /**
     * @return the id
     */
    String getId();

    /**
     * @param id
     *            the id to set
     */
    void setId(String id);

    /**
     * @return the name
     */
    String getName();

    /**
     * @param name
     *            the name to set
     */
    void setName(String name);

    /**
     * @return docTypes
     */
    List<String> getDocTypes();

    /**
     * @param docTypes
     *            the docTypes to set
     */
    void setDocTypes(List<String> docTypes);

    /**
     * @return the enabled
     */
    boolean isEnabled();

    /**
     * @param enabled
     *            the enabled to set
     */
    void setEnabled(boolean enabled);

    /**
     * Gibt den Stichtag zurck.
     * 
     * @return the keyDate
     */
    Date getKeyDate();

    /**
     * Setzt den Stichtag der Regel.
     * 
     * @param keyDate
     *            the keyDate to set
     */
    void setKeyDate(Date keyDate);

    /**
     * @return true wenn Pruefung bei Fehler abgebrochen werden soll, sonst
     *         false
     */
    boolean isAbbruch();

    /**
     * @param cancel
     *            boolean
     */
    void setAbbruch(boolean cancel);

    /**
     * @return the meldung
     */
    MeldungTyp getMeldung();

    /**
     * @param meldung
     *            the meldung to set
     */
    void setMeldung(MeldungTyp meldung);

    /**
     * FIXME Macht das hier Sinn?
     * 
     * @return die Version
     */
    BMUVersion getVersion();

    /**
     * In der Konfiguration im Element &lt;Info&gt;.
     * 
     * @return Die Beschreibung
     */
    String getBeschreibung();

    /**
     * In der Konfiguration im Element &lt;Info&gt;.
     * 
     * @param beschreibung
     *            Die Beschreibung
     */
    void setBeschreibung(String beschreibung);
    
    /**
     * Liefert das Datum bis zu dem eine Regel angewendet werden soll.
     * 
     * @return the keyToDate
     */
    Date getKeyToDate();

    /**
     * Setzt das Datum bis zu dem eine Regel angewendet werden soll.
     * 
     * @param keyToDate
     * 			Das Datum
     */
    void setKeyToDate(Date keyToDate);
    
    /**
     * Gibt zurueck, ob das Datum der zu pruefenden Signatur (true) oder das Dokumentendatum (false) 
     * fuer die Stichtagsermittlung verwendet werden soll.
     * 
     * @return useSignatureDate
     */
    boolean getUseSignatureDate();
    
    /**
     * Legt fest, ob das Datum der zu pruefenden Signatur oder das Dokumentendatum 
     * fuer die Stichtagsermittlung verwendet werden soll.
     * 
     * @param useSignatureDate
     * 			boolean
     */
    void setUseSignatureDate(boolean useSignatureDate);
}
