/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2022-10-19 14:48:03 +0000 (Wed, 19 Oct 2022) $ $Rev: 1729 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule;

import java.util.List;

import org.w3c.dom.Document;

import de.consist.bmu.rule.MeldungTyp.FehlerStufe;
import de.consist.bmu.rule.error.BMUException;

/**
 * Umfasst das Pr&uuml;fergebnis, erlaubt Erweiterung und Konvertierung in eine
 * BMU-Quittung.
 * 
 * Die Reihenfolge der Eintr&auml;ge ist implementierungsabh&auml;ngig.
 * 
 * @see RuleSet
 */
public interface RuleSetResult {

    /**
     * Enumeration der moeglichen Stati nach einer Pruefung.
     */
    enum Status {
        PARSE_ERROR,
        SCHEMA_ERROR,
        SIGNATURE_ERROR,
        SIGNATURES_NOT_VERIFIED,
        OK
    }
    
    /**
     * @return Liste von RuleResults
     */
    List<RuleResult> getList();

    /**
     * @return Das BMUDokument
     */
    BMUDokument getBMUDokument();

    /**
     * @return Das RuleSet
     */
    RuleSet getRuleSet();

    /**
     * @param klasse
     *            Die Fehlerklasse
     * @param stufe
     *            Die Fehlerstufe
     * @param beschreibung
     *            Die Beschreibung
     * @param code
     *            Der Fehlercode
     * @param abhilfe
     *            Der Abhilfetext
     */
    void addMeldung(String klasse, String stufe, String beschreibung,
            String code, String abhilfe);

    /**
     * @param klasse
     *            Die Fehlerklasse
     * @param stufe
     *            Die Fehlerstufe
     * @param beschreibung
     *            Die Beschreibung
     * @param code
     *            Der Fehlercode
     * @param abhilfe
     *            Der Abhilfetext
     */
    void addZKSMeldung(String klasse, String stufe, String beschreibung,
            String code, String abhilfe);

    /**
     * @return Das RuleResult mit der Bezugsmeldung
     */
    RuleResult getBezugResult();

    /**
     * @return FehlerStufe
     */
    FehlerStufe getHoechsteFehlerstufe();

    /**
     * Manuell die hoechste Fehlerstufe umstellen
     * 
     * @param stufe
     */
    void setFehlerstufe(FehlerStufe stufe);

    /**
     * @return Document mit Quittung
     * @throws BMUException
     *             BMUException
     */
    Document toQuittung() throws BMUException;
    
    /**
     * @return Status der Regelpruefung
     */
    Status getStatus();
    
    /**
     * @return Liste der Meldungen
     */
    List<MeldungTyp> getMeldungList();
    
    /**
     * @return Liste der Meldungen
     */
    List<MeldungTyp> getZKSMeldungList();
}
