/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
  * Copyright 2012 by Consist ITU Environmental Software GmbH
*/
package de.consist.bmu.rule.def;

import javax.xml.namespace.QName;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlRegistry;

import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.impl.RuleSetResultImpl;

/**
 * JAXB Objekt-Fabrik fuer Regeldefinitionen.
 */
@XmlRegistry
public class RuleObjectFactory {
    private static final QName RULEDEF_QNAME = new QName("", "RuleDef");
    private static final QName RULESETDEF_QNAME = new QName("", "RuleSetDef");
    private static final QName RULERESULT_QNAME = new QName("", "RuleResult");
    private static final QName RULESETRESULT_QNAME = new QName("", "RuleSetResult");

    /**
     * Create a new ObjectFactory that can be used to create new instances of classes for package: de.consist.bmu.rule.
     *
     */
    public RuleObjectFactory() {
    }
 
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link RuleDefImpl }{@code >}}.
     * @param value RuleDef
     * @return JAXBElement
     */
    @XmlElementDecl(namespace = "", name = "RuleDef")
    public final JAXBElement<RuleDefImpl> createRuleDef(RuleDefImpl value) {
        return new JAXBElement<RuleDefImpl>(RULEDEF_QNAME, RuleDefImpl.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link RuleSetDefImpl }{@code >}}.
     * 
     * @param value RuleSetDefImpl
     * @return JAXBElement
     */
    @XmlElementDecl(namespace = "", name = "RuleSetDef")
    public final JAXBElement<RuleSetDefImpl> createRuleSetDef(RuleSetDefImpl value) {
        return new JAXBElement<RuleSetDefImpl>(RULESETDEF_QNAME, RuleSetDefImpl.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link RuleResultImpl }{@code >}}.
     * 
     * @param value RuleResultImpl
     * @return JAXBElement
     */
    @XmlElementDecl(namespace = "", name = "RuleSetResult")
    public final JAXBElement<RuleResultImpl> createRuleResult(RuleResultImpl value) {
        return new JAXBElement<RuleResultImpl>(RULERESULT_QNAME, RuleResultImpl.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link RuleSetResultImpl }{@code >}}.
     * 
     * @param value RuleSetResultImpl
     * @return JAXBElement
     */
    @XmlElementDecl(namespace = "", name = "RuleSetResult")
    public final JAXBElement<RuleSetResultImpl> createRuleSetResult(RuleSetResultImpl value) {
        return new JAXBElement<RuleSetResultImpl>(RULESETRESULT_QNAME, RuleSetResultImpl.class, null, value);
    }
}
