/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;


import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplBGSBefLfdNr extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final int MAX_LFDNR = 3;

    private static final Log LOGGER = LogFactory.getLog(RuleImplBGSBefLfdNr.class);
    
    /**
     * XPath fuer BGSBEFLayer, sowie BGSVorlage- und BGSErgaenzungslayer mit Rolle BEF.
     */
    private static final String[] XPATH_BGS_BEFLFDNR = { "/descendant::bgs:BGSBEFLayer",
        "/descendant::bgs:BGSErgaenzungsLayer[@lib:ATBRolle='BEF']"
    };

    /**
     * @param ruleDef RuleDef
     */
    public RuleImplBGSBefLfdNr(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        for (String xPath : XPATH_BGS_BEFLFDNR) {
            NodeList nl;
            try {
                nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), xPath);
            } catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Prfen", e);
            }
            for (int i = 0; i < nl.getLength(); i++) {
                Element layer = (Element) nl.item(i);
                String layerID = layer.getAttributeNS(Namespace.TypenBibliothek.getUri(), "LayerID");
                if (layer.hasAttributeNS(Namespace.TypenBibliothek.getUri(), "ATBBefLfdNummer")) {
                    String atbBefLfdNr = layer.getAttributeNS(Namespace.TypenBibliothek.getUri(), "ATBBefLfdNummer");
                    int lfdNr = Integer.parseInt(atbBefLfdNr);
                    if (lfdNr < 1 || lfdNr > MAX_LFDNR) {
                        ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, layerID));
                    }
                } else {
                    LOGGER.warn("Attribut 'ATBBefLfdNummer' fehlt.");
                }
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPathes fr die zu prfenden Layer: " + Arrays.deepToString(XPATH_BGS_BEFLFDNR);
    }

}
