/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2012-08-16 17:40:53 +0200 (Do, 16 Aug 2012) $ $Rev: 918 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplDocSize extends RuleImpl {

    private static final long serialVersionUID = 1L;
    
    private static final Log LOGGER = LogFactory.getLog(RuleImplDocSize.class);
    
    private static final int MAX_DOCSIZE = 5242880;
    
    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplDocSize(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Length: " + bmuDok.getSize());
        }
        if (bmuDok.getSize() > MAX_DOCSIZE) {
            ruleResultList.add(new RuleResultImpl(getRuleDef(), 1, null));
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "Die Gre des Dokuments darf " + MAX_DOCSIZE + " Byte nicht berschreiten.";
    }

}
