/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-01-19 01:50:18 +0100 (Sa, 19 Jan 2013) $ $Rev: 978 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplSignatureRSAPSSPadding extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureRSAPSSPadding.class);

    private static final String[] RSA_ALGO = new String[] { XMLSignature.ALGO_ID_SIGNATURE_RSA_SHA1,
            XMLSignature.ALGO_ID_SIGNATURE_RSA_SHA224, XMLSignature.ALGO_ID_SIGNATURE_RSA_SHA256,
            XMLSignature.ALGO_ID_SIGNATURE_RSA_SHA384, XMLSignature.ALGO_ID_SIGNATURE_RSA_SHA512 };
    /**
     * XPath fuer ds:Signature.
     */
    private static final String XPATH_SIGNATURE = "/descendant::" + Namespace.xmldsig.getPrefix() + ":Signature[@Id]";

    /**
     * XPath fuer dsf:XPath.
     */
    private static final String XPATH_ALGMETHOD = "descendant::" + Namespace.xmldsig.getPrefix()
            + ":SignatureMethod/@Algorithm";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureRSAPSSPadding(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nodeList;
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            nodeList = xpf.evaluateNodeList(
                    bmuDok.getDocument(), XPATH_SIGNATURE);
            
            int index = 1;
            for (int i = 0; i < nodeList.getLength(); i++) {
                Element sigElem = (Element) nodeList.item(i);
                String sigID = sigElem.getAttribute("Id");
                SignatureVerificationResult svr = bmuDok.getMessageType()
                        .getSignatureVerificationResult(sigID);
                if (svr.isEnabled(getRuleDef())) {
                    String algMethod = xpf.evaluate(sigElem, XPATH_ALGMETHOD);
                    LOGGER.debug(XPATH_ALGMETHOD + ": " + algMethod);
                    List<String> rsaAlgoList = Arrays.asList(RSA_ALGO);
                    if (rsaAlgoList.contains(algMethod)) {
                        ruleResultList.add(new RuleResultImpl(this
                                .getRuleDef(), index++, sigID));
                    }
                }
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath fr die Ermittlung der zu prfenden Inhalte: ");
        builder.append(XPATH_SIGNATURE + "/" + XPATH_ALGMETHOD + "\n");
        builder.append("Geprfte nicht zulssige Algorithm-URI's: \n");
        builder.append(Arrays.toString(RSA_ALGO));
        return builder.toString();
    }

}
