package de.consist.bmu.rule.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class OSUtil {

	public static final List<String> readCmdOutput(String command) {
		List<String> result = new ArrayList<String>();

		try {
	        StringTokenizer st = new StringTokenizer("cmd /c " + command);
	        String[] cmdarray = new String[st.countTokens()];
	        for (int i = 0; st.hasMoreTokens(); i++)
	            cmdarray[i] = st.nextToken();
			Process p = Runtime.getRuntime().exec(cmdarray);
			p.waitFor();
			BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line;
			while ((line = reader.readLine()) != null) {
				if (line != null && !line.trim().isEmpty()) {
					result.add(line);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return result;
	}

	public static final String readCmdOutput(String command, int lineNumber) {
		List<String> result = readCmdOutput(command);
		if (result.size() < lineNumber) {
			return null;
		}

		return result.get(lineNumber - 1);
	}

	public static final String getBiosSerial() {
		return readCmdOutput("WMIC BIOS GET SERIALNUMBER", 2);
	}

	public static final String getHardwareModel() {
		return readCmdOutput("WMIC COMPUTERSYSTEM GET MODEL", 2);
	}

	public static final String getHardwareManufacturer() {
		return readCmdOutput("WMIC COMPUTERSYSTEM GET MANUFACTURER", 2);
	}

	public static final String getNumberOfProcessors() {
		return readCmdOutput("WMIC COMPUTERSYSTEM GET NUMBEROFPROCESSORS", 2);
	}

	public static final String getNumberOfCores() {
		return readCmdOutput("WMIC CPU GET NUMBEROFCORES", 2);
	}

	public static final String getNumberOfLogicalProcessors() {
		return readCmdOutput("WMIC CPU GET NUMBEROFLOGICALPROCESSORS", 2);
	}

	public static final String getCPUName() {
		return readCmdOutput("WMIC CPU GET NAME", 2);
	}
	
	public static final String getMaxProcessMemorySize() {
		return readCmdOutput("WMIC OS GET MaxProcessMemorySize", 2);
	}

	public static void main(String[] args) {
		System.out.println("BIOS Serial: " + getBiosSerial());
		System.out.println("Hardware Model: " + getHardwareModel());
		System.out.println("Hardware Manufacturer: " + getHardwareManufacturer());
		System.out.println("CPU Name: " + getCPUName());
		System.out.println("Number of Processors: " + getNumberOfProcessors());
		System.out.println("Number of Cores: " + getNumberOfCores());
		System.out.println("Number of logical Processors: " + getNumberOfLogicalProcessors());
		System.out.println("Maximum number, in kilobytes, of memory that can be allocated to a process: " + getMaxProcessMemorySize());
	}
}