/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.common;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import seccommerce.common.PropertyUtil;
import seccommerce.mail.SmtpHostPort;
import seccommerce.secsignersigg.ajc;
import seccommerce.secsignersigg.akp;
import seccommerce.secsignersigg.cm;
import seccommerce.secsignersigg.cz;
import seccommerce.secsignersigg.op;

public class GeneralOptions {
    private byte[] a;
    private PropertyUtil b;
    private boolean c;

    public GeneralOptions(PropertyUtil propertyUtil) {
        this.initWithProperties(propertyUtil);
    }

    protected GeneralOptions() {
    }

    public void initWithProperties(PropertyUtil propertyUtil) {
        if (this.c) {
            throw new IllegalStateException("Cannot call initWithProperties twice.");
        }
        this.b = propertyUtil;
        this.a = propertyUtil.getOrginalPropertiesFileContent();
        this.c = true;
    }

    public boolean isInitialized() {
        return this.c;
    }

    protected PropertyUtil getProperties() {
        return this.b;
    }

    public String getOriginalPropertiesFilePath() {
        return this.b.getOriginalFilePath();
    }

    public String getLanguage() {
        return this.getProperties().getProperty("seccommerce.language", "en");
    }

    public String getRegion() {
        return this.getProperties().getProperty("seccommerce.region", "US");
    }

    public int getButtonsAlignFont() {
        return this.getProperties().getPropertyInt("seccommerce.buttons.alignfont", -1);
    }

    public boolean isButtonsAllowPlainText() {
        return this.isTrue("seccommerce.buttons.allowplaintext", true);
    }

    public boolean isButtonsAllowScaleText() {
        return this.isTrue("seccommerce.buttons.allowscaletext", true);
    }

    public boolean isButtonsBoldFont() {
        return this.isTrue("seccommerce.buttons.boldfont", false);
    }

    public boolean isButtonsCapitals() {
        return this.isTrue("seccommerce.buttons.capitals", false);
    }

    public Color getButtonsFontColor() {
        return this.getProperties().getPropertyColor("seccommerce.buttons.fontcolor", Color.WHITE);
    }

    public int getButtonsFontSize() {
        return this.getProperties().getPropertyInt("seccommerce.buttons.fontsize", 11);
    }

    public int getButtonsLabelFontSize() {
        return this.getProperties().getPropertyInt("seccommerce.buttons.labelfontsize", 12);
    }

    public int getButtonsMinimalFontSize() {
        return this.getProperties().getPropertyInt("seccommerce.buttons.minimalfontsize", 5);
    }

    public boolean isButtonsWideFocus() {
        return this.isTrue("seccommerce.buttons.widefocus", false);
    }

    public Color getButtonsOverFontColor() {
        return this.getProperties().getPropertyColor("seccommerce.buttons.overfontcolor", Color.WHITE);
    }

    public Color getDialogHeaderFontColor() {
        return this.getProperties().getPropertyColor("seccommerce.dialogheader.fontcolor", new Color(255, 255, 255));
    }

    public int getDialogHeaderFontSize() {
        return this.getProperties().getPropertyInt("seccommerce.dialogheader.fontsize", 12);
    }

    public int getDialogHeaderFontX() {
        return this.getProperties().getPropertyInt("seccommerce.dialogheader.fontx", 12);
    }

    public int getDialogHeaderFontY() {
        return this.getProperties().getPropertyInt("seccommerce.dialogheader.fonty", 22);
    }

    public Color getDialogBackgroundColor() {
        return this.getProperties().getPropertyColor("seccommerce.dialog.background.color", new Color(255, 255, 255));
    }

    public int getDialogBogenObenHeight() {
        return this.getProperties().getPropertyInt("seccommerce.dialog.bogen.oben.height", 29);
    }

    public Color getDialogColorTitelText() {
        return this.getProperties().getPropertyColor("seccommerce.dialog.color.titeltext", new Color(0, 77, 145));
    }

    public Color getDialogFirstBottomPanelColor() {
        return this.getProperties().getPropertyColor("seccommerce.dialog.firstbottompanel.color", new Color(0, 51, 102));
    }

    public boolean isDialogFirstBottomPanelShow() {
        return this.isTrue("seccommerce.dialog.firstbottompanel.show", true);
    }

    public Color getDialogFirstTopPanelColor() {
        return this.getProperties().getPropertyColor("seccommerce.dialog.firsttoppanel.color", new Color(0, 51, 102));
    }

    public boolean getDialogFirstTopPanelShow() {
        return this.isTrue("seccommerce.dialog.firsttoppanel.show", true);
    }

    public Color getDialogForegroundColor() {
        return this.getProperties().getPropertyColor("seccommerce.dialog.foreground.color", new Color(0, 0, 0));
    }

    public Color getDialogHighlightColor() {
        return this.getProperties().getPropertyColor("seccommerce.dialog.highlight.color", new Color(0, 0, 0));
    }

    public int getFlagAlignLeft() {
        return this.getProperties().getPropertyInt("seccommerce.flag.align.left", 17);
    }

    public int getFlagAlignTop() {
        return this.getProperties().getPropertyInt("seccommerce.flag.align.top", 1);
    }

    public boolean isInitSmartcardDialogAllowAlternateReader() {
        return this.isTrue("seccommerce.initsmartcarddialog.allowAlternateReader", true);
    }

    public Color getInitSmartcardDialogBalkColor() {
        return this.getProperties().getPropertyColor("seccommerce.initsmartcarddialog.balkcolor", new Color(0, 0, 255));
    }

    public Color getInitSmartcardDialogDlgBgColor() {
        return this.getProperties().getPropertyColor("seccommerce.initsmartcarddialog.dlgbgcolor", new Color(255, 255, 255));
    }

    public Color getInitSmartcardDialogLineColor() {
        return this.getProperties().getPropertyColor("seccommerce.initsmartcarddialog.linecolor", new Color(192, 192, 192));
    }

    public Color getInitSmartcardDialogTextBgColor() {
        return this.getProperties().getPropertyColor("seccommerce.initsmartcarddialog.textbgcolor", new Color(255, 255, 255));
    }

    public Color getInitSmartcardDialogTextColor() {
        return this.getProperties().getPropertyColor("seccommerce.initsmartcarddialog.textcolor", new Color(0, 0, 0));
    }

    public Color getOkDialogButtonColor() {
        return this.getProperties().getPropertyColor("seccommerce.okdialog.buttoncolor", new Color(53, 59, 135));
    }

    public Color getOkDialogButtonText() {
        return this.getProperties().getPropertyColor("seccommerce.okdialog.buttontext", new Color(255, 255, 255));
    }

    public Color getOkDialogDlgBgColor() {
        return this.getProperties().getPropertyColor("seccommerce.okdialog.dlgbgcolor", new Color(255, 255, 255));
    }

    public Color getOkDialogHeaderBgColor() {
        return this.getProperties().getPropertyColor("seccommerce.okdialog.headerbgcolor", new Color(255, 255, 255));
    }

    public Color getOkDialogHeaderHeaderText() {
        return this.getProperties().getPropertyColor("seccommerce.okdialog.headertext", new Color(0, 0, 0));
    }

    public Color getOkDialogLineColor() {
        return this.getProperties().getPropertyColor("seccommerce.okdialog.linecolor", new Color(192, 192, 192));
    }

    public int getOkDialogLineHeight() {
        return this.getProperties().getPropertyInt("seccommerce.okdialog.line.height", 1);
    }

    public boolean isOkdialogSaveEnabled() {
        return this.isTrue("seccommerce.okdialog.saveoption", false);
    }

    public Color getPinDialogButtonColor() {
        return this.getProperties().getPropertyColor("seccommerce.pindialog.buttoncolor", new Color(53, 59, 135));
    }

    public Color getPinDialogButtonText() {
        return this.getProperties().getPropertyColor("seccommerce.pindialog.buttontext", Color.BLUE);
    }

    public String getPinDialogDefaultHeader() {
        return this.getProperties().getProperty("seccommerce.pindialog.defaultheader", "gfx/h_login.gif");
    }

    public Color getPinDialogDlgBgColor() {
        return this.getProperties().getPropertyColor("seccommerce.pindialog.dlgbgcolor", new Color(255, 255, 255));
    }

    public Color getPinDialogLineColor() {
        return this.getProperties().getPropertyColor("seccommerce.pindialog.linecolor", new Color(192, 192, 192));
    }

    public Color getPinDialogLPinInstructionColor() {
        return this.getProperties().getPropertyColor("seccommerce.pindialog.lPinInstructioncolor", new Color(0, 51, 153));
    }

    public Color getPinDialogTextBgColor() {
        return this.getProperties().getPropertyColor("seccommerce.pindialog.textbgcolor", new Color(255, 255, 255));
    }

    public Color getPinDialogTextColor() {
        return this.getProperties().getPropertyColor("seccommerce.pindialog.textcolor", new Color(0, 0, 0));
    }

    public int getSelectAlignFontBottom() {
        return this.getProperties().getPropertyInt("seccommerce.select.alignfont.bottom", 0);
    }

    public int getSelectAlignFontLeft() {
        return this.getProperties().getPropertyInt("seccommerce.select.alignfont.left", 27);
    }

    public int getSelectAlignFontRight() {
        return this.getProperties().getPropertyInt("seccommerce.select.alignfont.right", 13);
    }

    public int getSelectAlignFontTop() {
        return this.getProperties().getPropertyInt("seccommerce.select.alignfont.top", 4);
    }

    public Color getSelectBackground() {
        return this.getProperties().getPropertyColor("seccommerce.select.background", new Color(0, 51, 102));
    }

    public Color getSelectBottomPanelColor() {
        return this.getProperties().getPropertyColor("seccommerce.select.bottompanel.color", new Color(0, 51, 102));
    }

    public int getSelectBottomPanelHeight() {
        return this.getProperties().getPropertyInt("seccommerce.select.bottompanel.height", 2);
    }

    public boolean isSelectBottomPanelShow() {
        return this.isTrue("seccommerce.select.bottompanel.show", true);
    }

    public Color getSelectDialogPanelSpacerColor() {
        return this.getProperties().getPropertyColor("seccommerce.select.dialogpanelspacer.color", new Color(255, 255, 255));
    }

    public boolean isSelectDialogPanelSpacerShow() {
        return this.isTrue("seccommerce.select.dialogpanelspacer.show", true);
    }

    public Color getSelectDisabledFontColor() {
        return this.getProperties().getPropertyColor("seccommerce.select.disabledfontcolor", new Color(104, 116, 149));
    }

    public int getSelectExtraAlignfontBottom() {
        return this.getProperties().getPropertyInt("seccommerce.select.extra.alignfont.bottom", 0);
    }

    public int getSelectExtraAlignfontLeft() {
        return this.getProperties().getPropertyInt("seccommerce.select.extra.alignfont.left", 30);
    }

    public int getSelectExtraAlignfontRight() {
        return this.getProperties().getPropertyInt("seccommerce.select.extra.alignfont.right", 13);
    }

    public int getSelectExtraAlignfontTop() {
        return this.getProperties().getPropertyInt("seccommerce.select.extra.alignfont.top", 6);
    }

    public boolean isSelectFontBold() {
        return this.isTrue("seccommerce.select.font.bold", false);
    }

    public boolean isSelectFontCapitals() {
        return this.isTrue("seccommerce.select.font.capitals", false);
    }

    public int getSelectFontGap() {
        return this.getProperties().getPropertyInt("seccommerce.select.fontgap", 3);
    }

    public int getSelectFontSize() {
        return this.getProperties().getPropertyInt("seccommerce.select.fontsize", 0);
    }

    public Color getSelectHighlightFontColor() {
        return this.getProperties().getPropertyColor("seccommerce.select.highlightfontcolor", new Color(255, 204, 43));
    }

    public Color getSelectLeftPanelColor() {
        return this.getProperties().getPropertyColor("seccommerce.select.leftpanel.color", new Color(255, 255, 255));
    }

    public int getSelectLeftPanelHeight() {
        return this.getProperties().getPropertyInt("seccommerce.select.leftpanel.height", 47);
    }

    public int getSelectLogoLeft() {
        return this.getProperties().getPropertyInt("seccommerce.select.logo.left", 15);
    }

    public int getSelectLogoWidth() {
        return this.getProperties().getPropertyInt("seccommerce.select.logo.width", 151);
    }

    public int getSelectLogoHeight() {
        return this.getProperties().getPropertyInt("seccommerce.select.logo.height", 47);
    }

    public boolean isSelectNumbering() {
        return this.isTrue("seccommerce.select.numbering", false);
    }

    public boolean isTiffSigCreationEnabled() {
        return this.isTrue("seccommerce.tiff.insertsignature.allow", false);
    }

    public Color getSelectPanelBackground() {
        return this.getProperties().getPropertyColor("seccommerce.select.panelbackground", new Color(0, 51, 102));
    }

    public boolean isSelectTopFontBold() {
        return this.isTrue("seccommerce.select.topfont.bold", false);
    }

    public Color getSelectionDialogButtonColor() {
        return this.getProperties().getPropertyColor("seccommerce.selectiondialog.buttoncolor", new Color(53, 59, 135));
    }

    public Color getSelectionDialogButtonText() {
        return this.getProperties().getPropertyColor("seccommerce.selectiondialog.buttontext", new Color(255, 255, 255));
    }

    public Color getSelectionDialogDlgBgColor() {
        return this.getProperties().getPropertyColor("seccommerce.selectiondialog.dlgbgcolor", new Color(255, 255, 255));
    }

    public int getSelectiondDialogGapButton() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.gap.button", 8);
    }

    public int getSelectionDialogGapHeader() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.gap.header", 12);
    }

    public int getSelectionDialogGapLeft() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.gap.left", 12);
    }

    public int getSelectionDialogGapRight() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.gap.right", 12);
    }

    public int getSelectionDialogGapTop() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.gap.top", 12);
    }

    public Color getSelectionDialogHeaderBgColor() {
        return this.getProperties().getPropertyColor("seccommerce.selectiondialog.headerbgcolor", new Color(255, 255, 255));
    }

    public int getSelectionDialogHeaderBottom() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.headerbottom", 0);
    }

    public int getSelectionDialogHeaderLeft() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.headerleft", 0);
    }

    public int getSelectionDialogHeaderRight() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.headerright", 0);
    }

    public Color getSelectionDialogHeaderTextColor() {
        return this.getProperties().getPropertyColor("seccommerce.selectiondialog.headertext", new Color(0, 0, 0));
    }

    public int getSelectionDialogHeaderTop() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.headertop", 0);
    }

    public int getSelectionDialogLineHeight() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.line.height", 1);
    }

    public int getSelectionDialogLineWidth() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.line.width", 420);
    }

    public int getSelectionDialogLineX() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.line.x", 12);
    }

    public int getSelectionDialogLineY() {
        return this.getProperties().getPropertyInt("seccommerce.selectiondialog.line.y", 36);
    }

    public Color getSelectionDialogLineColor() {
        return this.getProperties().getPropertyColor("seccommerce.selectiondialog.linecolor", new Color(192, 192, 192));
    }

    public boolean isUsePinpad() {
        return this.isTrue("seccommerce.usepinpad", true);
    }

    public boolean isLogStdoutActive() {
        return this.isTrue("log.stdoutactive", true);
    }

    public boolean isLogFileActive() {
        return this.isTrue("log.fileactive", true);
    }

    public String getLogFilename() {
        String string = "seccommerce.log";
        String string2 = cz.u(this.getProperties().getProperty("log.filename", string));
        try {
            GeneralOptions.checkFileNameForIllegalValue(string2, "log", false, true);
            return string2;
        }
        catch (Exception exception) {
            System.err.println("The log file name defaults to " + string + " because the configured name cannot be used: " + exception.getMessage());
            return string;
        }
    }

    public String getLogDir() {
        return cz.u(this.getProperties().getProperty("log.dir"));
    }

    public boolean isLogFilenameAlter() {
        return this.isTrue("log.filenamealter", true);
    }

    public boolean isLogFilenameDate() {
        return this.isTrue("log.filenamedate", false);
    }

    public boolean isLogGzip() {
        return this.isTrue("log.gzip", true);
    }

    public int getLogMaxLogType(int n10) {
        return this.getProperties().getPropertyInt("log.maxlogtype", n10);
    }

    public String getLogstashUrl() {
        return this.getProperties().getProperty("log.logstash.url");
    }

    public boolean isSmoothingViewerUsed() {
        return this.isTrue(new String[]{"smoothingviewer", "seccommerce.smoothingviewer"}, true);
    }

    public boolean isViewerCopyingToBufferedImage() {
        return this.isTrue(new String[]{"copytobufferedimage", "seccommerce.copytobufferedimage"}, false);
    }

    public boolean isSupportReaderCtapi() {
        return this.isTrue("seccommerce.supportreaderctapi", true);
    }

    public boolean isSupportReaderPcsc() {
        return this.isTrue("seccommerce.supportreaderpcsc", true);
    }

    public String[] getExcludedPcscCardReaders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getProperties().getProperty("seccommerce.excludedreaderspcsc");
        if (null != string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.isEmpty()) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean isDebugReader() {
        return this.isTrue("seccommerce.debugreader", false);
    }

    public boolean isSupportReaderPcscWithoutSecurePin() {
        return this.isTrue("seccommerce.supportreaderpcscwithoutsecurepin", true);
    }

    public boolean isSupportReaderPkcs11() {
        return this.isTrue("seccommerce.supportreaderpkcs11", true);
    }

    public boolean isRememberPkcs11() {
        return this.isTrue("seccommerce.rememberreaderpkcs11", true);
    }

    public boolean isSupportedReaderCyberJackCtApi() {
        return this.isTrue("seccommerce.supportreadercptai.cyberjack", true);
    }

    public boolean isSupportedReaderKaanCtApi() {
        String[] stringArray = new String[]{"seccommerce.supportreaderctapi.kaan", "seccommerce.supportreaderctapi.kobil"};
        return this.isTrue(stringArray, true);
    }

    public boolean isSupportedReaderChipdriveCtApi() {
        String[] stringArray = new String[]{"seccommerce.supportreaderctapi.towitoko", "seccommerce.supportreaderctapi.chipdrive"};
        return this.isTrue(stringArray, true);
    }

    public boolean isSupportedReaderChipdrivePinpadCtApi() {
        String[] stringArray = new String[]{"seccommerce.supportreaderctapi.towitokopinpad", "seccommerce.supportreaderctapi.chipdrivepinpad"};
        return this.isTrue(stringArray, true);
    }

    public boolean isSupportedReaderChipdriveDesktopCtApi() {
        return this.isTrue("seccommerce.supportreaderctapi.chipdrivedesktop", true);
    }

    public boolean isSupportedReaderOrgaCtApi() {
        return this.isTrue("seccommerce.supportreaderctapi.orga", true);
    }

    public boolean isSupportedReaderCardManCtApi() {
        String[] stringArray = new String[]{"seccommerce.supportreaderctapi.cardman", "seccommerce.supportreaderctapi.omnikey"};
        return this.isTrue(stringArray, true);
    }

    public boolean isSupportedReaderOmnikey8751eHealthCtApi() {
        return this.isTrue("seccommerce.supportreaderctapi.omnikey8751", true);
    }

    public boolean isSupportedReaderCardStarCtApiCom() {
        String[] stringArray = new String[]{"seccommerce.supportreaderctapi.celectroniccom", "seccommerce.supportreaderctapi.cardstarcom", "seccommerce.supportreaderctapi.cardstarmedic2com"};
        return this.isTrue(stringArray, true);
    }

    public boolean isSupportedReaderCherryCtApi() {
        return this.isTrue("seccommerce.supportreaderctapi.cherry", true);
    }

    public boolean isSupportedReaderScmHealthCtApi() {
        return this.isTrue("seccommerce.supportreaderctapi.scmhealth", true);
    }

    public boolean isSupportedReaderGermanTelematicsCtApi() {
        String[] stringArray = new String[]{"seccommerce.supportreaderctapi.telematics", "seccommerce.supportreaderctapi.germantelematics"};
        return this.isTrue(stringArray, true);
    }

    public boolean isSupportedReaderHypercomCtApi() {
        return this.isTrue("seccommerce.supportreaderctapi.hypercom", true);
    }

    public boolean isSupportedReaderCardStarCtApi() {
        String[] stringArray = new String[]{"seccommerce.supportreaderctapi.celectronic", "seccommerce.supportreaderctapi.cardstar", "seccommerce.supportreaderctapi.cardstarmedic2"};
        return this.isTrue(stringArray, true);
    }

    public boolean isTcosCardSignWithNetkeyInsteadOfSigg() {
        return 1 == this.a();
    }

    public boolean isTcosCardSignWithNetkeyChoice() {
        return 2 == this.a();
    }

    private final int a() {
        return this.getProperties().getPropertyInt("seccommerce.tcoscard.signaturecertificatechoice", 0);
    }

    public int getShowDocDialogHeight() {
        return this.getProperties().getPropertyInt("seccommerce.showdocdialog.height", 600);
    }

    public int getShowDocDialogWidth() {
        return this.getProperties().getPropertyInt("seccommerce.showdocdialog.width", 800);
    }

    public boolean isShowPagesContinuously() {
        return this.isTrue("seccommerce.showpagescontinuously", false);
    }

    public boolean isShowTwoPages() {
        return this.isTrue("seccommerce.showtwopages", false);
    }

    public String getOrgShortName() {
        return this.getProperties().getProperty("seccommerce.orgshortname");
    }

    public boolean isCertAllowPseudonym() {
        return this.isTrue("seccommerce.cert.allowpseudonym", true);
    }

    public boolean isCertAllowECC() {
        return this.isTrue("seccommerce.cert.allowecc", true);
    }

    public boolean isQualifiedCertRequired() {
        String string = this.getProperties().getProperty("seccommerce.secsigner.requirequalifiedcert", "off");
        return this.getProperties().getProperty("seccommerce.cert.requirequalified", string).equalsIgnoreCase("on");
    }

    public String getFilenamePresetOcspResponse() {
        return this.getProperties().getProperty("seccommerce.filenamepreset.ocspresponse", "OCSP-Response.der");
    }

    public boolean isPkcs7SmimeCap() {
        return this.isTrue("seccommerce.pkcs7.smimecap", false);
    }

    public boolean isPrintPdfAnnotations() {
        return this.isTrue("seccommerce.secsigner.printpdfannotations", true);
    }

    public int getXmlDefaultView() {
        return this.getProperties().getPropertyInt("seccommerce.xmldefaultview", 3);
    }

    public int getDefaultFontSize(int n10) {
        return this.getProperties().getPropertyInt("seccommerce.secsigner.defaultfontsize", n10);
    }

    public String getFilenameFilterAttributeCert() {
        return this.getProperties().getProperty("seccommerce.filenamefilter.attributecert", "*.crt;*.atz;*.der;*.cry");
    }

    public float getImageScaleFactor() {
        return this.getProperties().getPropertyFloat("seccommerce.imagescalefactor", -1.0f);
    }

    public float getImageScaleFactor(String string) {
        if (null == string) {
            return this.getImageScaleFactor();
        }
        return this.getProperties().getPropertyFloat("seccommerce.imagescalefactor" + (string.startsWith(".") ? string : "." + string), this.getImageScaleFactor());
    }

    public boolean isRescaleEachPage() {
        return this.isTrue("seccommerce.imagescaleeachpage", false);
    }

    public int getCertExpireWarnDays() {
        return this.getProperties().getPropertyInt("seccommerce.cert.expirewarndays", 30);
    }

    public int getDialogHeaderHeight() {
        return this.getProperties().getPropertyInt("seccommerce.dialog.headerheight", 29);
    }

    public int getDialogStatusPanelHeight() {
        return this.getProperties().getPropertyInt("seccommerce.dialog.statuspanel.height", 29);
    }

    public int getSelectBottomPanelTop() {
        return this.getProperties().getPropertyInt("seccommerce.select.bottompanel.top", 0);
    }

    public boolean isDialogStatusPanelShow() {
        return this.isTrue("seccommerce.dialog.statuspanel.show", true);
    }

    public boolean isSelectLeftPanelShow() {
        return this.isTrue("seccommerce.select.leftpanel.show", false);
    }

    public int getOcspCacheTimeLimit() {
        return this.getProperties().getPropertyInt(new String[]{"secappserver.ocsp.cachetimelimit", "seccommerce.ocsp.cachetimelimit"}, 15);
    }

    public int getOcspTimeTolerance() {
        return this.getProperties().getPropertyInt("seccommerce.ocsp.timetolerance", 60);
    }

    public int getOcspReadTimeout() {
        return this.getProperties().getPropertyInt("seccommerce.ocsp.readtimeout", 30);
    }

    public int getOcspConnectErrorRetryThresholdMillis() {
        return this.getProperties().getPropertyInt("seccommerce.ocsp.connecterror.retrythresholdmillis", 1000);
    }

    public boolean isUseJdkUrlConnection() {
        return this.isUseJdkUrlConnection(true);
    }

    protected boolean isUseJdkUrlConnection(boolean bl10) {
        String string = this.getProperties().getProperty("seccommerce.jdkurlconnection");
        if (null == string) {
            return bl10;
        }
        return string.equalsIgnoreCase("on");
    }

    public int getTlsMinVersionMinor() {
        return this.getProperties().getPropertyInt("seccommerce.tls.minversionminor", 4);
    }

    public int getTlsMaxVersionMinor() {
        return this.getProperties().getPropertyInt("seccommerce.tls.maxversionminor", Integer.MAX_VALUE);
    }

    public int getHstsMaxAgeSeconds() {
        return this.getProperties().getPropertyInt("hstsMaxAgeSeconds", -1);
    }

    public String getOversigTimeStampServerUrl() {
        return this.getProperties().getProperty("oversig.timestampserver.url");
    }

    public String getOversigTimeStampServerHttpUsername() {
        return this.getProperties().getProperty("oversig.timestampserver.httpusername");
    }

    public String getOversigTimeStampServerHttpPassword() {
        return this.getProperties().getProperty("oversig.timestampserver.httppassword", cm.d(this.getProperties().getProperty("oversig.timestampserver.encrhttppassword")));
    }

    public String getOversigTimeStampServerKeyFilename() {
        return this.getProperties().getProperty("oversig.timestampserver.keyfilename");
    }

    public static String getOversigTimestampServerCertFilePropName() {
        return "oversig.timestampserver.certfilename";
    }

    public static String getOversigTimestampServerCertFilePropName(int n10) {
        return "oversig.timestampserver." + (n10 < 0 ? "" : n10 + ".") + "certfilename";
    }

    public String getOversigTimeStampServerCertFilename() {
        return this.getProperties().getProperty(GeneralOptions.getOversigTimestampServerCertFilePropName());
    }

    public String getOversigTimeStampServerCertFilename(int n10) {
        return this.getProperties().getProperty(GeneralOptions.getOversigTimestampServerCertFilePropName(n10));
    }

    public String getOversigTimestampServerKeyPassword() {
        return this.getProperties().getProperty("oversig.timestampserver.keypassword", cm.d(this.getProperties().getProperty("oversig.timestampserver.encrkeypassword")));
    }

    public boolean isOversigTimeStampServerSignReq() {
        return this.isTrue("oversig.timestampserver.signreq", false);
    }

    public int getOversigTSPServerFutureTimetolerance() {
        return this.getProperties().getPropertyInt("oversig.timestampserver.future.timetolerance", 2);
    }

    public int getTimestampSendRequestsMaxPerDay() {
        return this.getProperties().getPropertyInt("timestamp.request.send.maxperday", -1);
    }

    public Color getXmlViewerAttributeNameColor() {
        return this.getProperties().getPropertyColor("seccommerce.xmlviewer.attributename.color", new Color(0, 128, 0));
    }

    public Color getXmlViewerBraceColor() {
        return this.getProperties().getPropertyColor("seccommerce.xmlviewer.brace.color", new Color(64, 64, 64));
    }

    public Color getXmlViewerColonColor() {
        return this.getProperties().getPropertyColor("seccommerce.xmlviewer.colon.color", new Color(64, 64, 64));
    }

    public Color getXmlViewerCommaColor() {
        return this.getProperties().getPropertyColor("seccommerce.xmlviewer.comma.color", new Color(64, 64, 64));
    }

    public Color getXmlViewerCommentColor() {
        return this.getProperties().getPropertyColor("seccommerce.xmlviewer.comment.color", new Color(128, 128, 128));
    }

    public Color getXmlViewerErrorColor() {
        return this.getProperties().getPropertyColor("seccommerce.xmlviewer.error.color", new Color(255, 0, 0));
    }

    public Color getXmlViewerTagColor() {
        return this.getProperties().getPropertyColor("seccommerce.xmlviewer.tag.color", new Color(0, 0, 255));
    }

    public Color getXmlViewerTextColor() {
        return this.getProperties().getPropertyColor("seccommerce.xmlviewer.text.color", new Color(0, 0, 0));
    }

    public String getOpenProgramName(String string) {
        String string2 = string.startsWith(".") ? string : "." + string;
        return this.getProperties().getProperty("seccommerce.open" + string2, null);
    }

    public Color getButtonsFocusColor() {
        return this.getProperties().getPropertyColor("seccommerce.buttons.focuscolor");
    }

    public boolean isSelectExtraFontBold(boolean bl10) {
        String string = this.getProperties().getProperty("seccommerce.select.extrafontbold");
        if (null != string) {
            return string.equalsIgnoreCase("on");
        }
        return bl10;
    }

    public Color getFlagColor(Color color) {
        return this.getProperties().getPropertyColor("seccommerce.flag.color", color);
    }

    public String getOkDialogDefaultHeader() {
        return this.getProperties().getProperty("seccommerce.okdialog.defaultheader", "gfx/hinweis.gif");
    }

    public int getOkDialogLineWidth(int n10) {
        return this.getProperties().getPropertyInt("seccommerce.okdialog.line.width", n10);
    }

    public int getOkDialogLineX(int n10) {
        return this.getProperties().getPropertyInt("seccommerce.okdialog.line.x", n10);
    }

    public int getOkDialogLineY(int n10) {
        return this.getProperties().getPropertyInt("seccommerce.okdialog.line.y", n10);
    }

    public Color getOkDialogTextBgColor(Color color) {
        return this.getProperties().getPropertyColor("seccommerce.okdialog.textbgcolor", color);
    }

    public Color getOkDialogTextColor(Color color) {
        return this.getProperties().getPropertyColor("seccommerce.okdialog.textcolor", color);
    }

    public Color getSelectExtraFontColor(Color color) {
        return this.getProperties().getPropertyColor("seccommerce.select.extrafontcolor", color);
    }

    public Color getSelectFontColor(Color color) {
        return this.getProperties().getPropertyColor("seccommerce.select.fontcolor", color);
    }

    public boolean isSelectFontCurrentBold(boolean bl10) {
        String string = this.getProperties().getProperty("seccommerce.select.font.current.bold");
        if (null != string) {
            return string.equalsIgnoreCase("on");
        }
        return bl10;
    }

    public Color getSelectionDialogSpaceBgColor(Color color) {
        return this.getProperties().getPropertyColor("seccommerce.selectiondialog.spacebgcolor", color);
    }

    public Color getSelectSiggFunctionFontColor(Color color) {
        return this.getProperties().getPropertyColor("seccommerce.select.siggfunctionfontcolor", color);
    }

    public String getLogoPopup() {
        return this.getProperties().getProperty("seccommerce.logo.popup");
    }

    private static String a(int n10) {
        String string = "seccommerce.secappserver.proxy.";
        if (n10 >= 0) {
            string = string + n10 + ".";
        }
        return string;
    }

    public String getProxyServerName(int n10) {
        return this.getProperties().getProperty(GeneralOptions.a(n10) + "server");
    }

    public int getProxyServerPort(int n10) {
        return this.getProperties().getPropertyInt(GeneralOptions.a(n10) + "port", -1);
    }

    public String getProxyUserName(int n10) {
        return this.getProperties().getProperty(GeneralOptions.a(n10) + "username");
    }

    public String getProxyPassword(int n10) {
        return this.getProperties().getProperty(GeneralOptions.a(n10) + "password");
    }

    public String getProxyPasswordEncrypted(int n10) {
        String string = GeneralOptions.a(n10);
        return this.getProperties().getProperty(new String[]{string + "encryptedpassword", string + "encrpassword"}, null);
    }

    public String getProxyBypassHost(int n10) {
        return this.getProperties().getProperty("seccommerce.secappserver.proxy.bypass." + n10);
    }

    public String getProxyAutoConfUrl() {
        return this.getProperties().getProperty("proxy.autoconfurl");
    }

    public String getProxyHttpsBypass() {
        return this.getProperties().getProperty("proxy.https.bypass");
    }

    public String getProxyHttpsList() {
        return this.getProperties().getProperty("proxy.https.list");
    }

    public boolean isNeverAskUserForProxyPassword() {
        return this.isTrue("proxy.password.neveraskuser", false);
    }

    public String getConfigDir() {
        String string = this.getProperties().getProperty("seccommerce.configdir");
        return cz.u(string);
    }

    public String getConfigSubDirName() {
        String string = this.getProperties().getProperty("seccommerce.configsubdirname");
        return cz.s(string) ? ".seccommerce" : string;
    }

    public boolean isSecSignerApiValidateCertChain() {
        return !this.getProperties().getProperty("secsignerapi.validatecertchain", "on").equalsIgnoreCase("off");
    }

    public boolean isSecSignerApiCheckRevocation() {
        String string = this.getProperties().getProperty("secsignerapi.checkrevocation");
        if (null != string) {
            return !string.equalsIgnoreCase("off");
        }
        return !this.getProperties().getProperty("secsignerapi.checkocsp", "on").equalsIgnoreCase("off");
    }

    public boolean isSecSignerApiGenCertPss() {
        return this.isTrue("secsignerapi.gencert.pss", true);
    }

    public boolean isSecSignerApiEnableDecrypt() {
        return this.isTrue("secsignerapi.enabledecrypt", false);
    }

    public int getSecSignerApiClearanceMinutes() {
        return this.getProperties().getPropertyInt("secsignerapi.clearance.minutes", -1);
    }

    public int getSecSignerApiClearanceSigCount() {
        return this.getProperties().getPropertyInt("secsignerapi.clearance.sigcount", -1);
    }

    public static String getCardReaderPropName(int n10) {
        return "secsignerapi.cardreader." + n10;
    }

    public String getCardReader(int n10) {
        return this.getProperties().getProperty(GeneralOptions.getCardReaderPropName(n10));
    }

    public String getStoredSigPin(String string) {
        return this.getProperties().getProperty("secsignerapi.sigpin." + string);
    }

    public String getStoredCardAccessNumber(String string) {
        return this.getProperties().getProperty("secsignerapi.can." + string);
    }

    public String getSoftCertKeyFilename(int n10) {
        return this.getProperties().getProperty("secsignerapi.softcert." + n10 + ".keyfilename");
    }

    public String getSoftCertCertFilename(int n10) {
        return this.getProperties().getProperty("secsignerapi.softcert." + n10 + ".certfilename");
    }

    public String getSoftCertKeyPassword(int n10) {
        return this.getProperties().getProperty("secsignerapi.softcert." + n10 + ".password", cm.d(this.getProperties().getProperty("secsignerapi.softcert." + n10 + ".encrpassword")));
    }

    public String getJvmVersion() {
        return this.getProperties().getProperty("seccommerce.jvm.version");
    }

    public String getResourceJarName() throws IOException {
        return this.getResourceJarName(false);
    }

    public String getResourceJarName(boolean bl10) throws IOException {
        String string = this.b.getProperty("seccommerce.resource");
        GeneralOptions.checkFileNameForIllegalValue(string, "jar", bl10);
        return string;
    }

    public String getTableCheckFieldName(String string) {
        return this.getProperties().getProperty(string + ".checkfield");
    }

    public String getTableRowItalicsFieldName(String string) {
        return this.getProperties().getProperty(string + ".rowitalicsfield");
    }

    public String getTableColumnDisplayName(String string, int n10) throws ajc {
        String string2 = string + ".header." + n10 + ".displayname";
        String string3 = this.getProperties().getProperty(string2);
        if (null == string3) {
            throw new ajc(string2 + " missing");
        }
        return string3;
    }

    public String getTableColumnName(String string, int n10) throws ajc {
        String string2 = string + ".header." + n10 + ".name";
        String string3 = this.getProperties().getProperty(string2);
        if (null == string3) {
            throw new ajc(string2 + " missing");
        }
        return string3;
    }

    public int getTableHeaderCount(String string) throws ajc {
        String string2 = string + ".header.count";
        int n10 = this.getProperties().getPropertyInt(string2, -1);
        if (n10 < 0) {
            throw new ajc(string2 + " missing");
        }
        return n10;
    }

    public int getTableHeaderWidth(String string, int n10) {
        String string2 = string + ".header." + n10 + ".width";
        return this.getProperties().getPropertyInt(string2, -1);
    }

    public boolean getTableHeaderEditable(String string, int n10) {
        String string2 = string + ".header." + n10 + ".editable";
        return this.isTrue(string2, false);
    }

    public int getTableCheckFieldTrueValue(String string) {
        String string2 = string + ".checkfield.true";
        return this.getProperties().getPropertyInt(string2, 1);
    }

    public int getTableRowItalicsFieldTrueValue(String string) {
        String string2 = string + ".rowitalicsfield.true";
        return this.getProperties().getPropertyInt(string2, 1);
    }

    public String getHelp() {
        return this.getProperties().getProperty("seccommerce.help");
    }

    public String getExtraPinWarning() {
        return this.getProperties().getProperty("seccommerce.extrapinwarning", "");
    }

    public String getFalsePinWarning(String string) {
        return this.getProperties().getProperty("seccommerce.falsepinwarning", string);
    }

    public int getTimeOutFirstPINDigit() {
        return this.getProperties().getPropertyInt("seccommerce.pinpad.timeoutfirstdigit", 99);
    }

    public int getTimeOutSuccessivePINDigits() {
        return this.getProperties().getPropertyInt("seccommerce.pinpad.timeoutsuccessivedigits", 10);
    }

    protected SmtpHostPort getGeneralSmtpServer(String string) {
        String string2 = string;
        String string3 = this.getProperties().getProperty(string2);
        if (null == string3 || string3.isEmpty()) {
            return null;
        }
        op.c(string2 + "=" + string3);
        String string4 = string2 + ".auth.username";
        String string5 = this.getProperties().getProperty(string4);
        String string6 = string2 + ".auth.password";
        String string7 = string2 + ".auth.encrpassword";
        String string8 = string2 + ".auth.encryptedpassword";
        String string9 = this.getProperties().getProperty(string6, cm.d(this.getProperties().getProperty(string7, this.getProperties().getProperty(string8))));
        Long l10 = null;
        String string10 = string2 + ".tls";
        boolean bl10 = this.isTrue(string10, (boolean)akp.h);
        String string11 = string2 + ".starttls";
        String string12 = this.getProperties().getProperty(string11);
        Boolean bl11 = null;
        if (cz.t(string12)) {
            bl11 = !string12.equalsIgnoreCase("off");
        }
        String string13 = string2 + ".plaintextonly";
        String string14 = this.getProperties().getProperty(string13);
        Boolean bl12 = null;
        if (cz.t(string14)) {
            bl12 = !string14.equalsIgnoreCase("off");
        }
        return new SmtpHostPort(string3, 25, string5, string9, l10, bl10, bl11, bl12, 17L);
    }

    public boolean isCheckNonSignatureCertificatesForSigning() {
        return this.isTrue("seccommerce.checknonsignaturecertforsigning", true);
    }

    public int getWarningDialogExtraHeight() {
        return this.getProperties().getPropertyInt("seccommerce.dialogs.warning.extraheight", 0);
    }

    protected boolean isTrue(String string, boolean bl10) {
        return GeneralOptions.isTrue(this.getProperties(), string, bl10);
    }

    protected static boolean isTrue(PropertyUtil propertyUtil, String string, boolean bl10) {
        String string2 = propertyUtil.getProperty(string);
        if (null == string2) {
            return bl10;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase("on")) {
            return true;
        }
        if (string2.equalsIgnoreCase("off")) {
            return false;
        }
        op.a("Property value for '" + string + "' is not valid: '" + string2 + "'. The default value '" + bl10 + "' will be used instead.");
        return bl10;
    }

    protected boolean isTrue(String[] stringArray, boolean bl10) {
        if (stringArray == null) {
            return bl10;
        }
        boolean bl11 = false;
        boolean bl12 = bl10;
        String string = "";
        int n10 = stringArray.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            string = string + (i10 > 0 ? ", " : "") + stringArray[i10];
            String string2 = this.getProperties().getProperty(stringArray[i10]);
            if (null == string2) continue;
            if ((string2 = cz.b(string2, " ", "")).equalsIgnoreCase("on")) {
                if (bl11 && !bl12) {
                    op.a("Incompatible values for equivalent properties '" + string + "' have been set. Using value '" + bl12 + "'.");
                    continue;
                }
                bl11 = true;
                bl12 = true;
                continue;
            }
            if (string2.equalsIgnoreCase("off")) {
                if (bl11 && bl12) {
                    op.a("Incompatible values for equivalent properties '" + string + "' have been set. Using value '" + bl12 + "'.");
                    continue;
                }
                bl11 = true;
                bl12 = false;
                continue;
            }
            op.a("Property value for '" + stringArray[i10] + "' is not valid: '" + string2 + "'.");
        }
        return bl12;
    }

    protected static void checkFileNameForIllegalValue(String string, String string2, boolean bl10) throws IOException {
        GeneralOptions.checkFileNameForIllegalValue(string, string2, bl10, false);
    }

    protected static void checkFileNameForIllegalValue(@NotNull String string, String string2, boolean bl10, boolean bl11) throws IOException {
        Objects.requireNonNull(string, "No file name to check for illegal values configured.");
        boolean bl12 = false;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            char c10 = string.charAt(i10);
            if (c10 == '.') {
                if (bl12) {
                    throw new IOException("The configured file name \"" + string + "\" contains more than one dot.");
                }
                bl12 = true;
            }
            if (c10 == '.' || c10 >= '0' && c10 <= '9' || c10 >= 'a' && c10 <= 'z' || c10 >= 'A' && c10 <= 'Z' || c10 == '_' || c10 == '-' || bl10 && (c10 == '/' || c10 == ':') || bl11 && c10 == '%') continue;
            throw new IOException("The configured file name \"" + string + "\" contains the illegal character '" + c10 + "'.");
        }
        String string3 = '.' + string2;
        if (!string.toLowerCase().endsWith(string3)) {
            throw new IOException("The configured file name \"" + string + "\" does not end with \"" + string3 + "\".");
        }
    }

    public boolean isUseWorkDirAsPubPropPath() {
        return false;
    }
}

