/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.smartcard.pkcs11;

public class Pkcs11Exception
extends Exception {
    private static final long serialVersionUID = 20221209001L;
    public static final int CKR_OK = 0;
    public static final int CKR_CANCEL = 1;
    public static final int CKR_HOST_MEMORY = 2;
    public static final int CKR_SLOT_ID_INVALID = 3;
    public static final int CKR_GENERAL_ERROR = 5;
    public static final int CKR_FUNCTION_FAILED = 6;
    public static final int CKR_ARGUMENTS_BAD = 7;
    public static final int CKR_NO_EVENT = 8;
    public static final int CKR_NEED_TO_CREATE_THREADS = 9;
    public static final int CKR_CANT_LOCK = 10;
    public static final int CKR_ATTRIBUTE_READ_ONLY = 16;
    public static final int CKR_ATTRIBUTE_SENSITIVE = 17;
    public static final int CKR_ATTRIBUTE_TYPE_INVALID = 18;
    public static final int CKR_ATTRIBUTE_VALUE_INVALID = 19;
    public static final int CKR_ACTION_PROHIBITED = 27;
    public static final int CKR_DATA_INVALID = 32;
    public static final int CKR_DATA_LEN_RANGE = 33;
    public static final int CKR_DEVICE_ERROR = 48;
    public static final int CKR_DEVICE_MEMORY = 49;
    public static final int CKR_DEVICE_REMOVED = 50;
    public static final int CKR_ENCRYPTED_DATA_INVALID = 64;
    public static final int CKR_ENCRYPTED_DATA_LEN_RANGE = 65;
    public static final int CKR_AEAD_DECRYPT_FAILED = 66;
    public static final int CKR_FUNCTION_CANCELED = 80;
    public static final int CKR_FUNCTION_NOT_PARALLEL = 81;
    public static final int CKR_FUNCTION_NOT_SUPPORTED = 84;
    public static final int CKR_KEY_HANDLE_INVALID = 96;
    public static final int CKR_KEY_SIZE_RANGE = 98;
    public static final int CKR_KEY_TYPE_INCONSISTENT = 99;
    public static final int CKR_KEY_NOT_NEEDED = 100;
    public static final int CKR_KEY_CHANGED = 101;
    public static final int CKR_KEY_NEEDED = 102;
    public static final int CKR_KEY_INDIGESTIBLE = 103;
    public static final int CKR_KEY_FUNCTION_NOT_PERMITTED = 104;
    public static final int CKR_KEY_NOT_WRAPPABLE = 105;
    public static final int CKR_KEY_UNEXTRACTABLE = 106;
    public static final int CKR_MECHANISM_INVALID = 112;
    public static final int CKR_MECHANISM_PARAM_INVALID = 113;
    public static final int CKR_OBJECT_HANDLE_INVALID = 130;
    public static final int CKR_OPERATION_ACTIVE = 144;
    public static final int CKR_OPERATION_NOT_INITIALIZED = 145;
    public static final int CKR_PIN_INCORRECT = 160;
    public static final int CKR_PIN_INVALID = 161;
    public static final int CKR_PIN_LEN_RANGE = 162;
    public static final int CKR_PIN_EXPIRED = 163;
    public static final int CKR_PIN_LOCKED = 164;
    public static final int CKR_SESSION_CLOSED = 176;
    public static final int CKR_SESSION_COUNT = 177;
    public static final int CKR_SESSION_HANDLE_INVALID = 179;
    public static final int CKR_SESSION_PARALLEL_NOT_SUPPORTED = 180;
    public static final int CKR_SESSION_READ_ONLY = 181;
    public static final int CKR_SESSION_EXISTS = 182;
    public static final int CKR_SESSION_READ_ONLY_EXISTS = 183;
    public static final int CKR_SESSION_READ_WRITE_SO_EXISTS = 184;
    public static final int CKR_SIGNATURE_INVALID = 192;
    public static final int CKR_SIGNATURE_LEN_RANGE = 193;
    public static final int CKR_TEMPLATE_INCOMPLETE = 208;
    public static final int CKR_TEMPLATE_INCONSISTENT = 209;
    public static final int CKR_TOKEN_NOT_PRESENT = 224;
    public static final int CKR_TOKEN_NOT_RECOGNIZED = 225;
    public static final int CKR_TOKEN_WRITE_PROTECTED = 226;
    public static final int CKR_UNWRAPPING_KEY_HANDLE_INVALID = 240;
    public static final int CKR_UNWRAPPING_KEY_SIZE_RANGE = 241;
    public static final int CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT = 242;
    public static final int CKR_USER_ALREADY_LOGGED_IN = 256;
    public static final int CKR_USER_NOT_LOGGED_IN = 257;
    public static final int CKR_USER_PIN_NOT_INITIALIZED = 258;
    public static final int CKR_USER_TYPE_INVALID = 259;
    public static final int CKR_USER_ANOTHER_ALREADY_LOGGED_IN = 260;
    public static final int CKR_USER_TOO_MANY_TYPES = 261;
    public static final int CKR_WRAPPED_KEY_INVALID = 272;
    public static final int CKR_WRAPPED_KEY_LEN_RANGE = 274;
    public static final int CKR_WRAPPING_KEY_HANDLE_INVALID = 275;
    public static final int CKR_WRAPPING_KEY_SIZE_RANGE = 276;
    public static final int CKR_WRAPPING_KEY_TYPE_INCONSISTENT = 277;
    public static final int CKR_RANDOM_SEED_NOT_SUPPORTED = 288;
    public static final int CKR_RANDOM_NO_RNG = 289;
    public static final int CKR_DOMAIN_PARAMS_INVALID = 304;
    public static final int CKR_CURVE_NOT_SUPPORTED = 320;
    public static final int CKR_BUFFER_TOO_SMALL = 336;
    public static final int CKR_SAVED_STATE_INVALID = 352;
    public static final int CKR_INFORMATION_SENSITIVE = 368;
    public static final int CKR_STATE_UNSAVEABLE = 384;
    public static final int CKR_CRYPTOKI_NOT_INITIALIZED = 400;
    public static final int CKR_CRYPTOKI_ALREADY_INITIALIZED = 401;
    public static final int CKR_MUTEX_BAD = 416;
    public static final int CKR_MUTEX_NOT_LOCKED = 417;
    public static final int CKR_NEW_PIN_MODE = 432;
    public static final int CKR_NEXT_OTP = 433;
    public static final int CKR_EXCEEDED_MAX_ITERATIONS = 437;
    public static final int CKR_FIPS_SELF_TEST_FAILED = 438;
    public static final int CKR_LIBRARY_LOAD_FAILED = 439;
    public static final int CKR_PIN_TOO_WEAK = 440;
    public static final int CKR_PUBLIC_KEY_INVALID = 441;
    public static final int CKR_FUNCTION_REJECTED = 512;
    public static final int CKR_TOKEN_RESOURCE_EXCEEDED = 513;
    public static final int CKR_VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int CKR_NOT_FROM_PKCS11_DLL = -2076639058;
    private int a;

    public Pkcs11Exception(String string, int n10) {
        super(string);
        this.a = n10;
    }

    public int getPkcs11ReturnCode() {
        return this.a;
    }

    public String getPkcs11ReturnCodeAsText() {
        switch (this.a) {
            case 0: {
                return "CKR_OK";
            }
            case 1: {
                return "CKR_CANCEL";
            }
            case 2: {
                return "CKR_HOST_MEMORY";
            }
            case 3: {
                return "CKR_SLOT_ID_INVALID";
            }
            case 5: {
                return "CKR_GENERAL_ERROR";
            }
            case 6: {
                return "CKR_FUNCTION_FAILED";
            }
            case 7: {
                return "CKR_ARGUMENTS_BAD";
            }
            case 8: {
                return "CKR_NO_EVENT";
            }
            case 9: {
                return "CKR_NEED_TO_CREATE_THREADS";
            }
            case 10: {
                return "CKR_CANT_LOCK";
            }
            case 16: {
                return "CKR_ATTRIBUTE_READ_ONLY";
            }
            case 17: {
                return "CKR_ATTRIBUTE_SENSITIVE";
            }
            case 18: {
                return "CKR_ATTRIBUTE_TYPE_INVALID";
            }
            case 19: {
                return "CKR_ATTRIBUTE_VALUE_INVALID";
            }
            case 27: {
                return "CKR_ACTION_PROHIBITED";
            }
            case 32: {
                return "CKR_DATA_INVALID";
            }
            case 33: {
                return "CKR_DATA_LEN_RANGE";
            }
            case 48: {
                return "CKR_DEVICE_ERROR";
            }
            case 49: {
                return "CKR_DEVICE_MEMORY";
            }
            case 50: {
                return "CKR_DEVICE_REMOVED";
            }
            case 64: {
                return "CKR_ENCRYPTED_DATA_INVALID";
            }
            case 65: {
                return "";
            }
            case 66: {
                return "CKR_AEAD_DECRYPT_FAILED";
            }
            case 80: {
                return "CKR_FUNCTION_CANCELED";
            }
            case 81: {
                return "CKR_FUNCTION_NOT_PARALLEL";
            }
            case 84: {
                return "CKR_FUNCTION_NOT_SUPPORTED";
            }
            case 96: {
                return "CKR_KEY_HANDLE_INVALID";
            }
            case 98: {
                return "CKR_KEY_SIZE_RANGE";
            }
            case 99: {
                return "CKR_KEY_TYPE_INCONSISTENT";
            }
            case 100: {
                return "CKR_KEY_NOT_NEEDED";
            }
            case 101: {
                return "CKR_KEY_CHANGED";
            }
            case 102: {
                return "CKR_KEY_NEEDED";
            }
            case 103: {
                return "CKR_KEY_INDIGESTIBLE";
            }
            case 104: {
                return "CKR_KEY_FUNCTION_NOT_PERMITTED";
            }
            case 105: {
                return "CKR_KEY_NOT_WRAPPABLE";
            }
            case 106: {
                return "CKR_KEY_UNEXTRACTABLE";
            }
            case 112: {
                return "CKR_MECHANISM_INVALID";
            }
            case 113: {
                return "CKR_MECHANISM_PARAM_INVALID";
            }
            case 130: {
                return "CKR_OBJECT_HANDLE_INVALID";
            }
            case 144: {
                return "CKR_OPERATION_ACTIVE";
            }
            case 145: {
                return "CKR_OPERATION_NOT_INITIALIZED";
            }
            case 160: {
                return "CKR_PIN_INCORRECT";
            }
            case 161: {
                return "CKR_PIN_INVALID";
            }
            case 162: {
                return "CKR_PIN_LEN_RANGE";
            }
            case 163: {
                return "CKR_PIN_EXPIRED";
            }
            case 164: {
                return "CKR_PIN_LOCKED";
            }
            case 176: {
                return "CKR_SESSION_CLOSED";
            }
            case 177: {
                return "CKR_SESSION_COUNT";
            }
            case 179: {
                return "CKR_SESSION_HANDLE_INVALID";
            }
            case 180: {
                return "CKR_SESSION_PARALLEL_NOT_SUPPORTED";
            }
            case 181: {
                return "CKR_SESSION_READ_ONLY";
            }
            case 182: {
                return "CKR_SESSION_EXISTS";
            }
            case 183: {
                return "CKR_SESSION_READ_ONLY_EXISTS";
            }
            case 184: {
                return "CKR_SESSION_READ_WRITE_SO_EXISTS";
            }
            case 192: {
                return "CKR_SIGNATURE_INVALID";
            }
            case 193: {
                return "CKR_SIGNATURE_LEN_RANGE";
            }
            case 208: {
                return "CKR_TEMPLATE_INCOMPLETE";
            }
            case 209: {
                return "CKR_TEMPLATE_INCONSISTENT";
            }
            case 224: {
                return "CKR_TOKEN_NOT_PRESENT";
            }
            case 225: {
                return "CKR_TOKEN_NOT_RECOGNIZED";
            }
            case 226: {
                return "CKR_TOKEN_WRITE_PROTECTED";
            }
            case 240: {
                return "CKR_UNWRAPPING_KEY_HANDLE_INVALID";
            }
            case 241: {
                return "CKR_UNWRAPPING_KEY_SIZE_RANGE";
            }
            case 242: {
                return "CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT";
            }
            case 256: {
                return "CKR_USER_ALREADY_LOGGED_IN";
            }
            case 257: {
                return "CKR_USER_NOT_LOGGED_IN";
            }
            case 258: {
                return "CKR_USER_PIN_NOT_INITIALIZED";
            }
            case 259: {
                return "CKR_USER_TYPE_INVALID";
            }
            case 260: {
                return "CKR_USER_ANOTHER_ALREADY_LOGGED_IN";
            }
            case 261: {
                return "CKR_USER_TOO_MANY_TYPES";
            }
            case 272: {
                return "CKR_WRAPPED_KEY_INVALID";
            }
            case 274: {
                return "CKR_WRAPPED_KEY_LEN_RANGE";
            }
            case 275: {
                return "CKR_WRAPPING_KEY_HANDLE_INVALID";
            }
            case 276: {
                return "CKR_WRAPPING_KEY_SIZE_RANGE";
            }
            case 277: {
                return "CKR_WRAPPING_KEY_TYPE_INCONSISTENT";
            }
            case 288: {
                return "CKR_RANDOM_SEED_NOT_SUPPORTED";
            }
            case 289: {
                return "CKR_RANDOM_NO_RNG";
            }
            case 304: {
                return "CKR_DOMAIN_PARAMS_INVALID";
            }
            case 320: {
                return "CKR_CURVE_NOT_SUPPORTED";
            }
            case 336: {
                return "CKR_BUFFER_TOO_SMALL";
            }
            case 352: {
                return "CKR_SAVED_STATE_INVALID";
            }
            case 368: {
                return "CKR_INFORMATION_SENSITIVE";
            }
            case 384: {
                return "CKR_STATE_UNSAVEABLE";
            }
            case 400: {
                return "CKR_CRYPTOKI_NOT_INITIALIZED";
            }
            case 401: {
                return "CKR_CRYPTOKI_ALREADY_INITIALIZED";
            }
            case 416: {
                return "CKR_MUTEX_BAD";
            }
            case 417: {
                return "CKR_MUTEX_NOT_LOCKED";
            }
            case 432: {
                return "CKR_NEW_PIN_MODE";
            }
            case 433: {
                return "CKR_NEXT_OTP";
            }
            case 437: {
                return "CKR_EXCEEDED_MAX_ITERATIONS";
            }
            case 438: {
                return "CKR_FIPS_SELF_TEST_FAILED";
            }
            case 439: {
                return "CKR_LIBRARY_LOAD_FAILED";
            }
            case 440: {
                return "CKR_PIN_TOO_WEAK";
            }
            case 441: {
                return "CKR_PUBLIC_KEY_INVALID";
            }
            case 512: {
                return "CKR_FUNCTION_REJECTED";
            }
            case 513: {
                return "CKR_TOKEN_RESOURCE_EXCEEDED";
            }
            case -2076639058: {
                return "Error from SecCommerce PKCS#11 wrapper DLL";
            }
            case -2147483648: {
                return "CKR_VENDOR_DEFINED";
            }
        }
        return "Unknown PKCS#11 return code " + Integer.toHexString(this.a);
    }

    @Override
    public String toString() {
        return this.getLocalizedMessage() + " " + this.getPkcs11ReturnCodeAsText();
    }
}

