/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.secsigner.soap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import seccommerce.secsignerext.ajh;
import seccommerce.secsignerext.be4;
import seccommerce.secsignerext.bfs;
import seccommerce.secsignerext.cg_;
import seccommerce.secsignerext.os;
import seccommerce.secsignersigg.SecSigner;
import seccommerce.secsignersigg.SecSignerException;

public class SecSignerSoap
extends Thread {
    private be4 a;
    private SecSigner b;
    private ServerSocket c;
    private String d;
    private boolean e;

    public static void main(String[] stringArray) {
        String string = "Usage: SecSignerSoap -port <SOAP server port number> [-bindaddr <SOAP server port binding address>] [-debugfolder <debug folder>] [-debugsoap]";
        if (stringArray.length < 2) {
            System.out.println(string);
            System.exit(1);
        }
        int n10 = -1;
        String string2 = null;
        String string3 = null;
        boolean bl10 = false;
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            String string4;
            String string5 = stringArray[i10];
            String string6 = string4 = i10 < stringArray.length - 1 ? stringArray[i10 + 1] : null;
            if ("-port".equals(string5)) {
                if (null == string4) {
                    System.out.println("Command line parameter -port requires an argument (the port number).");
                    System.exit(2);
                }
                try {
                    n10 = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    System.out.println("Command line parameter <SOAP server port number> has to be an integer.");
                    System.exit(3);
                }
                ++i10;
                continue;
            }
            if ("-bindaddr".equals(string5)) {
                if (null == string4) {
                    System.out.println("Command line parameter -bindaddr requires an argument (the IP address to bind the SOAP server port to).");
                    System.exit(8);
                }
                string2 = string4;
                ++i10;
                continue;
            }
            if ("-debugfolder".equals(string5)) {
                if (null == string4) {
                    System.out.println("Command line parameter -debugfolder requires an argument (the folder's name).");
                    System.exit(4);
                }
                string3 = string4;
                ++i10;
                continue;
            }
            if ("-debugsoap".equals(string5)) {
                bl10 = true;
                continue;
            }
            System.out.println("Unsupported parameter '" + string5 + "'. " + string);
            System.exit(5);
        }
        if (n10 < 0) {
            System.out.println("Command line parameter -port missing.");
            System.exit(6);
        }
        if (bl10 && string3 == null) {
            System.out.println("If parameter -debugsoap is set then the parameter -debugfolder needs to be set too.");
            System.exit(7);
        }
        try {
            new SecSignerSoap(n10, string2, string3, bl10).run();
        }
        catch (SecSignerException secSignerException) {
            os.a(secSignerException, "Could not create the SecSigner");
            System.exit(19);
        }
    }

    public SecSignerSoap(int n10, String string, String string2, boolean bl10) throws SecSignerException {
        String string3;
        String string4;
        Object object;
        this.d = string2;
        this.e = bl10;
        try {
            object = InetAddress.getByName(string == null ? "localhost" : string);
            os.c("Binding SecSigner's SOAP server to " + object + " port " + n10 + ".");
            this.c = new ServerSocket(n10, 0, (InetAddress)object);
        }
        catch (IOException iOException) {
            os.a(iOException, "Could not bind the SOAP server socket to port " + n10);
            System.exit(20);
        }
        switch (bfs.a1()) {
            case a: {
                object = "secsigner.properties";
                break;
            }
            case b: {
                object = "secsignerB.properties";
                break;
            }
            case c: {
                object = "secsignerC.properties";
                break;
            }
            default: {
                throw new SecSignerException("Illegal SecSigner config selection.");
            }
        }
        try {
            string4 = null;
            string3 = new cg_().a("SecSigner.jar", string4).getAbsolutePath();
        }
        catch (IOException iOException) {
            throw new SecSignerException("SecSigner's program archive not found: " + iOException.getMessage(), (Throwable)iOException);
        }
        string4 = string3 + '/' + (String)object;
        os.c("Loading SecSigner properties from " + string4);
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string4);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("Could not load SecSigner's properties file: " + exception);
            System.exit(21);
        }
        this.b = new SecSigner(null, properties, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Socket socket = null;
            long l10 = 0L;
            try {
                socket = this.c.accept();
                l10 = System.currentTimeMillis();
                this.a(socket);
            }
            catch (Exception exception) {
                os.a(exception, "Communication error with SecSigner SOAP client");
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                os.a(throwable, "SecSigner SOAP system error");
            }
            finally {
                if (null != socket) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        os.b("Socket to SecSigner SOAP client could not be closed: " + exception);
                        os.a(exception);
                    }
                }
            }
            long l11 = System.currentTimeMillis();
            long l12 = l11 - l10;
            os.c("SOAP request in " + l12 + " milliseconds processed.");
        }
    }

    private final void a(Socket socket) throws ajh, IOException {
        File file = null;
        File file2 = null;
        if (this.d != null && this.e) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
                file = new File(new File(this.d), "SOAP-" + simpleDateFormat.format(new Date()) + "-Request.xml");
                file2 = new File(new File(this.d), "SOAP-" + simpleDateFormat.format(new Date()) + "-Response.xml");
            }
            catch (Exception exception) {
                os.a("Could not write SOAP response to the debug folder '" + this.d + "': " + exception.getMessage());
            }
        }
        this.a = new be4(this.e);
        this.a.a(socket.getInputStream(), socket.getOutputStream(), "http://localhost:" + socket.getLocalPort() + "/", file, file2, this.b);
    }
}

