/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.secsignerext;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import seccommerce.secpki.bo.IdentUserType;
import seccommerce.secpki.bo.IdentifiedUser;
import seccommerce.secpki.bo.RemSigProvAccnt;
import seccommerce.secsignerext.ah5;
import seccommerce.secsignerext.ah7;
import seccommerce.secsignerext.aih;
import seccommerce.secsignerext.ais;
import seccommerce.secsignerext.ajh;
import seccommerce.secsignerext.b0;
import seccommerce.secsignerext.b2n;
import seccommerce.secsignerext.b2p;
import seccommerce.secsignerext.b2q;
import seccommerce.secsignerext.b2s;
import seccommerce.secsignerext.b_p;
import seccommerce.secsignerext.bz9;
import seccommerce.secsignerext.cc6;
import seccommerce.secsignerext.cca;
import seccommerce.secsignerext.cct;
import seccommerce.secsignerext.os;
import seccommerce.user.bo.IdProfile;

@b2p(a=b2q.IDSERVER, b=b2s.REQUEST)
public class bwq {
    @b2n
    private bz9 a;

    public Map<Long, IdentifiedUser> a(@NotNull Collection<Long> collection) throws ajh {
        List<IdentifiedUser> list;
        Objects.requireNonNull(collection, "getForUserIdIds: userIdIds must not be null");
        if (collection.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            list = this.a.a(collection);
        }
        catch (b_p b_p2) {
            throw new ajh("Error while trying to get IdentifiedUser for userIdIds " + collection, b_p2);
        }
        return list.stream().collect(Collectors.toMap(IdentifiedUser::c, Function.identity()));
    }

    public List<IdentifiedUser> a(@NotNull Long l10) throws ajh {
        Objects.requireNonNull(l10, "getForExternalUserIds: orgId must not be null");
        try {
            return this.a.c(l10);
        }
        catch (b_p b_p2) {
            throw new ajh("Error while trying to get IdentifiedUser for external users", b_p2);
        }
    }

    @Nullable
    public IdentifiedUser a(@NotNull RemSigProvAccnt remSigProvAccnt) throws ajh {
        Objects.requireNonNull(remSigProvAccnt, "getForSignMe: remSigProvAccnt must not be null");
        return this.a(remSigProvAccnt.b(), remSigProvAccnt.c(), remSigProvAccnt.e());
    }

    @Nullable
    private final IdentifiedUser a(@NotNull Long l10, @Nullable Long l11, @Nullable Long l12) throws ajh {
        Objects.requireNonNull(l10, "getForSignMe: orgId must not be null");
        if (l11 == null && l12 == null) {
            return null;
        }
        if (l11 != null && l12 != null) {
            throw new IllegalArgumentException("Cannot get IdentifiedUser for signMe user if both userIdId and externalUserIdId are set");
        }
        try {
            return l11 != null ? this.a.a(l10, l11) : this.a.b(l10, l12);
        }
        catch (b_p b_p2) {
            throw new ajh("Error while trying to get IdentifiedUser for orgId " + l10 + " and userIdId " + l11 + ", externalUserId " + l12, b_p2);
        }
    }

    public void a(@NotNull Long l10, @NotNull String string, @NotNull aih aih2, @NotNull RemSigProvAccnt remSigProvAccnt) throws ajh {
        Objects.requireNonNull(l10, "createOrUpdateByGettingSignMeData: orgId must not be null");
        Objects.requireNonNull(string, "createByGettingSignMeData: identityId must not be null");
        Objects.requireNonNull(aih2, "createByGettingSignMeData: identityVerifier must not be null");
        Objects.requireNonNull(remSigProvAccnt, "createByGettingSignMeData: remSigProvAccnt must not be null");
        if (remSigProvAccnt.c() == null && remSigProvAccnt.e() == null) {
            throw new IllegalArgumentException("Cannot createByGettingSignMeData: Either userIdId or externalUserId needs to be set");
        }
        if (remSigProvAccnt.c() != null && remSigProvAccnt.e() != null) {
            throw new IllegalArgumentException("Cannot createByGettingSignMeData: Only one of userIdId or externalUserId is allowed to be set");
        }
        if (!aih.a(string)) {
            throw new ajh("Cannot createByGettingSignMeData: Passed identityId is not a full sign me identity id");
        }
        cc6 cc62 = bwq.a(aih2, string);
        if (cc62.c() != ah5.e && cc62.c() != ah5.f) {
            os.f("Not creating a IdentifiedUser for userIdId: " + remSigProvAccnt.c() + ", externalUserId: " + remSigProvAccnt.e() + " because ident status is " + (Object)((Object)cc62.c()));
            return;
        }
        cct cct2 = remSigProvAccnt.c() != null ? cct.a(l10, remSigProvAccnt.c(), cc62.a(), cc62.b()) : cct.b(l10, remSigProvAccnt.e(), cc62.a(), cc62.b());
        this.a(cct2, string);
    }

    private static cc6 a(@NotNull aih aih2, @NotNull String string) {
        Objects.requireNonNull(aih2, "getCurrentSignMeData: identityVerifier must not be null");
        Objects.requireNonNull(string, "getCurrentSignMeData: identityId must not be null");
        ah7 ah72 = aih2.c(string);
        ais ais2 = aih2.e(string);
        Date date = ais2.d();
        ah5 ah52 = ais2.c();
        return new cc6(ah72, date, ah52);
    }

    public void a(@NotNull Long l10, @NotNull Long l11) throws ajh {
        Objects.requireNonNull(l10, "createInternalIdentifiedUserForSignMe: orgId must not be null");
        Objects.requireNonNull(l11, "createInternalIdentifiedUserForSignMe: userIdId must not be null");
        IdentifiedUser identifiedUser = new IdentifiedUser();
        identifiedUser.a(l10);
        identifiedUser.b(l11);
        identifiedUser.a(IdentUserType.a.a.a());
        IdentifiedUser identifiedUser2 = this.a(l10, l11, null);
        if (identifiedUser2 != null) {
            os.f("Not creating a empty IdentifiedUser for userIdId " + l11 + " because an entry already exists");
            return;
        }
        try {
            this.a.a(identifiedUser);
        }
        catch (b_p b_p2) {
            throw new ajh("Could not create a new IdentifiedUser for orgId " + l10 + " and useridid " + l11, b_p2);
        }
    }

    public void b(@NotNull Long l10, @NotNull Long l11) throws ajh {
        Objects.requireNonNull(l10, "createExternalIdentifiedUserForSignMe: orgId must not be null");
        IdentifiedUser identifiedUser = this.a(l10, null, l11);
        if (identifiedUser != null) {
            os.f("Not creating a empty IdentifiedUser for external userId " + l11 + " because an entry already exists");
            return;
        }
        IdentifiedUser identifiedUser2 = new IdentifiedUser();
        identifiedUser2.a(l10);
        identifiedUser2.c(l11);
        identifiedUser2.a(IdentUserType.a.a.a());
        try {
            this.a.a(identifiedUser2);
        }
        catch (b_p b_p2) {
            throw new ajh("Could not create a new IdentifiedUser for orgId " + l10 + " and external user id " + l11, b_p2);
        }
    }

    private final void a(@NotNull cct cct2, @NotNull String string) throws ajh {
        Objects.requireNonNull(cct2, "createOrUpdateForSignMeUser: updateTO must not be null");
        Objects.requireNonNull(string, "createOrUpdateForSignMeUser: signMeIdentityId must not be null");
        IdentifiedUser identifiedUser = this.a(cct2.a(), cct2.b(), cct2.c());
        IdentifiedUser identifiedUser2 = new IdentifiedUser();
        identifiedUser2.a(cct2.a());
        identifiedUser2.b(cct2.b());
        identifiedUser2.c(cct2.c());
        identifiedUser2.a(IdentUserType.a.a.a());
        identifiedUser2.e(string);
        identifiedUser2.d(cct2.e());
        bwq.a(identifiedUser2, cct2.d());
        try {
            if (identifiedUser == null) {
                this.a.a(identifiedUser2);
            } else {
                IdentifiedUser identifiedUser3 = new IdentifiedUser();
                identifiedUser3.e(identifiedUser.v());
                this.a.a(identifiedUser3, identifiedUser2);
            }
        }
        catch (b_p b_p2) {
            throw new ajh("Error while trying to create or update IdentifiedUser for userIdId:" + cct2.b() + " / externalUserId:" + cct2.c(), b_p2);
        }
    }

    public void a(@NotNull Long l10, @NotNull cct cct2) throws ajh {
        Objects.requireNonNull(l10, "updateForSignMeUser: identifiedUserId must not be null");
        Objects.requireNonNull(cct2, "updateForSignMeUser: updateTO must not be null");
        this.a(l10, cct2, null);
    }

    public void a(@NotNull Long l10, @NotNull cct cct2, @Nullable String string) throws ajh {
        Objects.requireNonNull(l10, "updateForSignMeUser: identifiedUserId must not be null");
        Objects.requireNonNull(cct2, "updateForSignMeUser: updateTO must not be null");
        IdentifiedUser identifiedUser = new IdentifiedUser();
        identifiedUser.e(l10);
        IdentifiedUser identifiedUser2 = new IdentifiedUser();
        identifiedUser2.d(cct2.e());
        bwq.a(identifiedUser2, cct2.d());
        identifiedUser2.e(string);
        try {
            this.a.a(identifiedUser, identifiedUser2);
        }
        catch (b_p b_p2) {
            throw new ajh("Error while trying to update IdentifiedUser for userIdId:" + cct2.b() + " / externalUserId:" + cct2.c(), b_p2);
        }
    }

    private static void a(@NotNull IdentifiedUser identifiedUser, @NotNull ah7 ah72) throws ajh {
        Objects.requireNonNull(identifiedUser, "setPersonValues: identifiedUser must not be null");
        Objects.requireNonNull(ah72, "setPersonValues: person must not be null");
        identifiedUser.c(ah72.f());
        identifiedUser.d(ah72.e());
        identifiedUser.f(ah72.a());
        identifiedUser.b(new Date());
        try {
            identifiedUser.c(b0.a(ah72.i()));
        }
        catch (ParseException parseException) {
            throw new ajh("Could not parse date of birth with value " + ah72.i() + " to date object", parseException);
        }
    }

    public static boolean a(@NotNull IdentifiedUser identifiedUser, @NotNull IdProfile idProfile) {
        Objects.requireNonNull(identifiedUser, "isIdentDataMatchingIdProfile: identifiedUser must not be null");
        Objects.requireNonNull(idProfile, "isIdentDataMatchingIdProfile: idProfile must not be null");
        if (identifiedUser.c() == null) {
            throw new IllegalArgumentException("Cannot check if IdentifiedUser matches IdProfile: Identified User is not an user");
        }
        if (!identifiedUser.c().equals(idProfile.getUserIdId())) {
            throw new IllegalArgumentException("IdentifiedUser userIdId " + identifiedUser.c() + " does not match IdProfile userIdId " + idProfile.getUserIdId());
        }
        if (!Objects.equals(idProfile.getFirstName(), identifiedUser.f())) {
            return false;
        }
        if (!Objects.equals(idProfile.getLastName(), identifiedUser.g())) {
            return false;
        }
        if (!Objects.equals(idProfile.getEmailAddress(), identifiedUser.bp()) || !idProfile.getEmailAddressVerifd().booleanValue()) {
            return false;
        }
        return b0.a(idProfile.getBirthDate(), identifiedUser.h());
    }

    public static boolean a(@NotNull IdentifiedUser identifiedUser, @NotNull cca cca2) {
        Objects.requireNonNull(identifiedUser, "isExternalIdentDataMatchingContact: identifiedUser must not be null");
        Objects.requireNonNull(cca2, "isExternalIdentDataMatchingContact: contactResultTO must not be null");
        if (identifiedUser.e() == null) {
            throw new IllegalArgumentException("Cannot check if IdentifiedUser matches ContactResultTO: Identified User is not an external person");
        }
        if (cca2.c() == null || !cca2.c().equalsIgnoreCase(identifiedUser.bp())) {
            return false;
        }
        if (cca2.e() == null || !cca2.e().equalsIgnoreCase(identifiedUser.f())) {
            return false;
        }
        return cca2.f() != null && cca2.f().equalsIgnoreCase(identifiedUser.g());
    }

    public void a(@NotNull Long l10, @NotNull Set<Long> set) throws ajh {
        long l11;
        Objects.requireNonNull(l10, "deleteUserData: orgId must not be null");
        Objects.requireNonNull(set, "deleteUserData: userIdIds must not be null");
        if (set.isEmpty()) {
            return;
        }
        try {
            l11 = this.a.a(l10, set);
        }
        catch (b_p b_p2) {
            throw new ajh("Could not delete data in IdentifiedUser table for userIdIds " + set, b_p2);
        }
        os.c("Deleted " + l11 + " IdentifiedUser objects for userIdIds " + set);
    }

    public void b(@NotNull Long l10, @NotNull Set<Long> set) throws ajh {
        long l11;
        Objects.requireNonNull(l10, "deleteUserData: orgId must not be null");
        Objects.requireNonNull(set, "deleteUserData: userIdIds must not be null");
        if (set.isEmpty()) {
            return;
        }
        try {
            l11 = this.a.b(l10, set);
        }
        catch (b_p b_p2) {
            throw new ajh("Could not delete data in IdentifiedUser table for userIdIds " + set, b_p2);
        }
        os.c("Deleted " + l11 + " IdentifiedUser objects for userIdIds " + set);
    }

    public void c(@NotNull Long l10, @NotNull Long l11) throws ajh {
        Objects.requireNonNull(l10, "deleteExternalUserData: orgId must not be null");
        Objects.requireNonNull(l11, "deleteExternalUserData: externalUserId must not be null");
        this.c(l10, Collections.singleton(l11));
    }

    public void c(@NotNull Long l10, @NotNull Set<Long> set) throws ajh {
        long l11;
        Objects.requireNonNull(l10, "deleteExternalUserData: orgId must not be null");
        Objects.requireNonNull(set, "deleteExternalUserData: externalUserIds must not be null");
        try {
            l11 = this.a.c(l10, set);
        }
        catch (b_p b_p2) {
            throw new ajh("Could not delete data in IdentifiedUser table for external userIds " + set, b_p2);
        }
        os.c("Deleted " + l11 + " IdentifiedUser objects for externalUserIds " + set);
    }

    public void b(@NotNull Long l10) throws ajh {
        long l11;
        Objects.requireNonNull(l10, "deleteExternalUserData: orgId must not be null");
        try {
            l11 = this.a.d(l10);
        }
        catch (b_p b_p2) {
            throw new ajh("Could not delete data in IdentifiedUser table for orgId " + l10, b_p2);
        }
        os.c("Deleted " + l11 + " IdentifiedUser objects for orgId " + l10);
    }
}

