/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CRC32Helper {
    private static final Logger _logger = LogManager.getLogger(CRC32Helper.class);

    public static String getCRC32(String source, String encoding) {
        Object retVal = "";
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(source.getBytes(encoding));
            retVal = Long.toHexString(CRC32Helper.getCRC32(bais));
            if (((String)retVal).length() % 2 != 0) {
                retVal = "0" + (String)retVal;
            }
        }
        catch (Exception ex) {
            _logger.error("error calculationg CRC32 of " + source, (Throwable)ex);
        }
        return retVal;
    }

    public static long getCRC32(InputStream is) {
        _logger.debug("<getCRC32> start..");
        long retVal = -1L;
        try {
            CRC32 crc = new CRC32();
            CheckedInputStream cis = new CheckedInputStream(is, crc);
            byte[] data = new byte[1024];
            while (cis.read(data) != -1) {
            }
            retVal = crc.getValue();
        }
        catch (Exception ex) {
            _logger.error("error calculating CRC32", (Throwable)ex);
        }
        _logger.debug("<getCRC32> end.");
        return retVal;
    }

    public static String getCRC32File(String filepath) {
        Object retVal = "";
        try {
            FileInputStream fis = new FileInputStream(filepath);
            retVal = Long.toHexString(CRC32Helper.getCRC32(fis));
            if (((String)retVal).length() % 2 != 0) {
                retVal = "0" + (String)retVal;
            }
        }
        catch (Exception ex) {
            _logger.error("error calculationg CRC32 of " + filepath, (Throwable)ex);
        }
        return retVal;
    }

    public static long getFileSize(String filepath) {
        long retVal = -1L;
        File file = new File(filepath);
        if (file.exists()) {
            retVal = file.length();
        }
        return retVal;
    }
}

