/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertHelper {
    public static X509Certificate readCert(File f) throws Exception {
        FileInputStream inStream = new FileInputStream(f);
        X509Certificate cert = CertHelper.readCert(inStream);
        ((InputStream)inStream).close();
        return cert;
    }

    public static X509Certificate readCert(String path) throws Exception {
        InputStream inStream = CertHelper.class.getResourceAsStream(path);
        X509Certificate cert = CertHelper.readCert(inStream);
        inStream.close();
        return cert;
    }

    public static X509Certificate readCert(InputStream inStream) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
        return x509Cert;
    }

    public static byte[] readByteArray(String path) throws Exception {
        InputStream is = CertHelper.class.getResourceAsStream(path);
        byte[] data = CertHelper.readByteArray(is);
        is.close();
        return data;
    }

    public static byte[] readByteArray(File f) throws Exception {
        FileInputStream is = new FileInputStream(f);
        byte[] data = CertHelper.readByteArray(is);
        ((InputStream)is).close();
        return data;
    }

    public static byte[] readByteArray(InputStream is) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = is.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }
}

