/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import de.itu.util.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public abstract class ITUInitializer {
    private static final Logger _logger = LogManager.getLogger(ITUInitializer.class);
    private static final String KEY_BASE_DIR = "ITUInitializer.BaseDir";
    protected static ITUInitializer _theInstance = null;
    private boolean _isInitialized = false;
    protected File _baseDir = null;
    private Map<String, Properties> _propMap = new HashMap<String, Properties>();

    public static ITUInitializer getInstance() {
        return _theInstance;
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public Properties init(String propFilePath) {
        Properties props = null;
        File propFile = null;
        if (propFilePath != null && propFilePath.length() > 0) {
            propFile = new File(propFilePath);
        }
        if (propFile != null && propFile.exists()) {
            props = this.init(propFile);
        }
        return props;
    }

    protected Properties init(File propFile) {
        Properties props = this._propMap.get(propFile.getAbsolutePath());
        if (props == null) {
            props = new Properties();
            try {
                FileInputStream in = new FileInputStream(propFile);
                props.load(in);
                this._propMap.put(propFile.getAbsolutePath(), props);
            }
            catch (Exception ex) {
                _logger.error("Fehler beim Laden der Properties aus Datei: " + propFile.getAbsolutePath(), (Throwable)ex);
            }
        }
        if (!this._isInitialized && propFile != null) {
            if (propFile.getName().endsWith(".properties")) {
                org.apache.logging.log4j.spi.LoggerContext contextSpi = LogManager.getContext((boolean)false);
                if (contextSpi instanceof LoggerContext) {
                    ((LoggerContext)contextSpi).setConfigLocation(propFile.toURI());
                }
            } else {
                LogUtils.initLogging(Level.INFO);
                _logger.warn("Konfigurationsdatei ist nicht kompatibel mit Log4j2: " + propFile.getAbsolutePath());
            }
            _logger.info("Logger initialisiert aus Datei: " + propFile.getAbsolutePath());
            String userDir = System.getProperty("user.dir");
            this._baseDir = new File(props.getProperty(KEY_BASE_DIR, userDir));
            _logger.info("Basis-Verzeichnis: " + String.valueOf(this._baseDir));
            this._isInitialized = true;
        }
        return props;
    }

    public String getProperty(String key) {
        String val = null;
        if (this._isInitialized) {
            for (Properties props : this._propMap.values()) {
                if (!props.containsKey(key)) continue;
                val = props.getProperty(key);
                _logger.debug("key '" + key + "' found, val=" + val);
                break;
            }
        }
        return val;
    }

    public String getBaseDir() {
        if (this._baseDir != null) {
            return this._baseDir.getAbsolutePath();
        }
        return null;
    }

    public void setBaseDir(File dir) {
        this._baseDir = dir;
    }
}

