/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xml;

import de.itu.util.Dump;
import de.itu.xml.XmlException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.w3c.dom.Document;

public class XalanAdapter {
    private static XalanAdapter theInstance = null;
    private static Logger _logger = LogManager.getLogger(XalanAdapter.class);
    private String _xsltBaseDir = null;

    private XalanAdapter() {
    }

    public static synchronized XalanAdapter getInstance() {
        if (theInstance == null) {
            theInstance = new XalanAdapter();
        }
        return theInstance;
    }

    public void setDebug() {
        TransformerFactory.newInstance().setErrorListener(new MyTrace());
    }

    public MyTransformer prepareTransformation(InputStream is, String xslBaseDir) throws XmlException {
        this._xsltBaseDir = xslBaseDir;
        StreamSource stylesheet = new StreamSource(is);
        return this.prepareTransformation(stylesheet);
    }

    public MyTransformer prepareTransformation(String xslName) throws XmlException {
        File xsl = new File(xslName);
        this._xsltBaseDir = xsl.getParent();
        StreamSource stylesheet = new StreamSource(xslName);
        stylesheet.setSystemId(xslName);
        return this.prepareTransformation(stylesheet);
    }

    private MyTransformer prepareTransformation(StreamSource stylesheet) throws XmlException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (!(factory instanceof TransformerFactoryImpl)) {
            _logger.warn("Unexpected TransformerFactory implementation: " + factory.getClass().getName());
            factory = TransformerFactory.newInstance("org.apache.xalan.processor.TransformerFactoryImpl", null);
        }
        if (!factory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") || !factory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
            throw new XmlException("Invalid TransformerFactory");
        }
        factory.setURIResolver(new MyResolver());
        Transformer t = null;
        try {
            t = factory.newTransformer(stylesheet);
        }
        catch (TransformerConfigurationException e) {
            throw new XmlException(e, "TransformerConfigurationException: " + e.getMessage());
        }
        Dump.getInstance().dumpProperties(t.getOutputProperties());
        return new MyTransformer(t);
    }

    public Document transform(Document in, String xslName) throws XmlException {
        MyTransformer t = this.prepareTransformation(xslName);
        DOMSource input = new DOMSource(in);
        DOMResult output = new DOMResult();
        try {
            t._t.transform(input, output);
        }
        catch (TransformerException e) {
            throw new XmlException(e, "TransformerException: " + e.getMessage());
        }
        return (Document)output.getNode();
    }

    private class MyTrace
    implements ErrorListener {
        private MyTrace() {
        }

        @Override
        public void warning(TransformerException p0) throws TransformerException {
            _logger.warn("Warning: " + String.valueOf(p0));
        }

        @Override
        public void error(TransformerException p0) throws TransformerException {
            _logger.error("Error: " + String.valueOf(p0));
        }

        @Override
        public void fatalError(TransformerException p0) throws TransformerException {
            _logger.fatal("Fatal: " + String.valueOf(p0));
        }
    }

    public class MyTransformer {
        private Transformer _t;

        private MyTransformer(Transformer t) {
            this._t = t;
        }

        public String getOutputMethod() {
            return this._t.getOutputProperty("method");
        }

        public void setParameter(String name, Object value) {
            this._t.setParameter(name, value);
        }

        public Document transform(Document in) throws XmlException {
            DOMSource input = new DOMSource(in);
            DOMResult output = new DOMResult();
            try {
                this._t.transform(input, output);
            }
            catch (TransformerException e) {
                throw new XmlException(e, "TransformerException: " + e.getMessage());
            }
            return (Document)output.getNode();
        }

        public void transform(Document in, String out) throws XmlException {
            DOMSource input = new DOMSource(in);
            StreamResult output = null;
            try {
                output = new StreamResult(new FileOutputStream(out));
            }
            catch (FileNotFoundException e) {
                throw new XmlException(e, "FileNotFoundException: " + e.getMessage());
            }
            try {
                this._t.transform(input, output);
            }
            catch (TransformerException e) {
                throw new XmlException(e, "TransformerException: " + e.getMessage());
            }
        }

        public void transform(StreamSource in, String out) throws XmlException {
            StreamResult output = null;
            try {
                output = new StreamResult(new FileOutputStream(out));
            }
            catch (FileNotFoundException e) {
                throw new XmlException(e, "FileNotFoundException: " + e.getMessage());
            }
            try {
                this._t.transform(in, output);
            }
            catch (TransformerException e) {
                throw new XmlException(e, "TransformerException: " + e.getMessage());
            }
        }
    }

    public class MyResolver
    implements URIResolver {
        @Override
        public Source resolve(String href, String base) throws TransformerException {
            StreamSource src = null;
            _logger.debug("<resolve> href=" + href + ", base=" + base);
            String name = XalanAdapter.this._xsltBaseDir + "/" + href;
            InputStream is = XalanAdapter.class.getResourceAsStream(name);
            if (is != null) {
                src = new StreamSource(is);
                _logger.debug("<resolve> source found: " + name);
            } else {
                _logger.debug("<resolve> source not found: " + name);
            }
            return src;
        }
    }
}

