/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xmlsec;

import de.consist.bmu.rule.xpath.XPathFassade;
import de.itu.xml.DateToXsdDatetimeFormatter;
import de.itu.xml.XmlUtil;
import de.itu.xmlsec.KeyStoreAdapter;
import de.itu.xmlsec.RemoteSignService;
import de.itu.xmlsec.XmlSecException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xml.security.algorithms.implementations.SignatureECDSA;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.XMLUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSecSignFassade {
    private static final Logger _logger = LogManager.getLogger(XmlSecSignFassade.class);
    private static final String DSIG_PREFIX = "ds";
    private static final String XAdES_NS = "http://uri.etsi.org/01903/v1.3.2#";
    private static final String XAdES_NS_PREFIX = "xades";
    private static final String XAdES_QualProps = "xades:QualifyingProperties";
    private static final String XAdES_Target = "Target";
    private static final String XAdES_SignedProps = "xades:SignedProperties";
    private static final String XAdES_SignedSigProps = "xades:SignedSignatureProperties";
    private static final String XAdES_SigningTime = "xades:SigningTime";
    private static final String XAdES_SigningCert = "xades:SigningCertificate";
    private static final String XAdES_SigningCertV2 = "xades:SigningCertificateV2";
    private static final String XAdES_SignedDataObjectProperties = "xades:SignedDataObjectProperties";
    private static final String XAdES_DataObjectFormat = "xades:DataObjectFormat";
    private static final String XAdES_REFERENCE_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    public static final String SIGNATURE_XPATH_INTERSECT = "here()/ancestor::*[6]";
    public static final String SIGNATURE_XPATH_SUBTRACT = "here()/ancestor::*[6]/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']";
    public static final String SIGNATURE_XPATH_SUBTRACT_INCLUDE_FIRSTSIG = "here()/ancestor::*[5]/following-sibbling::*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']";
    public static final byte[] HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes();
    private static XmlSecSignFassade _theInstance = null;
    private X509Certificate _cert = null;
    private PrivateKey _pk = null;
    private KeyStore.PrivateKeyEntry _pke = null;
    private boolean _eIDASFormat = true;

    private XmlSecSignFassade() {
    }

    public static XmlSecSignFassade getInstance() {
        if (_theInstance == null && !(_theInstance = new XmlSecSignFassade()).init()) {
            _logger.error("Fehler beim Initialisieren von XmlSec");
            _theInstance = null;
        }
        return _theInstance;
    }

    public boolean isUsingEIDASFormat() {
        return this._eIDASFormat;
    }

    public void setUseEIDASFormat(boolean eIDASFormat) {
        this._eIDASFormat = eIDASFormat;
    }

    public synchronized boolean init() {
        boolean binitialized = true;
        System.setProperty("org.apache.xml.security.ignoreLineBreaks", "true");
        return binitialized;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected synchronized void loadSignInfos() throws XmlSecException {
        File ksFile = new File(System.getProperty("user.home"), "Asys/mbs.jks");
        if (!ksFile.exists()) {
            _logger.debug("Datei nicht gefunden: " + ksFile.getAbsolutePath());
            return;
        }
        KeyStoreAdapter ksa = KeyStoreAdapter.getInstance(ksFile, "meier".toCharArray());
        if (ksa != null) {
            this._cert = ksa.getCertificate("asys");
            this._pke = ksa.getPrivateKeyEntry("asys", "asys".toCharArray());
            _logger.debug("Zertifikat und PrivateKey geladen.");
            return;
        }
        _logger.error("Fehler beim laden der Zertifikate");
        throw new XmlSecException("Fehler beim Laden des Keystore");
    }

    public boolean loadSignInfos(File ksFile, char[] pw) throws XmlSecException, FileNotFoundException {
        boolean retVal = false;
        if (ksFile.exists()) {
            retVal = this.loadSignInfos(ksFile.getAbsolutePath().toLowerCase(), new FileInputStream(ksFile), pw);
        }
        return retVal;
    }

    public boolean loadSignInfos(String ksName, InputStream in, char[] pw) throws XmlSecException {
        boolean retVal = false;
        String ksType = "JKS";
        String provider = "SUN";
        String alias = "asys";
        if (ksName.endsWith(".p12") || ksName.endsWith(".pfx")) {
            ksType = "PKCS12";
            provider = "BC";
        }
        KeyStoreAdapter ksa = KeyStoreAdapter.getInstance(ksName, in, pw, ksType, provider);
        if ("PKCS12".equals(ksType)) {
            alias = ksa.getKeyAlias();
        }
        this._cert = ksa.getCertificate(alias);
        this._pke = ksa.getPrivateKeyEntry(alias, pw);
        retVal = true;
        return retVal;
    }

    public void setSignInfos(X509Certificate cert, PrivateKey pk) {
        if (cert != null && pk != null) {
            _logger.info("Setze Zertifikat und privaten Schl\u00fcssel zum signieren: " + cert.getSubjectX500Principal().getName());
            this._cert = cert;
            this._pk = pk;
            this._pke = null;
        } else {
            _logger.warn("Zertifikat und/oder privater Schl\u00fcssel sind ung\u00fcltig!");
        }
    }

    public void setSignInfos(X509Certificate cert, KeyStore.PrivateKeyEntry pk) {
        if (cert != null && pk != null) {
            _logger.info("Setze Zertifikat und privaten Schl\u00fcssel zum signieren: " + cert.getSubjectX500Principal().getName());
            this._cert = cert;
            this._pke = pk;
            this._pk = null;
        } else {
            _logger.warn("Zertifikat und/oder privater Schl\u00fcssel sind ung\u00fcltig!");
        }
    }

    public Document signiere(Document doc, String xPath, String xPathIntersect, String sigID) throws XmlSecException {
        if (doc == null) {
            throw new IllegalArgumentException("Document must not be null");
        }
        try {
            return this.signApache(doc, xPath, sigID);
        }
        catch (Exception e) {
            _logger.error("error signing document", (Throwable)e);
            throw new XmlSecException("<signiere> Unerwarteter Fehler: " + e.getMessage(), e);
        }
    }

    public Document signiere(Document doc, String xPath, String xPathIntersect, String sigID, X509Certificate cert, PrivateKey pk) throws XmlSecException {
        if (doc == null) {
            throw new IllegalArgumentException("Document must not be null");
        }
        Document signedDoc = null;
        X509Certificate certOrg = this._cert;
        PrivateKey pkOrg = this._pk;
        if (cert != null && pk != null) {
            this.setSignInfos(cert, pk);
        }
        try {
            signedDoc = this.signApache(doc, xPath, sigID);
        }
        catch (Exception e) {
            _logger.error("error signing document", (Throwable)e);
            throw new XmlSecException("<signiere> Unerwarteter Fehler: " + e.getMessage(), e);
        }
        finally {
            if (certOrg != null && pkOrg != null) {
                this.setSignInfos(certOrg, pkOrg);
            }
        }
        return signedDoc;
    }

    public Document signiere(Document doc, String xPath, String xPathIntersect, String sigID, X509Certificate cert, KeyStore.PrivateKeyEntry pk) throws XmlSecException {
        if (doc == null) {
            throw new IllegalArgumentException("Document must not be null");
        }
        Document signedDoc = null;
        X509Certificate certOrg = this._cert;
        KeyStore.PrivateKeyEntry pkOrg = this._pke;
        if (cert != null && pk != null) {
            this.setSignInfos(cert, pk);
        }
        try {
            signedDoc = this.signApache(doc, xPath, sigID);
        }
        catch (Exception e) {
            _logger.error("error signing document", (Throwable)e);
            throw new XmlSecException("<signiere> Unerwarteter Fehler: " + e.getMessage(), e);
        }
        finally {
            if (certOrg != null && pkOrg != null) {
                this.setSignInfos(certOrg, pkOrg);
            }
        }
        return signedDoc;
    }

    private Element createXadesSigningCert(Document doc) throws NoSuchAlgorithmException, CertificateEncodingException, NoSuchProviderException {
        Element cert = doc.createElementNS(XAdES_NS, "xades:Cert");
        Element certDigest = doc.createElementNS(XAdES_NS, "xades:CertDigest");
        Element digestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        digestMethod.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
        Element digestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        String digest = Base64.encodeBase64String((byte[])md.digest(this._cert.getEncoded()));
        digestValue.setTextContent(digest);
        certDigest.appendChild(digestMethod);
        certDigest.appendChild(digestValue);
        cert.appendChild(certDigest);
        if (this._eIDASFormat) {
            Element issuerSerialV2 = doc.createElementNS(XAdES_NS, "xades:IssuerSerialV2");
            try {
                X500Name issuerX500Name = new X500Name(this._cert.getIssuerX500Principal().getName());
                GeneralName generalName = new GeneralName(issuerX500Name);
                GeneralNames generalNames = new GeneralNames(generalName);
                BigInteger serialNumber = this._cert.getSerialNumber();
                IssuerSerial issuerSerial = new IssuerSerial(generalNames, serialNumber);
                String issuerBase64 = Base64.encodeBase64String((byte[])issuerSerial.toASN1Primitive().getEncoded("DER"));
                issuerSerialV2.setTextContent(issuerBase64);
                cert.appendChild(issuerSerialV2);
            }
            catch (IOException e) {
                _logger.error("Fehler", (Throwable)e);
            }
        } else {
            Element issuerSerial = doc.createElementNS(XAdES_NS, "xades:IssuerSerial");
            Element x509IssuerName = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerName");
            x509IssuerName.setTextContent(this._cert.getIssuerX500Principal().getName());
            Element x509SerialNumber = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509SerialNumber");
            x509SerialNumber.setTextContent(this._cert.getSerialNumber().toString());
            issuerSerial.appendChild(x509IssuerName);
            issuerSerial.appendChild(x509SerialNumber);
            cert.appendChild(issuerSerial);
        }
        return cert;
    }

    private Element createXadesQualProps(Document doc, String sigID, String spID, String refID) throws CertificateEncodingException, DOMException, NoSuchAlgorithmException, NoSuchProviderException {
        Element qpElement = doc.createElementNS(XAdES_NS, XAdES_QualProps);
        qpElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", XAdES_NS);
        qpElement.setAttributeNS(null, XAdES_Target, "#" + sigID);
        Element spElement = doc.createElementNS(XAdES_NS, XAdES_SignedProps);
        spElement.setAttributeNS(null, "Id", spID);
        spElement.setIdAttribute("Id", true);
        Element sspElement = doc.createElementNS(XAdES_NS, XAdES_SignedSigProps);
        Element stElement = doc.createElementNS(XAdES_NS, XAdES_SigningTime);
        String st = new DateToXsdDatetimeFormatter(TimeZone.getDefault()).format(new Date());
        stElement.setTextContent(st);
        Element scElement = doc.createElementNS(XAdES_NS, this._eIDASFormat ? XAdES_SigningCertV2 : XAdES_SigningCert);
        scElement.appendChild(this.createXadesSigningCert(doc));
        sspElement.appendChild(stElement);
        sspElement.appendChild(scElement);
        spElement.appendChild(sspElement);
        if (this._eIDASFormat) {
            Element signedDataObjectProperties = doc.createElementNS(XAdES_NS, XAdES_SignedDataObjectProperties);
            Element dataObjectFormat = doc.createElementNS(XAdES_NS, XAdES_DataObjectFormat);
            Element mimeType = doc.createElementNS(XAdES_NS, "xades:MimeType");
            mimeType.setTextContent("text/xml");
            dataObjectFormat.setAttributeNS(null, "ObjectReference", "#" + refID);
            dataObjectFormat.appendChild(mimeType);
            signedDataObjectProperties.appendChild(dataObjectFormat);
            spElement.appendChild(signedDataObjectProperties);
        }
        qpElement.appendChild(spElement);
        return qpElement;
    }

    public Document signApache(Document doc, String xPath, String sigID) throws XmlSecException {
        return this.signApache(doc, xPath, sigID, "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1");
    }

    public Document signApache(Document doc, String xPath, String sigID, String signatureMethodURI) throws XmlSecException {
        String spID = XmlUtil.generateID();
        String refID = XmlUtil.generateID();
        try {
            XMLSignature sig = new XMLSignature(doc, null, signatureMethodURI, "http://www.w3.org/2001/10/xml-exc-c14n#");
            sig.setId(sigID);
            Transforms transforms = new Transforms(doc);
            String[][] filters = new String[][]{{"intersect", SIGNATURE_XPATH_INTERSECT}, {"subtract", SIGNATURE_XPATH_SUBTRACT}};
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstances((Document)doc, (String[][])filters));
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            sig.addDocument("", transforms, "http://www.w3.org/2001/04/xmlenc#sha256", refID, "text/xml");
            Transforms transformsXades = new Transforms(doc);
            transformsXades.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            sig.addDocument("#" + spID, transformsXades, "http://www.w3.org/2001/04/xmlenc#sha256", null, XAdES_REFERENCE_TYPE);
            if (this._cert == null) {
                throw new XmlSecException("Kein Zertifikat zum Signieren.", new IllegalStateException("Kein Zertifikat zum Signieren."));
            }
            if (this._eIDASFormat && this._pke != null) {
                X509Data x509Data = new X509Data(doc);
                for (Certificate cert : this._pke.getCertificateChain()) {
                    x509Data.addCertificate((X509Certificate)cert);
                }
                KeyInfo keyInfo = new KeyInfo(doc);
                keyInfo.add(x509Data);
                sig.getElement().appendChild(keyInfo.getElement());
            } else {
                sig.addKeyInfo(this._cert);
                sig.addKeyInfo(this._cert.getPublicKey());
            }
            ObjectContainer oc = new ObjectContainer(doc);
            oc.appendChild((Node)this.createXadesQualProps(doc, sigID, spID, refID));
            sig.appendObject(oc);
            Node parentNode = null;
            parentNode = xPath != null && xPath.length() > 0 ? XPathFassade.getInstance().evaluateNode(doc, xPath) : doc.getDocumentElement();
            parentNode.appendChild(sig.getElement());
            if (this._pke != null) {
                sig.sign((Key)this._pke.getPrivateKey());
            } else if (this._pk != null) {
                sig.sign((Key)this._pk);
            }
            _logger.debug("Signatur mit ID=" + sig.getId() + " erzeugt");
        }
        catch (Exception e) {
            _logger.error("Signieren eines Dokuments mit Apache-XmlSec", (Throwable)e);
            throw new XmlSecException("Fehler beim Signieren eines Dokuments mit Apache-XmlSec", e);
        }
        return doc;
    }

    public Document signRemote(Document doc, String xPath, String sigID, RemoteSignService rss, char[] certPin, String otp, String signatureMethodURI) throws XmlSecException {
        String spID = XmlUtil.generateID();
        String refID = XmlUtil.generateID();
        try {
            this._cert = rss.getCert();
            XMLSignature sig = new XMLSignature(doc, null, signatureMethodURI, "http://www.w3.org/2001/10/xml-exc-c14n#");
            sig.setId(sigID);
            Transforms transforms = new Transforms(doc);
            String[][] filters = new String[][]{{"intersect", SIGNATURE_XPATH_INTERSECT}, {"subtract", SIGNATURE_XPATH_SUBTRACT}};
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstances((Document)doc, (String[][])filters));
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            sig.addDocument("", transforms, "http://www.w3.org/2001/04/xmlenc#sha256", refID, "text/xml");
            Transforms transformsXades = new Transforms(doc);
            transformsXades.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            sig.addDocument("#" + spID, transformsXades, "http://www.w3.org/2001/04/xmlenc#sha256", null, XAdES_REFERENCE_TYPE);
            sig.addKeyInfo(this._cert);
            sig.addKeyInfo(this._cert.getPublicKey());
            ObjectContainer oc = new ObjectContainer(doc);
            oc.appendChild((Node)this.createXadesQualProps(doc, sigID, spID, refID));
            sig.appendObject(oc);
            Node parentNode = null;
            parentNode = xPath != null && xPath.length() > 0 ? XPathFassade.getInstance().evaluateNode(doc, xPath) : doc.getDocumentElement();
            parentNode.appendChild(sig.getElement());
            SignedInfo si = sig.getSignedInfo();
            si.generateDigestValues();
            byte[] signedInfoBytes = si.getCanonicalizedOctetStream();
            byte[] rawSignature = rss.sign(signedInfoBytes, certPin, otp);
            Element sigElem = sig.getElement();
            Element sigValueElem = (Element)sigElem.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0);
            byte[] sigValue = rawSignature;
            if (this._cert.getPublicKey() instanceof ECPublicKey) {
                ECPublicKey ecKey = (ECPublicKey)this._cert.getPublicKey();
                int rawLen = (ecKey.getParams().getCurve().getField().getFieldSize() + 7) / 8;
                sigValue = SignatureECDSA.convertASN1toXMLDSIG((byte[])rawSignature, (int)rawLen);
            }
            sigValueElem.setTextContent(XMLUtils.encodeToString((byte[])sigValue));
        }
        catch (Exception e) {
            _logger.error("Signieren eines Dokuments mit Apache-XmlSec", (Throwable)e);
            throw new XmlSecException("Fehler beim Signieren eines Dokuments mit Apache-XmlSec", e);
        }
        return doc;
    }
}

