/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.ActivityStats;
import com.jamonapi.JAMonListener;
import com.jamonapi.Listeners;
import com.jamonapi.MonKey;
import com.jamonapi.RangeImp;
import java.io.Serializable;

final class MonInternals
implements Serializable {
    private static final long serialVersionUID = 278L;
    static final double MAX_DOUBLE = -1.7976931348623157E308;
    static final double MIN_DOUBLE = Double.MAX_VALUE;
    MonKey key;
    double total = 0.0;
    double min = Double.MAX_VALUE;
    double max = -1.7976931348623157E308;
    double hits = 0.0;
    double sumOfSquares = 0.0;
    double lastValue = 0.0;
    long firstAccess = 0L;
    long lastAccess = 0L;
    boolean isTimeMonitor = false;
    boolean enabled = true;
    boolean trackActivity = false;
    String name = "";
    String displayHeader = "";
    double maxActive = 0.0;
    double totalActive = 0.0;
    boolean isPrimary = false;
    boolean startHasBeenCalled = false;
    private ActivityStats activityStats;
    RangeImp range;
    double allActiveTotal;
    double primaryActiveTotal;
    double thisActiveTotal;
    private Listeners listeners;

    MonInternals() {
    }

    public Listeners createListeners() {
        this.listeners = new Listeners(this);
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null;
    }

    public boolean hasListener(int listenerType) {
        return this.listeners != null && this.listeners.hasListener(listenerType);
    }

    public JAMonListener getListener(int listenerType) {
        return this.listeners.getListenerType(listenerType).getListener();
    }

    public Listeners getListeners() {
        return this.listeners;
    }

    public void setActivityStats(ActivityStats stats) {
        this.activityStats = stats;
    }

    public ActivityStats getActivityStats() {
        return this.activityStats;
    }

    public void incrementActivity() {
        if (this.trackActivity) {
            this.activityStats.allActive.increment();
            if (this.isPrimary) {
                this.activityStats.primaryActive.increment();
            }
        }
    }

    public void decrementActivity() {
        if (this.trackActivity) {
            if (this.isPrimary) {
                this.activityStats.primaryActive.decrement();
            }
            this.activityStats.allActive.decrement();
        }
    }

    public void updateActivity() {
        if (this.trackActivity) {
            this.thisActiveTotal += this.activityStats.thisActive.getCount();
            this.primaryActiveTotal += this.activityStats.primaryActive.getCount();
            this.allActiveTotal += this.activityStats.allActive.getCount();
        }
    }

    public double incrementThisActive() {
        return this.activityStats.thisActive.incrementAndReturn();
    }

    public void decrementThisActive() {
        this.activityStats.thisActive.decrement();
    }

    public void stop(double active) {
        this.totalActive += active;
        this.decrementThisActive();
        this.decrementActivity();
    }

    public void skip() {
        this.decrementThisActive();
        this.decrementActivity();
    }

    public double getThisActiveCount() {
        return this.activityStats.thisActive.getCount();
    }

    public void setThisActiveCount(double value) {
        this.activityStats.thisActive.setCount(value);
    }

    public void reset() {
        this.lastValue = 0.0;
        this.sumOfSquares = 0.0;
        this.total = 0.0;
        this.hits = 0.0;
        this.lastAccess = 0L;
        this.firstAccess = 0L;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.startHasBeenCalled = false;
        this.trackActivity = false;
        this.listeners = null;
        this.totalActive = 0.0;
        this.maxActive = 0.0;
        this.activityStats.thisActive.setCount(0.0);
        this.thisActiveTotal = 0.0;
        this.primaryActiveTotal = 0.0;
        this.allActiveTotal = 0.0;
        if (this.range != null) {
            this.range.reset();
        }
    }
}

