/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.distributed.DistributedUtils;
import com.jamonapi.distributed.JamonDataPersister;
import java.util.Set;
import java.util.TreeSet;

public class HazelcastPersisterImp
implements JamonDataPersister {
    private IMap<String, MonitorComposite> jamonDataMap;
    private HazelcastInstance hazelCast;

    public HazelcastPersisterImp() {
        this.hazelCast = Hazelcast.newHazelcastInstance();
    }

    public HazelcastPersisterImp(HazelcastInstance hazelCast) {
        this.hazelCast = hazelCast;
    }

    @Override
    public Set<String> getInstances() {
        this.intitialize();
        return new TreeSet<String>(this.jamonDataMap.keySet());
    }

    @Override
    public void put() {
        this.put(this.getInstance());
    }

    @Override
    public void put(String key) {
        this.intitialize();
        this.jamonDataMap.set((Object)key, (Object)DistributedUtils.changeInstanceName(key, MonitorFactory.getRootMonitor().copy()));
    }

    @Override
    public MonitorComposite get(String key) {
        this.intitialize();
        return (MonitorComposite)this.jamonDataMap.get((Object)key);
    }

    @Override
    public void remove(String instanceKey) {
        this.intitialize();
        this.jamonDataMap.delete((Object)instanceKey);
    }

    @Override
    public String getInstance() {
        this.intitialize();
        return this.hazelCast.getCluster().getLocalMember().toString();
    }

    public void shutDownHazelCast() {
        this.intitialize();
        this.hazelCast.shutdown();
    }

    private void intitialize() {
        if (this.jamonDataMap == null) {
            this.jamonDataMap = this.hazelCast.getMap(MonitorComposite.class.getCanonicalName());
        }
    }
}

