/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureRSAPSSPadding
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureRSAPSSPadding.class);
    private static final String[] RSA_ALGO = new String[]{"http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"};
    private static final String XPATH_SIGNATURE = "/descendant::" + Namespace.xmldsig.getPrefix() + ":Signature[@Id]";
    private static final String XPATH_ALGMETHOD = "descendant::" + Namespace.xmldsig.getPrefix() + ":SignatureMethod/@Algorithm";

    public RuleImplSignatureRSAPSSPadding(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            NodeList nodeList = xpf.evaluateNodeList(bmuDok.getDocument(), XPATH_SIGNATURE);
            int index = 1;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element sigElem = (Element)nodeList.item(i);
                String sigID = sigElem.getAttribute("Id");
                SignatureVerificationResult svr = bmuDok.getMessageType().getSignatureVerificationResult(sigID);
                if (!svr.isEnabled(this.getRuleDef())) continue;
                String algMethod = xpf.evaluate(sigElem, XPATH_ALGMETHOD);
                LOGGER.debug((Object)(XPATH_ALGMETHOD + ": " + algMethod));
                List<String> rsaAlgoList = Arrays.asList(RSA_ALGO);
                if (!rsaAlgoList.contains(algMethod)) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath f\u00fcr die Ermittlung der zu pr\u00fcfenden Inhalte: ");
        builder.append(XPATH_SIGNATURE + "/" + XPATH_ALGMETHOD + "\n");
        builder.append("Gepr\u00fcfte nicht zul\u00e4ssige Algorithm-URI's: \n");
        builder.append(Arrays.toString(RSA_ALGO));
        return builder.toString();
    }
}

