/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.schema;

import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.BMUMessageTypeEnum;
import de.consist.bmu.rule.BMUVersion;
import de.consist.bmu.rule.RuleFactory;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.config.schema.fxs.FXSConfig;
import de.consist.bmu.rule.config.schema.fxs.FXSConfigHelper;
import de.consist.bmu.rule.config.schema.fxs.FXSSCHEMATYPE;
import de.consist.bmu.rule.config.schema.fxs.FXSTYPE;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.FXSDokument;
import de.consist.bmu.rule.impl.SignatureVerificationResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.util.CertUtils;
import de.consist.bmu.rule.util.DateUtils;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.Serializable;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="messagetype", propOrder={"_bmuMsgTypeEnum", "_isMessage", "_version", "_msgUUID", "_docNr", "_hasSubDocs", "_sigIds", "_signTime", "_en", "_signatureVerificationResultList", "_fxsDokumentList"})
@XmlRootElement(name="MessageType")
public class BMUMessageTypeImpl
implements BMUMessageType,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ENSN_VORLAGELAYER_NAME = "ENSNVorlageLayer";
    private static final String BGS_VORLAGELAYER_NAME = "BGSVorlageLayer";
    private static final String UNS_VORLAGELAYER_NAME = "UNSVorlageLayer";
    private static final Log LOGGER = LogFactory.getLog(BMUMessageTypeImpl.class);
    @XmlElement(name="MessageTypeEnum", type=BMUMessageTypeEnum.class)
    private BMUMessageTypeEnum _bmuMsgTypeEnum;
    @XmlElement(name="Nachricht")
    private boolean _isMessage;
    @XmlElement(name="Version")
    private BMUVersion _version;
    @XmlElement(name="MsgUUID")
    private String _msgUUID;
    @XmlElement(name="DocNr")
    private String _docNr;
    @XmlElement(name="SubDocs")
    private boolean _hasSubDocs;
    @XmlElement(name="SignaturID")
    private List<String> _sigIds;
    @XmlElement(name="SigningTime")
    private Date _signTime;
    @XmlElement(name="EN")
    private BMUMessageType.ENStatus _en;
    @XmlElement(name="SignatureVerificationResult")
    private List<SignatureVerificationResult> _signatureVerificationResultList;
    @XmlElement(name="FXSDokument")
    private List<FXSDokument> _fxsDokumentList;
    public static final BMUVersion BMU_SPEC_VERSION_CURRENT = BMUVersion.V104;
    private static final String BMU_SPEC_VERSION_XPATH = "/msg:Nachricht/@lib:Spezifikationsversion";
    private static final String BMU_SPEC_VERSION_NO_MSG_XPATH = "/*/@lib:Spezifikationsversion";
    private static final String XPATH_BMU_MSG = "count(/msg:Nachricht) > 0";
    private static final String XPATH_MSG_TYPE_NAME = "local-name(/msg:Nachricht/msg:Nutzdaten/*)";
    private static final String XPATH_MSG_TYPE_NAME_FXS = "descendant::*[local-name()='FreieXMLStruktur']";
    private static final String XPATH_MSG_TYPE_NAME_FXS_G11 = "descendant::*[local-name()='AnyXml' and namespace-uri()='Waste-WG-2018-Message']";
    private static final String XPATH_NUTZDATEN_MSG_TYPE_NAME = "local-name(/*)";
    private static final String XPATH_MSGUUID = "/msg:Nachricht/@msg:MsgUUID";

    public BMUMessageTypeImpl() {
    }

    public BMUMessageTypeImpl(BMUMessageTypeEnum bmuMsgTypeEnum) {
        this._bmuMsgTypeEnum = bmuMsgTypeEnum;
        this._isMessage = true;
        this._version = BMUVersion.V104;
        this._msgUUID = null;
        this._docNr = null;
        this._hasSubDocs = false;
        this._sigIds = new ArrayList<String>();
        this._signTime = new Date();
        this._en = BMUMessageType.ENStatus.Unknown;
        this._signatureVerificationResultList = new ArrayList<SignatureVerificationResult>();
        this._fxsDokumentList = new ArrayList<FXSDokument>();
    }

    public final String toString() {
        return this._bmuMsgTypeEnum.toString();
    }

    @Override
    public final BMUMessageTypeEnum getEnumType() {
        return this._bmuMsgTypeEnum;
    }

    @Override
    public final Namespace getNS() {
        return this._bmuMsgTypeEnum.getNS();
    }

    @Override
    public final String[] getXPathNummer() {
        return this._bmuMsgTypeEnum.getXPathNummer();
    }

    @Override
    public final String getBMUType() {
        return this._bmuMsgTypeEnum.getBMUType();
    }

    @Override
    public final boolean isLayerDoc() {
        return this._bmuMsgTypeEnum.isLayerDoc();
    }

    @Override
    public final boolean isMessage() {
        return this._isMessage;
    }

    @Override
    public final BMUVersion getVersion() {
        return this._version;
    }

    @Override
    public final String getMsgUUID() {
        return this._msgUUID;
    }

    @Override
    public final String getName() {
        return this._bmuMsgTypeEnum.getNS().getPrefix() + ":" + this._bmuMsgTypeEnum.toString();
    }

    @Override
    public final String getDocNr() {
        return this._docNr;
    }

    @Override
    public final List<String> getSigIds() {
        return this._sigIds;
    }

    @Override
    public final Date getFirstSignTime() {
        return this._signTime;
    }

    @Override
    public final Date getLastSignTime() {
        Date retVal = new Date(0L);
        for (SignatureVerificationResult svr : this._signatureVerificationResultList) {
            if (!svr.getSigningTime().after(retVal)) continue;
            retVal = svr.getSigningTime();
        }
        return retVal;
    }

    @Override
    public final BMUMessageType.ENStatus getENStatus() {
        return this._en;
    }

    @Override
    public final boolean isIntern() {
        return BMUMessageTypeEnum.RegistrierungsantragZKS.equals((Object)this._bmuMsgTypeEnum) || BMUMessageTypeEnum.RegistrierungsauftragZKS.equals((Object)this._bmuMsgTypeEnum);
    }

    @Override
    public final boolean hasSubDocs() {
        return this._hasSubDocs;
    }

    @Override
    public final List<SignatureVerificationResult> getSignatureVerificationResultList() {
        return this._signatureVerificationResultList;
    }

    @Override
    public final SignatureVerificationResult getSignatureVerificationResult(String sigID) {
        SignatureVerificationResult result = null;
        for (SignatureVerificationResult svr : this._signatureVerificationResultList) {
            if (!sigID.equals(svr.getSignatureID())) continue;
            result = svr;
            break;
        }
        return result;
    }

    public static BMUMessageTypeImpl getMessageType(Document doc) throws BMUException {
        BMUMessageTypeImpl bmt = null;
        try {
            String testEN;
            boolean isMessage = XPathFassade.getInstance().evalBool(doc.getDocumentElement(), XPATH_BMU_MSG);
            String msgTypeName = null;
            String version = null;
            String msgUUID = null;
            if (isMessage) {
                msgTypeName = XPathFassade.getInstance().evaluate(doc, XPATH_MSG_TYPE_NAME);
                version = XPathFassade.getInstance().evaluate(doc, BMU_SPEC_VERSION_XPATH);
                msgUUID = XPathFassade.getInstance().evaluate(doc, XPATH_MSGUUID);
            } else {
                LOGGER.debug((Object)"Document ist keine BMU-Nachricht, pr\u00fcfe auf Nutzdaten..");
                msgTypeName = XPathFassade.getInstance().evaluate(doc, XPATH_NUTZDATEN_MSG_TYPE_NAME);
                version = XPathFassade.getInstance().evaluate(doc, BMU_SPEC_VERSION_NO_MSG_XPATH);
            }
            LOGGER.debug((Object)("BMU-Nachrichtentyp: " + msgTypeName + ", version=" + version));
            BMUMessageTypeEnum bmte = BMUMessageTypeEnum.valueOf(msgTypeName);
            if (BMUMessageTypeEnum.Mitteilung.equals((Object)bmte) && (testEN = XPathFassade.getInstance().evaluate(doc, BMUMessageTypeEnum.ENSNDokument.getXPathNummer()[0])) != null && !testEN.isEmpty()) {
                bmte = BMUMessageTypeEnum.ENSNDokument;
            }
            bmt = new BMUMessageTypeImpl(bmte);
            bmt._isMessage = isMessage;
            bmt._version = BMUVersion.lookupVersion(version);
            bmt._msgUUID = msgUUID;
            String docNr = null;
            String[] xPathNummer = bmte.getXPathNummer();
            for (int i = 0; i < xPathNummer.length; ++i) {
                try {
                    docNr = XPathFassade.getInstance().evaluate(doc.getDocumentElement(), xPathNummer[i]);
                    if (docNr == null || docNr.length() <= 0) continue;
                    docNr = docNr.trim();
                    LOGGER.debug((Object)("Nr ermittelt: " + docNr));
                    break;
                }
                catch (XPathExpressionException ex) {
                    LOGGER.debug((Object)("Nr konnte nicht ermittelt werden: " + ex.getMessage()));
                }
            }
            bmt._docNr = docNr;
            bmt._signTime = new Date();
            bmt.check4SubDocs(doc);
            bmt.checkENSN(doc);
            bmt.checkSignatures(doc);
            bmt.checkFXS(doc);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Auswerten des XPath-Ausdrucks", e);
        }
        return bmt;
    }

    private void checkFXS(Document doc) throws BMUException {
        try {
            FXSConfig fxsConfig;
            NodeList nlFXS = XPathFassade.getInstance().evaluateNodeList(doc, XPATH_MSG_TYPE_NAME_FXS);
            if (nlFXS.getLength() == 0) {
                nlFXS = XPathFassade.getInstance().evaluateNodeList(doc, XPATH_MSG_TYPE_NAME_FXS_G11);
            }
            if ((fxsConfig = RuleFactory.getInstance().getFXSConfig()) != null) {
                LOGGER.debug((Object)"Pruefe auf konfigurierte freie XML-Strukturen im Dokument");
                for (int i = 0; i < nlFXS.getLength(); ++i) {
                    Element elemFXS = (Element)nlFXS.item(i);
                    Element elemData = XmlUtils.getFirstChildElement(elemFXS);
                    String rootElementName = elemData.getLocalName();
                    String nsURI = elemData.getNamespaceURI();
                    LOGGER.debug((Object)("Pruefe auf Element: " + nsURI + ":" + rootElementName));
                    String fxsName = null;
                    for (FXSTYPE fxs : fxsConfig.getFXS()) {
                        FXSSCHEMATYPE fxsSchema = FXSConfigHelper.getSchemaByID(fxsConfig, fxs.getSchemaID());
                        if (fxsSchema == null || !fxsSchema.getNSUri().equals(nsURI) || !fxs.getRootElementName().contains(rootElementName)) continue;
                        if (fxsName == null) {
                            fxsName = fxs.getName();
                        }
                        if (fxsName.equals(fxs.getName())) {
                            String id = elemFXS.getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
                            String uri = elemFXS.getAttributeNS(Namespace.TypenBibliothek.getUri(), "NamespaceURI");
                            FXSDokument fxsDok = new FXSDokument(fxs, id, uri, elemData);
                            LOGGER.debug((Object)("Freie XML-Struktur gefunden: " + String.valueOf(fxsDok)));
                            this._fxsDokumentList.add(fxsDok);
                            continue;
                        }
                        LOGGER.warn((Object)("Konfigurierte freie Xml-Strukturen unterschiedlicher Typen gefunden: " + fxsName + ", " + fxs.getName()));
                    }
                }
            } else {
                LOGGER.debug((Object)"Keine Konfiguration von freien XML-Strukturen vorhanden");
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.error((Object)"Fehler beim Pr\u00fcfen auf bekannte freie XML-Strukturen.", (Throwable)e);
            throw new BMUException("Fehler beim Pr\u00fcfen auf bekannte freie XML-Strukturen.", e);
        }
    }

    private void check4SubDocs(Document doc) throws BMUException {
        if (BMUMessageTypeEnum.ENSNDokument.equals((Object)this._bmuMsgTypeEnum)) {
            try {
                this._hasSubDocs = XPathFassade.getInstance().evalBool(doc.getDocumentElement(), "count(descendant::en:EGFDokument) > 0") || XPathFassade.getInstance().evalBool(doc.getDocumentElement(), "count(descendant::ags:AGSBescheid) > 0") || XPathFassade.getInstance().evalBool(doc.getDocumentElement(), "count(descendant::en:DADokument) > 0");
                LOGGER.debug((Object)("Integrierte Dokumente gefunden: " + this._hasSubDocs));
            }
            catch (XPathExpressionException e) {
                LOGGER.error((Object)"Fehler beim Pr\u00fcfen auf integrierte Dokumente.", (Throwable)e);
                throw new BMUException("Fehler beim Pr\u00fcfen auf integrierte Dokumente.", e);
            }
        }
        if (BMUMessageTypeEnum.DiWaSSRegAntrag.equals((Object)this._bmuMsgTypeEnum)) {
            try {
                this._hasSubDocs = XPathFassade.getInstance().evalBool(doc.getDocumentElement(), "count(descendant::wsr:MasterUserRegistration) > 0") && XPathFassade.getInstance().evalBool(doc.getDocumentElement(), "//wsr:ListOfSites/@wsr:SiteRegistration='true' or //wsr:ListOfSites/@wsr:SiteRegistration='1'");
                LOGGER.debug((Object)("Integrierte Dokumente gefunden: " + this._hasSubDocs));
            }
            catch (XPathExpressionException e) {
                LOGGER.error((Object)"Fehler beim Pr\u00fcfen auf integrierte Dokumente.", (Throwable)e);
                throw new BMUException("Fehler beim Pr\u00fcfen auf integrierte Dokumente.", e);
            }
        }
    }

    private void checkSignatures(Document doc) throws BMUException {
        this._signatureVerificationResultList.clear();
        this._sigIds.clear();
        try {
            XPathFassade xf = XPathFassade.getInstance();
            NodeList nl = xf.evaluateNodeList(doc, "/descendant::ds:Signature");
            XMLGregorianCalendar signingCal = null;
            for (int i = 0; i < nl.getLength(); ++i) {
                Element sigNode = (Element)nl.item(i);
                String sigID = sigNode.getAttribute("Id");
                if (sigID == null || sigID.isEmpty()) {
                    LOGGER.warn((Object)("Die Signatur im Element '" + xf.evaluate(sigNode, "local-name(parent::*)") + "' hat kein ID-Attribut!"));
                    continue;
                }
                this._sigIds.add(sigID);
                String subjectDN = null;
                NodeList certNodeList = sigNode.getElementsByTagNameNS(Namespace.xmldsig.getUri(), "X509Certificate");
                if (certNodeList.getLength() == 0) {
                    LOGGER.warn((Object)("Kein Zertifikat in der Signatur mit der ID '" + sigID + "' vorhanden"));
                } else if (certNodeList.getLength() > 1) {
                    LOGGER.warn((Object)("Mehr als 1 Zertifikat in der Signatur mit der ID '" + sigID + "' vorhanden"));
                } else {
                    Element elemCert = (Element)certNodeList.item(0);
                    X509Certificate x509Cert = CertUtils.getX509CertificateFromBase64(elemCert.getTextContent());
                    subjectDN = x509Cert.getSubjectX500Principal().getName();
                }
                boolean vorlageLayer = false;
                String sigNodeParentLocalName = xf.evaluate(sigNode, "local-name(parent::*)");
                if (ENSN_VORLAGELAYER_NAME.equals(sigNodeParentLocalName) || BGS_VORLAGELAYER_NAME.equals(sigNodeParentLocalName) || UNS_VORLAGELAYER_NAME.equals(sigNodeParentLocalName)) {
                    LOGGER.debug((Object)("skipping SigningTime for Signature in Layer: " + sigNodeParentLocalName));
                    vorlageLayer = true;
                }
                Date signingTime = null;
                NodeList signingTimeNodeList = sigNode.getElementsByTagNameNS(Namespace.xades.getUri(), "SigningTime");
                if (signingTimeNodeList.getLength() > 0) {
                    Node signingTimeNode = signingTimeNodeList.item(0);
                    XMLGregorianCalendar actSigningCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(signingTimeNode.getTextContent());
                    signingTime = actSigningCal.toGregorianCalendar().getTime();
                    if (!vorlageLayer) {
                        if (signingCal == null) {
                            signingCal = actSigningCal;
                        } else if (actSigningCal.compare(signingCal) == -1) {
                            signingCal = actSigningCal;
                        }
                    }
                }
                boolean eIDAS = false;
                NodeList nlCertV2 = sigNode.getElementsByTagNameNS(Namespace.xades.getUri(), "SigningCertificateV2");
                if (nlCertV2.getLength() > 0) {
                    LOGGER.debug((Object)"Element 'SigningCertificateV2' vorhanden!");
                    eIDAS = true;
                }
                this._signatureVerificationResultList.add(new SignatureVerificationResultImpl(sigID, subjectDN, signingTime, eIDAS));
            }
            if (signingCal != null) {
                this._signTime = signingCal.toGregorianCalendar().getTime();
                LOGGER.debug((Object)("SigningTime: " + DateUtils.toDateTimeString(this._signTime)));
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.error((Object)"Fehler beim Verarbeiten der Signaturen.", (Throwable)e);
            throw new BMUException("Fehler beim Verarbeiten der Signaturen.", e);
        }
        catch (DOMException e) {
            LOGGER.error((Object)"Fehler beim Ermitteln des Signaturzeitpunkts.", (Throwable)e);
            throw new BMUException("Fehler beim Ermitteln des Signaturzeitpunkts.", e);
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error((Object)"Fehler beim Ermitteln des Signaturzeitpunkts.", (Throwable)e);
            throw new BMUException("Fehler beim Ermitteln des Signaturzeitpunkts.", e);
        }
        catch (CertificateException e) {
            LOGGER.error((Object)"Fehler beim Verarbeiten der Signatur.", (Throwable)e);
            throw new BMUException("Fehler beim Ermitteln des Signaturzeitpunkts.", e);
        }
        catch (NoSuchProviderException e) {
            LOGGER.error((Object)"Fehler beim Verarbeiten der Signatur.", (Throwable)e);
            throw new BMUException("Fehler beim Ermitteln des Signaturzeitpunkts.", e);
        }
    }

    private void checkENSN(Document doc) throws BMUException {
        if (BMUMessageTypeEnum.ENSNDokument.equals((Object)this._bmuMsgTypeEnum)) {
            try {
                XPathFassade xpf = XPathFassade.getInstance();
                Element docElem = doc.getDocumentElement();
                boolean indicatorENSet = xpf.evalBool(docElem, "count(/descendant::en:IndicatorEN) > 0");
                if (indicatorENSet) {
                    boolean indicatorEN = xpf.evalBool(docElem, "/descendant::en:IndicatorEN[last()]='true' or /descendant::en:IndicatorEN[last()]=1");
                    this._en = indicatorEN ? BMUMessageType.ENStatus.EN : BMUMessageType.ENStatus.SN;
                } else {
                    LOGGER.error((Object)"IndicatorEN ist nicht gesetzt, Klassifikation in EN/SN nicht m\u00f6glich!");
                }
            }
            catch (XPathExpressionException e) {
                LOGGER.error((Object)"Fehler bei der Klassifizierung auf EN/SN", (Throwable)e);
                throw new BMUException("Fehler bei der Klassifizierung auf EN/SN", e);
            }
        }
    }

    @Override
    public List<FXSDokument> getFXSDokumentList() {
        return this._fxsDokumentList;
    }

    public static class Adapter
    extends XmlAdapter<BMUMessageTypeImpl, BMUMessageType> {
        public final BMUMessageType unmarshal(BMUMessageTypeImpl msgTypeImpl) {
            return msgTypeImpl;
        }

        public final BMUMessageTypeImpl marshal(BMUMessageType msgType) {
            return (BMUMessageTypeImpl)msgType;
        }
    }
}

