<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:html="http://www.w3c.org/TR/xhtml1/" xmlns:dyn="http://exslt.org/dynamic" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" xmlns:msg="uri:BMU_Waste_Interface/Message" xmlns:ags="uri:BMU_Waste_Interface/AGS" xmlns:bgs="uri:BMU_Waste_Interface/BGS" xmlns:cat="uri:BMU_Waste_Interface/Kataloge" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:en="uri:BMU_Waste_Interface/EN" xmlns:ntz="uri:BMU_Waste_Interface/Ntz" xmlns:reg="uri:BMU_Waste_Interface/Reg" xmlns:zks="uri:BMU_Waste_Interface/ZKS" xmlns:wmsg="Waste-WG-2018-Message" xmlns:tfs="http://xsd.infotech.de/schema/tfs" xmlns:xades="http://uri.etsi.org/01903/v1.3.2#" xmlns:b64="xalan://de.itu.util.Base64" xmlns:crc32="xalan://de.itu.util.CRC32Helper" xmlns:x509="xalan://de.itu.util.X509CertHelper" xmlns:str="http://exslt.org/strings" extension-element-prefixes="dyn b64 crc32 x509" exclude-result-prefixes="xsl dyn lib msg ags bgs cat ds en ntz reg zks b64 crc32 x509 xades">
	<xsl:template name="Kopf">
		<!-- Kopf-->
		<table bgcolor="#CCCCCC" width="100%" border="0" id="noprint">
			<tr width="100%">
				<td width="5%"/>
				<td width="95%" align="right">
					<font id="Titel">
						<xsl:choose>
							<xsl:when test="string-length(//@lib:Spezifikationsversion)>0">
								BMU-Version <xsl:value-of select="//@lib:Spezifikationsversion"/>
							</xsl:when>
							<xsl:otherwise>
								kein BMU-Dokument
							</xsl:otherwise>
						</xsl:choose>
					</font>
				</td>
			</tr>
			<tr width="100%">
				<td width="5%"/>
				<td width="95%" align="left">
					<form>
						<input type="button" height="20" width="100" value="Formular Drucken" onClick="window.print()"/>
					</form>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="formatDouble">
		<xsl:param name="wert"/>
		<xsl:param name="unit"/>
		<xsl:if test="string-length($wert)>0">
			<xsl:choose>
				<xsl:when test="contains($wert,'.') and contains($wert,',')">
					<!-- punkt und komma mal schauen-->
					<xsl:variable name="W1">
						<xsl:value-of select="translate(substring-before($wert,'.'),',','.')"/>
					</xsl:variable>
					<xsl:variable name="W2">
						<xsl:value-of select="substring-after($wert,'.')"/>
					</xsl:variable>
					<xsl:value-of select="concat($W1,',',$W2)"/>
				</xsl:when>
				<xsl:when test="contains($wert,'.')">
					<!-- nur punkt-->
					<xsl:value-of select="translate($wert,'.',',')"/>
				</xsl:when>
				<xsl:when test="contains($wert,',')">
					<!-- nur komma-->
					<xsl:value-of select="translate($wert,',','.')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$wert"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="string-length($unit)>0">
			<xsl:value-of select="concat(' ',$unit)"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="formatDate">
		<xsl:param name="date"/>
		<xsl:if test="string-length($date)&gt;9">
			<xsl:value-of select="substring($date,9,2)"/>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="substring($date,6,2)"/>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="substring($date,1,4)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="formatTime">
		<xsl:param name="date"/>
		<xsl:if test="string-length($date)&gt;9">
			<xsl:value-of select="substring($date,12,8)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="replace_backslash">
		<xsl:param name="text"/>
		<xsl:param name="from"/>
		<xsl:param name="to"/>
		<xsl:choose>
			<xsl:when test="contains($text, $from)">
				<xsl:variable name="before" select="substring-before($text, $from)"/>
				<xsl:variable name="after" select="substring-after($text, $from)"/>
				<xsl:variable name="prefix" select="concat($before, $to)"/>
				<xsl:value-of select="$before"/>
				<xsl:value-of select="$to"/>
				<xsl:call-template name="replace_backslash">
					<xsl:with-param name="text" select="$after"/>
					<xsl:with-param name="from" select="$from"/>
					<xsl:with-param name="to" select="$to"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="reverseTag">
		<xsl:param name="tag"/>
		<xsl:choose>
			<xsl:when test="contains($tag, '/')">
				<xsl:call-template name="reverseTag">
					<xsl:with-param name="tag" select="substring-after($tag, '/')"/>
				</xsl:call-template>
				<xsl:value-of select="concat('[parent::', substring-before($tag, '/'))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$tag"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="setSlash">
		<xsl:param name="tag"/>
		<xsl:choose>
			<xsl:when test="contains($tag, '/')">
				<xsl:call-template name="setSlash">
					<xsl:with-param name="tag" select="substring-after($tag, '/')"/>
				</xsl:call-template>
				<xsl:value-of select="']'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="showSigBegleitformular">
		<xsl:param name="DOK_TYP" select="'Test'"/>
		<br/>
		<table width="100%" id="noprint" border="0" style="solid" bgcolor="#CCCCCC">
			<tr>
				<td>
					<table width="100%">
						<tr>
							<td width="5"/>
							<td id="Ueberschrift2" width="98%">Signaturen des Dokumentes (es wird immer das gesamte Dokument signiert)
							</td>
						</tr>
						<tr>
							<td width="5"/>
							<td width="98%">
								<font id="Ueberschrift2">Dokument: </font>
								<font id="Aktuell_nu">
									<xsl:value-of select="local-name()"/>
								</font>
								<font id="Ueberschrift2"> Rolle: </font>
								<font id="Aktuell_nu">
									<xsl:value-of select="ntz:FreieXMLStruktur//tfs:ExtendedSignatureRole/@tfs:role"/>
								</font>
							</td>
						</tr>
						<tr>
							<td width="5"/>
							<td width="98%">
								<table width="100%">
									<tr>
										<td id="titel" width="50%">Rechtsverbindliche Unterschrift (1. Signatur)</td>
										<td id="titel" width="50%">Rechtsverbindliche Unterschrift (2. Signatur)</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td id="Ueberschrift2" width="5"/>
							<td width="98%">
								<table width="100%">
									<tr>
										<td width="50%">
											<xsl:if test="ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
												<xsl:variable name="SIG_DATE">
													<xsl:call-template name="formatDate">
														<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
													</xsl:call-template>
												</xsl:variable>
												<font id="Aktuell_nu">
													<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
													<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
												</font>
											</xsl:if>
										</td>
										<td width="50%">
											<xsl:if test="ds:Signature[2]/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
												<xsl:variable name="SIG_DATE2">
													<xsl:call-template name="formatDate">
														<xsl:with-param name="date" select="ds:Signature[2]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
													</xsl:call-template>
												</xsl:variable>
												<font id="Aktuell_nu">
													<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[2]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
													<xsl:value-of select="concat(' (', $SIG_DATE2, ')')"/>
												</font>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="getSigBegleitformular">
		<xsl:param name="ROLLE1" select="''"/>
		<xsl:param name="ROLLE2" select="''"/>
		<xsl:if test="ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
			<xsl:choose>
				<xsl:when test="string-length($ROLLE1)>0">
					<xsl:if test="ntz:FreieXMLStruktur//tfs:ExtendedSignatureRole/@tfs:role=$ROLLE1 or ntz:FreieXMLStruktur//tfs:ExtendedSignatureRole/@tfs:role=$ROLLE2">
						<xsl:variable name="SIG_DATE">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
						<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="SIG_DATE">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
					<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="DUMMY_ZEICHEN">
		<td>
			<font id="Aktuell_nu">&#173;</font>
		</td>
	</xsl:template>

	<xsl:template name="SUBSTRING_VAL">
		<xsl:param name="VAL"/>
		<xsl:param name="MAX_ZEICHEN"/>
		<xsl:choose>
			<xsl:when test="string-length($VAL)>$MAX_ZEICHEN">
				<xsl:value-of select="substring($VAL,1,$MAX_ZEICHEN)"/>...
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$VAL"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="Style">
		<style type="text/css" media="screen">
					a:link { color:#000099; } 
					a:visited { color:000099; } 
					a:active { color:000099; } 
					
					body { text-align:left;
					font-family:Arial,sans-serif; font-size: 15px;
					font-weight: normal; text-decoration: none;
					background-color :#FFFFFF; color: #222222; }

					#Titel {
					font-family:Arial,sans-serif; font-size:17px;
					font-weight:bold; color:black; }

					#Titel_klein {
					font-family:Arial,sans-serif; font-size:15px;
					color:black; }

					#Titel_gross {

					font-family:Arial,sans-serif; font-size:16px;
					font-weight:bold; color:black; }


					#Text_normal {

					font-family:Arial,sans-serif; font-size:16px;
					color:black; }

					#Text_kleiner {

					font-family:Arial,sans-serif; font-size:13px;
					color:black; }



					#Text {

					font-family:Times New Roman; font-size:16px;
					color:#8888FF;

					} #Text_klein {

					font-family: Times New Roman; font-size:14px;
					color:#006699;

					} #Ueberschrift { font-family:Arial,sans-serif;
					font-size:22px; font-weight:bold; color:black; }

					#Ueberschrift_Storno { font-family:Arial,sans-serif;
					font-size:22px; font-weight:bold; color:black; background-color :yellow;}

					#Nummer { font-family:Arial,sans-serif;
					font-size:24px; color:black;

					} #Nummer2 { font-family:Arial,sans-serif;
					font-size:20px; color:black;

					}

					#Tabelle { text-align:left; border-width:1px;
					border-style:solid; border-color:black; }

					#Tabelle-Haupt { border-width:3px;
					border-style:solid; border-color:#CCCCCC; }

					#Ueberschrift2 { font-family:Arial,sans-serif;
					font-size:17px; font-weight:bold; color:black; }

					#Ueberschrift3{ font-family:Arial,sans-serif;
					font-size:22px; color:black; margin: 0.5cm 0cm
					0.5cm 0cm;}

					#FormPosition{ font-family:Arial,sans-serif;
					font-size:22px; color:#0000FF; margin: 0.5cm 0cm
					0.5cm 0cm;}

					#Aktuell { font-family: Times New Roman;
					font-size:18px; color:#0000FF;}

					#Aktuell_notu { font-family: Times New Roman;
					font-size:18px; color:#0000FF;}

					#Aktuell_gross { font-family: Arial,sans-serif;
					font-size:22px; color:#0000FF;}

					#Aktuell_nu { font-family: Arial,sans-serif;
					font-size:15px; color:#0000FF;}

					#Aktuell_nu_indikator { font-family: Arial,sans-serif;
					font-size:15px; color:#0000FF;}

					#Text_nu {
					font-family:Arial,sans-serif; font-size:14px;
					color:#8888FF;}

					#Aktuell_nu_gestrichen {font-family: Arial,sans-serif;
					font-size:17px; color:#0000FF;text-decoration: line-through;}

					#Aktuell_klein { font-family: Arial,sans-serif;
					font-size:13px; color:#0000FF;}

					#Tabelle_links { border-left-width:1px;
					border-right-width:0px; border-bottom-width:0px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_rechts { margin:0; border-left-width:0px;
					border-right-width:1px; border-bottom-width:0px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_oben { border-left-width:0px;
					border-right-width:0px; border-bottom-width:0px;
					border-top-width:1px; border-style:solid;
					border-color:black; }

					#Tabelle_unten { border-left-width:0px;
					border-right-width:0px; border-bottom-width:1px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_unten_links { border-left-width:1px;
					border-right-width:0px; border-bottom-width:1px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_unten_rechts { border-left-width:0px;
					border-right-width:1px; border-bottom-width:1px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_nicht_unten { text-align:left;
					border-left-width:1px; border-right-width:1px;
					border-bottom-width:0px; border-top-width:1px;
					border-style:solid; border-color:black; }

					#Tabelle_nicht_oben { border-left-width:1px;
					border-right-width:1px; border-bottom-width:1px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_ohne { border-width:0; }

					#Tabelle_ohne_1px { border-left-width:0px;
					border-right-width:0px; border-bottom-width:0px;
					border-top-width:1px; border-style:solid;
					border-color:white; }

					#Tabelle_nicht_oben_unten { border-left-width:1px;
					border-right-width:1px; border-bottom-width:0px;
					border-top-width:0px; border-style:solid;
					border-color:black; }

					#Tabelle_indikator { border-width:1px;
					border-style:solid; border-color:black; height:15;
					width:15; }

				</style>
		<style type="text/css" media="print">
			@page { margin: 0; }
			a:link { color:#000099; } 
			a:visited { color:000099; } 
			a:active { color:000099; } 

			body { font-family:Arial,sans-serif; font-size: 7pt;
			margin: 0;
			}
			#Titel {

			font-family:Arial,sans-serif; font-size:6pt;
			font-style:bold;
			color:black; }

			#Titel_klein {

			font-family:Arial,sans-serif; font-size:5pt;

			color:black; }

			#Titel_gross {

			font-family:Arial,sans-serif; font-size:10pt;
			font-weight:bold; color:black; }

			#Text {

			font-family: Times New Roman; font-size:8pt; color:black;
			font-style:italic; }


			#Text_normal {

			font-family:Arial,sans-serif; font-size:10pt; color:black; }

			#Text_kleiner {

			font-family:Arial,sans-serif; font-size:9pt; color:black; }

			#Text_klein {

			font-family: Times New Roman; font-size:9pt; color:black;
			font-style:italic; }

			#Ueberschrift { font-family:Arial,sans-serif;
			font-size:12pt; font-weight:bold; color:black; }

			#Ueberschrift_Storno { font-family:Arial,sans-serif;
			font-size:12pt; font-weight:bold; color:black; }

			#Nummer { font-family:Arial,sans-serif; font-size:11pt;
			font-weight:bold; }

			#Nummer2 { font-family:Arial,sans-serif; font-size:9pt;
			color:black;

			}

			#Tabelle { border-width:1px; border-style:solid;
			border-color:black; }

			#Ueberschrift2 { font-family:Arial,sans-serif;
			font-size:10pt; color:black; }

			#Aktuell { font-family: Times New Roman; font-size:7pt;
			color:#0000FF;  }

			#Aktuell_notu { font-family: Times New Roman;
			font-size:7pt; color:#0000FF;}

			#Aktuell_nu { font-family: Times New Roman;
			font-size:6pt; color:#0000FF;}

			#Aktuell_nu_indikator { font-family: Arial,sans-serif;
			font-size:4pt; color:#0000FF;}

			#Aktuell_gross { font-family: Times New Roman;
			font-size:8pt; color:#0000FF;}

			#Aktuell_nu_gestrichen {font-family: Times New Roman;
			font-size:7pt; color:#0000FF; text-decoration: line-through;}

			#Aktuell_klein { font-family: Times New Roman;
			font-size:5pt; color:#0000FF; }

			#noprint{ display:none }

			#Ueberschrift3{ font-family:Arial,sans-serif; font-size:8pt;
			color:black; margin: 0.2cm 0cm 0cm 0cm; }

			#Tabelle-Haupt { border-width:0px; }


			#Tabelle_links { border-left-width:1px;
			border-right-width:0px; border-bottom-width:0px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_rechts { border-left-width:0px;
			border-right-width:1px; border-bottom-width:0px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_unten_rechts { border-left-width:0px;
			border-right-width:1px; border-bottom-width:1px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_oben { border-left-width:0px;
			border-right-width:0px; border-bottom-width:0px;
			border-top-width:1px; border-style:solid;
			border-color:black; }

			#Tabelle_unten { border-left-width:0px;
			border-right-width:0px; border-bottom-width:1px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_unten_links { border-left-width:1px;
			border-right-width:0px; border-bottom-width:1px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_nicht_unten { border-left-width:1px;
			border-right-width:1px; border-bottom-width:0px;
			border-top-width:1px; border-style:solid;
			border-color:black; }

			#Tabelle_nicht_oben_unten { border-left-width:1px;
			border-right-width:1px; border-bottom-width:0px;
			border-top-width:0px; border-style:solid;
			border-color:black; }

			#Tabelle_ohne { border-width:0 }

			#Tabelle_ohne_1px { border-left-width:0px;
			border-right-width:0px; border-bottom-width:0px;
			border-top-width:1px; border-style:solid;
			border-color:white; }

			#Tabelle_indikator { border-width:1px; border-style:solid;
			border-color:black; height:11; width:11; }


		</style>
	</xsl:template>
</xsl:stylesheet>
