<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:html="http://www.w3c.org/TR/xhtml1/" 
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" 
xmlns:msg="uri:BMU_Waste_Interface/Message" 
xmlns:ntz="uri:BMU_Waste_Interface/Ntz" 
xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
xmlns:b64="xalan://de.itu.util.Base64" 
xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
xmlns:x509="xalan://de.itu.util.X509CertHelper" 
xmlns:util="xalan://de.condat.mbs.tools.TransformUtils"
xmlns:itu="xalan://de.itu.util.ISO_3166" 
xmlns:tfs="http://xsd.infotech.de/schema/tfs" 
xmlns:wmsg="Waste-WG-2018-Message" 
xmlns:wx="Guidlines11xtra" 
extension-element-prefixes="b64 crc32 x509 tfs util" 
exclude-result-prefixes="xsl lib msg ds b64 crc32 x509 tfs wmsg util">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="register" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:variable name="LEERZEICHEN" select="' '"> </xsl:variable>
	<xsl:template match="/">
		<xsl:for-each select="//wmsg:WasteMovementDocument">
			<xsl:if test="position()=$positionsnummer">
				<xsl:call-template name="WasteMovementDocument"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="WasteMovementDocument">
		<html>
			<head>
				<title>Begleitformular</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile1_2"/>
							<xsl:call-template name="Zeile3"/>
							<xsl:call-template name="Zeile4"/>
							<xsl:call-template name="Zeile5_6"/>
							<xsl:call-template name="Zeile7"/>
							<xsl:call-template name="Zeile8"/>
							<xsl:call-template name="Zeile8a"/>
							<xsl:call-template name="Zeile9"/>
							<xsl:call-template name="Zeile10"/>
							<xsl:call-template name="Zeile12"/>
							<xsl:call-template name="Zeile13"/>
							<xsl:call-template name="Zeile14"/>
							<xsl:call-template name="Zeile15"/>
							<xsl:call-template name="Zeile16"/>
							<xsl:call-template name="Zeile17"/>
							<xsl:call-template name="Zeile17a"/>
							<xsl:call-template name="Zeile18"/>
							<xsl:call-template name="Zeile19"/>
							<xsl:call-template name="Zeile19a"/>
							<xsl:call-template name="Zeile20"/>
							<xsl:call-template name="Zeile21"/>
							<xsl:call-template name="Zeile22"/>
							<xsl:call-template name="EndeForm"/>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="Zeile1_2">
		<table width="100%" id="Tabelle_ohne">
			<tr>
				<td id="Ueberschrift2">Begleitformular für grenzüberschreitende Verbringungen von Abfällen</td>
			</tr>
			<xsl:if test="//wx:NTZxtra/wx:Canceled='true'">
				<tr>
					<td>
						<font id="Ueberschrift_Storno">
							<xsl:value-of select="'Der Transport wurde storniert.'"/>
						</font>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel">1. Entspricht der Notifizierung Nr.</td>
				<td id="Aktuell_gross">
					<xsl:value-of select="wmsg:NotificationID"/>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
				<tr>
					<td id="Titel">2. Fortlaufende Nummer / Gesamtzahl der Verbringungen:</td>
					<td>
						<font id="Aktuell_gross">
							<xsl:value-of select="wmsg:SequenceNumber"/>
						</font>
						<xsl:value-of select="$LEERZEICHEN"/>
						<font id="Titel">/</font>
						<xsl:value-of select="$LEERZEICHEN"/>
						<font id="Aktuell_gross">
							<xsl:value-of select="wmsg:ShipmentQuantity"/>
						</font>
					</td>
				</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile3">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(wmsg:TransportAnnouncement/wmsg:Notifier)>0">
							<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:Notifier">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'3. Exporteur - Notifizierender'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'3. Exporteur - Notifizierender'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile4">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(wmsg:TransportAnnouncement/wmsg:Consignee)>0">
							<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:Consignee">
								<xsl:call-template name="NAME_ADRESSE">
									<xsl:with-param name="ROLLE_VBF" select="'4. Importeur - Empfänger'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'4. Importeur - Empfänger'"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile5_6">
		<xsl:for-each select="wmsg:TransportAnnouncement">
			<table width="100%" id="Tabelle_nicht_unten">
				<colgroup>
					<col width="50%" valign="top"/>
					<col width="50%" valign="top"/>
				</colgroup>
				<tr>
					<td>
						<table width="100%" id="Tabelle_rechts">
							<colgroup>
								<col width="40%"/>
								<col width="25%"/>
								<col width="10%"/>
								<col width="15%"/>
								<col width="10%"/>
							</colgroup>
							<tr>
								<td id="Titel">5. Tatsächliche Menge:</td>
								<td id="Titel_klein">Tonnen (Mg):</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDouble">
										<xsl:with-param name="wert" select="wmsg:ActualQuantity/wmsg:MassMeasure"></xsl:with-param>
										<xsl:with-param name="unit" select="wmsg:ActualQuantity/wmsg:MassMeasure/@unitCode"></xsl:with-param>
									</xsl:call-template>
								</td>
								<td id="Titel_klein">m³:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDouble">
										<xsl:with-param name="wert" select="wmsg:ActualQuantity/wmsg:VolumeMeasure"></xsl:with-param>
										<xsl:with-param name="unit" select="wmsg:ActualQuantity/wmsg:VolumeMeasure/@unitCode"></xsl:with-param>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="70%"/>
								<col width="30%"/>
							</colgroup>
							<tr>
								<td id="Titel">6. Tatsächliches Datum der Verbringung:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:StartDate"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile7">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="10%"/>
							<col width="45%"/>
							<col width="20%"/>
							<col width="5%"/>
						</colgroup>
						<tr>
							<td id="Titel">7. Verpackung</td>
							<td id="Titel_klein">Art(en):</td>
							<td id="Aktuell_klein">
								<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:Packaging">
									<xsl:variable name="lTypeCode">
										<xsl:value-of select="wmsg:PackageTypeCode"/>
									</xsl:variable>
									<xsl:variable name="TypeCode">
										<xsl:choose>
											<xsl:when test="$lTypeCode = '1'">1. Trommel/Fass</xsl:when>
											<!-- DR = Drum -> 1 = Fässer -->
											<xsl:when test="$lTypeCode = '2'">2. Holzfass</xsl:when>
											<!-- W1 = Jerrican -> 3 = Kanister -->
											<xsl:when test="$lTypeCode = '3'">3. Kanister</xsl:when>
											<!-- 2C = Barrel, wooden -> 2 = Holzfässer -->
											<xsl:when test="$lTypeCode = '4'">4. Kiste/Kasten</xsl:when>
											<!-- BX = Box -> 4 = Kisten -->
											<xsl:when test="$lTypeCode = '5'">5. Sack/Beutel</xsl:when>
											<!-- BG = Bag -> 5 = Säcke -->
											<xsl:when test="$lTypeCode = '6'">6. Verbundverpackung</xsl:when>
											<!-- W2 = Composite Package -> 6 = Zusammengesetzte Verp.-->
											<xsl:when test="$lTypeCode = '7'">7. Druckbehälter</xsl:when>
											<!-- W3 = Pressure Receptacle -> 7 = Druckbehälter -->
											<xsl:when test="$lTypeCode = '8'">8. Schüttgut</xsl:when>
											<!-- W4 = Other -> 9 = Sonstige Verpackungen -->
											<!--xsl:when test="$lTypeCode = 'W5'">
												<xsl:value-of select="'9. Andere: '"/>
												<xsl:value-of select="Type"/>
											</xsl:when-->
											<!-- W5 = Bulk -> 8 = Unverpackt, Schüttgut -->
											<xsl:otherwise>9. Andere</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:if test="position()>1">
										<xsl:value-of select="', '"/>
									</xsl:if>
									<xsl:value-of select="$TypeCode"/>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Anzahl der Frachstücke:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:TransportAnnouncement/wmsg:Packaging/wmsg:PackageQuantity"/>
							</td>
						</tr>
					</table>
					<xsl:if test="string-length(wmsg:TransportAnnouncement/wmsg:Packaging/wmsg:PackageDescription/wmsg:Description)>0">
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td id="Titel_klein">Beschreibung:</td>
							</tr>
							<tr>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:Packaging/wmsg:PackageDescription/wmsg:Description">
										<xsl:if test="position()>1">
											<br/>
										</xsl:if>
										<xsl:call-template name="getFieldWithLanguage">
											<xsl:with-param name="TheValue" select="."/>
										</xsl:call-template>
									</xsl:for-each>
								</td>
							</tr>
						</table>
					</xsl:if>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="40%"/>
							<col width="5%"/>
							<col width="10%"/>
							<col width="5%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td id="Titel"> Besondere Handhabungsvorschriften:</td>
							<td id="Titel_klein">Ja</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wmsg:TransportAnnouncement/wmsg:Packaging/wmsg:SpecialHandlingRequirementIndicator='true'">
												<font id="Aktuell_klein">
													<xsl:value-of select="'X'"/>
												</font>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Nein</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wmsg:TransportAnnouncement/wmsg:Packaging/wmsg:SpecialHandlingRequirementIndicator='false'">
												<font id="Aktuell_klein">
													<xsl:value-of select="'X'"/>
												</font>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td/>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile8">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">8. Transportunternehmen</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:Carrier">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:call-template name="NAME_ADRESSE">
							<xsl:with-param name="ROLLE_VBF" select="concat( '8.',position(), ' Transporttunternehmen')"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Transportart:</td>
								<td id="Aktuell_klein">
									<xsl:value-of select="wmsg:MeansOfTransportCode"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Zeile8a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">8. Transportabschnitte</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:Transport">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:call-template name="NAME_ADRESSE">
							<xsl:with-param name="ROLLE_VBF" select="concat( '8.',position(), ' Transportabschnitt')"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Transportart:</td>
								<td id="Aktuell_klein">
									<xsl:value-of select="wmsg:MeansOfTransportCode"/>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Kennzeichen:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:VehicleID">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Übergabedatum:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:TransferDate"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Unterschrift:</td>
								<td id="Aktuell_klein">
									<xsl:value-of select="wmsg:CarrierSignatureText"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile9">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">9. Abfallerzeuger</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:WasteProducer">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:call-template name="NAME_ADRESSE">
							<xsl:with-param name="ROLLE_VBF" select="concat( '9.',position(), ' Abfallerzeuger')"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%" valign="top"/>
								<col width="80%" valign="top"/>
							</colgroup>
							<tr>
								<td>
									<font id="Titel_klein">Ort der Abfallerzeugung:</font>
								</td>
								<td>
									<font id="Aktuell_klein">
										<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
											<xsl:if test="position()>1">
												<br/>
											</xsl:if>
											<xsl:call-template name="getFieldWithLanguage">
												<xsl:with-param name="TheValue" select="."/>
											</xsl:call-template>
										</xsl:for-each>
									</font>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Zeile10">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">10. Beseitigungs- Verwertunganlage(n) / 11. Beseitigungs-/Verwertungsverfahren</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:NonInterimRecoveryDisposalFacility">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:call-template name="NAME_ADRESSE">
							<xsl:with-param name="ROLLE_VBF" select="concat( '10.',position(), ' Nicht vorläufige Beseitigungs- Verwertunganlage')"/>
						</xsl:call-template>
					</td>
				</tr>
				<xsl:call-template name="Zeile11"/>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile11">
		<tr>
			<td>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%" valign="top"/>
						<col width="80%" valign="top"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Ort der tatsächlichen<br/>Beseitigung/Verwertung:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:SiteDescription/wmsg:Description">
								<xsl:if test="position()>1">
									<br/>
								</xsl:if>
								<xsl:call-template name="getFieldWithLanguage">
									<xsl:with-param name="TheValue" select="."/>
								</xsl:call-template>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Kennnummer(n):</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:SiteID">
								<xsl:if test="position()>1">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="concat(., ' (', itu:getLandKuerzel(@identificationSchemeID), ')')"/>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">D-Code / R-Code:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:RecoveryDisposalTypeCode">
								<xsl:if test="position()>1">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Verfahrensbeschreibung:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:RecoveryDisposalDescription/wmsg:Description">
								<xsl:if test="position()>1">
									<br/>
								</xsl:if>
								<xsl:call-template name="getFieldWithLanguage">
									<xsl:with-param name="TheValue" select="."/>
								</xsl:call-template>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Angewandte Technologie:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:TechnologyDescription/wmsg:Description">
								<xsl:if test="position()>1">
									<br/>
								</xsl:if>
								<xsl:call-template name="getFieldWithLanguage">
									<xsl:with-param name="TheValue" select="."/>
								</xsl:call-template>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Grund für die Ausfuhr:</td>
						<td id="Aktuell_klein">
							<xsl:for-each select="wmsg:ReasonForExportDescription/wmsg:Description">
								<xsl:if test="position()>1">
									<br/>
								</xsl:if>
								<xsl:call-template name="getFieldWithLanguage">
									<xsl:with-param name="TheValue" select="."/>
								</xsl:call-template>
							</xsl:for-each>
							<xsl:value-of select="$LEERZEICHEN"/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="Zeile12">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">12. Bezeichnung und Zusammensetzung des Abfalls:</td>
			</tr>
			<tr>
				<td id="Aktuell_klein">
					<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:WasteDesignationDescription/wmsg:Description">
						<xsl:if test="position()>1">
							<br/>
						</xsl:if>
						<xsl:call-template name="getFieldWithLanguage">
							<xsl:with-param name="TheValue" select="."/>
						</xsl:call-template>
					</xsl:for-each>
					<xsl:value-of select="$LEERZEICHEN"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile13">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="30%"/>
							<col width="70%"/>
						</colgroup>
						<tr>
							<td id="Titel">13. Physikalische Eigenschaften:</td>
							<td id="Aktuell_klein">
								<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:PhysicalCharacteristicTypeCode">
									<xsl:variable name="lPhys">
										<xsl:value-of select="."/>
									</xsl:variable>
									<xsl:variable name="PhysEig">
										<xsl:choose>
											<xsl:when test="$lPhys = 1">1. Staub- oder pulverförmig</xsl:when>
											<!-- SOLDUS = Solid - Dusty -> 1 = pulverförmig oder staubförmig -->
											<xsl:when test="$lPhys = 2">2. Fest</xsl:when>
											<!-- SOLCHU = Solid - in chunks -> 2 = fest -->
											<xsl:when test="$lPhys = 3">3. Pastös/breiig</xsl:when>
											<!-- SLUVISC =  Viscous or paste -> 3 = pastös oder breiig -->
											<xsl:when test="$lPhys = 4">4. Schlammig</xsl:when>
											<!-- SLU = Sludgy -> 4 = schlammig -->
											<xsl:when test="$lPhys = 5">5. Flüssig</xsl:when>
											<!-- LIQ = Liquid -> 5 = flüssig -->
											<xsl:when test="$lPhys = 6">6. Gasförmig</xsl:when>
											<!-- GAS = Gaseous -> 6 = gasförmig -->
											<xsl:otherwise>0. unbekannt</xsl:otherwise>
											<!-- ??? -> 0 = unbekannt -->
										</xsl:choose>
									</xsl:variable>
									<xsl:if test="position()>1">
										<xsl:value-of select="', '"/>
									</xsl:if>
									<xsl:value-of select="$PhysEig"/>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<xsl:if test="string-length(wmsg:TransportAnnouncement/wmsg:hysicalCharacteristicDescription/wmsg:Description)>0">
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td id="Titel_klein">Beschreibung:</td>
				</tr>
				<tr>
					<td id="Aktuell_klein">
						<xsl:for-each select="wmsg:TransportAnnouncement/wmsg:hysicalCharacteristicDescription/wmsg:Description">
							<xsl:if test="position()>1">
								<br/>
							</xsl:if>
							<xsl:call-template name="getFieldWithLanguage">
								<xsl:with-param name="TheValue" select="."/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Zeile14">
		<xsl:for-each select="wmsg:TransportAnnouncement">
			<table width="100%" id="Tabelle_nicht_unten">
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<tr>
								<td id="Titel">14. Abfallidentifizierung</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="3%" align="right"/>
								<col width="37%"/>
								<col width="60%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">i)</td>
								<td id="Titel_klein">Basel Anlage VIII (oder IX falls anwendbar):</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='BASEL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">ii)</td>
								<td id="Titel_klein">OECD-Code (falls abweichend von i):</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='OECD']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iii)</td>
								<td id="Titel_klein">EU-Abfallverzeichnis:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='EWL']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iv)</td>
								<td id="Titel_klein">Nationaler Code im Ausfuhrland:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='NATEXP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">v)</td>
								<td id="Titel_klein">Nationaler Code im Einfuhrland:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='NATIMP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">vi)</td>
								<td id="Titel_klein">Sonstige:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='OTHER']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">vii)</td>
								<td id="Titel_klein">Y-Code:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='YCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">viii)</td>
								<td id="Titel_klein">H-Code:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='HCODE']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">iX) </td>
								<td id="Titel_klein">UN-Klasse:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNCLASS']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">X)</td>
								<td id="Titel_klein">UN-Kennnummer:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNNUM']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Xi)</td>
								<td id="Titel_klein">UN-Versandname:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='UNSHIP']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Xii)</td>
								<td id="Titel_klein">Zollnummer(n) (HS):</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:WasteClassification/wmsg:WasteTypeCode[@listID='CUST']">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile15">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">15. Erklärung des Exporteurs – Notifizierenden/Erzeugers</td>
						</tr>
						<tr>
							<td id="Titel_klein">Ich erkläre hiermit, dass die obigen Informationen nach meinem besten Wissen vollständig sind und der Wahrheit entsprechen.<br/>Ich erkläre ferner, dass rechtlich durchsetzbare vertragliche Verpflichtungen schriftlich eingegangen wurden, alle für die grenzüberschreitende Verbringung erforderlichen Versicherungen oder sonstigen Sicherheitsleistungen abgeschlossen bzw. hinterlegt wurden und alle erforderlichen Zustimmungen der zuständigen Behörden der betreffenden Staaten vorliegen.</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="25%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="25%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Name des Exporteurs:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:DeclarationExporter/wmsg:Name"/>
							</td>
							<td id="Titel_klein">Datum:</td>
							<td id="Aktuell_klein">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="wmsg:DeclarationExporter/wmsg:Date"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Unterschrift:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:DeclarationExporter/wmsg:Signature"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Name des Erzeugers:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:DeclarationProducer/wmsg:Name"/>
							</td>
							<td id="Titel_klein">Datum:</td>
							<td id="Aktuell_klein">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="wmsg:DeclarationProducer/wmsg:Date"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Unterschrift:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:DeclarationProducer/wmsg:Signature"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile16">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">16. Von sonstigen an der grenzüberschreitenden Verbringung beteiligte Personen auszufüllen, falls zusätzliche Informationen verlangt werden:</td>
						</tr>
						<tr>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:TransportAnnouncement/wmsg:AdditionalInformation/wmsg:Description"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile17">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr>
							<td id="Titel">17. Eingang beim Importeur – Empfänger (falls keine Anlage)</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Datum:</td>
							<td id="Aktuell_nu">
								<xsl:call-template name="formatDate">
									<!--xsl:with-param name="date" select="../ntz:FreieXMLStruktur/tfs:EUDINCertificateOfWasteReceiptDocument/tfs:ImporterConsigneeReceptionConfirmation/tfs:Date"/-->
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Name:</td>
							<td id="Aktuell_nu">
									<!--xsl:value-of select="../ntz:FreieXMLStruktur//tfs:EUDINCertificateOfWasteReceiptDocument/tfs:ImporterConsigneeReceptionConfirmation/tfs:PersonName"/-->
							</td>
							<td id="Titel_klein">Unterschrift:</td>
							<td>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile17a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr align="center">
							<td>
								<font id="Titel">VON DER BESEITIGUNGS/VERWERTUNGSANLAGE AUSZUFÜLLEN</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile18">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">18. Eingang bei den Beseitigungs- oder Verwertungsanlage(n)</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:CertificateOfWasteReceipt">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:for-each select="wmsg:RecipientParty">
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="concat( '18.',position(), ' Eingang bei der Beseitigungs- oder Verwertungsanlage')"/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="35%"/>
								<col width="10%"/>
								<col width="17%"/>
								<col width="10%"/>
								<col width="23%"/>
								<col width="5%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Eingangsdatum:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:ReceiptDate"/>
									</xsl:call-template>
								</td>
								<td id="Titel_klein">in Empfang genommen:</td>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:if test="wmsg:RejectionIndicator = 'false'">
													<font id="Aktuell_klein">
														<xsl:value-of select="'X'"/>
													</font>
												</xsl:if>
											</td>
										</tr>
									</table>
								</td>
								<td id="Titel_klein">Empfang verweigert:</td>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:if test="wmsg:RejectionIndicator = 'true'">
													<font id="Aktuell_klein">
														<xsl:value-of select="'X'"/>
													</font>
												</xsl:if>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
						<xsl:if test="string-length(wmsg:RejectionDescription/wmsg:Description)>0">
							<table width="100%" id="Tabelle_ohne">
								<tr>
									<td id="Titel_klein">Beschreibung bei teilweiser Zurückweisung:</td>
									<td id="Aktuell_klein">
										<xsl:for-each select="wmsg:RejectionDescription/wmsg:Description">
											<xsl:if test="position()>1">
												<br/>
											</xsl:if>
											<xsl:call-template name="getFieldWithLanguage">
												<xsl:with-param name="TheValue" select="."/>
											</xsl:call-template>
										</xsl:for-each>
									</td>
								</tr>
							</table>
						</xsl:if>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="35%"/>
								<col width="10%"/>
								<col width="17%"/>
								<col width="38%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">In Empfang genommene Menge: Tonnen (Mg):</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDouble">
										<xsl:with-param name="wert" select="wmsg:Quantity/wmsg:MassMeasure"></xsl:with-param>
										<xsl:with-param name="unit" select="wmsg:Quantity/wmsg:MassMeasure/@unitCode"></xsl:with-param>
									</xsl:call-template>
								</td>
								<td id="Titel_klein">m³:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDouble">
										<xsl:with-param name="wert" select="wmsg:Quantity/wmsg:VolumeMeasure"></xsl:with-param>
										<xsl:with-param name="unit" select="wmsg:Quantity/wmsg:VolumeMeasure/@unitCode"></xsl:with-param>
									</xsl:call-template>
								</td>
							</tr>
						</table>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="35%"/>
								<col width="65%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Ungefähres Datum der Beseitigung/Verwertung:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:RecoveryDisposalStartDate"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Beseitigungs- Verwertungsverfahren:</td>
								<td id="Aktuell_klein">
									<xsl:for-each select="wmsg:RecoveryDisposalTypeCode">
										<xsl:if test="position()>1">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</td>
							</tr>
						</table>
						<xsl:if test="string-length(wmsg:RecoveryDisposalDescription/wmsg:Description)>0">
							<table width="100%" id="Tabelle_ohne">
								<tr>
									<td id="Titel_klein">Beschreibung wenn Beseitigungs- Verwertungsverfahren nicht eindeutig:</td>
									<td id="Aktuell_klein">
										<xsl:for-each select="wmsg:RecoveryDisposalDescription/wmsg:Description">
											<xsl:if test="position()>1">
												<br/>
											</xsl:if>
											<xsl:call-template name="getFieldWithLanguage">
												<xsl:with-param name="TheValue" select="."/>
											</xsl:call-template>
										</xsl:for-each>
									</td>
								</tr>
							</table>
						</xsl:if>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Name:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="SUBSTRING_VAL">
										<xsl:with-param name="VAL" select="wmsg:Name"/>
										<xsl:with-param name="MAX_ZEICHEN" select="70"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Datum:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:Date"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Unterschrift:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="SUBSTRING_VAL">
										<xsl:with-param name="VAL" select="wmsg:Signatur"/>
										<xsl:with-param name="MAX_ZEICHEN" select="70"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Zeile19">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">19. Entsorgungsbestätigunge(n)</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:CertificateOfCompletion">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:for-each select="wmsg:RecoveryDisposalParty">
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="concat( '19.',position(), ' Ich bescheinige hiermit, dass die oben beschriebenen Abfälle beseitigt/verwertet worden sind.')"/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<table width="100%" id="Tabelle_ohne">
							<colgroup>
								<col width="20%"/>
								<col width="80%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Name:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="SUBSTRING_VAL">
										<xsl:with-param name="VAL" select="wmsg:Name"/>
										<xsl:with-param name="MAX_ZEICHEN" select="70"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Datum:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date" select="wmsg:Date"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Unterschrift:</td>
								<td id="Aktuell_klein">
									<xsl:call-template name="SUBSTRING_VAL">
										<xsl:with-param name="VAL" select="wmsg:Signatur"/>
										<xsl:with-param name="MAX_ZEICHEN" select="70"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile19a">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td>
					<table width="100%" id="Tabelle_ohne">
						<tr align="center">
							<td>
								<font id="Titel">VON DER ZOLLSTELLE AUSZUFÜLLEN</font>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile20">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">20. Ausfuhrstaat/Versandstaat oder Ausgangszollstelle</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="60%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Die in diesem Begleitformular beschriebenen Abfälle wurden aus dem Land ausgeführt am:</td>
				<td id="Aktuell_klein">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="wmsg:ExitCustomsDeclaration/wmsg:Date"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="15%"/>
				<col width="85%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Unterschrift:</td>
				<td id="Aktuell_klein">
					<xsl:value-of select="wmsg:ExitCustomsDeclaration/wmsg:DeclarationSignatureText"/>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<tr>
				<td>
					<xsl:for-each select="wmsg:ExitCustomsDeclaration/wmsg:CustomsParty">
						<xsl:call-template name="NAME_ADRESSE">
							<xsl:with-param name="ROLLE_VBF" select="'Exportbehörde oder Zollstelle'"/>
						</xsl:call-template>
					</xsl:for-each>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile21">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">21. Einfuhrstaat/Empfängerstaat oder Eingangszollstelle</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="60%"/>
				<col width="40%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Die in diesem Begleitformular beschriebenen Abfälle wurden in das Land eingeführt am:</td>
				<td id="Aktuell_klein">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="wmsg:EntryCustomsDeclaration/wmsg:Date"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<colgroup>
				<col width="15%"/>
				<col width="85%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Unterschrift:</td>
				<td id="Aktuell_klein">
					<xsl:value-of select="wmsg:EntryCustomsDeclaration/wmsg:DeclarationSignatureText"/>
				</td>
			</tr>
		</table>
		<table width="100%" id="Tabelle_nicht_oben_unten">
			<tr>
				<td>
					<xsl:for-each select="wmsg:EntryCustomsDeclaration/wmsg:CustomsParty">
						<xsl:call-template name="NAME_ADRESSE">
							<xsl:with-param name="ROLLE_VBF" select="'Importbehörde oder Zollstelle'"/>
						</xsl:call-template>
					</xsl:for-each>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile22">
		<table width="100%" id="Tabelle_nicht_unten">
			<tr>
				<td id="Titel">22. Stempel der Zollstellen der Durchfuhrstaaten</td>
			</tr>
		</table>
		<xsl:for-each select="wmsg:TransitCustomsDeclaration">
			<xsl:call-template name="TableOneDashLine"/>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<colgroup>
					<col width="20%"/>
					<col width="80%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Land:</td>
					<td id="Aktuell_klein">
						<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
					</td>
				</tr>
			</table>		
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td id="Titel">Eingang</td>
				</tr>
			</table>		
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<colgroup>
					<col width="20%"/>
					<col width="80%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Eingang am</td>
					<td id="Aktuell_klein">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="wmsg:Entry/wmsg:Date"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td id="Titel_klein">Unterschrift</td>
					<td id="Aktuell_klein">
						<xsl:value-of select="wmsg:Entry/wmsg:DeclarationSignatureText"/>
					</td>
				</tr>
			</table>		
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:for-each select="wmsg:Entry/wmsg:CustomsParty">
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'Transitbehörde oder Zollstelle (Eingang)'"/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td id="Titel">Ausgang</td>
				</tr>
			</table>		
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<colgroup>
					<col width="20%"/>
					<col width="80%"/>
				</colgroup>
				<tr>
					<td id="Titel_klein">Ausgang am</td>
					<td id="Aktuell_klein">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="wmsg:Exit/wmsg:Date"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td id="Titel_klein">Unterschrift</td>
					<td id="Aktuell_klein">
						<xsl:value-of select="wmsg:Exit/wmsg:DeclarationSignatureText"/>
					</td>
				</tr>
			</table>		
			<table width="100%" id="Tabelle_nicht_oben_unten">
				<tr>
					<td>
						<xsl:for-each select="wmsg:Exit/wmsg:CustomsParty">
							<xsl:call-template name="NAME_ADRESSE">
								<xsl:with-param name="ROLLE_VBF" select="'Transitbehörde oder Zollstelle (Ausgang)'"/>
							</xsl:call-template>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="Zeile22a">
		<xsl:variable name="COUNT_TRANSIT" select="count(wmsg:TransitCustomsDeclaration)"/>
		<table width="100%" id="Tabelle_nicht_unten">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<xsl:for-each select="wmsg:TransitCustomsDeclaration">
					<xsl:choose>
						<xsl:when test="position()=1">
							<td width="50%">
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:call-template name="ZOLL_MORE"/>
								</table>
							</td>
						</xsl:when>
						<xsl:when test="position()=2">
							<td width="50%">
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:call-template name="ZOLL_MORE"/>
								</table>
							</td>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:choose>
					<xsl:when test="$COUNT_TRANSIT=0">
						<td width="50%">
							<table width="100%" id="Tabelle_rechts">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
						<td width="50%">
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
					</xsl:when>
					<xsl:when test="$COUNT_TRANSIT=1">
						<td width="50%">
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
					</xsl:when>
				</xsl:choose>
			</tr>
		</table>
		<table width="100%" id="Tabelle">
			<colgroup>
				<col width="50%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<xsl:for-each select="wmsg:TransitCustomsDeclaration">
					<xsl:choose>
						<xsl:when test="position()=3">
							<td width="50%">
								<table width="100%" id="Tabelle_rechts">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:call-template name="ZOLL_MORE"/>
								</table>
							</td>
						</xsl:when>
						<xsl:when test="position()=4">
							<td width="50%">
								<table width="100%" id="Tabelle_ohne">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:call-template name="ZOLL_MORE"/>
								</table>
							</td>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:choose>
					<xsl:when test="$COUNT_TRANSIT=0 or $COUNT_TRANSIT=1 or $COUNT_TRANSIT=2">
						<td width="50%">
							<table width="100%" id="Tabelle_rechts">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
						<td width="50%">
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
					</xsl:when>
					<xsl:when test="$COUNT_TRANSIT=0 or $COUNT_TRANSIT=1 or $COUNT_TRANSIT=2 or $COUNT_TRANSIT=3">
						<td width="50%">
							<table width="100%" id="Tabelle_ohne">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:call-template name="ZOLL_MORE"/>
							</table>
						</td>
					</xsl:when>
				</xsl:choose>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="ZOLL_MORE">
		<tr>
			<td id="Titel_klein">Name des Staates:</td>
			<td id="Aktuell_klein">
				<xsl:value-of select="itu:getLandKuerzel(wmsg:CountryID)"/>
			</td>
		</tr>
		<tr>
			<td>
				<table width="100%" id="Tabelle_rechts">
					<colgroup>
						<col width="25%"/>
						<col width="75%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Eingang:</td>
						<td id="Aktuell_klein">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="wmsg:Entry/wmsg:Date"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</td>
			<td>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="25%"/>
						<col width="75%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Ausgang:</td>
						<td id="Aktuell_klein">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="wmsg:Exit/wmsg:Date"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="NAME_ADRESSE">
		<xsl:param name="ROLLE_VBF"/>
		<xsl:param name="BEHOERDE" select="false()"/>

		<xsl:if test="$BEHOERDE=false()">
			<table width="100%" id="Tabelle_ohne">
				<tr>
					<td id="Titel">
						<xsl:value-of select="$ROLLE_VBF"/>
					</td>
				</tr>
			</table>
		</xsl:if>

		<xsl:choose>
			<xsl:when test="string-length(wmsg:OrganizationName)>0 or string-length(wmsg:Person)>0">
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<xsl:if test="$BEHOERDE">
							<tr>
								<td id="Titel_klein">Codenummer:</td>
								<td id="Aktuell_klein">
									<xsl:value-of select="wmsg:CompetentAuthorityID"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td id="Titel_klein">Registriernummer(n):</td>
							<td id="Aktuell_klein">
								<xsl:for-each select="wmsg:PartyID">
									<xsl:if test="position()>1">
										<xsl:value-of select="', '"/>
									</xsl:if>
									<xsl:value-of select="concat(., ' (', itu:getLandKuerzel(@identificationSchemeID), ')')"/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Name:</td>
							<td id="Aktuell_klein">
								<xsl:variable name="NAME_1">
									<xsl:choose>
										<xsl:when test="string-length(wmsg:OrganizationName)>0">
											<xsl:value-of select="wmsg:OrganizationName"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="wmsg:Person/wmsg:GivenName"/>
											<xsl:value-of select="$LEERZEICHEN"/>
											<xsl:value-of select="wmsg:Person/wmsg:FamilyName"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:value-of select="$NAME_1"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Anschrift:</td>
							<td id="Aktuell_klein">
								<xsl:variable name="STRASSE">
									<xsl:choose>
										<xsl:when test="string-length(wmsg:Address/wmsg:StreetName) > 0">
											<xsl:value-of select="wmsg:Address/wmsg:StreetName"/>
										</xsl:when>
										<xsl:when test="string-length(wmsg:Address/wmsg:PostOfficeBox)">
											<xsl:value-of select="wmsg:Address/wmsg:PostOfficeBox"/>
										</xsl:when>
									</xsl:choose>
								</xsl:variable>
								<xsl:variable name="HAUSNR">
									<xsl:value-of select="wmsg:Address/wmsg:BuildingNumber"/>
								</xsl:variable>
								<xsl:variable name="BLOCK">
									<xsl:if test="string-length(wmsg:Address/wmsg:BlockName)>0">
										<xsl:value-of select="concat(' (Block: ', wmsg:Address/wmsg:BlockName, ')')"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="STOCK">
									<xsl:if test="string-length(wmsg:Address/wmsg:StaircaseNumber)>0">
										<xsl:value-of select="concat(' (Stockwerk: ', wmsg:Address/wmsg:StaircaseNumber, ')')"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="FLUR">
									<xsl:if test="string-length(wmsg:Address/wmsg:FloorIdentification)>0">
										<xsl:value-of select="concat(' (Flur: ', wmsg:Address/wmsg:FloorIdentification, ')')"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="ZIMMER">
									<xsl:if test="string-length(wmsg:Address/wmsg:RoomIdentification)>0">
										<xsl:value-of select="concat(' (Zimmer: ', wmsg:Address/wmsg:RoomIdentification, ')')"/>
									</xsl:if>
								</xsl:variable>
								<xsl:value-of select="normalize-space(concat($STRASSE, ' ', $HAUSNR, $BLOCK, $STOCK, $FLUR, $ZIMMER))"/>
							</td>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell_klein">
								<xsl:value-of select="normalize-space(concat(wmsg:Address/wmsg:Postcode,' ',wmsg:Address/wmsg:CityName,' ',wmsg:Address/wmsg:CitySubDivisionName))"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Land:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="itu:getLandKuerzel(wmsg:Address/wmsg:CountryID)"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Kontaktperson:</td>
							<td id="Aktuell_klein">
								<xsl:variable name="GENDER">
									<xsl:choose>
										<xsl:when test="wmsg:Contact/wmsg:GenderCode=1">Herr</xsl:when>
										<xsl:when test="wmsg:Contact/wmsg:GenderCode=2">Frau</xsl:when>
									</xsl:choose>
								</xsl:variable>
								<xsl:value-of select="normalize-space(concat($GENDER, ' ', wmsg:Contact/wmsg:GivenName, ' ',wmsg:Contact/wmsg:FamilyName))"/>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="30%"/>
							<col width="10%"/>
							<col width="40%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Tel.:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Contact/wmsg:TelephoneCompleteNumber"/>
							</td>
							<td id="Titel_klein">Fax:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Contact/wmsg:FaxCompleteNumber"/>
							</td>
						</tr>
					</table>
					<table width="100%" id="Tabelle_ohne">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">E-Mail:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Contact/wmsg:EmailURI"/>&#173;
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Homepage:</td>
							<td id="Aktuell_klein">
								<xsl:value-of select="wmsg:Contact/wmsg:WebsiteURI"/>&#173;
							</td>
						</tr>
					</table>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="20%"/>
						<col width="30%"/>
					</colgroup>
					<xsl:if test="$BEHOERDE">
						<tr>
							<td id="Titel_klein">Codenummer:</td>
							<xsl:call-template name="DUMMY_ZEICHEN"/>
						</tr>
					</xsl:if>
					<tr>
						<td id="Titel_klein">Registriernummer:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="80%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Name:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td id="Titel_klein">Anschrift:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td id="Titel_klein">Land:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td id="Titel_klein">Kontaktperson:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
				<table width="100%" id="Tabelle_ohne">
					<colgroup>
						<col width="20%"/>
						<col width="30%"/>
						<col width="10%"/>
						<col width="40%"/>
					</colgroup>
					<tr>
						<td id="Titel_klein">Tel.:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
						<td id="Titel_klein">Fax:</td>
						<td/>
					</tr>
					<tr>
						<td id="Titel_klein">E-Mail:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
					<tr>
						<td id="Titel_klein">Homepage:</td>
						<xsl:call-template name="DUMMY_ZEICHEN"/>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="EndeForm">
		<!-- Tabelle mit unterer Linie versehen -->
		<table id="Tabelle_oben" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="DUMMY_ZEICHEN">
		<td>
			<font id="Aktuell_klein">&#173;</font>
		</td>
	</xsl:template>
</xsl:stylesheet>
