<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
	xmlns:svc_zba="urn:de:bmu:eanv:ServiceModul:0:4"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib ds zks b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
    <xsl:template match="zks:BGSNrZuteilung">
        <html>
            <head>
                <title>Nummernzuteilung</title>
                <!-- CSS - Datei   -->
                <xsl:call-template name="Style"/>
            </head>
            <body>
                <xsl:call-template name="Kopf"/>
                <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
                    <tr>
                        <th>
							<tr>
								<td>
									<font id="Nummer">
								Nummernzuteilung
								</font>
								</td>
							</tr>
							<tr height="3%">
								<td/>
							</tr>
                            <xsl:call-template name="NummernAnforderung"/>
							<xsl:call-template name="Nummern"/>
                        </th>
                    </tr>
                </table>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="NummernAnforderung">
        <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
            <tr height="10">
                <td/>
            </tr>
            <tr width="100%">
                <td id="Nummer2"> Nummern-Anforderung </td>
            </tr>
            <tr height="3%">
                <td/>
            </tr>
            <tr width="100%">
                <td id="Titel"> Behördliche Nummer </td>
            </tr>
            <tr width="100%">
                <td id="Aktuell">
                    <xsl:value-of select="concat(zks:BGSNrAnforderung/zks:BehoerdlicheNummer/lib:BehoerdlicheNr, zks:BGSNrAnforderung/zks:BehoerdlicheNummer/lib:Pruefziffer, ' (', zks:BGSNrAnforderung/zks:BehoerdlicheNummer/@lib:ATBRolle, ')')"/>
                </td>
            </tr>
            <tr width="100%">
                <td width="50%" id="Titel">Anzahl Nummern</td>
                <td width="50%" id="Titel">Nummernart</td>
            </tr>
            <tr width="100%">
				<td width="50%" id="Aktuell">
					<xsl:value-of select="zks:BGSNrAnforderung/zks:Anzahl"/>
				</td>
				<td width="50%" id="Aktuell">
					<xsl:value-of select="zks:BGSNrAnforderung/zks:Anzahl/@zks:Nummernart"/>
				</td>
            </tr>
            <tr height="10">
                <td/>
            </tr>
			<tr width="100%">
				<td width="50%" id="Titel">Unterschrift (Signatur)</td>
				<td width="50%" id="Titel">2. Unterschrift (2. Signatur)</td>
			</tr>
			<tr width="100%">
				<td width="50%">
					<xsl:call-template name="Sig1NameNoLayer"/>
				</td>
				<td width="50%">
					<xsl:call-template name="Sig2NameNoLayer"/>
				</td>
			</tr>
        </table>
    </xsl:template>
    
	<xsl:template name="Nummern">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<font id="Nummer2">Nummern:</font>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%">
						<xsl:for-each select="//zks:BGSNummer">
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="lib:PaginierNr"/>
									&#173;
									<xsl:value-of select="lib:Pruefziffer"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
					<tr width="100%">
						<td id="Titel"> Kontingent Rest </td>
					</tr>
					<tr width="100%">
						<td id="Aktuell">
							<xsl:value-of select="zks:KontingentRest"/>
						</td>
					</tr>
					<tr height="10">
						<td/>
					</tr>
					<tr width="100%">
						<td width="50%" id="Titel">Unterschrift (Signatur)</td>
						<td width="50%" id="Titel">2. Unterschrift (2. Signatur)</td>
					</tr>
					<tr width="100%">
						<td width="50%">
							<font id="Aktuell">
								<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
							</font>
						</td>
						<td width="50%">
							<xsl:if test="boolean(ds:Signature[2])">
								<font id="Aktuell">
									<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[2]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
								</font>
							</xsl:if>
						</td>
					</tr>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
