/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RuleImplLayerATBRolle
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String[] XPATH_BGS_LAYER_ID = new String[]{"/descendant::bgs:BGSErgaenzungsLayer[@lib:ATBRolle='BEVERZ' or @lib:ATBRolle='MAK' or @lib:ATBRolle='PROV' or @lib:ATBRolle='SONST']"};
    private static final String[] XPATH_ENSN_LAYER_ID = new String[]{"/descendant::en:ENSNErgaenzungsLayer[@lib:ATBRolle='ZWL' or @lib:ATBRolle='MAK' or @lib:ATBRolle='PROV' or @lib:ATBRolle='SONST']"};
    private static final String[] XPATH_UNS_LAYER_ID = new String[]{"/descendant::bgs:UNSBasisLayer[lib:ATBRolle='ZWL' or @lib:ATBRolle='BEH' or @lib:ATBRolle='BEVERZ' or @lib:ATBRolle='MAK' or @lib:ATBRolle='PROV' or @lib:ATBRolle='SONST']", "/descendant::bgs:UNSErgaenzungsLayer[@lib:ATBRolle='ZWL' or @lib:ATBRolle='BEVERZ' or @lib:ATBRolle='MAK' or @lib:ATBRolle='PROV' or @lib:ATBRolle='SONST']"};
    private static final Log LOGGER = LogFactory.getLog(RuleImplLayerATBRolle.class);

    public RuleImplLayerATBRolle(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> checkATBRolle(Document doc, String xPath, int index) throws BMUException {
        NodeList layerNodeList;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            layerNodeList = XPathFassade.getInstance().evaluateNodeList(doc, xPath);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        for (int i = 0; i < layerNodeList.getLength(); ++i) {
            Element layer = (Element)layerNodeList.item(i);
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index + i, layer.getAttributeNS(Namespace.TypenBibliothek.getUri(), "LayerID")));
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        BMUMessageType msgType = bmuDok.getMessageType();
        int index = 1;
        switch (msgType.getEnumType()) {
            case BGSDokument: {
                for (String xPath : XPATH_BGS_LAYER_ID) {
                    ruleResultList.addAll(this.checkATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            case UNSDokument: {
                for (String xPath : XPATH_UNS_LAYER_ID) {
                    ruleResultList.addAll(this.checkATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            case ENSNDokument: {
                for (String xPath : XPATH_ENSN_LAYER_ID) {
                    ruleResultList.addAll(this.checkATBRolle(doc, xPath, index + ruleResultList.size()));
                }
                break;
            }
            default: {
                LOGGER.warn((Object)("unexpected message-type: " + String.valueOf((Object)msgType.getEnumType())));
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Begleitscheinen: ");
        builder.append(Arrays.deepToString(XPATH_BGS_LAYER_ID));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von \u00dcbernahmescheinen: ");
        builder.append(Arrays.deepToString(XPATH_UNS_LAYER_ID));
        builder.append("\n");
        builder.append("XPathes f\u00fcr die Pr\u00fcfung von Nachweisen: ");
        builder.append(Arrays.deepToString(XPATH_ENSN_LAYER_ID));
        return builder.toString();
    }
}

